/*
 * Decompiled with CFR 0.152.
 */
package org.libxinejna;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import org.libxinejna.Xine;
import org.libxinejna.XineEventListener;
import org.libxinejna.XineLib;
import org.libxinejna.XineVideoView;

public class XineController
implements XineLib.Xine_event_listener_cb_t {
    private XineLib.Xine_stream_t stream;
    private XineLib.Xine_video_port_t vo_port;
    private XineLib.Xine_audio_port_t ao_port;
    private XineLib.Xine_event_queue_t event_queue;
    private Xine engine;
    private XineVideoView view;
    private XineEventListener xineEventListener = null;
    private boolean running = false;
    private Object runningMutex = new Object();
    static final String vo_driver = "auto";
    static final String ao_driver = "auto";
    public static boolean xine_debug_output = false;

    protected XineController(Xine xine, XineVideoView xineVideoView) {
        int n = 0;
        Pointer pointer = null;
        this.view = xineVideoView;
        this.engine = xine;
        if (xineVideoView != null) {
            this.vo_port = XineLib.INSTANCE.xine_open_video_driver(xine.getXineEngine(), "auto", n, pointer);
            if (this.vo_port == null) {
                System.out.println("Unable to initialize 'auto' video driver. Giving up.\n");
            }
        }
        System.out.println("xine_open_audio_driver");
        this.ao_port = XineLib.INSTANCE.xine_open_audio_driver(xine.getXineEngine(), "auto", null);
        if (this.ao_port == null) {
            System.out.println("Unable to initialize 'auto' audio driver. Giving up.\n");
        }
        System.out.println("xine_stream_new");
        this.stream = XineLib.INSTANCE.xine_stream_new(xine.getXineEngine(), this.ao_port, this.vo_port);
        if (xine_debug_output) {
            XineLib.INSTANCE.xine_set_param(this.stream, 11, 2);
        }
        System.out.println("xine event queue");
        this.event_queue = XineLib.INSTANCE.xine_event_new_queue(this.stream);
        XineLib.INSTANCE.xine_event_create_listener_thread(this.event_queue, this, null);
        if (xineVideoView != null) {
            xineVideoView.registerXineController(this);
        }
    }

    public XineLib.Xine_stream_t getNativeStream() {
        return this.stream;
    }

    public void open(String string) {
        XineLib.INSTANCE.xine_open(this.stream, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.runningMutex;
        synchronized (object) {
            XineLib.INSTANCE.xine_play(this.stream, 0, 0);
            this.running = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(int n, int n2) {
        Object object = this.runningMutex;
        synchronized (object) {
            this.running = true;
        }
        XineLib.INSTANCE.xine_play(this.stream, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.runningMutex;
        synchronized (object) {
            XineLib.INSTANCE.xine_stop(this.stream);
            this.running = false;
        }
    }

    public boolean isPaused() {
        return XineLib.INSTANCE.xine_get_param(this.stream, 1) == 0;
    }

    public void pause() {
        if (this.isPlaying() && !this.isPaused()) {
            XineLib.INSTANCE.xine_set_param(this.stream, 1, 0);
        }
    }

    public void resume() {
        if (this.isPaused()) {
            XineLib.INSTANCE.xine_set_param(this.stream, 1, 4);
        }
    }

    public boolean isPlaying() {
        return this.running && !this.isPaused();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playOnce() {
        Object object = this.runningMutex;
        synchronized (object) {
            if (!this.running) {
                this.start();
            }
            while (this.running) {
                try {
                    this.runningMutex.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playOnce(int n, int n2) {
        Object object = this.runningMutex;
        synchronized (object) {
            if (!this.running) {
                this.start(n, n2);
            }
            while (this.running) {
                try {
                    this.runningMutex.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public int getStreamLength() {
        IntByReference intByReference = new IntByReference();
        IntByReference intByReference2 = new IntByReference();
        IntByReference intByReference3 = new IntByReference();
        int n = XineLib.INSTANCE.xine_get_pos_length(this.stream, intByReference, intByReference2, intByReference3);
        if (n == 1) {
            return intByReference3.getValue();
        }
        return 0;
    }

    public int getStreamPos() {
        IntByReference intByReference = new IntByReference();
        IntByReference intByReference2 = new IntByReference();
        IntByReference intByReference3 = new IntByReference();
        int n = XineLib.INSTANCE.xine_get_pos_length(this.stream, intByReference, intByReference2, intByReference3);
        if (n == 1) {
            return intByReference2.getValue();
        }
        return -1;
    }

    public boolean hasVideo() {
        return XineLib.INSTANCE.xine_get_stream_info(this.stream, 18) != 0;
    }

    public boolean hasAudio() {
        return XineLib.INSTANCE.xine_get_stream_info(this.stream, 19) != 0;
    }

    public void dispose() {
        XineLib.INSTANCE.xine_stop(this.stream);
        if (this.view != null) {
            this.view.unregisterXineController();
        }
        XineLib.INSTANCE.xine_event_dispose_queue(this.event_queue);
        XineLib.INSTANCE.xine_close(this.stream);
        XineLib.INSTANCE.xine_dispose(this.stream);
        if (this.ao_port != null) {
            XineLib.INSTANCE.xine_close_audio_driver(this.engine.getXineEngine(), this.ao_port);
        }
        if (this.vo_port != null) {
            XineLib.INSTANCE.xine_close_video_driver(this.engine.getXineEngine(), this.vo_port);
        }
    }

    public void setParam(int n, int n2) {
        XineLib.INSTANCE.xine_set_param(this.stream, n, n2);
    }

    public void volumeUp() {
        this.volumeUp(1);
    }

    public void volumeUp(int n) {
        this.setVolume(this.getVolume() + n);
    }

    public void volumeDown() {
        this.volumeDown(1);
    }

    public void volumeDown(int n) {
        this.setVolume(this.getVolume() - n);
    }

    public void setVolume(int n) {
        if (n > 100) {
            n = 100;
        } else if (n < 0) {
            n = 0;
        }
        XineLib.INSTANCE.xine_set_param(this.stream, 6, n);
    }

    public int getVolume() {
        return XineLib.INSTANCE.xine_get_param(this.stream, 6);
    }

    public int getNrAudioChannels() {
        return XineLib.INSTANCE.xine_get_stream_info(this.stream, 11);
    }

    public int getMaxAudioChannels() {
        return XineLib.INSTANCE.xine_get_stream_info(this.stream, 24);
    }

    public int getAudioChannel() {
        return XineLib.INSTANCE.xine_get_param(this.stream, 3);
    }

    public void setAudioChannel(int n) {
        XineLib.INSTANCE.xine_set_param(this.stream, 3, n);
    }

    public void registerXineEventListener(XineEventListener xineEventListener) {
        this.xineEventListener = xineEventListener;
    }

    public native void dispatchXineEvents(long var1, long var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callback(Pointer pointer, XineLib.Xine_event_t xine_event_t) {
        switch (xine_event_t.type) {
            case 1: {
                Object object = this.runningMutex;
                synchronized (object) {
                    this.running = false;
                    this.runningMutex.notifyAll();
                    break;
                }
            }
        }
        if (this.xineEventListener != null) {
            this.xineEventListener.handleXineEvent(xine_event_t.type, null);
        }
    }
}

