/*
 * Copyright (c) 2001-2006 MUSIC TECHNOLOGY GROUP (MTG)
 *                         UNIVERSITAT POMPEU FABRA
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include "vmPlayer.hxx"
#include "vmPlayList.hxx"

namespace CLAM
{
	namespace VM
	{
		PlayList::PlayerList PlayList::mList;

		void PlayList::Add(Player* player)
		{
			mList.push_back(player);
		}
		
		void PlayList::Remove(Player* player)
		{
			PlayerList::iterator it = mList.begin();
			for(;it != mList.end(); it++)
			{
				if((*it)==player)
				{
					mList.erase(it);
					break;
				}
			}
		}
		
		void PlayList::Stop()
		{
			PlayerList::iterator it = mList.begin();
			for(;it != mList.end(); it++)
			{
				if((*it)->IsPlaying())
				{
					(*it)->stop();
					break;
				}
			}
		}
	}
}

// END

