/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.lxmed.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.sourceforge.lxmed.model.MenuItem;

public class Category {
    protected String displayName;
    protected String codeName;
    protected String icon;
    protected List<MenuItem> items = new ArrayList<MenuItem>();

    public Category(String displayName, String codeName, String icon) {
        this.displayName = displayName;
        this.codeName = codeName;
        this.icon = icon;
    }

    public <T> T[] toArray(T[] a) {
        return this.items.toArray(a);
    }

    public Object[] toArray() {
        return this.items.toArray();
    }

    public List<MenuItem> subList(int fromIndex, int toIndex) {
        return this.items.subList(fromIndex, toIndex);
    }

    public int size() {
        return this.items.size();
    }

    public MenuItem set(int index, MenuItem element) {
        return this.items.set(index, element);
    }

    public boolean retainAll(Collection<?> c) {
        return this.items.retainAll(c);
    }

    public boolean removeAll(Collection<?> c) {
        return this.items.removeAll(c);
    }

    public MenuItem remove(int index) {
        return this.items.remove(index);
    }

    public boolean remove(Object o) {
        return this.items.remove(o);
    }

    public ListIterator<MenuItem> listIterator(int index) {
        return this.items.listIterator(index);
    }

    public ListIterator<MenuItem> listIterator() {
        return this.items.listIterator();
    }

    public int lastIndexOf(Object o) {
        return this.items.lastIndexOf(o);
    }

    public Iterator<MenuItem> iterator() {
        return this.items.iterator();
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public int indexOf(Object o) {
        return this.items.indexOf(o);
    }

    public int hashCode() {
        return ((Object)this.items).hashCode();
    }

    public MenuItem get(int index) {
        return this.items.get(index);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Category other = (Category)obj;
        if (this.codeName == null ? other.codeName != null : !this.codeName.equals(other.codeName)) {
            return false;
        }
        return this.items == other.items || this.items != null && ((Object)this.items).equals(other.items);
    }

    public boolean containsAll(Collection<?> c) {
        return this.items.containsAll(c);
    }

    public boolean contains(Object o) {
        return this.items.contains(o);
    }

    public void clear() {
        this.items.clear();
    }

    public boolean addAll(int index, Collection<? extends MenuItem> c) {
        return this.items.addAll(index, c);
    }

    public boolean addAll(Collection<? extends MenuItem> c) {
        return this.items.addAll(c);
    }

    public void add(int index, MenuItem element) {
        this.items.add(index, element);
        element.setCategory(this);
    }

    public boolean add(MenuItem e) {
        boolean ret = this.items.add(e);
        e.setCategory(this);
        return ret;
    }

    public String getCodeName() {
        return this.codeName;
    }

    public void setCodeName(String codeName) {
        this.codeName = codeName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setItems(List<MenuItem> items) {
        this.items = items;
    }

    public List<MenuItem> getItems() {
        return this.items;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public static List<Category> init() {
        ArrayList<Category> ret = new ArrayList<Category>();
        ret.add(new Category("Accessories", "Utility", "accessories.png"));
        ret.add(new Category("Education", "Education", "science.png"));
        ret.add(new Category("Games", "Game", "games.png"));
        ret.add(new Category("Graphics", "Graphics", "graphics.png"));
        ret.add(new Category("Internet", "Network", "internet.png"));
        ret.add(new Category("Office", "Office", "office.png"));
        ret.add(new Category("Other", "", "other.png"));
        ret.add(new Category("Programming", "Development", "development.png"));
        ret.add(new Category("Sound & Video", "AudioVideo", "multimedia.png"));
        ret.add(new Category("System Tools", "System", "system.png"));
        ret.add(new Category("Preferences", "Settings", "preferences.png"));
        return ret;
    }

    public String toString() {
        return this.displayName;
    }

    public void addAndPersist() {
    }

    public void updateAndPersist() {
    }

    public void removeAndPersist() {
    }
}

