#!/bin/bash

# user must be root
if [ "$(id -u)" != "0" ]; then
   echo "Installation must be run as root" 1>&2
   exit 1
fi

# remove any previous version
echo "[+] Removing any previous version"
rm -rvf /opt/awemenugen
echo

# copy new files
echo "[+] Installing new files"
mkdir -v /opt/awemenugen
mkdir -v /opt/awemenugen/lib
cp -v awemenugen.sh /opt/awemenugen
cp -v awemenugen.jar /opt/awemenugen
cp -v lib/* /opt/awemenugen/lib
chmod -v +x /opt/awemenugen/awemenugen.sh

sudo rm -v /usr/bin/awemenugen
ln -s -v /opt/awemenugen/awemenugen.sh /usr/bin/awemenugen

echo
echo "Installation sucessfully completed. Enter 'awemenugen' to generate your new main menu"
echo
