/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.lxmed.commands;

import java.io.FileNotFoundException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.lxmed.commands.LxmedCommand;
import net.sourceforge.lxmed.model.Category;
import net.sourceforge.lxmed.model.MenuItem;
import net.sourceforge.lxmed.model.Model;

public class EditItemCommand
implements LxmedCommand {
    private MenuItem previous;
    private MenuItem next;
    private MenuItem real;
    private Category previousCategory;
    private Category nextCategory;

    public EditItemCommand(MenuItem original, MenuItem edited) {
        try {
            this.previous = original;
            this.real = edited;
            this.next = (MenuItem)edited.clone();
            this.previousCategory = this.previous.getCategory();
            this.nextCategory = this.next.getCategory();
            original.setCategory(null);
            this.previous.setCategory(null);
            this.next.setCategory(null);
            edited.setCategory(null);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
    }

    public void doCommand() {
        this.real.setCategory(this.nextCategory);
        this.real.setOriginalCode(this.next.getOriginalCode());
        this.real.setOriginalCategories(this.next.getOriginalCategories());
        this.real.setReadOnly(this.next.isReadOnly());
        this.real.getContent().clear();
        for (String key : this.next.getContent().keySet()) {
            this.real.getContent().put(key, this.next.getContent().get(key));
        }
        try {
            Model.getModel().updateMenuItem(this.real);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(EditItemCommand.class.getName()).log(Level.SEVERE, "edit redo error", ex);
        }
    }

    public void undoCommand() {
        this.real.setCategory(this.previousCategory);
        this.real.setOriginalCode(this.previous.getOriginalCode());
        this.real.setOriginalCategories(this.previous.getOriginalCategories());
        this.real.setReadOnly(this.previous.isReadOnly());
        this.real.getContent().clear();
        for (String key : this.previous.getContent().keySet()) {
            this.real.getContent().put(key, this.previous.getContent().get(key));
        }
        try {
            Model.getModel().updateMenuItem(this.real);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(EditItemCommand.class.getName()).log(Level.SEVERE, "edit undo error", ex);
        }
    }
}

