/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.lxmed.gui;

import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import net.sourceforge.lxmed.model.Category;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoriesListCellRenderer
extends DefaultListCellRenderer {
    private Map<String, Icon> icons = new HashMap<String, Icon>();

    public CategoriesListCellRenderer(List<Category> categories) {
        for (Category categorie : categories) {
            ImageIcon icon = new ImageIcon(this.getClass().getResource("/net/sourceforge/lxmed/images/categories/" + categorie.getIcon()));
            this.icons.put(categorie.getCodeName(), icon);
        }
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        Category c = (Category)value;
        Icon icon = this.icons.get(c.getCodeName());
        label.setIcon(icon);
        return label;
    }
}

