/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.lxmed.gui;

import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import net.sourceforge.lxmed.model.MenuItem;
import net.sourceforge.lxmed.utils.Configuration;

public class MenuItemsListCellRenderer
extends DefaultListCellRenderer {
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        MenuItem mi = (MenuItem)list.getModel().getElementAt(index);
        try {
            if (mi != null && this.rootOnly(mi)) {
                label.setForeground(new Color(170, 0, 0));
            } else if (mi.getExec().toLowerCase().contains("wine")) {
                label.setForeground(new Color(170, 170, 0));
            } else {
                label.setForeground(new Color(0, 170, 0));
            }
            if (mi != null && mi.isVisible()) {
                label.setFont(label.getFont().deriveFont(1));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return label;
    }

    private boolean rootOnly(MenuItem mi) {
        return !Configuration.IS_ROOT && (mi.getPath().getAbsolutePath().trim().startsWith(Configuration.ROOT_APPS) || mi.getPath().getAbsolutePath().trim().startsWith(Configuration.ROOT_LOCAL_APPS));
    }
}

