/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.lxmed.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.lxmed.model.MenuItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Category
implements Iterable<MenuItem> {
    protected String displayName;
    protected String codeName;
    protected String icon;
    protected List<MenuItem> items = new ArrayList<MenuItem>();

    public Category(String displayName, String codeName, String icon) {
        this.displayName = displayName;
        this.codeName = codeName;
        this.icon = icon;
    }

    public void add(MenuItem newMenuItem) {
        if (newMenuItem == null) {
            return;
        }
        if (this.items == null) {
            this.items = new ArrayList<MenuItem>();
        }
        if (!this.items.contains(newMenuItem)) {
            this.items.add(newMenuItem);
            newMenuItem.setCategory(this);
        }
    }

    public void remove(MenuItem oldMenuItem) {
        if (oldMenuItem == null) {
            return;
        }
        if (this.items != null && this.items.contains(oldMenuItem)) {
            this.items.remove(oldMenuItem);
            oldMenuItem.setCategory(null);
        }
    }

    public String getCodeName() {
        return this.codeName;
    }

    public void setCodeName(String codeName) {
        this.codeName = codeName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setItems(List<MenuItem> items) {
        this.items = items;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public static List<Category> init() {
        ArrayList<Category> ret = new ArrayList<Category>();
        ret.add(new Category("Accessories", "Utility", "accessories.png"));
        ret.add(new Category("Education", "Education", "science.png"));
        ret.add(new Category("Games", "Game", "games.png"));
        ret.add(new Category("Graphics", "Graphics", "graphics.png"));
        ret.add(new Category("Internet", "Network", "internet.png"));
        ret.add(new Category("Office", "Office", "office.png"));
        ret.add(new Category("Other", "", "other.png"));
        ret.add(new Category("Programming", "Development", "development.png"));
        ret.add(new Category("Sound & Video", "AudioVideo", "multimedia.png"));
        ret.add(new Category("System Tools", "System", "system.png"));
        ret.add(new Category("Preferences", "Settings", "preferences.png"));
        return ret;
    }

    public String toString() {
        return this.displayName;
    }

    @Override
    public Iterator<MenuItem> iterator() {
        return this.items.iterator();
    }

    public List<MenuItem> getItems() {
        return this.items;
    }
}

