/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.lxmed.model;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sourceforge.lxmed.LxmedException;
import net.sourceforge.lxmed.model.Category;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuItem
implements Cloneable {
    public static String CATEGORIES = "Categories";
    protected File path;
    protected Category category;
    protected String originalCategories;
    protected String originalCode;
    protected boolean readonly = true;
    protected Map<String, String> content = new LinkedHashMap<String, String>();

    public MenuItem() {
    }

    public MenuItem(String name) {
        this.content.put("Name", name);
    }

    public MenuItem(MenuItem mi) {
        this.path = mi.path;
        this.category = mi.category;
        this.originalCategories = mi.originalCategories;
        this.originalCode = mi.originalCode;
        this.readonly = mi.readonly;
        for (String string : mi.content.keySet()) {
            this.content.put(string, mi.content.get(string));
        }
    }

    public String getComment() {
        return this.content.get("Comment");
    }

    public void setComment(String comment) {
        this.content.put("Comment", comment);
    }

    public String getExec() {
        return this.content.get("Exec");
    }

    public void setExec(String exec) {
        this.content.put("Exec", exec);
    }

    public String getGenericName() {
        return this.content.get("GenericName");
    }

    public void setGenericName(String genericName) {
        this.content.put("GenericName", genericName);
    }

    public String getIconStr() {
        return this.content.get("Icon");
    }

    public void setIconStr(String iconStr) {
        this.content.put("Icon", iconStr);
    }

    public String getName() {
        return this.content.get("Name");
    }

    public void setName(String name) {
        this.content.put("Name", name);
    }

    public boolean isNoDisplay() {
        String str = this.content.get("NoDisplay");
        return str != null && str.toLowerCase().trim().equals("true");
    }

    public void setNoDisplay(boolean noDisplay) {
        this.content.put("NoDisplay", Boolean.toString(noDisplay));
    }

    public File getPath() {
        return this.path;
    }

    public void setPath(File path) {
        this.path = path;
    }

    public Category getCategory() {
        return this.category;
    }

    public void setCategory(Category newCategory) {
        if (this.category == null || !this.category.equals(newCategory)) {
            if (this.category != null) {
                Category oldCategory = this.category;
                this.category = null;
                this.content.remove(CATEGORIES);
                oldCategory.remove(this);
            }
            if (newCategory != null) {
                this.category = newCategory;
                this.content.put(CATEGORIES, newCategory.getCodeName());
                this.category.add(this);
            }
        }
    }

    public boolean isReadOnly() {
        return this.readonly;
    }

    public void setReadOnly(boolean readonly) {
        this.readonly = readonly;
    }

    public String getOriginalCategories() {
        return this.originalCategories;
    }

    public void setOriginalCategories(String originalCategories) {
        this.originalCategories = originalCategories;
    }

    public String getOriginalCode() {
        return this.originalCode;
    }

    public void setOriginalCode(String originalCode) {
        this.originalCode = originalCode;
    }

    public Map<String, String> getContent() {
        return this.content;
    }

    public void setContent(Map<String, String> content) {
        this.content = content;
    }

    public String getDesktopCode() {
        this.checkItem();
        if (!this.content.containsKey("Type")) {
            this.content.put("Type", "Application");
        }
        if (!this.content.containsKey(CATEGORIES) && this.category != null) {
            this.content.put(CATEGORIES, this.category.getCodeName());
        }
        String ret = "[Desktop Entry]\n";
        for (String key : this.content.keySet()) {
            if (key.equals(CATEGORIES)) {
                String categories = this.content.get(key);
                if (categories.endsWith(";")) continue;
                ret = ret + key + "=" + this.content.get(key) + ";\n";
                continue;
            }
            ret = ret + key + "=" + this.content.get(key) + "\n";
        }
        return ret;
    }

    public String toString() {
        return this.getName();
    }

    private void checkItem() throws LxmedException {
        Object[] mandatories;
        for (Object object : mandatories = new Object[]{this.getName(), this.category}) {
            if (object == null) {
                throw new LxmedException("Null reference in MenuItem mandatory field.");
            }
            if (object instanceof String) {
                if (!((String)object).trim().equals("")) continue;
                throw new LxmedException("Empty string.");
            }
            if (!(object instanceof Category)) continue;
        }
    }

    public void cloneData(MenuItem newMenuItem) {
        this.content.clear();
        if (newMenuItem.getCategory() != null) {
            this.setCategory(newMenuItem.getCategory());
        }
        for (String key : newMenuItem.getContent().keySet()) {
            this.content.put(key, newMenuItem.getContent().get(key));
        }
        this.setOriginalCategories(newMenuItem.getOriginalCategories());
        this.setReadOnly(newMenuItem.readonly);
        if (newMenuItem.getPath() != null) {
            this.setPath(newMenuItem.getPath());
        }
    }

    public boolean isVisible() {
        if (this.content.containsKey("OnlyShowIn")) {
            String[] values;
            for (String s : values = this.content.get("OnlyShowIn").split(";")) {
                if (!s.trim().equals("LXDE")) continue;
                return true;
            }
            return false;
        }
        if (this.content.containsKey("NotShowIn")) {
            String[] values;
            for (String s : values = this.content.get("NotShowIn").split(";")) {
                if (!s.trim().equals("LXDE")) continue;
                return false;
            }
            return true;
        }
        return !this.isNoDisplay();
    }

    public String putToContentMap(String key, String value) {
        return this.content.put(key, value);
    }

    public Object clone() throws CloneNotSupportedException {
        MenuItem ret = new MenuItem();
        ret.setCategory(this.category);
        ret.setOriginalCategories(this.originalCategories);
        ret.setOriginalCode(this.originalCode);
        ret.setReadOnly(this.readonly);
        ret.setPath(new File(this.path.getAbsolutePath()));
        for (String key : this.content.keySet()) {
            ret.content.put(key, this.content.get(key));
        }
        return ret;
    }
}

