/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.lxmed.persistence;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import net.sourceforge.lxmed.LxmedException;
import net.sourceforge.lxmed.model.MenuItem;

public class FileUtil {
    public static boolean save(MenuItem item) throws FileNotFoundException {
        File path = item.getPath();
        if (!path.getParentFile().exists() && !path.getParentFile().mkdirs()) {
            throw new LxmedException("Directory not created: " + path.getParent());
        }
        try {
            PrintWriter pout = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path), "UTF-8"));
            pout.print(item.getDesktopCode());
            pout.flush();
            pout.close();
        }
        catch (UnsupportedEncodingException ex) {
            return false;
        }
        return true;
    }

    public static boolean delete(MenuItem item) {
        return item.getPath().delete();
    }

    public static String getFileName(String name) {
        String[] forbidden = new String[]{"/", "\\", "?", "%", "*", ":", "|", "\"", "<", ">", ".", ",", ";", "'", "(", ")", " "};
        String ret = name;
        for (String string : forbidden) {
            ret = ret.replace(string, "_");
        }
        return ret + ".desktop";
    }

    public static String getTimestampedFileName(String name) {
        String[] forbidden = new String[]{"/", "\\", "?", "%", "*", ":", "|", "\"", "<", ">", ".", ",", ";", "'", "(", ")", " "};
        String ret = name;
        for (String string : forbidden) {
            ret = ret.replace(string, "_");
        }
        return ret + "-" + System.currentTimeMillis() + ".desktop";
    }
}

