/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.lxmed.persistence;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.lxmed.model.Category;
import net.sourceforge.lxmed.model.MenuItem;
import net.sourceforge.lxmed.model.Model;
import net.sourceforge.lxmed.persistence.ItemNameComparator;
import net.sourceforge.lxmed.utils.Configuration;

public class ModelLoader {
    public static Model load() {
        File[] paths;
        Model model = Model.getModel();
        for (File path : paths = new File[]{new File(Configuration.ROOT_APPS), new File(Configuration.ROOT_LOCAL_APPS), new File(Configuration.USER_APPS)}) {
            if (!path.exists()) continue;
            for (File file : path.listFiles()) {
                if (!file.getName().endsWith(".desktop")) continue;
                ModelLoader.loadDesktopFile(file);
            }
        }
        for (Category categorie : Model.getModel().getCategories()) {
            ModelLoader.sortItemsByName(categorie);
        }
        return model;
    }

    public static MenuItem loadDesktopFile(File file) {
        String code = "";
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            while ((line = br.readLine()) != null) {
                if (!line.contains("=")) continue;
                code = code.concat(line.trim()).concat("\n");
            }
            br.close();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ModelLoader.class.getName()).log(Level.SEVERE, "Error on loading desktop file", ex);
        }
        catch (IOException ioe) {
            Logger.getLogger(ModelLoader.class.getName()).log(Level.SEVERE, "Error no. 2 on loading desktop file", ioe);
        }
        MenuItem mi = ModelLoader.loadData(code);
        mi.setPath(file);
        if (!Configuration.IS_ROOT) {
            for (String string : Configuration.getAdminFolders()) {
                if (mi.getPath().getParent().trim().equals(string.trim())) {
                    mi.setReadOnly(true);
                    break;
                }
                mi.setReadOnly(false);
            }
        } else {
            mi.setReadOnly(false);
        }
        ModelLoader.extractCategorie(mi, mi.getOriginalCategories());
        return null;
    }

    public static MenuItem loadData(String fileContent) {
        String[] lines;
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        for (String line : lines = fileContent.split("\n")) {
            if (!line.contains("=")) continue;
            String[] strs = line.split("=");
            String rest = "";
            for (int i = 1; i < strs.length; ++i) {
                rest = rest + "=" + strs[i];
            }
            if (rest.length() > 0) {
                rest = rest.substring(1);
            }
            values.put(strs[0], rest);
        }
        MenuItem mi = new MenuItem();
        mi.setContent(values);
        mi.setOriginalCategories((String)values.get("Categories"));
        mi.setOriginalCode(fileContent);
        return mi;
    }

    private static void extractCategorie(MenuItem mi, String cat) {
        String[] cats;
        if (cat == null || cat.trim().equals("")) {
            Model.getModel().getCategoryByCode("").add(mi);
            return;
        }
        for (String string : cats = cat.split(";")) {
            if (!string.equals("Settings")) continue;
            Model.getModel().getCategoryByCode(string).add(mi);
            return;
        }
        for (String string : cats) {
            if (Model.getModel().getCategoryByCode(string) == null) continue;
            Model.getModel().getCategoryByCode(string).add(mi);
            return;
        }
        Model.getModel().getCategoryByCode("").add(mi);
    }

    public static void sortItemsByName(Category c) {
        Collections.sort(c.getItems(), new ItemNameComparator());
    }
}

