#ifdef COPYRIGHT_INFORMATION
#include "gplv3.h"
#endif
/**********************************************************************/
/*  Copyright Edscott Wilson Garcia 2005 
 *  See attached GPL licence for further information.
 *
 *  Included code contributed by xfce project is GPL:
 *  Copyright (C) 2004-2005 Eduard Roccatello (eduard@xfce.org)
 *  Copyright (c) 2004 Brian Tarricone, <bjt23@cornell.edu>
 *  Copyright (C) 2002-2003 Jasper Huijsmans (huysmans@users.sourceforge.net)
 *  Copyright (C) 2003 Benedikt Meurer <benedikt.meurer@unix-ag.uni-siegen.de>
 *  Copyright (c) 2004 Nils Rennebarth
*/

/******************  apfinder... *****************/
#if 0
static gchar *
get_desktop_string (
    const gchar * key,
    const gchar * file
) {
    GKeyFile *key_file;
    GError *error = NULL;
    gchar *value;
    key_file = g_key_file_new ();
    if(!g_key_file_load_from_file (key_file, file, 0, &error)) {
        DBG ("%s (%s)\n", error->message, file);
        g_error_free (error);
        return NULL;
    }
    value = g_key_file_get_locale_string (key_file, "Desktop Entry", key, NULL, &error);
    if(error) {
        DBG ("%s (%s)\n", error->message, file);
        g_error_free (error);
    }
    g_key_file_free (key_file);
    return value;
}

static int
get_desktop_bool (
    const gchar * key,
    const gchar * file
) {
    GKeyFile *key_file;
    GError *error = NULL;
    gboolean value = FALSE;
    key_file = g_key_file_new ();
    if(!g_key_file_load_from_file (key_file, file, 0, &error)) {
        DBG ("%s (%s)\n", error->message, file);
        g_error_free (error);
        return FALSE;
    }
    value = g_key_file_get_boolean (key_file, "Desktop Entry", key, &error);
    if(error) {
        DBG ("%s (%s)\n", error->message, file);
        g_error_free (error);
    }
    g_key_file_free (key_file);
    return value;
}
#endif

/****************************   xfdesktop *************************/
static void
do_atoms (
    view_t * desk_view_p
) {
    rfm_global_t *rfm_global_p = rfm_global();
    Window xid;
    GdkAtom atom;
#if 0
    //GdkWindow *win=gtk_widget_get_parent_window(desk_view_p->widgets.paper);
    // gotta be realized...
    //gdk_window_move_resize (win, 0, 0, root_w,root_h);
    //gdk_window_lower(win);
#endif
    gtk_window_set_type_hint (GTK_WINDOW (rfm_global_p->window), GDK_WINDOW_TYPE_HINT_DESKTOP);

    atom = gdk_atom_intern ("_NET_WM_WINDOW_TYPE_DESKTOP", FALSE);
    gdk_property_change (gdk_get_default_root_window (),
//    gdk_property_change (gtk_widget_get_window(rfm_global_p->window),
                         gdk_atom_intern ("_NET_WM_WINDOW_TYPE", FALSE),
                         gdk_atom_intern ("ATOM", FALSE), 32, 
			 GDK_PROP_MODE_REPLACE, 
			 (guchar *) & atom, 1);
    gtk_widget_realize (rfm_global_p->window);
    xid = GDK_WINDOW_XID (gtk_widget_get_window(rfm_global_p->window));

    gdk_property_change (gdk_get_default_root_window (),
                         gdk_atom_intern ("RODENT_DESKTOP_WINDOW", FALSE),
                         gdk_atom_intern ("WINDOW", FALSE), 32, GDK_PROP_MODE_REPLACE, (guchar *) & xid, 1);
    /* we are not nautilus... 
       gdk_property_change(gdk_get_default_root_window(),
       gdk_atom_intern("NAUTILUS_DESKTOP_WINDOW_ID", FALSE),
       gdk_atom_intern("WINDOW", FALSE), 32,
       GDK_PROP_MODE_REPLACE, (guchar *)&xid, 1); */
}

static void
screen_set_selection (
    view_t * desk_view_p
) {
    rfm_global_t *rfm_global_p = rfm_global();
    const gchar *display_env = g_getenv ("DISPLAY");
    gchar *p;
    gint xscreen = -1;

    Window xwin;
//      gchar selection_name[100];
    Atom selection_atom;

    if(display_env) {
        if((p = g_strrstr (display_env, ".")))
            xscreen = atoi (p);
    }
    if(xscreen == -1)
        xscreen = 0;
    GdkScreen *screen = gtk_widget_get_screen (rfm_global_p->window);
    GdkWindow *root_win = gdk_screen_get_root_window (screen);
    xwin = GDK_WINDOW_XID (root_win);
    /* one screen for now */
    /* xscreen = gdk_screen_get_number(desktop->priv->gscreen); */

    selection_atom = XInternAtom (rfm_global_p->Xdisplay, "RODENT_DESK_ATOM", False);
    XSetSelectionOwner (rfm_global_p->Xdisplay, selection_atom, xwin, GDK_CURRENT_TIME);
}

static gboolean
rodent_running () {
    rfm_global_t *rfm_global_p = rfm_global();
    Atom selection_atom = XInternAtom (rfm_global_p->Xdisplay, "RODENT_DESK_ATOM", False);
    if(selection_atom == None)
        return FALSE;
    // atom is interned. Who owns it?
    Window xid = XGetSelectionOwner (rfm_global_p->Xdisplay, selection_atom);
    NOOP ("RODENT_DESK_ATOM --> 0x%x\n", (unsigned) xid);
    if(xid == 0) {
        // no one owns it... 
        return FALSE;
    }
    unsigned char *property_data;
    unsigned long items,
      remaining;
    int actual_format;
    Atom actual_atom;
    if(XGetWindowProperty (rfm_global_p->Xdisplay, xid,
                           selection_atom, 0, 255, FALSE, XA_STRING,
                           &actual_atom, &actual_format, &items, &remaining, &property_data) == Success) {
        NOOP("property_data=%s\n", ((property_data) ? property_data : (unsigned char *)
                                        "null"));
        if(property_data)
            XFree (property_data);
    }

    return TRUE;
}

static void
event_forward_to_rootwin (
    GdkScreen * gscreen,
    GdkEvent * event
) {
    rfm_global_t *rfm_global_p = rfm_global();
    XButtonEvent xev,
      xev2;

    if(event->type == GDK_BUTTON_PRESS || event->type == GDK_BUTTON_RELEASE) {
        if(event->type == GDK_BUTTON_PRESS) {
            xev.type = ButtonPress;
            /*
             * rox has an option to disable the next
             * instruction. it is called "blackbox_hack". Does
             * anyone know why exactly it is needed?
             */
            XUngrabPointer (rfm_global_p->Xdisplay, event->button.time);
        } else
            xev.type = ButtonRelease;

        xev.button = event->button.button;
        xev.x = event->button.x;        /* Needed for icewm */
        xev.y = event->button.y;
        xev.x_root = event->button.x_root;
        xev.y_root = event->button.y_root;
        xev.state = event->button.state;

        xev2.type = 0;
    } else if(event->type == GDK_SCROLL) {
        xev.type = ButtonPress;
        xev.button = event->scroll.direction + 4;
        xev.x = event->scroll.x;        /* Needed for icewm */
        xev.y = event->scroll.y;
        xev.x_root = event->scroll.x_root;
        xev.y_root = event->scroll.y_root;
        xev.state = event->scroll.state;

        xev2.type = ButtonRelease;
        xev2.button = xev.button;
    } else
        return;
    xev.window = GDK_WINDOW_XID (gdk_screen_get_root_window (gscreen));
    xev.root = xev.window;
    xev.subwindow = None;
    xev.time = event->button.time;
    xev.same_screen = True;

    XSendEvent (rfm_global_p->Xdisplay, xev.window, False, ButtonPressMask | ButtonReleaseMask, (XEvent *) & xev);
    if(xev2.type == 0)
        return;

    /* send button release for scroll event */
    xev2.window = xev.window;
    xev2.root = xev.root;
    xev2.subwindow = xev.subwindow;
    xev2.time = xev.time;
    xev2.x = xev.x;
    xev2.y = xev.y;
    xev2.x_root = xev.x_root;
    xev2.y_root = xev.y_root;
    xev2.state = xev.state;
    xev2.same_screen = xev.same_screen;

    XSendEvent (rfm_global_p->Xdisplay, xev2.window, False, ButtonPressMask | ButtonReleaseMask, (XEvent *) & xev2);
}

static gboolean
scroll_cb ( GtkWidget * w, GdkEventScroll * evt, gpointer user_data) {
    event_forward_to_rootwin (gtk_widget_get_screen (w), (GdkEvent *) evt);
    return TRUE;
}
#if 0
static view_t *
create_deskview_p ( void) {
    view_t *view_p = (view_t *) malloc (sizeof (view_t));
    if (!view_p) g_error("malloc: %s", strerror(errno));
    view_p->widgets.view_p = (void *) view_p;
    g_return_val_if_fail (view_p != NULL, NULL);
    memset (view_p, 0, sizeof (view_t));
    return view_p;
}
#endif

static int desktop_main ( void) {
    rfm_global_t *rfm_global_p = rfm_global();
    if(rfm_global_p->argc > 1 && (!strcmp (rfm_global_p->argv[1], "--version")
                                 || !strcmp (rfm_global_p->argv[1], "-V"))) {
        g_print ("\tThis is Rodent %s (xffm-%s)\n", TAG, VERSION);
        g_print ("\tbuilt with GTK+-%d.%d.%d, ", GTK_MAJOR_VERSION, GTK_MINOR_VERSION, GTK_MICRO_VERSION);
        g_print ("linked with GTK+-%d.%d.%d.\n", gtk_major_version, gtk_minor_version, gtk_micro_version);
        exit (0);
    }

    if(rodent_running ()) {
        DBG ("An instance of %s is already running\n", rfm_global_p->argv[0]);
        exit (1);
    }
    return 0;
}
