#ifdef COPYRIGHT_INFORMATION
#include "gplv3.h"
#endif
/*
 * Copyright (C) 2002-2012 Edscott Wilson Garcia
 * EMail: edscott@users.sf.net
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; 
 */
static void 
update_reselect_list(widgets_t *widgets_p){
    view_t *view_p = widgets_p->view_p;
    GSList *tmp = view_p->reselect_list;
    for (; tmp && tmp->data; tmp=tmp->next){
	g_free(tmp->data);
    }
    g_slist_free(view_p->reselect_list);
    view_p->reselect_list = NULL;
    tmp = view_p->selection_list;
    for (; tmp && tmp->data; tmp=tmp->next){
	record_entry_t *en = tmp->data;
	view_p->reselect_list = 
	    g_slist_prepend(view_p->reselect_list, g_strdup(en->path));
	TRACE( "adding %s to reselect list\n", en->path);
    }
}


static void
get_items(view_t * view_p, gint *top_items, gint *bottom_items){
    if (!g_object_get_data(G_OBJECT(view_p->widgets.paper), "vpane")) return ;
    GtkScrolledWindow *scrolled_window = g_object_get_data(G_OBJECT(view_p->widgets.paper), "scrolled_window");
    GtkAdjustment *adjustment = gtk_scrolled_window_get_vadjustment (scrolled_window);
    gdouble sp = gtk_adjustment_get_value (adjustment);
    gdouble page_size = gtk_adjustment_get_page_size(adjustment);
    GdkRectangle rect;
    rfm_layout_get_vpane_allocation(view_p, &rect);
   

    gint cellwidth = CELLWIDTH(view_p);
    gint cellheight = CELLHEIGHT(view_p);
    // items in screen:
    
    gint columns = rect.width / cellwidth;
    gint page_rows = ((gint)page_size) / cellheight;
    gint top_rows = ((gint)page_size + (gint) (sp)) / cellheight;

    gint page_items = page_rows * columns;
    gint top = top_rows * columns;
    gint bottom = top - page_items;
    if (top_items) *top_items = top;
    if (bottom_items) *bottom_items = bottom;
#ifdef DEBUG_TRACE
    gdouble upper = gtk_adjustment_get_upper(adjustment);
    gint total_rows = ((gint)upper) / cellheight;
    gint total_items = total_rows * columns;
    TRACE( "page items = %d, top_items = %d, bottom_items = %d  total_items  = %d\n",
		page_items, top, bottom, total_items);
#endif
    return;
}

static void 
scroll_down(view_t * view_p){
    GtkScrolledWindow *scrolled_window = g_object_get_data(G_OBJECT(view_p->widgets.paper), "scrolled_window");
    GtkAdjustment *adjustment = gtk_scrolled_window_get_vadjustment (scrolled_window);
    gdouble scroll_pos = CELLHEIGHT(view_p) + gtk_adjustment_get_value (adjustment);
    gdouble max = gtk_adjustment_get_upper (adjustment);
    if(scroll_pos > max) scroll_pos = max;
    rodent_set_scroll (view_p, scroll_pos);
}

static void 
scroll_up(view_t * view_p){
    GtkScrolledWindow *scrolled_window = g_object_get_data(G_OBJECT(view_p->widgets.paper), "scrolled_window");
    GtkAdjustment *adjustment = gtk_scrolled_window_get_vadjustment (scrolled_window);
    gdouble scroll_pos = gtk_adjustment_get_value (adjustment) - CELLHEIGHT(view_p);
    if(scroll_pos < 0) scroll_pos = 0;
    rodent_set_scroll (view_p, scroll_pos);
}

static void 
scroll_end(view_t * view_p){
    GtkScrolledWindow *scrolled_window = g_object_get_data(G_OBJECT(view_p->widgets.paper), "scrolled_window");
    GtkAdjustment *adjustment = gtk_scrolled_window_get_vadjustment (scrolled_window);
    //gdouble scroll_pos = gtk_adjustment_get_value (adjustment) - CELLHEIGHT(view_p);
    gdouble max = gtk_adjustment_get_upper (adjustment);
    rodent_set_scroll (view_p, max);
}

static gboolean
iconview_key(widgets_t *widgets_p, GdkEventKey * event){

    NOOP(stderr,"keyboard_event: 0x%x\n", event->keyval);


    view_t *view_p = widgets_p->view_p;
#if 0   
    // Non configurable: only in gridview library
    if(event->state & (GDK_SHIFT_MASK | GDK_CONTROL_MASK | GDK_MOD1_MASK)) {
	if (event->state & GDK_CONTROL_MASK && 
	    (event->keyval == GDK_KEY_T || event->keyval == GDK_KEY_t)) {
	    newpage(NULL, rfm_global_p->window);
	    return TRUE;
	}
        //if(rodent_common_mask_key (event, &(view_p->widgets))) return TRUE;
    }
#endif
    // Non configurable
    if(g_slist_length (view_p->selection_list) 
	    || g_object_get_data(G_OBJECT(view_p->widgets.paper), "RODENT_ROOT_SELECTED")) {
        if(event->keyval == GDK_KEY_Return || event->keyval == GDK_KEY_KP_Enter) {
	    if (g_slist_length (view_p->selection_list) > 1){
		rfm_natural(RFM_MODULE_DIR, "callbacks", GINT_TO_POINTER(OPEN_WITH_ACTIVATE), "callback");
	    } else {
		rfm_natural(RFM_MODULE_DIR, "callbacks", GINT_TO_POINTER(ACTIVATE), "callback");
	    }
	    return TRUE;
	}
    }
    if (event->keyval == GDK_KEY_Menu){
	// This does not create a new thread
	GdkEventButton  b_event;
	b_event.time = event->time;
	rodent_pop_menu ("main_popup_menu", &b_event);
	return TRUE;
    } else if (event->keyval == GDK_KEY_Back){
	rfm_natural(RFM_MODULE_DIR, "callbacks", GINT_TO_POINTER(BACK_ACTIVATE), "callback");
    } else if (event->keyval == GDK_KEY_Forward){
	rfm_natural(RFM_MODULE_DIR, "callbacks", GINT_TO_POINTER(JUMP_TO_ACTIVATE), "callback");
    } else if (event->keyval == GDK_KEY_Find || event->keyval == GDK_KEY_Search){
	rfm_natural(RFM_MODULE_DIR, "callbacks", GINT_TO_POINTER(FIND_ACTIVATE), "callback");
    }




    if(!lp_get_active(widgets_p)) {
	update_reselect_list(widgets_p);
    }
    // Escape key. Switch between iconview and lpterm.
    if(event->keyval == GDK_KEY_Escape) {
ESCAPE:
	if(lp_get_active(widgets_p)) {
	    g_free(view_p->lp_command);
	    view_p->lp_command = get_current_text ((GtkTextView *) widgets_p->status);
	    rfm_clear_text_window(NULL, widgets_p);

	} else {
	    // If you cannot get a read lock, abort.
	    if(!rfm_population_try_read_lock (view_p, "iconview_key")) {
		DBG("1,Cannot ge read lock at iconview_key\n");
		return TRUE;
	    }
	    rodent_unselect_all_pixbuf (view_p);
	    rodent_unsaturate_icon (view_p);
	    rfm_population_read_unlock (view_p, "iconview_key");
	    status_grab_focus (widgets_p->view_p, 0);
	    if (!view_p->lp_command) view_p->lp_command = g_strdup("");
	    rfm_status (widgets_p, "xffm/emblem_terminal", view_p->lp_command, NULL);
	    g_object_set_data (G_OBJECT (widgets_p->status), "clean", NULL);
	    gtk_text_view_set_cursor_visible(GTK_TEXT_VIEW  (widgets_p->status), TRUE);
	    lp_set_active(widgets_p, TRUE);
	}
	return TRUE;
    }

    if(lp_get_active(widgets_p)) {
	return FALSE;
    }
    

    // These are the reserved keys that will be processed by the iconview
    guint iconview_keys[]={
	GDK_KEY_Escape,
	GDK_KEY_Page_Up,
	GDK_KEY_Page_Down,
	GDK_KEY_Home,
	GDK_KEY_Left,
	GDK_KEY_Up,
	GDK_KEY_Down,
	GDK_KEY_Right,
	GDK_KEY_End,
	0};

    guint *ui_p=iconview_keys;
    gboolean is_iconview_key = FALSE;
    for (;ui_p && *ui_p; ui_p++){
	if (event->keyval == *ui_p && 
		!(event->state & GDK_CONTROL_MASK ) &&
		!(event->state & GDK_SHIFT_MASK )){
	    is_iconview_key = TRUE;
	    break;
	}
    }

    if (!is_iconview_key){
	if (event->state & (GDK_MOD1_MASK|GDK_MOD5_MASK)) return TRUE;
	if ((event->state & GDK_CONTROL_MASK) && !lp_is_key(event)) return TRUE;	
	rodent_unselect_all_pixbuf (view_p);
	rodent_unsaturate_icon (view_p);
	status_grab_focus (widgets_p->view_p, 0);
	lp_set_active(widgets_p, TRUE);
	return FALSE;
    }


    if (view_p->widgets.rename) {
        rfm_natural(RFM_MODULE_DIR, "callbacks", GINT_TO_POINTER(DONE_WITH_RENAME), "callback");
    }

    // If you cannot get a read lock, abort.
    if(!rfm_population_try_read_lock (view_p, "iconview_key")) {
	DBG("2,Cannot ge read lock at iconview_key\n");
	return TRUE;
    }
    if (view_p->population_pp == NULL){
        // not set up yet...
        rfm_population_read_unlock (view_p, "iconview_key");
	return TRUE;
    }

    
    if (!(event->state & GDK_SHIFT_MASK)) {
	rodent_unselect_all_pixbuf (view_p);
	rodent_unsaturate_icon (view_p);
	rodent_unsaturate_label (view_p);
    } else {
	// Unselect up item on multiple selections
	if (view_p->mouse_event.selected_p && view_p->mouse_event.selected_p->en
		&& IS_UP_TYPE(view_p->mouse_event.selected_p->en->type)){
	    rfm_unselect_pixbuf(view_p, view_p->mouse_event.selected_p);
	}
    }

    gint id;
    gint selection_id = -1;
    population_t **pp = view_p->population_pp;
    for (id = 0;pp && pp[id]; id++) {
	if (pp[id] == view_p->mouse_event.selected_p){
	    selection_id = id;
	    break;
	}
    }
    if (selection_id < 0 && pp[0]) {
	id = 0;
	selection_id = 0;
    }

    // selection_id is now properly set.

    gint i;
    gint grid_columns = GRID_COLUMNS(view_p);
    gint max_elements = MAX_ELEMENTS(view_p);
    gint top_items;
    gint bottom_items;
    get_items(view_p, &top_items, &bottom_items);
    // if selection_id is not visible, then scroll.
    while (selection_id > top_items){
	scroll_down(view_p);
	get_items(view_p, &top_items, &bottom_items);
    }
    while (selection_id  < bottom_items) {
	scroll_up(view_p);
	get_items(view_p, &top_items, &bottom_items);
    }



    switch (event->keyval) {
       case GDK_KEY_Home:
            selection_id = 0;
	    rodent_set_scroll (view_p, 0);
            break;
       case GDK_KEY_End:
            selection_id = max_elements - 1;
	    scroll_end(view_p);
            break;
        case GDK_KEY_Page_Down:
	    for (i=0; i<3; i++) scroll_down(view_p);
            if(selection_id + 3*grid_columns < max_elements) {
                selection_id += (3*grid_columns);
            }
	    break;
        case GDK_KEY_Page_Up:
	    for (i=0; i<3; i++) scroll_up(view_p);	
            if(selection_id >= 3*grid_columns){
		selection_id -= (3*grid_columns);
	    }
	    break;
       case GDK_KEY_Left:
            if(selection_id > 0) {
		selection_id--;
		if(selection_id  < bottom_items) scroll_up(view_p);
	    }
            break;
        case GDK_KEY_Right:
            if(view_p->population_pp[selection_id + 1]){
		selection_id++;
		if(selection_id > top_items) scroll_down(view_p);
	    }
            break;
        case GDK_KEY_Down:
	    TRACE( "selection_id=%d columns=%d top_items=%d\n",
		selection_id + grid_columns, grid_columns,  top_items);
            if(selection_id + grid_columns >= top_items) scroll_down(view_p);
            if(selection_id + grid_columns < max_elements) {
                selection_id += grid_columns;
            }
            break;
        case GDK_KEY_Up:
	    TRACE( "selection_id=%d columns=%d bottom_items=%d\n",
		selection_id - grid_columns, grid_columns, bottom_items);
            if (selection_id == 0)  {
	        rfm_population_read_unlock (view_p, "iconview_key");
                goto ESCAPE;
            }
            if(selection_id >= grid_columns){
		selection_id -= grid_columns;
                if(selection_id < bottom_items) scroll_up(view_p);	
	    }
            break;
        default:
	    DBG("iconview_key(): should not reach this line of code\n");
            rfm_population_read_unlock (view_p, "iconview_key");
            return TRUE;
    }                       // end switch


    if(selection_id >= 0) { 
	// This only occurs if id is valid, which it will be.
	//gint selected_column = selection_id % grid_columns;
        //gint selected_row = selection_id / grid_columns;
	rodent_unsaturate_icon (view_p);
	rfm_select_pixbuf (view_p, view_p->population_pp[selection_id]);
        view_p->mouse_event.selected_p = view_p->population_pp[selection_id];
	view_p->population_pp[id]->flags &= (LABEL_SATURATED ^ 0xffffffff);
	rodent_redraw_item (view_p, view_p->population_pp[id]);
	view_p->population_pp[selection_id]->flags |= LABEL_SATURATED;
	rodent_redraw_item (view_p, view_p->population_pp[selection_id]);
	if (selection_id){
	    g_object_set_data(G_OBJECT(view_p->widgets.paper), "RODENT_ROOT_SELECTED", NULL);
	} else {
	    g_object_set_data(G_OBJECT(view_p->widgets.paper), "RODENT_ROOT_SELECTED", GINT_TO_POINTER(1));
	}
    } else {
	DBG("Invalid selection_id in iconview_key()\n");
    }

    rfm_update_status_line (view_p);
    
    rfm_population_read_unlock (view_p, "iconview_key");
    return TRUE;
    
}

