/*
 * Edscott Wilson Garcia Copyright 2012
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; 
 */
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
#include "rodent.h"
#include "fuse-group_options.h"
#include "fuse-common.h"


/* this should be first 2 lines after headers: */
G_MODULE_EXPORT LIBRFM_MODULE

#define MODULE_NAME "obex"
//Not applicable:
//#define SUBMODULE_NAME "fuse"
#define MODULE_LABEL _("ObexFTP")
#define MODULE_ICON_ID "xffm/emblem_atom/compositeC/emblem_bluetooth"
#define MODULE_ENTRY_TIP _("Use Bluetooth wireless networking to connect to your phone")
#define PARENT_MODULE_NAME "fuse"

#include "module-skeleton.h"
// Skeleton definitions

G_MODULE_EXPORT RFM_MODULE_NAME
G_MODULE_EXPORT RFM_SUBMODULE_NAME
G_MODULE_EXPORT RFM_MODULE_LABEL
G_MODULE_EXPORT RFM_MODULE_ICON_ID
G_MODULE_EXPORT RFM_MODULE_ENTRY_TIP

G_MODULE_EXPORT RFM_MODULE_PREFERENCES_KEY("RODENT-OBEX")
G_MODULE_EXPORT RFM_IS_ROOT_MODULE(FALSE)
G_MODULE_EXPORT RFM_PLUGIN_INFO(_("Bluetooth Transfer"))
G_MODULE_EXPORT RFM_MODULE_ACTIVE(TRUE)
G_MODULE_EXPORT RFM_MODULE_MONITOR(TRUE)
G_MODULE_EXPORT RFM_MODULE_RELOAD(TRUE)
G_MODULE_EXPORT RFM_MODULE_SKIPWAIT(TRUE)
G_MODULE_EXPORT RFM_IS_SELECTABLE(TRUE)

// superceded:
//G_MODULE_EXPORT RFM_ITEM_ICON_ID
// G_MODULE_EXPORT RFM_G_MODULE_CHECK_INIT
// g_module_check_init is now located at fuse-common.c

#define OBEX_AUTHORIZATION _("Bluetooth Devices")
#define OBEX_INFO1 _("Bluetooth Device Setup")
#define OBEX_INFO2 _("The Bluetooth new device setup will walk you through the process of configuring Bluetooth enabled devices for use with this computer.")
#define OBEX_OPTIONS _("Bluetooth Devices")
#define OBEX_DEVICE _("Bluetooth Adapters")
#define OBEX_MAC   _("Mac Address")
#define OBEX_NAME   _("Device Name")
#define OBEX_PIN   _("User Specified PIN")
#define FUSE_MOUNT_POINT  _("Mount point:")
#define OBEX_KEY_FILE "fuse.ini"
#define OBEX_TIP OBEX_INFO1
#include "fuse-options.i"    
#include "obex-dialog.i"

#if 0
G_MODULE_EXPORT
void *
module_icon_id(void){
    static gchar *icon=NULL;
    if (icon == NULL){
	icon = g_strdup_printf("%s/pixmaps/rodent-obex.svg", PACKAGE_DATA_DIR);
    }
    return icon;
}
#endif

G_MODULE_EXPORT
xfdir_t *
module_xfdir_get (void *p) {
   void *argv[] = {
	p,
	(void *)"obexfs",
	(void *)"obex://",
	(void *)"FUSE_MOUNT_POINT",
	(void *)MODULE_NAME,
	(void *)OBEX_AUTHORIZATION,
	NULL
    };
    return FUSE_xfdir(argv);
}

G_MODULE_EXPORT
const gchar *
item_icon_id (void *p){
    void *argv[] = {
	p,
	(void *)MODULE_LABEL,
	(void *)module_icon_id(),
	(void *)OBEX_AUTHORIZATION,
	NULL
    };
    return FUSE_icon(argv);
}


// gboolean
// This function informs Rodent by returning TRUE that the double click
// action will be processed by the module. If function returns FALSE
// (or is not defined in the module) then Rodent will attempt the default
// double click action.
// Parameter p is the view's widgets_p pointer.
// Parameter q is the icon's record entry.
G_MODULE_EXPORT
void *
double_click(void * p, void *q){
    record_entry_t *en = q;
    if (!en) return NULL;
    const gchar *url = en->pseudo_path;
    return FUSE_click((void *)confirm_obex_host_dialog, url, en, MODULE_NAME);

}



void *
mount_url (widgets_t *widgets_p, const gchar *url){
    gchar **options_fuse = NULL;
    gchar **options_module = NULL;
    gchar *mount_point = group_options_get_key_value (url, "FUSE_MOUNT_POINT");
    if (!fuse_mkdir(mount_point)){
	g_free(mount_point);
	return NULL;
    }
    gchar *device = group_options_get_key_value (url, "OBEX_DEVICE");
    gchar *mac = group_options_get_key_value (url, "OBEX_MAC");

    gchar *name = group_options_get_key_value (url, "OBEX_NAME");
    gboolean monitor = group_options_get_key_boolean (url, "FUSE_MONITOR");


    gchar *argv[MAX_COMMAND_ARGS];
    const gchar *remote = url;
    if (strncmp(remote, "obex://", strlen("obex://"))==0) {
	remote += strlen("obex://");
    }
    
    gint i=0;
    argv[i++] = "obexfs";
    argv[i++] = "-N"; // non blocking, FWIW
    argv[i++] = "-b";
    argv[i++] = mac;
    argv[i++] = mount_point;

    // The rest of options...
    gchar **o;

    options_fuse = 
	group_options_get_key_options(url, 1, 
	    fuse_options);
    for (o=options_fuse; o && *o && i+1 < MAX_COMMAND_ARGS; o++) {
	argv[i++] = *o;
    }

    gchar *fsname=NULL;
    if (monitor){
	rfm_set_monitor_type(mount_point);
 	/*argv[i++] = "-o";
	fsname =  g_strdup_printf("fsname=monitor-%s",remote);
	argv[i++] = fsname;*/
    } 
    options_module =
	group_options_get_key_options(url, 2, 
	    module_options);
    for (o=options_module; o && *o && i+1 < MAX_COMMAND_ARGS; o++) {
	argv[i++] = *o;
    }

    argv[i++] = NULL;

    rfm_show_text(widgets_p);
    rfm_thread_run_argv (widgets_p, argv, FALSE);

    g_free(device);
    g_free(mac);
    g_free(name);
    g_free(mount_point);
    g_free(fsname);

    g_strfreev(options_fuse);
    g_strfreev(options_module);
    return GINT_TO_POINTER(TRUE);

}


static void
mount_host (GtkMenuItem * menuitem, gpointer user_data){
    record_entry_t *en = g_object_get_data(G_OBJECT(menuitem), "entry");
    if (!en) return;
    widgets_t *widgets_p = rfm_get_widget("widgets_p");;

    mount_url(widgets_p, en->pseudo_path);
}

static void 
do_properties (GtkMenuItem * menuitem, gpointer user_data) {
    record_entry_t *en = g_object_get_data(G_OBJECT(menuitem), "entry");
    const gchar *url = en->pseudo_path;
    FUSE_click((void *)confirm_obex_host_dialog, url, NULL, MODULE_NAME);

    return ;
}


// gboolean
// This function is to generate a module specific popup menu, either on
// icon click or on void space click . 
// If this function will generate a popup menu, return value should be TRUE,
// otherwise return FALSE so Rodent will generate the default popup menu.
// Popup menu for modules should be set as view data on the paper object
// identified by "private_popup_menu".
// Parameter p is the view's widgets_p pointer.
// Parameter q is the icon's record entry.
G_MODULE_EXPORT
void *
private_popup(void *p, void *q){
    void *argv[] = {
	(void *)OBEX_OPTIONS,
	(void *)do_properties,
	(void *)mount_host,
	NULL
    };
   return FUSE_popup(argv);
}


//  gchar *  
// This function returns a newly allocated string with the general information
// of the entry (parameter p). Rodent uses this to construct the popup tip.
// Returned value should be freed when no longer used.
G_MODULE_EXPORT
void *
item_entry_tip(void *p){
    if (!p) return NULL;
    record_entry_t *en = p;
    if (!en->path) return NULL;
    if (strcmp(en->path, OBEX_AUTHORIZATION)==0){
	return g_strdup(OBEX_INFO2);
    }
    if (rfm_g_file_test(en->path, G_FILE_TEST_IS_DIR)){
	gchar *text =  g_strdup_printf("\n%s\n\n%s\n",
		en->path,
		_("The mount point used for the media device connection."));
	return text;
    }
    if (en->module  && strcmp(en->module, MODULE_NAME)){
	const gchar *text = rfm_void(PLUGIN_DIR, en->module, "module_entry_tip");
	return g_strdup(text);
    } 
    return g_strdup("fixme: obex-submodule.c");
}


