#ifdef COPYRIGHT_INFORMATION
#include "gplv3.h"
#endif
/*
 * Copyright (C) 2002-2012 Edscott Wilson Garcia
 * EMail: edscott@users.sf.net
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; 
 */
//
//
// Dialog to configure a new sshfs host.
/*
 * Edscott Wilson Garcia Copyright 2011
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */



/*{
        BINARY, // type
	TRUE, // sensitive
	"-o", // option flag
	"reconnect", // option id
	N_("reconnect to server"), // text
	{
	    .default_char = NULL // union: gint, gchar *, gdouble
	}
    },*/


// Test cases:
//  1. ssh key, empty passphrase
//  2. ssh key, passphrase
//  3. ssh user/password


static void
free_ssh_host (ssh_host_t *ssh_host_p){
    if (!ssh_host_p) return;
   
    // Release strings
    g_free(ssh_host_p->computer);
    g_free(ssh_host_p->remote_path);
    g_free(ssh_host_p->url);
    g_free(ssh_host_p->mount_point);
    g_free(ssh_host_p->login);
    // Release structure
    g_free(ssh_host_p);
}

static gchar *
get_ssh_fullhost(ssh_host_t *ssh_host_p){
    if (ssh_host_p->secure_shell_key) {
	return g_strdup_printf("%s", ssh_host_p->computer);
    } else if (!ssh_host_p->login) {
	return g_strdup_printf("%s", ssh_host_p->computer);
    } else {
	return g_strdup_printf("%s@%s", 
		ssh_host_p->login, ssh_host_p->computer);
    }
}



