#ifdef COPYRIGHT_INFORMATION
#include "gplv3.h"
#endif
/*
 * Copyright (C) 2002-2012 Edscott Wilson Garcia
 * EMail: edscott@users.sf.net
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; 
 */
//
//

/*
 * Edscott Wilson Garcia Copyright 2012
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
void *
mount_url (widgets_t *widgets_p, const gchar *url);

gchar*
accept (fuse_data_t *f_data_p, const gchar *url){
    // url is the keyfile group
    f_data_p->url = url;
    if (!FUSE_get_login_info (f_data_p)) {
	return NULL;
    }
    // FLAG_0 is done.

    // FLAG_1: fuse options.    
    f_data_p->flag_id = 1;
    f_data_p->options_p = fuse_options;
    f_data_p->options_keys_p = &fuse_option_keys;
    FUSE_set_options(f_data_p);     
    // FLAG_2: module options
    f_data_p->flag_id = 2;
    f_data_p->options_p = module_options;
    f_data_p->options_keys_p = &module_option_keys;
    FUSE_set_options(f_data_p);     
    // FLAG_3: sshfs options
    f_data_p->flag_id = 3;
    f_data_p->options_p = sshfs_options;
    f_data_p->options_keys_p = &sshfs_option_keys;
    FUSE_set_options(f_data_p);     
    // FLAG_4: ftp options (submodule specific)
    // FLAG_5: curlftpfs options (submodule specific)
    //
    // FLAG_6: mount options 
    // FLAG_7: nfs options 
    // FLAG_8: nfs v23 options 
    // FLAG_9: nfs v4 options 
    // FLAG_10: cifs options 
   
    return FUSE_save_keyfile(f_data_p);
}



static
fuse_data_t *
confirm_ssh_host_dialog (const gchar *url) {
    widgets_t * widgets_p = rfm_get_widget("widgets_p");
    fuse_data_t *f_data_p = (fuse_data_t *)FUSE_data_new(NULL);
    if (!f_data_p) g_error("cannot allocate f_data_p\n");

    f_data_p->widgets_p = widgets_p;
    f_data_p->url = url;
    f_data_p->info1 = SSH_SECURE_SHELL_KEY_INFO1;
    f_data_p->info2 = SSH_SECURE_SHELL_KEY_INFO2;

    f_data_p->dialog = FUSE_init_dialog(f_data_p);
#if 10

    g_object_set_data(G_OBJECT(f_data_p->dialog), 
	    "f_data_p", f_data_p);
    g_object_set_data(G_OBJECT(f_data_p->dialog), 
	    "url_template", "sftp");

    GtkWidget *hbox;

    f_data_p->item_string = FUSE_COMPUTER;
    f_data_p->item_id = "FUSE_COMPUTER";
    if (!FUSE_add_entry(f_data_p)) DBG("FUSE_add_entry(f_data_p): %s\n", "FUSE_COMPUTER");

    f_data_p->item_string = FUSE_REMOTE_PATH;
    f_data_p->item_id = "FUSE_REMOTE_PATH";
    if (!FUSE_add_entry(f_data_p)) DBG("FUSE_add_entry(f_data_p): %s\n", "FUSE_REMOTE_PATH");


    f_data_p->item_string = FUSE_LOGIN;
    f_data_p->item_id = "FUSE_LOGIN";
    if (!FUSE_add_entry(f_data_p)) DBG("FUSE_add_entry(f_data_p): %s\n", "FUSE_LOGIN");


    f_data_p->extra_text = FUSE_CAUTION;
    f_data_p->extra_text = NULL;
    f_data_p->item_string = FUSE_SECURE_SHELL_KEY;
    f_data_p->item_id = "FUSE_SECURE_SHELL_KEY";
    if (!FUSE_add_check(f_data_p)) DBG("FUSE_add_entry(f_data_p): %s\n", "FUSE_SECURE_SHELL_KEY");

    f_data_p->item_string = FUSE_ALLOW_EMPTY_PASSPHRASE;
    f_data_p->item_id = "FUSE_ALLOW_EMPTY_PASSPHRASE";
    if (!FUSE_add_check(f_data_p)) DBG("FUSE_add_entry(f_data_p): %s\n", "FUSE_ALLOW_EMPTY_PASSPHRASE");


    f_data_p->item_string = FUSE_MOUNT_POINT;
    f_data_p->item_id = "FUSE_MOUNT_POINT";
    hbox =
	FUSE_add_entry(f_data_p);
    if (rfm_void(PLUGIN_DIR, "fstab", "module_active")) {
	gtk_widget_set_sensitive(hbox, FALSE);
    }


    f_data_p->item_string = FUSE_URL;
    f_data_p->item_id = "FUSE_URL";
    if (!FUSE_add_entry(f_data_p)) DBG("FUSE_add_entry(f_data_p): %s\n", "FUSE_URL");
    GtkWidget *entry = g_object_get_data(G_OBJECT(f_data_p->dialog), "FUSE_URL");
    const gchar *url_template = g_object_get_data(G_OBJECT(f_data_p->dialog),"url_template");
    gchar *u =g_strconcat(url_template, "://", NULL);
    gtk_entry_set_text(GTK_ENTRY(entry), u);
    g_free(u);
    gtk_widget_set_sensitive(entry, FALSE);


    
    f_data_p->extra_text = FUSE_CAUTION;
    f_data_p->item_string = FUSE_MONITOR;
    f_data_p->item_id = "FUSE_MONITOR";
    if (!FUSE_add_check(f_data_p)) DBG("FUSE_add_entry(f_data_p): %s\n", "FUSE_MONITOR");

    f_data_p->item_string = FUSE_BROADBAND;
    f_data_p->item_id = "FUSE_BROADBAND";
    if (!FUSE_add_check(f_data_p)) DBG("FUSE_add_entry(f_data_p): %s\n", "FUSE_BROADBAND");


    f_data_p->label = _("FUSE");
    f_data_p->options_p = fuse_options;
    f_data_p->flag_id = 1;
    FUSE_add_option_page(f_data_p);

    f_data_p->label = _("SSHFS");
    f_data_p->options_p = sshfs_options;
    f_data_p->flag_id = 3;
    FUSE_add_option_page(f_data_p);

 
    f_data_p->label = _("Module");
    f_data_p->options_p = module_options;
    f_data_p->flag_id = 2;
    FUSE_add_option_page(f_data_p);
 
    FUSE_reset_url_field(f_data_p);
#endif                                
    return f_data_p;
}

#if 0
static gboolean
confirm_ssh_host (const gchar *url) {
    widgets_t * widgets_p = rfm_get_widget("widgets_p");
    GCond *signal = fuse_hold_monitor();
    fuse_data_t *f_data_p = confirm_ssh_host_dialog (url);
    if(!f_data_p || !f_data_p->dialog){
        return FALSE;
    }
    gint response;
retry:
    response = rfm_dialog_run_response(f_data_p->dialog);
    gtk_widget_hide (f_data_p->dialog);
    gboolean retval;
    if(response == GTK_RESPONSE_YES || response == GTK_RESPONSE_APPLY){
	gchar *new_url = accept(f_data_p, url);
	if (!new_url) {
	    gtk_widget_show (f_data_p->dialog);
	    goto retry;
	}
	if(response == GTK_RESPONSE_YES) {
	    mount_url(new_url);
	}
	gtk_widget_destroy (f_data_p->dialog);
	view_t *view_p = widgets_p->view_p;
	record_entry_t *t_en = rfm_copy_entry(view_p->en);
	if(!rodent_refresh (widgets_p, t_en)) {
	    rfm_destroy_entry(t_en);
	}

	g_free(new_url);
        retval = TRUE;
    } else {
	gtk_widget_destroy (f_data_p->dialog);
        retval = FALSE;
    }
    g_cond_signal(signal);
    return retval;
}
#endif
//////////////////////////////////////////////////////////////////////////////////

