#ifdef COPYRIGHT_INFORMATION
#include "gplv3.h"
#endif
/*
 * Copyright (C) 2002-2012 Edscott Wilson Garcia
 * EMail: edscott@users.sf.net
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; 
 */
//
//

static gchar **sshfs_option_keys = NULL;
static  GroupOptions sshfs_options[]={
// SSHFS options:
    {
	.sensitive = 1, .flag = "-C", .id = NULL,
	.text = N_("equivalent to \'-o compression=yes\'"), 
	    .entry = NULL },
    {
	.sensitive = 1, .flag = "-o", .id = "reconnect", 
	.text = N_("reconnect to server"), 
	.entry = NULL },
    {
	.sensitive = 1, .flag = "-o", .id = "delay_connect",
	.text = N_("delay connection to server"),
	.entry = NULL },
    {
	.sensitive = 1, .flag = "-o", .id = "sshfs_sync",
	.text = N_("synchronous writes"),
	.entry = NULL },
    {
	.sensitive = 1, .flag = "-o", .id = "no_readahead",
	.text = N_("synchronous reads (no speculative readahead)"), 
	.entry = NULL },
    {
	.sensitive = 1, .flag = "-o", .id = "sshfs_debug",
	.text = N_("print some debugging information"), 
	.entry = NULL },
    {
	.sensitive = 1, .flag = "-o", .id = "cache=no",
	.text = N_("disable caching"), 
	.entry = NULL},

    {
	.sensitive = 2, .flag = "-o", .id = "cache_timeout=",
	.text = N_("sets timeout for caches in seconds (default: 20)"), 
	.entry = "13"},
    {
	.sensitive = 2, .flag = "-o", .id = "cache_stat_timeout=",
	.text = N_("sets timeout for stat cache"), 
	.entry = "13"},
    {
	.sensitive = 2, .flag = "-o", .id = "cache_dir_timeout=",
	.text = N_("sets timeout for dir cache"), 
	.entry = "13"},
    {
	.sensitive = 2, .flag = "-o", .id = "cache_link_timeout=",
	.text = N_("sets timeout for link cache"), 
	.entry = "13"},

    {
	.sensitive = 1, .flag = "-o", .id = "workaround=", 
	.text = N_("colon separated list of workarounds\n\n\
none --> no workarounds enabled\n\
all  --> all workarounds enabled\n\
[no]rename --> fix renaming to existing file (default: off)\n\
[no]nodelaysrv --> set nodelay tcp flag in sshd (default: off)\n\
[no]truncate --> fix truncate for old servers (default: off)\n\
[no]buflimit --> fix buffer fillup bug in server (default: on)\n"), 
	.entry = "none"},
    {
	.sensitive = 1, .flag = "-o", .id = "idmap=",
	.text = N_("user/group ID mapping, possible types are:\n\n\
none --> no translation of the ID space (default)\n\
user --> only translate UID of connecting user\n"), 
	.entry = "none"},
    
    {
	.sensitive = 1, .flag = "-o", .id = "ssh_command=", 
	.text = N_("execute CMD instead of \'ssh\'"), 
	.entry = "ssh"},
    {
	.sensitive = 1, .flag = "-o", .id = "ssh_protocol=",
	.text = N_("ssh protocol to use (default: 2)"), 
	.entry = "2"},
    {
	.sensitive = 1, .flag = "-o", .id = "sftp_server=", 
	.text = N_("path to sftp server or subsystem (default: sftp)"), 
	.entry = "sftp"},
    {
	.sensitive = 1, .flag = "-o", .id = "directport=",
	.text = N_("directly connect to PORT bypassing ssh"), 
	.entry = "PORT"},

    {
	.sensitive = 1, .flag = "-o", .id = "transform_symlinks",
	.text = N_("transform absolute symlinks to relative"), 
	.entry = NULL },
    {
	.sensitive = 2, .flag = "-o", .id = "follow_symlinks",
	.text = N_("follow symlinks on the server"), 
	.entry = NULL },
    {
	.sensitive = 1, .flag = "-o", .id = "no_check_root", 
	.text = N_("don\'t check for existence of \'dir\' on server"), 
	.entry = NULL },
    {
	.sensitive =0, .flag = "-o", .id = "password_stdin",
	.text = N_("read password from stdin (only for pam_mount!)"),
	.entry = NULL },
    {
	.sensitive = 2, .flag = "-o", .id = "", 
	.text = N_("SSHOPT=VAL: ssh options (see man ssh_config)"), 
	.entry = "ConnectTimeout=5"},
    {
	.sensitive = 0, NULL, NULL, NULL, .entry = NULL
    }
  };

