
#include <gtk/gtk.h>
#include <gdk/gdkx.h>

static void 
get_root_geometry(gint *w, gint *h){
    gint x_return, y_return;
    guint w_return, h_return, d_return, border_return;
    Window root_return;
    Display *display = gdk_x11_display_get_xdisplay(gdk_display_get_default());

    XGetGeometry(display, gdk_x11_get_default_root_xwindow (), &root_return,
	    &x_return, &y_return, 
	    &w_return, &h_return, 
	    &border_return, 
	    &d_return);
    if (w) *w = w_return;
    if (h) *h = h_return;
    return;
}

static gboolean animation_stop=FALSE;
static gboolean 
anim_f(void *data){
    GdkPixbufAnimation *animation = data;
    GdkPixbufAnimationIter *a_iter = g_object_get_data(G_OBJECT(animation), "a_iter");
    GtkWidget *abox = g_object_get_data(G_OBJECT(animation), "abox");
    if (animation_stop) {
	g_object_unref(a_iter);
	g_object_unref(animation);
	return FALSE;
    }
    gdk_pixbuf_animation_iter_advance(a_iter, NULL);
							 
    GdkPixbuf *pixbuf = gdk_pixbuf_animation_iter_get_pixbuf(a_iter);
    GtkWidget *image = gtk_image_new_from_pixbuf (pixbuf);
    GList *children = gtk_container_get_children  (GTK_CONTAINER(abox));
    if (children && children->data) {
	GtkWidget *child = children->data;
	gtk_container_remove (GTK_CONTAINER(abox), child);
    }
    g_list_free(children);
    gtk_container_add  (GTK_CONTAINER(abox), image);
    gtk_widget_show(image);
    return TRUE;
}


gint
main (int argc, char *argv[]) {
    
    gtk_init (&argc, &argv);
    GtkWidget *window = gtk_window_new(GTK_WINDOW_POPUP);

	gchar *iconpath=g_strdup_printf("%s/icons/rfm/animated/rodent_animate_logo.gif", PACKAGE_DATA_DIR);

	GdkPixbufAnimation *animation = gdk_pixbuf_animation_new_from_file (iconpath, NULL);
	g_free(iconpath);
	GdkPixbufAnimationIter *a_iter = gdk_pixbuf_animation_get_iter  (animation, NULL);
	GdkPixbuf *pixbuf = gdk_pixbuf_animation_iter_get_pixbuf(a_iter);
	g_object_set_data(G_OBJECT(animation), "a_iter", a_iter);
	g_object_set_data(G_OBJECT(animation), "abox", window);

	GtkWidget *image = gtk_image_new_from_pixbuf (pixbuf);
	gtk_widget_show(image);
	gtk_container_add (GTK_CONTAINER (window), image);
	animation_stop=FALSE;
	gtk_window_set_keep_above (GTK_WINDOW(window), TRUE);
	gtk_widget_realize(window);
	// Here we should get root window parameters and center the window.
	gint w,h;
	get_root_geometry(&w, &h);
	gint x = w/2 - gdk_pixbuf_get_width(pixbuf)/2;
	gint y = h/2 - gdk_pixbuf_get_height(pixbuf)/2;

	gtk_window_move(GTK_WINDOW(window), x, y);
	
	gtk_widget_show(window);
	g_timeout_add (20, anim_f, animation);
    GMainLoop *main_loop = g_main_loop_new (NULL, FALSE);	
    g_main_loop_run(main_loop);
    g_main_loop_unref (main_loop);
    return 0;
}

