/*
 * Copyright 2014 Edscott Wilson Garcia 
 * license: GPL v.3
 */

#include "rodent.h"
#include "xmltree.h"

gint
main (int argc, char *argv[]) {
    if (!argv[1]){
        fprintf(stderr, "use: %s <xml_file> [xml_schema]\n",
                argv[0]);
        exit(0);
    }
    gchar *xmlfile = g_strdup(argv[1]); 
    if (!g_file_test(xmlfile, G_FILE_TEST_EXISTS)){
        fprintf(stderr, "%s does not exist.\n", xmlfile);
        exit(0);
    }
    if (argv[2] && !g_file_test(argv[2],G_FILE_TEST_EXISTS)){
        fprintf(stderr, "%s does not exist.\n", argv[2]);
        exit(0);
    }

#if GTK_MAJOR_VERSION==2
    if (rfm_gtk_version() != 2)
#else
    if (rfm_gtk_version() != 3)
#endif
	g_error("Critical error. Librfm is compiled for gtk+%d.0 You need to reconfigure and compile to match gtk versions.\n", rfm_gtk_version());

    rfm_init();
    setlocale (LC_ALL, "");
    gtk_init (&argc, &argv);
    
    void *xmltree = XMLTREE_new();
    //XMLTREE_set_defaults_function(xmltree, set_default_keybindings, xmltree);
    XMLTREE_set_title(xmltree, g_strdup_printf("rodent-xml %s", xmlfile));
    XMLTREE_set_xml(xmltree, xmlfile);
    g_free(xmlfile);

    if (argv[2]){
        gchar *schemafile = g_build_filename(argv[2], NULL); 
        XMLTREE_set_schema(xmltree, schemafile);
        g_free(schemafile);
    }

    //XMLTREE_set_editable_attribute(xmltree, "Keybinding", XMLTREE_key_type);
    //XMLTREE_text_activates_top_attribute(xmltree, 1);

    //set_default_keybindings (xmltree);

    // XXX This is specific for rodent-pkg XML files:
    XMLTREE_set_echo(xmltree, "action", "cmd");
    XMLTREE_set_echo(xmltree, "option", "loption");

    // Open the window
    XMLTREE_run(xmltree);
    // Free allocated resources
    XMLTREE_free(xmltree);

    return 1;
}
    
