#ifdef COPYRIGHT_INFORMATION
#include "gplv3.h"
#endif
static gchar *yum;
#if 0
#ifndef PKG_YUM_I
#define PKG_YUM_I
static gchar *yum_global_lo[] = {"assumeyes", "quiet", "verbose", "cacheonly", "version", 
"showduplicates", "obsoletes", "noplugins", "nogpgcheck", "skip-broken", 
    NULL};
static gchar *yum_global_lop[] = {
    "config",
    "debuglevel",
    "errorlevel",
    "rpmverbosity",
    "randomwait",
    "installroot",
    "enablerepo",
    "disablerepo",
    "exclude",
    "color",
    "disableexcludes",
    "disableplugin",
    "releasever",
    "setopt",
    NULL};
static pkg_command_t yums[] = {
    {.flags=ACCESS_READ|NO_SELECTION, 
        .cmd="search",  .argument="pattern/pkg_name"},
    {.flags=ACCESS_WRITE|NO_SELECTION|REMOTE_SELECTION|LOCK_DATABASE, 
        .cmd="install", .argument="pkg-name"},
    {.flags=ACCESS_WRITE|NO_SELECTION|LOCAL_SELECTION|LOCK_DATABASE|YUM_ONLY, 
        .cmd="erase", .argument="pkg-name"},
    {.flags=ACCESS_WRITE|NO_SELECTION|LOCAL_SELECTION, 
        .cmd="update", .argument="pkg-name"},
    //{.flags=ACCESS_WRITE|NO_SELECTION|LOCAL_SELECTION, 
      //  .cmd="update-to", .argument="pkg-name"},
    {.flags=ACCESS_WRITE|NO_SELECTION|LOCK_DATABASE, 
        .cmd="clean"},
    {.cmd=NULL} // no comma after last item
};
#define YUM_MENU_STUFF \
	{MENUITEM_TYPE,"pkg_menu_menu","pkg_search",\
	    {0x2001, N_("search"),"xffm/emblem_find",\
	    (gpointer) pkg_option, "search",0,0}},\
	{MENUITEM_TYPE,"pkg_menu_menu","pkg_install",\
	    {0x2001, N_("install"),"xffm/emblem_greenball",\
	    (gpointer) pkg_option, "install",0,0}},\
	{MENUITEM_TYPE,"pkg_menu_menu","pkg_erase",\
	    {0x2001, N_("erase"),"xffm/stock_remove",\
	    (gpointer) pkg_option, "erase",0,0}},\
	{MENUITEM_TYPE,"pkg_menu_menu","pkg_update",\
	    {0x2001, N_("update"),"xffm/stock_refresh",\
	    (gpointer) pkg_option, "update",0,0}},\
	{MENUITEM_TYPE,"pkg_menu_menu","pkg_clean",\
	    {0x2001, N_("clean"),"xffm/stock_clear",\
	    (gpointer) pkg_option, "clean",0,0}},\
	{NULL_TYPE} 
#endif
#endif


static GSList *add_yum_search_item(GSList *pkg_list, gchar *line, widgets_t *widgets_p){

	if (!strchr(line,'\n')) return pkg_list;
	if (*line == ' '){
	    //rfm_threaded_diagnostics(widgets_p, "xffm/emblem_package", NULL);
	    rfm_threaded_diagnostics(widgets_p, "xffm_tag/blue", g_strdup(line));	
	    return pkg_list;
	}    
	rfm_threaded_diagnostics(widgets_p, "xffm_tag/red", g_strdup(line));	
	NOOP("line=%s",line);
	
	*(strchr(line,'\n'))=0;
	g_strchug(line);
	if (!strstr(line, " : ")) return pkg_list;

	gchar **split = g_strsplit(line, " : ", -1);
	DBG("%s|%s\n", split[0], split[1]);
	g_strstrip(split[0]);
	g_strstrip(split[1]);
        if (strlen(split[0]) ==0){
            g_strfreev(split);
            return pkg_list;
        }

	record_entry_t *en=rfm_mk_entry(0);
	en->path = g_strdup(split[0]);
	en->type=0; /* remove local-type attributes */
	en->st = (struct stat *)malloc(sizeof(struct stat));
	if (!en->st) g_error("malloc: %s\n", strerror(errno));
	memset(en->st,0,sizeof(struct stat));

	g_hash_table_replace(installed_hash, g_strdup(en->path), g_strdup_printf("%s\n", split[1]));
	en->module=MODULE_NAME;
	pkg_list=g_slist_prepend(pkg_list,en);
        g_strfreev(split);
        // Is it installed?
        gchar *command = g_strdup_printf("yum list installed %s", en->path);
        FILE *p = popen(command, "r");
        if (p) {
            gchar buffer[2096];
            memset(buffer, 0, 2096);
            while (fgets(buffer, 2095, p) && !feof(p)){
                if (strstr(buffer, en->path)){
                    SET_LOCAL_TYPE(en->type);
                    break;
                }
            }
            pclose(p);
        }
        g_free(command);
    
    return pkg_list;
}
