.\"
.\" $Id$
.\"
.TH fimrc 5 "(c) 2011\-2016 Michele Martone"
.SH NAME
fimrc \- \fB fim \fP configuration file and language reference

.SH SYNOPSIS
.B ~/.fimrc
.fi
.B /usr/local/etc/fimrc
.fi
.B fim \-\-script\-from\-stdin [ {options} ] < {scriptfile}
.fi
.B fim \-\-execute\-script {scriptfile} [ {options} ]
.fi
.B fim \-\-execute\-commands {commands} [ {options} ]
.fi
.B fim \-\-final\-commands {commands} [ {options} ]
.fi
.B fim \-\-write\-scriptout {scriptfile} [ {options} ]  
.fi
.B fim \-\-write\-scriptout /dev/stdout [ {options} ]
.fi

.SH DESCRIPTION
This page explains the 
.B fim
language, which is used for the 
.B fimrc
configuration files, {scriptfile}s, or {commands} passed via command line {options}.
This language can be used to issue commands (or programs) from the internal program command line accessed interactively through the ":" key (or rather, the key code specified by the "_console_key" variable).
One may exit from command line mode by pressing the Enter key on an empty line (a non empty command line would be submitted for execution), or the Esc key  (only in SDL mode).
The general form of a fim command/program is shown in the next section.


.SH FIM LANGUAGE GRAMMAR
This section specifies the grammar of the 
.B fim
language.

Language elements surrounded by a single quote ("'") are literals.

Warning: at the present state, this grammar has conflicts. A future release shall fix them.

  program: %empty
         | statement_list

  statement_list: statement
                | statement ';' statement_list
                | non_atomic_statements_block statement_list
                | statements_block

  non_atomic_statements_block: '{' statement_list '}'
                             | INTEGER '{' statement_list '}'
                             | conditional_statement

  statements_block: atomic_statements_block
                  | non_atomic_statements_block

  conditional_statement: if_statement
                       | loop_statement

  if_statement: 'if' '(' expression ')' statements_block
              | 'if' '(' expression ')' statements_block 'else' statements_block

  loop_statement: 'while' '(' expression ')' statements_block
                | 'do' statements_block 'while' '(' expression ')'

  atomic_statements_block: statement ';'
                         | statement ';' ';'
                         | statement ';' ';' ';'

  statement: '!' arguments
           | INTEGER IDENTIFIER
           | SLASH_AND_REGEXP
           | '+' UNQUOTED_FLOAT '%'
           | '+' QUOTED_FLOAT '%'
           | '+' INTEGER '%'
           | '*' UNQUOTED_FLOAT
           | '*' QUOTED_FLOAT
           | '*' INTEGER
           | UNQUOTED_FLOAT '%'
           | QUOTED_FLOAT '%'
           | INTEGER '%'
           | '\-' UNQUOTED_FLOAT '%'
           | '\-' QUOTED_FLOAT '%'
           | '\-' INTEGER '%'
           | INTEGER
           | '\-' INTEGER
           | IDENTIFIER
           | IDENTIFIER FILE_PATH
           | IDENTIFIER arguments
           | INTEGER IDENTIFIER arguments
           | IDENTIFIER '=' expression

  arguments: expression
           | expression arguments

  expression: '(' expression ')'
            | expression '.' expression
            | '!' expression
            | expression '%' expression
            | expression '+' expression
            | expression '\-' expression
            | expression '*' expression
            | expression '/' expression
            | expression '<' expression
            | expression '>' expression
            | expression '||' expression
            | expression BOR expression
            | expression '&&' expression
            | expression BAND expression
            | expression '>=' expression
            | expression '<=' expression
            | expression '!=' expression
            | expression '==' expression
            | expression '=~' expression
            | '\-' expression
            | IDENTIFIER
            | INTEGER
            | QUOTED_FLOAT
            | UNQUOTED_FLOAT
            | STRING

A STRING can be either a single quoted string or a double quoted string.
A FLOAT is a floating point number.
A QUOTED_FLOAT is a floating point number, either single ("'") or double (""") quoted.
An INTEGER shall be an unsigned integer number.
An IDENTIFIER shall be one of the valid fim commands (see 
.B COMMANDS REFERENCE
) or a valid alias.
A VARIABLE shall be an already declared or undeclared variable identifier (see 
.B VARIABLES REFERENCE
) or a valid alias, created using the 
.B alias
command.
The "=~" operator treats the right expression as a STRING, and uses is as a regular expression for matching purposes.
The SLASH_AND_REGEXP is a slash ("/") followed by a STRING, interpreted as a regular expression.
See \fR\fIregex\fR(1) for regular expression syntax.

The way some one\-line statements are evaluated:

.nf
:       enter command line mode
:{number}       jump to {number}^th image in the list
:^	        jump to first image in the list
:$	        jump to last image in the list
:*{factor}      scale the image by {factor}
:{scale}%       scale the image to the desired {scale}
:+{scale}%       scale the image up to the desired percentage {scale} (relatively to the original)
:\-{scale}%       scale the image down to the desired percentage {scale} (relatively to the original)

/{regexp}		 entering the pattern {regexp} (with /) makes fim jump to the next image whose filename matches {regexp}
/*.png$		 entering this pattern (with /) makes fim jump to the next image whose filename ends with 'png'
/png		 a shortcut for /.*png.*

!{syscmd}		executes the {syscmd} quoted string as a "/bin/sh" shell command


.SH COMMANDS REFERENCE

.B
alias
.fi
alias [{identifier} [{commands} [{description}]]]
.fi

.B
align
.fi
align bottom : align to the lower side the current image; align top : align to the upper side the current image; 
.fi

.B
autocmd
.fi
autocmd {event} {pattern} {commands} : manipulate auto commands
.fi

.B
autocmd_del
.fi
autocmd_del : manipulate auto commands. usage: autocmd_del {event} {pattern} {commands}
.fi

.B
basename
.fi
basename {filename} : returns the basename of {filename}
.fi

.B
bind
.fi
bind [{keysym} [{commands}]] : bind a keyboard symbol/shortcut {keysym} to {commands}; if {keysym} is at least two characters long and begins with 0 (zero), the integer number after the 0 will be treated as a raw keycode to bind the specified {keysym} to. activate the _verbose_keys variable to discover (display device dependent) raw keys.; binding is dynamical, so you can rebind keys even during program's execution
.fi

.B
cd
.fi
cd {path}: change the current directory to {path}. cd \- will change to the previous current directory (before the last ":cd {path}" command)
.fi

.B
clear
.fi
clear : clear the virtual console
.fi

.B
commands
.fi
commands : display the existing commands
.fi

.B
desaturate
.fi
desaturate : desaturate the displayed image colors. To get back the original you will have to reload the image.
.fi

.B
desc
.fi
desc 'load' {filename} [{sepchar}] : load description file {filename}, using the optional {sepchar} character as separator. See documentation of \-\-load\-image\-descriptions\-file for the format of {filename}.
.fi

.B
display
.fi
display ['reinit' {string}]|'resize' {w} {h}] : display the current file contents; if 'reinit' switch is supplied, the '{string}' specifier will be used to reinitialize (e.g.: change resolution, window system options) the display device; see documentation for the \-\-output\-device command line switch for allowed values of {string}; if 'resize' and no argument, will ask the window manager to size the window like the image; if 'resize' and two arguments, these will be used as width and height of window, to set. 
.fi

.B
dump_key_codes
.fi
dump_key_codes : dump the active key codes (unescaped, for inspection)
.fi

.B
echo
.fi
echo {args}: print the {args} on console
.fi

.B
else
.fi
if(expression){action;}['else'{action;}] : see else
.fi

.B
eval
.fi
eval {args} : evaluate {args} as commands, executing them
.fi

.B
exec
.fi
exec {filename(s)} : execute script {filename(s)}
.fi

.B
getenv
.fi
getenv {identifier} : display the value of the {identifier} environment variable
.fi

.B
goto
.fi
goto {['+'|'\-']{number}['%']['f'|'p']} | {/{regexp}/} | {'+//'}: jump to an image; if {number} is given, and not surrounded by any specifier, will go to image at index {number} ; if followed by '%', the effective index will be computed as a percentage to the current available images; if prepended by '\-' or '+', the jump will be relative to the current index; the 'f' specifier asks for the jump to occur within the files; the 'p' specifier asks for the jump to occur in terms of pages, within the current file; if /{regexp}/ is given, will jump to the first image matching the given /{regexp}/ regular expression pattern; if given '+//', will jump to the first different image matching the last given regular expression pattern. Match will occur on both file name and description, eventually loaded via desc or \-\-load\-image\-descriptions\-file.
.fi

.B
help
.fi
help [{identifier}] : provide online help, assuming {identifier} is a variable, alias, or command identifier. If {identifier} begins with  /, the search will be on the help contents and a list of matching items will be given instead. A list of commands can be obtained simply invoking "commands"; a list of aliases with "alias"; a list of bindings with "bind".
.fi

.B
if
.fi
if(expression){action;}['else'{action;}] : see if
.fi

.B
info
.fi
info : display information about the current file
.fi

.B
limit
.fi
limit [{expression} |{variable} {value}] : A browsable file list filtering function (like limiting in the 'mutt' program). Uses information loaded via \-\-load\-image\-descriptions\-file. If one argument only is provided, restrict to files whose description string matches {expression}. If two arguments are provided, restrict to files having property {variable} set to {value}. If invoked with one exclamation point ('!') as argument will restrict to the currently marked files only.  Invoked with no arguments, the original browsable files list is restored.
.fi

.B
list
.fi
list : display the files list; list 'random_shuffle': randomly shuffle the file list; list 'reverse': reverse the file list; list 'clear': clear the file list; list 'sort': sort the file list; list 'sort_basename': sort the file list according to the file base name; list 'pop' : pop the last file from the files list; list 'remove' [{filename(s)}] : remove the current file, or the {filename(s)}, if specified ; list {filename(s)} 'push': push {filename(s)} to the back of the files list; list 'filesnum': display the number of files in the files list; list 'mark' [{args}] : mark image file names for stdout printing at exit, with {args} mark the ones matching according to the rules of the 'limit' command, otherwise the current file; list 'unmark' [{args}] : unmark marked image file names, with {args} unmark the ones matching according to the rules of the 'limit' command, otherwise the current file; list 'marked': show which files have been marked so far; list 'pushdir; {dirname}: will push all the files in {dirname}, when matching the regular expression in variable _pushdir_re or, if empty, from constant regular expression \.JPG$|\.PNG$|\.GIF$|\.BMP$|\.TIFF$|\.TIF$|\.JPEG$|\.JFIF$|\.PPM$|\.PGM$|\.PBM$|\.PCX$; list 'pushdirr' {dirname}: like pushdir, but will also push encountered directory entries recursively. 
.fi

.B
load
.fi
load : load the image, if not yet loaded (see also reload)
.fi

.B
negate
.fi
negate : negate the displayed image colors.
.fi

.B
pan
.fi
pan {'down'|'up'|'left'|'right'|'ne'|'nw'|'se'|'sw'} [{steps}['%']] pan the image {steps} pixels in the desired direction; if the '%' specifier is present, {steps} will be treated as a percentage of current screen dimensions; if {steps} is not specified, the "_steps" variable will be used; if present, the "_hsteps" variable will be considered for horizontal panning; if present, the "_vsteps" variable will be considered for vertical panning; the variables may be terminated by the '%' specifier 
.fi

.B
popen
.fi
popen {syscmd} : pipe a command, invoking popen(): spawns a shell, invoking {syscmd} and executing as fim commands the output of {syscmd}
.fi

.B
pread
.fi
pread {args} : execute {args} as a shell command and read the output as an image file (using popen)
.fi

.B
prefetch
.fi
prefetch : prefetch (read into the cache) the two nearby image files (next and previous), for a faster subsequent opening. See also the _want_prefetch variable.
.fi

.B
pwd
.fi
pwd : print the current directory name, and updates the _pwd variable
.fi

.B
quit
.fi
quit [{number}] : terminate the program; if {number} is specified, use it as the program return status
.fi

.B
recording
.fi
recording 'start' : start recording the executed commands; recording 'stop' : stop  recording the executed commands; recording 'dump' : dump in the console the record buffer; recording 'execute' : execute the record buffer; recording 'repeat_last' : repeat the last performed action; 
.fi

.B
redisplay
.fi
redisplay : re\-display the current file contents
.fi

.B
reload
.fi
reload [{arg}] : load the image into memory; if {arg} is present, will force reloading, bypassing the cache (see also load)
.fi

.B
rotate
.fi
rotate {number}: rotate the image the specified amount of degrees [undocumented]
.fi

.B
scale
.fi
scale {['+'|'\-']{value}['%']|'*'{value}|'w'|'h'|'a'|'b'|'+[+\-*/]'} : scale the image according to a scale {value} (e.g.: 0.5,40%,'w','h','a','b'); if given '*' and a value, will multiply the current scale by that value; if given 'w', will scale according to the screen width; if given 'h', scale to the screen height; if given 'a', to the minimum of 'w' and 'h'; if given 'b', like 'a', provided that the image width exceeds 'w' or 'h'; if {value} is a number, will scale relatively to the original image width; if the number is followed by '%', the relative scale will be treated on a percent scale; if given '++'('+\-'), will increment (decrement) the "_magnify_factor", "_reduce_factor" variables by "_scale_factor_delta"; if given '+*'('+/'), will multiply (divide) the "_magnify_factor", "_reduce_factor" variables by "_scale_factor_multiplier"; 
.fi

.B
scrolldown
.fi
scrolldown : scroll down the image, going next if at bottom
.fi

.B
scrollforward
.fi
scrollforward : scroll the image as it were reading it
.fi

.B
set
.fi
set: returns a list of variables which are set; set {identifier}: returns the value of variable {identifier}; set {identifier} {commands}: sets variable {identifier} to value {commands}; 
.fi

.B
set_commandline_mode
.fi
set_commandline_mode : set console mode
.fi

.B
set_interactive_mode
.fi
set_interactive_mode : set interactive mode
.fi

.B
sleep
.fi
sleep [{number}=1] : sleep for the specified (default 1) number of seconds
.fi

.B
status
.fi
status : set the status line to the collation of the given arguments
.fi

.B
stdout
.fi
stdout {args} : writes to stdout its arguments {args}
.fi

.B
system
.fi
system {syscmd}: get the output of the shell command {syscmd}. (uses popen())
.fi

.B
variables
.fi
variables : display the existing variables
.fi

.B
unalias
.fi
unalias {identifier} | '\-a' : delete the alias {identifier} or all aliases (use '\-a', not \-a)
.fi

.B
unbind
.fi
unbind {keysym} : unbind the action associated to a specified {keysym}; if {keysym} is at least two characters long and begins with 0 (zero), the integer number after the 0 will be treated as a raw keycode to bind the specified {keysym} to. activate the _verbose_keys variable to discover (display device dependent) raw keys.
.fi

.B
while
.fi
while(expression){action;}  A conditional cycle construct. May be interrupted by hitting the Esc or the : key
.fi

.B
window
.fi
window {args} : manipulates the window system windows; each value of {args} shall be one of ['split' | 'hsplit' | 'vsplit' | 'normalize' | 'enlarge' | 'venlarge' | 'henlarge' | 'up' | 'down' | 'left' | 'right' | 'close' | 'swap']
.fi

.SH AUTOCOMMANDS REFERENCE
Available autocommands are: PostScale, PreScale, PrePan, PostPan, PreRedisplay, PostRedisplay, PreDisplay, PostDisplay, PrePrefetch, PostPrefetch, PostReload, PreReload, PostLoad, PreLoad, PostGoto, PreGoto, PreConfigLoading, PostConfigLoading, PreHardcodedConfigLoading, PostHardcodedConfigLoading, PreUserConfigLoading, PostUserConfigLoading, PreGlobalConfigLoading, PostGlobalConfigLoading, PreInteractiveCommand, PostInteractiveCommand, PreExecutionCycle, PreExecutionCycleArgs, PostExecutionCycle, PreWindow, PostWindow,  and they are triggered on actions as indicated by their name.
.SH VARIABLES REFERENCE
If undeclared, a variable will evaluate to 0.

There namespaces in which variables may exist are: current image, global. A namespace is specified by a prefix, which is one of: 'i:', which shall be prepended to the variable name. The global namespace is equivalent to the empty one:''. The special variable i:* expands to the collation of all the name\-value pairs for the current image.

In the following, the [internal] variables are the ones referenced in the source code (not including the hardcoded configuration, which may be inspected and/or invalidated by the user at runtime).

.B
_TERM
[out,g:] the environment TERM variable
.fi
.B
__exif_flipped
[out,i:] flipping information, read from the EXIF tags of a given image.
.fi
.B
__exif_mirrored
[out,i:] mirroring information, read from the EXIF tags of a given imag.
.fi
.B
__exif_orientation
[out,i:] orientation information in the same format of _orientation, read from the orientation EXIF tags (i:EXIF_Orientation).
.fi
.B
_archive_files
[in,g:] Regular expression matching filenames to be treated as (multipage) archives. If empty, ".*(RAR|ZIP|TAR|TAR.GZ|TGZ|TAR.BZ2|TBZ|TBZ2|CBR|CBZ|LHA|7Z|XAR|ISO)$" will be used. Within each archive, only filenames matching the regular expression in the _pushdir_re variable will be considered for opening.
.fi
.B
_autocmd_trace_stack
[in,g:] dump to stdout autocommands (autocmd) stack trace during their execution (for debugging purposes)
.fi
.B
_autodesaturate
[in,g:] if 1, will desaturate images by default
.fi
.B
_autoflip
[in,g:] if 1, will flip images by default
.fi
.B
_automirror
[in,g:] if 1, will mirror images by default
.fi
.B
_autonegate
[in,g:] if 1, will negate images by default
.fi
.B
_autotop
[in,g:] if 1, will align to the top freshly loaded images
.fi
.B
_cache_status
[out,g:] string with current information on cache status
.fi
.B
_cached_images
[out,g:] the number of images currently cached.
.fi
.B
_caption_over_image
[experimental,in,g:] if _caption_over_image is set not to 0, will display the contents of i:_comment as a caption over the image; if larger than 1, with black background. 
.fi
.B
_command_expansion
[in,g:] if 1, will enable autocompletion (on execution) of alias and command strings
.fi
.B
_comment
[i:,out] the image comment, extracted from the image file (if any)
.fi
.B
_console_buffer_free
[out,g:] amount of unused memory in the output console buffer
.fi
.B
_console_buffer_total
[out,g:] amount of memory allocated for the output console buffer
.fi
.B
_console_buffer_used
[out,g:] amount of used memory in the output console buffer
.fi
.B
_console_key
[in,g:] the key binding (an integer variable) for spawning the command line; will have precedence over any other binding
.fi
.B
_console_lines
[out,g:] the number of buffered output console text lines
.fi
.B
_console_offset
[in,out,g:] position of the text beginning in the output console, expressed in lines
.fi
.B
_debug_commands
[in,g:] print out each command before its execution (for debugging purposes)
.fi
.B
_device_string
[out,g:] the current display device string
.fi
.B
_display_as_binary
[in,g:] will force loading of the specified files as pixelmaps (no image decoding will be performed); if 1, using one bit per pixel;  if 24, using 24 bits per pixel; otherwise will load and decode the files as usual
.fi
.B
_display_as_rendered_text
[in,g:] will force loading of the specified files as text files (no image decoding will be performed); if 1; otherwise will load and decode the files as usual
.fi
.B
_display_busy
[in,g:] if 1, will display a message on the status bar when processing
.fi
.B
_display_console
[in,g:] if 1, will display the output console
.fi
.B
_display_status
[in,g:] if 1, will display the status bar
.fi
.B
_display_status_bar
[in,g:] if 1, will display the status bar
.fi
.B
_display_status_fmt
[in,g:] custom info format string, displayed in the lower left corner of the status bar; if unset: full pathname; otherwise a custom format string specified just as _info_fmt_str.
.fi
.B
_do_sanity_check
[in,experimental,g:] if 1, will execute a sanity check on startup
.fi
.B
_exiftool_comment
[out,g:] comment extracted via the exiftool interface; see _use_exiftool.
.fi
.B
_fbfont
[out,g:] The current console font file string. If the internal hardcoded font has been used, then its value is "fim://".
.fi
.B
_file_loader
[in,i:,g:] if not empty, this string will force a file loader (among the ones listed in the \-V switch output); [out] i:_file_loader stores the loader of the current image
.fi
.B
_fileindex
[out,g:] the current image numeric index
.fi
.B
_filelistlen
[out,g:] the length of the current image list
.fi
.B
_filename
[out,i:] the current file name string
.fi
.B
_fim_bpp
[out,g:] the bits per pixel count
.fi
.B
_fim_default_config_file_contents
[out,g:] the contents of the default (hardcoded) configuration file (executed after the minimal hardcoded config)
.fi
.B
_fim_default_grammar_file_contents
[out,g:] the contents of the default (hardcoded) grammar file
.fi
.B
_fim_scriptout_file
[in,g:] the name of the file to write to when recording sessions
.fi
.B
_fim_version
[out,g:] fim version number; may be used for keeping compatibility of fim scripts across evolving versions.
.fi
.B
_hsteps
[in,g:] the default steps, in pixels, when panning images horizontally (overrides steps)
.fi
.B
_ignorecase
[in,g:] if 1, will allow for case insensitive regexp\-based match in autocommands (autocmd); 
.fi
.B
_info_fmt_str
[in,g:] custom info format string, displayed in the lower right corner of the status bar; may contain ordinary text and special 'expando' sequences. These are: %p for current scale, in percentage; %w for width; %h for height; %i for image index in list; %l for image list length; %L for flip/mirror/orientation information; %P for page information; %F for file size; %M for screen image memory size; %m for memory used by mipmap; %C for memory used by cache; %T for total memory used (approximation); %R for total max memory used (as detected by getrusage()); %n for the current file path name; %N for the current file path name basename; ; %c for centering information; %v for the fim program/version identifier string; %% for an ordinary %. A sequence like %?VAR?EXP? expands to EXP if i:VAR is set; EXP will be copied verbatim except for contained sequences of the form %:VAR:, which will be expanded to the value of variable i:VAR; this is meant to be used like in e.g. 'EXIF_DateTimeOriginal?[%:EXIF_DateTimeOriginal:]?', where an EXIF\-set variable (make sure you have libexif for this) will be used only if present.
.fi
.B
_inhibit_display
[internal,g:] if 1, will inhibit display
.fi
.B
_last_file_loader
[out,g:] after each image load, _last_file_loader will be set to the last file loader used
.fi
.B
_last_system_output
[out,experimental,g:] the standard output of the last call to the system command
.fi
.B
_lastfileindex
[out,g:] the last visited image numeric index. Useful for jumping back and forth easily between two images with 'goto _lastfileindex'.
.fi
.B
_load_default_etc_fimrc
[in,g:] if 1 at startup, will load the system wide initialization file
.fi
.B
_load_fim_history
[in,g:] if 1 on startup, will load the ~/.fim_history file on startup
.fi
.B
_lwidth
[in,g:] if>0, will force the output console text width
.fi
.B
_magnify_factor
[in,g:] the image scale multiplier used when magnifying images size
.fi
.B
_max_cached_images
[in,experimental,g:] the maximum number of images after which evictions will be forced. Setting this to 0 (no limits) is ok provided _max_cached_memory is set meaningfully.
.fi
.B
_max_cached_memory
[in,experimental,g:] the maximum amount of memory (in KiB) at which images will be continued being added to the cache. Setting this to 0 (no limit) will lead to a crash (there is no protection currently).
.fi
.B
_max_iterated_commands
[experimental,g:] the iteration limit for N in "N[commandname]" iterated command invocations
.fi
.B
_no_default_configuration
[in,g:] if 0, a default, hardcoded configuration will be executed at startup, after the minimal hardcoded one. 
.fi
.B
_no_external_loader_programs
[in,g:] if 1, no external loading programs will be tried for piping in an unsupported type image file
.fi
.B
_no_rc_file
[in,g:] if 1, the ~/.fimrc file will not be loaded at startup
.fi
.B
_open_offset
[in,optional,g:,i:] offset (specified in bytes) used when opening a file; [out] i:_open_offset will be assigned to images opened at a nonzero offset 
.fi
.B
_open_offset_retry
[in,optional,g:] number of adjacent bytes to probe in opening the file 
.fi
.B
_orientation
[internal,i:] Orthogonal clockwise rotation (orientation) is controlled by: 'i:_orientation', 'g:_orientation' and applied on a per\-image basis. In particular, the values of the three variables are summed up and the sum is interpreted as the image orientation.  If the sum is 0, no rotation will apply; if it is 1, a single ( 90') rotation will apply; if it is 2, a double (180') rotation will apply; if it is 3, a triple (270') rotation will apply.  If the sum is not one of 0,1,2,3, the value of the sum modulo 4 is considered.  Therefore, ":i:_orientation=1" and ":i:_orientation=5" are equivalent: they rotate the image one time by 90'.
.fi
.B
_preferred_rendering_dpi
[in,optional,g:] if >0, pdf, ps, djvu rendering will use this value for a default document dpi (instead of a default value) 
.fi
.B
_preferred_rendering_width
[in,optional,g:] if >0, bit based rendering will use this value for a default document width (instead of a default value) 
.fi
.B
_push_checks
[in,experimental,g:] if 1 (default), will check with stat() existence of input files before push'ing them (set this to 0 to speed up loading very long file lists; in these cases a trailing slash (/) will have to be used to tell fim a pathname is a directory). This only works after initialization (thus, after command line files have been push'ed); use \-\-no\-stat\-push if you wish to set this to 0 at command line files specification 
.fi
.B
_push_pushes_dirs
[in,g:] if 1, the push command will also accept and push directories (using pushdir)
.fi
.B
_pushdir_re
[in] regular expression to match against when pushing files from a directory or an archive. By default this is "\.JPG$|\.PNG$|\.GIF$|\.BMP$|\.TIFF$|\.TIF$|\.JPEG$|\.JFIF$|\.PPM$|\.PGM$|\.PBM$|\.PCX$".
.fi
.B
_pwd
[out,g:] the current working directory; will be updated at startup and whenever the working directory changes
.fi
.B
_re_search_opts
[in,g:] affects regexp\-based searches; if an empty string, defaults will apply; if contains 'i' ('I'), case insensitive (sensitive) searches will occur; if contains 'b', will match on basename, if contains 'f' on full pathname. 
.fi
.B
_reduce_factor
[in,g:] the image scale multiplier used when reducing images size
.fi
.B
_retry_loader_probe
[in,g:] if 1 and user specified a file loader and this fails, will probe for a different loader
.fi
.B
_rows
[in,g:] if >0, will set the number of displayed text lines in the console
.fi
.B
_save_fim_history
[in,g:] if 1 on exit, will save the ~/.fim_history file on exit
.fi
.B
_scale_factor_delta
[in,g:] value used for incrementing/decrementing the scaling factors
.fi
.B
_scale_factor_multiplier
[in,g:] value used for scaling up/down the scaling factors
.fi
.B
_scale_style
[in,g:] if non empty, this string will be fed to the scale command
.fi
.B
_screen_height
[out] the screen height
.fi
.B
_screen_width
[out,g:] the screen width
.fi
.B
_seek_magic
[optional,g:] will seek for a magic signature before opening a file (for now, use like this: fim \-c '_seek_magic=MAGIC_STRING;push file_to_seek_in.ext' ) 
.fi
.B
_status_line
[in,g:] if 1, will display the status bar
.fi
.B
_steps
[in,g:] the default steps, in pixels, when panning images
.fi
.B
_sys_rc_file
[in,g:] string with the global configuration file name
.fi
.B
_use_exiftool
[in,g:] if >0 and supported, exiftool will be used to get additional information. if 1, this will be appened to _comment; if 2, will go to _exiftool_comment
.fi
.B
_use_mipmaps
[in,g:] if >0, will use mipmaps to speed up downscaling of images (this has a memory overhead equivalent to one image copy); mipmaps will not be cached. 
.fi
.B
_verbose_errors
[in,g:] if 1, will display on stdout internal errors, while parsing commands
.fi
.B
_verbose_keys
[in,g:] if 1, after each interactive mode key hit, the console will display the hit key raw keycode
.fi
.B
_verbosity
[in,experimental,g:] program verbosity
.fi
.B
_vsteps
[in,g:] the default steps, in pixels, when panning images vertically (overrides steps)
.fi
.B
_want_autocenter
[in,g:] if 1, the image will be displayed centered 
.fi
.B
_want_exif_orientation
[in,g:] if 1, will reorient images using information from EXIF metadata (and stored in in __exif_orientation, __exif_mirrored, __exif_flipped ).
.fi
.B
_want_prefetch
[in,g:] if 1, will prefetch further files just after display of the first file
.fi
.B
_want_sleep_seconds
[in,g:] number of seconds of sleep during slideshow mode
.fi
.B
_want_wm_caption_status
[in,g:] this works only if supported by the display device (currently only SDL). if set to a number that is not 0, will show the status (or command) line in the window manager caption; if set to a non\-empty string, will interpret it just as a file info format string (see _info_fmt_str); if empty, will show the program version.
.fi
.B
angle
[in,out,i:] a floating point number specifying the rotation angle, in degrees
.fi
.B
ascale
[in,out,i:] the asymmetric scaling of the current image
.fi
.B
desaturated
[out,i:] 1, if the image is desaturated
.fi
.B
flipped
[out,i:] 1, if the image is flipped
.fi
.B
fresh
[in,out,i:,experimental] 1 if the image was loaded, before all autocommands (autocmd) execution
.fi
.B
height
[out,i:] the current image original height
.fi
.B
mirrored
[out,i:] 1, if the image is mirrored 
.fi
.B
negated
[out,i:] 1, if the image is negated
.fi
.B
page
[out,experimental,g:] the current page
.fi
.B
pages
[out,experimental,i:] the current number of pages of an image
.fi
.B
random
[out] a pseudorandom number
.fi
.B
scale
[in,i:] the scale of the current image
.fi
.B
sheight
[out,i:] the current image scaled height
.fi
.B
swidth
[out,i:] the current image scaled width
.fi
.B
width
[out,i:] the current image original width
.fi
.SH COMMAND LINE USAGE EXAMPLES
.nf
# jump to the third image:
3;
# jump to first image:
^;
# jump to last image:
$;
# magnify the image two times:
*2;
# scale the image to the 30% of the original:
30%;
# scale the image up by 30%:
+30%;
# scale the image down by 30%:
\-30%;
# jump to the next image whose filename matches the ".*jpg" regular expression:
/.*jpg;
# executes the "date" system command
!"date";

.SH CONFIGURATION FILE EXAMPLES
This is the default configuration, as contained in the _fim_default_config_file_contents variable.

.nf
# $LastChangedDate: 2016\-01\-17 22:14:48 +0100 (Sun, 17 Jan 2016) $
# Contents of the default 'fimrc' file, hardcoded in the fim executable.
# Read the documentation (man fimrc) to discover how to change this default hardcoded file and how to make your own.
# Note that usually a ~/.fimrc file is read after these options take effect, so you could reset all of this with ease.
# Lines beginning with a pound (#) are ignored by fim (they are treated as comments).
#
# Internal variables.
# Some of these variables influence Fim's behaviour (input variables), some are set by Fim (output variables).
# It is wise the input variables are set at the beginning of the file, so the bottom may issue commands correctly affected by them.
if(_debug_commands==''){_debug_commands=0;}
if(_command_expansion==''){_command_expansion=1;}
if(_display_status==''){_display_status=0;}
if(_max_cached_images==''){_max_cached_images=5;}
if(_max_cached_memory==''){_max_cached_memory=81920;}
if(_max_iterated_commands==''){_max_iterated_commands=100;}
if(_want_prefetch==''){_want_prefetch=1;}
if(_no_external_loader_programs==''){_no_external_loader_programs=0;}
if(_scale_style==''){_scale_style='b';}
if(_save_fim_history==''){_save_fim_history=1;}
if(_load_fim_history==''){_load_fim_history=1;}
if(_verbose_keys==''){_verbose_keys=0;}
if(_display_busy==''){_display_busy=1;}
if(_ignorecase==''){_ignorecase=1;}
if(_re_search_opts==''){_re_search_opts='bi';}
if(_console_offset==''){_console_offset=0;}
if(_console_key==''){_console_key=58;}
if(_display_as_binary==''){_display_as_binary=0;}
if(_push_checks==''){_push_checks=1;}
#if(_want_wm_caption_status==''){_want_wm_caption_status=0;}
if(_want_exif_orientation==''){_want_exif_orientation=1;}
if(ascale==''){ascale="1.0";}
if(_use_mipmaps==''){_use_mipmaps=1;}
#
# External variables (not used internally).
if(allow_round_scroll==''){allow_round_scroll=0;}
if(console_scroll_n==''){console_scroll_n=3;}
#
alias "toggleautoflip" "_autoflip=1\-_autoflip;" "";
alias "toggleautonegate" "_autonegate=1\-_autonegate;" "";
alias "toggleflip" "i:flipped=1\-i:flipped;" "";
alias "flip" "toggleflip;redisplay;" "flip the current image along the horizontal axis";
alias "fliponce" "flip;toggleflip;" "";
alias "toggleautomirror" "_automirror=1\-_automirror;" "";
alias "togglemirror" "i:mirrored=1\-i:mirrored;" "";
alias "mirror" "togglemirror;redisplay;" "mirror the image along the vertical axis" "";
alias "mirroronce" "mirror;togglemirror;" "";
alias 'toggleLimitMarked' '__pre_limit_fileindex=_fileindex;_limit_mode=1\-_limit_mode; if(_limit_mode==1){limit "!";} else { limit; } if(_filelistlen<1){_limit_mode=0;limit;goto __pre_limit_fileindex;} i:fresh=1;redisplay; ' "toggle between limiting file list to the marked files and the full list";
# Warning : binding to C\-s, C\-z and C\-c won't make effect, as these
# codes are catched by the console driver and will have no effect in fim.
# Moreover, C\-z will crash fim and C\-c will terminate it.
# Some other combinations (e.g.:C\-l) may have similar problems in your console.
bind 'f' "flip;";
bind 'F' "fliponce;";
bind 'm' "mirror;";
bind 'M' "mirroronce;";
bind 'q' "quit";
bind 'Esc' "quit";
#bind 'n' "next_file;";
#bind 'n' "next;";
bind 'C\-h' "help";
#bind '?' "help"; # assigned to back\-search
#bind '/' "help"; # assigned to forward\-search
bind '=' "scale '100%'";
#bind 'p' "prev_file;";
bind 'Del' "list 'pop';reload;";
#bind 's' "list 'sort'";
bind 's' "scrollforward";
bind 'C\-s' "swap;redisplay;";
bind 'S' "toggleDisplayStatus";
bind 'I' "toggleautonegate";
bind 'i' "negate;redisplay;";
bind 'g' "desaturate;redisplay;";
bind 'G' "toggleDesaturate;";
#bind 'R' "reload";
#bind 'R' "redisplay";
bind 'r' "rotate90;";
bind 'R' "rotate270;";
#bind 'R' "rotate10;display;";
#bind 'r' "rotate10_ccw;display;";
#bind 'r' "reload;";
#bind 'C\-d' "display";
bind '+' "magnify";
#bind 'C\-+' "angle=angle+10.0;display;";
bind 'a' "scale 'a';";
bind 'H' "scale 'H';";
bind 'Tab' "toggleVerbosity";
bind 'Menu' "toggleVerbosity";
#bind 'C\-k' "_want_wm_caption_status=1\-_want_wm_caption_status;status ' '";
bind 'v' "toggleDisplayStatus";
bind 'A' "A";
bind 'C\-m' "list 'mark'";
bind 'u' "list 'unmark'";
bind 'Enter' "list 'mark';next";
bind '\-' "reduce";
bind "Up" "pan_up";
bind 'k' "pan_up";
#bind 'C\-k' "pan_up";
bind "Right" "pan_right";
bind 'l' "pan_right";
bind "Down" "pan_down";
bind 'j' "pan_down";
bind "Left" "pan_left";
bind 'h' "pan_left";
bind ' ' "scrolldown";
bind 't' "align 'top';";
bind 'C\-g' "system 'fbgrab fim.png'";
bind 'C\-r' "recording 'start';";
bind 'Q' "recording 'stop'";
bind 'D' "recording 'dump';";
bind 'E' "recording 'execute';";
bind 'C\-e' "recording 'execute';";
bind 'C\-x' "recording 'execute';";
bind '.' "recording 'repeat_last';";
bind '`' "toggleLimitMarked;";
alias "toggleVerbosity" "_display_console=1\-_display_console;i:fresh=1;redisplay;" "";
alias "toggleKeyVerbosity" "_verbose_keys=1\-_verbose_keys;redisplay;" "";
alias "toggleDesaturate" "_autodesaturate=1\-_autodesaturate;redisplay;" "";
alias "idempotent_cmd" "goto '+0p';";
#
# autocommands are essential to Fim's automated behaviour
# examples:
#autocmd "PostInteractiveCommand" "fim.png" "echo '\\nmatched an interactive command on fim.png\\n';";
#autocmd "PostDisplay" ".*png" "echo 'this is a png file';";
#autocmd "PostDisplay" ".*jpg" "echo 'this is a jpg file';";
#autocmd "PostDisplay" ".*gif" "echo 'this is a gif file';";
#autocmd "PostDisplay" "" "echo '\\nthis is a file\\n'";
#autocmd "PostGoto"   "" "set_interactive_mode;";
autocmd "PostGoto" "" "reload;";
#autocmd "PostGoto" "" "load;";
#autocmd "PostDisplay"   "" "i:fresh=1" ;
#autocmd "PreWindow"   "" "";
autocmd "PostWindow"   "" "display;";
autocmd "PreRedisplay"   "" "i:_will_display=1;";
autocmd "PreRedisplay"   "" "if(_scale_style!='' && i:fresh){i:fresh=0;scale _scale_style ;i:fresh=0;}";
autocmd "PostRedisplay" ""   "i:_will_display=0;";
# Display device specific config
alias "aalib_fix_do" "{if(aascale==''){ascale='2.0';}else{ascale=aascale;} i:fresh=1;display;if(_TERM=~'screen'){echo 'screen+aalib?expect binding problems!'}}" "See aalib_fix.";
alias "aalib_fix" "if(_device_string=='aa'){aalib_fix_do;scale 'a';}" "When using the aalib (ASCII art) library we face a problem: glyph proportions are seldom square (as pixels are), and are tricky to detect; for this reason, we need to reshape the image with respect to the font ratio, but we have to make a guess in the scaling factor to compensate. If at runtime a better value is known for the terminal font height/with ratio, it may be fed in the 'aascale' variable for an accurate scaling.";
#alias "exif_fix" "i:_orientation=exif_orientation;exif_orientation='';i:mirrored=exif_mirrored;exif_mirrored='';i:flipped=exif_flipped;exif_flipped='';" "";
#autocmd "PostReload"   "" "aalib_fix;exif_fix;";
#autocmd "PostLoad"   "" "aalib_fix;exif_fix;";
autocmd "PostReload"   "" "aalib_fix;";
autocmd "PostLoad"   "" "aalib_fix;";
bind "F11" "if(_device_string=='sdl' && !_fullscreen){_old_sw=_screen_width;_old_sh=_screen_height;display 'reinit' 'MW0:0';_fullscreen=1;}else if(_device_string=='sdl' && _old_sw*_old_sh*_fullscreen){display 'reinit' 'rwm'._old_sw.':'._old_sh;_fullscreen=0;}";

autocmd "PostReload"  "" "i:fresh=1" ;
autocmd "PostScale"   "" "if(0==i:_will_display){i:fresh=1;display;}" ;
#autocmd "PostScale"   "" "{i:fresh=1;display;}" ;
autocmd "PostPan"     "" "{i:fresh=1;display;}" ;
autocmd "PostReload"   "" "if(i:fresh){redisplay;}";
autocmd "PostInteractiveCommand"   "" "if(i:fresh){display;i:fresh=0;}";
autocmd "PostInteractiveCommand"   "" "if(_want_prefetch){prefetch;}";
autocmd "PostInteractiveCommand"   "" "if(_display_console==0 && i:fresh){redisplay;i:fresh=0;}";
autocmd "PostInteractiveCommand"   "" "idempotent_cmd;"; # Bug workaround: without it console scroll is broken.

alias "next10" "i=0;while(i<10){i=i+1;next;display;sleep '1';};" "goes forward 10 images";
bind 'N' 'next10';
bind 'P' 'prev10';
bind 'C\-n' "goto '+//'";
bind 'C\-p' "goto '\-//'";
bind 'C\-b' "goto '\-//'"; # Warning: C\-b cannot be detected on many configurations.
bind 'W' "display 'resize';" "if supported, resizes the window to match the current image pixels size";
bind 'C\-w' "scale '100%';display 'resize';" "if supported, scales the image to 100% and resizes the window to match its size (if fits)";
alias "endless_slideshow" "while(1){display;sleep '1';next;};" "performs an automated slideshow, endlessly";
alias "bookview"          "while(1){display;sleep '2';scrolldown;};" "";
alias "comicview"         "while(1){display;sleep '1';scrolldown;};" "";
alias "read"              "while(1){display;sleep '1';scrollforward;};" "";
alias "slowread"          "while(1){display;sleep '2';scrollforward;};" "";
alias "fastread"          "while(1){display;scrollforward;};" "";
alias "pornview"          "echo 'press any key repeatedly to terminate' ;endless_slideshow;" "";
#bind  "C\-p" "pornview";
#bind  "C\-b" "bookview";
autocmd "PreExecutionCycle" "/fbps\-" "_display_busy=0;_display_status=0;" ;
autocmd "PreExecutionCycle" "" "i:fresh=1;reload;";
#autocmd "PreExecutionCycle" "" "redisplay;";
autocmd "PreExecutionCycle" "/fbps\-.*ps001.png" "i:fresh=1;redisplay;";
#autocmd "PostInteractiveCommand" "" "i:fresh=0;";
#autocmd "PostInteractiveCommand" "" "prefetch;";
bind '*' "scale '100%'";
bind 'w' "scale 'w'";
bind '<' "rotate10_ccw;display;";
bind '>' "rotate10;display;";
bind '_' "_scale_style='';scale '100%';";
bind ',' "_display_console=1;echo _last_system_output;";
bind 'C\-a' "if(_scale_style!='a'){_scale_style='a';scale 'a';}else{_scale_style='';scale '100%';}";
#bind 'h' "scale 'h'";
#
alias "pan_nw" "pan 'nw';" "pans the image to the upper left";
alias "pan_ne" "pan 'ne';" "pans the image to the upper right";
alias "pan_se" "pan 'se';" "pans the image to the lower left";
alias "pan_sw" "pan 'sw';" "pans the image to the lower right";
alias "pan_down" "pan 'down';" "pans the image down";
alias "pan_up" "pan 'up';" "pans the image up";
alias "pan_left" "pan 'left';" "pans the image left";
alias "pan_right" "pan 'right';" "pans the image right";
#
alias "diagonal_nw" "pan_nw;" "pans the image to the upper left";
alias "diagonal_ne" "pan_ne;" "pans the image to the upper right";
alias "diagonal_se" "pan_se;" "pans the image to the lower left";
alias "diagonal_sw" "pan_sw;" "pans the image to the lower right";
bind 'd' "diagonal_nw;";
bind 'D' "diagonal_se;";
bind 'x' "diagonal_ne;";
bind 'X' "diagonal_sw;";
alias "toggleDisplayStatus" "_display_status=1\-_display_status;" "";
alias "toggleDisplayBusy" "_display_busy=1\-_display_busy;" "";
alias "sort" "list 'sort'" "sorts the files list ordered";
#toggleVerbosity;
#bind 'f' "next;display;";
#bind 'b' "prev;display;";
bind 'o' "sort";
bind 'b' "prev;";
bind 'B' "toggleDisplayBusy";
alias "random_slideshow" "while(1){goto random;}" "performs a shuffled slideshow";
alias "rotate90_ccw" "i:_orientation=i:_orientation+3;i:fresh=1;i:fresh=1;redisplay;" "";
alias "rotate90_cw"  "i:_orientation=i:_orientation+1;i:fresh=1;i:fresh=1;redisplay;" "";
alias "rotate180"  "i:_orientation=i:_orientation+2;i:fresh=1;i:fresh=1;redisplay;" "";
alias "rotate90" "rotate90_cw;display;" "";
alias "rotate270" "rotate90_ccw;display;" "";
alias "rotate10"     "rotate  '10';display;" "";
alias "rotate10_ccw" "rotate \-10;display;" "";

# window related aliases and commands
alias "wu" "window 'up'" "selects the window upwards the current";
alias "wd" "window 'down'" "selects the window under the current";
alias "wl" "window 'left'" "selects the window at left of the current";
alias "wr" "window 'right'" "selects the window at right of the current";
#bind 'K' "wu";
bind 'K' 'if(_display_console==0){echo i:_filename.": ".i:_comment;toggleVerbosity}else{toggleVerbosity;}';
# Note : on many consoles C\-j is by default equivalent to Enter.. so this may not work :)
#bind 'C\-j' "wd";
#bind 'J' "wd";
#bind 'H' "wl";
#bind 'L' "wr";
#alias "split" "window 'split'" "split the current window horizontally";
#alias "vsplit" "window 'vsplit'" "split the current window vertically";
#alias "swap" "window 'swap'" "swap the enclosing window subwindows";
#alias "ws " "window 'swap'" "see swap";
#bind 'T' "split;redisplay;";
##don't use C\-s : it will be usually catched by the console driver, and fim won't get it!
##bind 'C\-s' "split;";
#bind 'V' "vsplit;redisplay;";
#bind 'U' "swap;redisplay;";
#alias 'venlarge' 'window "venlarge"' "";
#alias 'henlarge' 'window "henlarge"' "";
#alias 'wnormalize' 'window "normalize"' "";
#alias 'wclose' 'window "close"' "";
#alias 'wc' 'window "close"' "closes the current window";
#bind  'C' "wc;redisplay;";

alias 'cache' 'echo _cache_status;' "displays cached images status";
#bind 'c' 'cache;';
bind 'c' 'align "center";';
alias 'widen'  'i:ascale=i:ascale*"1.1";*1.0;' "widen the current image";
alias 'narrow' 'i:ascale=i:ascale/"1.1";*1.0;' "narrow the current image";
alias 'contract' 'narrow';
bind  'y' "widen" "widens horizontally the image";
bind  'Y' "narrow" "shrinks horizontally the image";
#alias 'scu'   'scroll_console_up;'   "";
#alias 'scd'   'scroll_console_down;' "";
#alias 'console_scroll_up'   'if(_console_offset<_console_lines){_console_offset=_console_offset+1;}';
#alias 'console_scroll_down' 'if(_console_offset>0){_console_offset=_console_offset\-1;}';
alias 'console_scroll_up' 'if(_console_offset<_console_lines+console_scroll_n\-_rows){_console_offset=_console_offset+console_scroll_n;}';
alias 'console_scroll_down' 'if(allow_round_scroll || (_console_offset>=console_scroll_n)){_console_offset=_console_offset\-console_scroll_n;}';
alias 'console_scroll_reset' '{_console_offset=0;}';
alias 'scu'   'console_scroll_up;'   "";
alias 'scd'   'console_scroll_down;' "";
alias 'scz'   'console_scroll_reset;' "";
alias 'center'   'align "center"';
alias 'left'   'align "left"';
alias 'right'  'align "right"';
alias 'top'   'align "top"';
alias 'bottom'   'align "bottom"';
bind "PageUp" "if(_display_console==0){prev;}else{scu;}";
bind "PageDown" "if(_display_console==0){next;}else{scd;}";
bind "Home" "0;";
bind "End" "$;";
bind "^" "0;";
bind "$" "$;";
bind "Backspace" "prev;";
bind "'" "goto _lastfileindex"; 
_display_status=1;
_want_wm_caption_status="fim:%N@%p%%%L[%i/%l]";
_info_fmt_str="%p%% %wx%h%L %i/%l%P %F %T %c";
_display_status_fmt="%N%?EXIF_DateTimeOriginal?[%:EXIF_DateTimeOriginal:]?%?EXIF_ExposureTime?[%:EXIF_ExposureTime:]?%?EXIF_FNumber?[%:EXIF_FNumber:]?%?EXIF_ApertureValue?[%:EXIF_ApertureValue:]?%?EXIF_ISOSpeedRatings?[ISO%:EXIF_ISOSpeedRatings:]?:%k";
#_display_status_fmt="%N:%k"; #
#_use_exiftool=0;
echo "WELCOME : to switch to the command line interface press ':' ";
# Some more examples:
#alias "plisten" 'popen "nc \-l \-p 9999 "' "executes fim commands coming from port 9999 on this computer";
#alias "wlisten" "while(1){sleep;plisten;}" "listen to a pipe, endlessly";
#alias "musicplay"  "system 'mpc play'" "";
#alias "musicpause" "system 'mpc pause'" "";
#alias "rdjpgcom" 'system "rdjpgcom" i:_filename';
# offsetscan usage : need a mechanism for popping all images before.
#alias "offsetscan" "while(i:width<1){list 'push' offimage;_open_offset=_open_offset+1;reload;}";
#alias "offsetscan" "while(i:width<1){list 'push' '/home/dez/mostro.jpg';stdout _open_offset ;_open_offset=_open_offset+1;reload;}";
#alias "webcam" "pread 'vgrabbj \-d /dev/video0';";
#alias "webcam_cycle" "while(1){webcam;reload;sleep 1;};";
#This is a FIM initialization file. 
#Without one of these FIM is nothing.
#So feel free to modify it, but with caution! 

.SH NOTES
This manual page is incomplete: a number of topics, as type conversions, or operator precedence, or exact command usage is left unspecified.
The conditions for autocommands triggering are not specified as they should.
A formal description of the various one\-line commands, as well a more extensive example list is needed.
Many of the listed variables are only valid within a namespace, and this shall be documented clearly.
.SH BUGS
The
.B fim
language has a number of problems that shall be first documented, then fixed.
.SH SEE ALSO
\fR\fIfim\fR(1), \fR\fIfimgs\fR(1), \fR\fIregex\fR(1).
.SH AUTHOR
Michele Martone <dezperado _CUT_ autistici _CUT_ org>
.SH COPYRIGHT
See copyright notice in \fR\fIfim\fR(1).


