/**
 * Copyright (c) 2011-2015 by Andrew Mustun. All rights reserved.
 * 
 * This file is part of the QCAD project.
 *
 * QCAD is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * QCAD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with QCAD.
 */
#include <QtPlugin>

#include "RWebView.h"
#include "RWebViewPlugin.h"

RWebViewPlugin::RWebViewPlugin(QObject *parent) :
    QObject(parent) {
    initialized = false;
}

void RWebViewPlugin::initialize(QDesignerFormEditorInterface * /* core */) {
    if (initialized) {
        return;
    }
    initialized = true;
}

bool RWebViewPlugin::isInitialized() const {
    return initialized;
}

QWidget *RWebViewPlugin::createWidget(QWidget *parent) {
    return new RWebView(parent);
}

QString RWebViewPlugin::name() const {
    return "RWebView";
}

QString RWebViewPlugin::group() const {
    return "RCustomWidgets";
}

QIcon RWebViewPlugin::icon() const {
    return QIcon();
}

QString RWebViewPlugin::toolTip() const {
    return "";
}

QString RWebViewPlugin::whatsThis() const {
    return "";
}

bool RWebViewPlugin::isContainer() const {
    return false;
}

QString RWebViewPlugin::domXml() const {
    return "<ui language=\"c++\">\n"
        " <widget class=\"RWebView\" name=\"webView\">\n"
        " </widget>\n"
        "</ui>\n";
}

QString RWebViewPlugin::includeFile() const {
    return "RWebView.h";
}
