/**
 * Copyright (c) 2011-2015 by Andrew Mustun. All rights reserved.
 * 
 * This file is part of the QCAD project.
 *
 * QCAD is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * QCAD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with QCAD.
 */

#ifndef RWEBVIEW_H_
#define RWEBVIEW_H_

#include "gui_global.h"

#include <QWebView>

/**
 * \scriptable
 * \ingroup gui
 */
class QCADGUI_EXPORT RWebView: public QWebView {

Q_OBJECT

public:
    RWebView(QWidget* parent);
    virtual ~RWebView();
    virtual QSize sizeHint() const;
    virtual QSize minimumSizeHint() const;

    void installEventFilter(QObject* filterObj) {
        QWebView::installEventFilter(filterObj);
    }

    void setAttribute(Qt::WidgetAttribute attribute, bool on = true) {
        QWebView::setAttribute(attribute, on);
    }

    QObject* parent() const {
        return QWebView::parent();
    }
};

Q_DECLARE_METATYPE(RWebView*)

#endif
