#ifdef COPYRIGHT_INFORMATION
#include "gplv3.h"
#endif
/*
 *
 *  Copyright (c) 2004-2011 Edscott Wilson Garcia <edscott@users.sf.net>
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library;  */

#include <sys/types.h>
#include <sys/wait.h>

#include "rfm.h"
#if 1
static gchar *icon_ids[]={
// actions
    "xffm/stock_add/compositeX/emblem_greenball","list-add-symbolic",
    "xffm/stock_remove/compositeX/emblem_redball","list-remove-symbolic",
    "xffm/emblem_edit","edit-symbolic",
    "xffm/emblem_find","edit-find-symbolic",

    "xffm/stock_dialog-warning","dialog-warning-symbolic",
    "xffm/stock_process-reset","process-stop-symbolic",
    "xffm/stock_document-open","document-open-recent",   
    "xffm/stock_file","text-x-generic",
    "xffm/stock_document-open","document-open",
    "xffm/emblem_keyhole","dialog-password",
    "xffm/emblem_keyhole","dialog-password-symbolic",
    "xffm/stock_go-bottom","window-minimize-symbolic",
    "xffm/stock_window-close","window-close-symbolic",

// places
//
    "xffm/emblem_documents","folder-documents-symbolic",
    "xffm/stock_directory/compositeX/stock_go-down","folder-download-symbolic",
    "xffm/emblem_music","folder-music-symbolic",
    "xffm/emblem_image","folder-pictures-symbolic",
    "xffm/stock_directory/compositeX/","folder-publicshare-symbolic",
    "xffm/emblem_shared","folder-remote-symbolic",
    "xffm/stock_directory/compositeX/stock_edit-find","folder-saved-search-symbolic",
    "xffm/stock_directory","folder-symbolic",
    "xffm/stock_directory/compositeX/stock_format-text-bold",
         "folder-templates-symbolic",
    "xffm/emblem_video","folder-videos-symbolic",
    "xffm/stock_directory/compositeX/emblem_network","network-server-symbolic",
    "xffm/emblem_network","network-workgroup-symbolic",
    "xffm/emblem_start-here","start-here-symbolic",
    "xffm/emblem_bookmark","user-bookmarks-symbolic",
    "xffm/emblem_desktop","user-desktop-symbolic",
    "xffm/stock_home","user-home-symbolic",
    "xffm/emblem_bak","user-trash-symbolic",
// devices
    "xffm/stock_harddisk","drive-harddisk-symbolic",
    "xffm/stock_harddisk","harddisk-symbolic",
    "xffm/emblem_broken","image-missing",
/*    "xffm/emblem_file","text-x-generic",
    "xffm/emblem_file","ascii",
    "xffm/emblem_file","empty",
    "xffm/emblem_file","txt",
    "xffm/emblem_file","txt2",
    "xffm/emblem_file","unknown",
    "xffm/emblem_file","mime_ascii",*/


#if 0
    
// devices
    "xffm/","drive-harddisk-ieee1394-symbolic",
    "xffm/","drive-harddisk-system-symbolic",
    "xffm/","drive-harddisk-usb-symbolic",
    "xffm/","drive-multidisk-alt2-symbolic",
    "xffm/","drive-multidisk-alt-symbolic",
    "xffm/","drive-multidisk-symbolic",
    "xffm/","drive-optical-symbolic",
    "xffm/","drive-removable-media-symbolic",
    "xffm/","headphones-symbolic",
    "xffm/","input-dialpad-symbolic",
    "xffm/","input-gaming-symbolic",
    "xffm/","input-keyboard-symbolic",
    "xffm/","input-mouse-symbolic",
    "xffm/","input-tablet-symbolic",
    "xffm/","input-touchpad-symbolic",
    "xffm/","media-flash-symbolic",
    "xffm/","media-floppy-symbolic",
    "xffm/","media-optical-bd-symbolic",
    "xffm/","media-optical-cd-audio-symbolic",
    "xffm/","media-optical-dvd-symbolic",
    "xffm/","media-optical-symbolic",
    "xffm/","media-removable-symbolic",
    "xffm/","media-zip-symbolic",
    "xffm/","multimedia-player-apple-ipod-touch-symbolic",
    "xffm/","multimedia-player-symbolic",
    "xffm/","network-wired-symbolic",
    "xffm/","network-wireless-symbolic",
    "xffm/","phone-apple-iphone-symbolic",
    "xffm/","phone-symbolic",
    "xffm/","printer-network-symbolic",
    "xffm/","printer-symbolic",
    "xffm/","scanner-symbolic",
    "xffm/","video-display-symbolic",
    // actions
    "xffm/","action-unavailable-symbolic",
    "xffm/","bookmark-add-symbolic",
    "xffm/","bookmark-new-symbolic",
    "xffm/","call-end-symbolic",
    "xffm/","call-start-symbolic",
    "xffm/","content-loading-symbolic",
    "xffm/","document-open-recent-symbolic",
    "xffm/","document-open-symbolic",
    "xffm/","document-page-setup-symbolic",
    "xffm/","document-properties-symbolic",
    "xffm/","document-save-as-symbolic",
    "xffm/","document-save-symbolic",
    "xffm/","document-send-symbolic",
    "xffm/","edit-clear-all-symbolic",
    "xffm/","edit-clear-rtl-symbolic",
    "xffm/","edit-clear-symbolic",
    "xffm/","edit-copy-symbolic",
    "xffm/","edit-cut-symbolic",
    "xffm/","edit-delete-symbolic",
    "xffm/","edit-find-symbolic",
    "xffm/","edit-paste-symbolic",
    "xffm/","edit-redo-rtl-symbolic",
    "xffm/","edit-redo-symbolic",
    "xffm/","edit-select-all-symbolic",
    "xffm/","edit-select-symbolic",
    "xffm/","edit-undo-rtl-symbolic",
    "xffm/","edit-undo-symbolic",
    "xffm/","find-location-symbolic",
    "xffm/","format-indent-less-rtl-symbolic",
    "xffm/","format-indent-less-symbolic",
    "xffm/","format-indent-more-rtl-symbolic",
    "xffm/","format-indent-more-symbolic",
    "xffm/","format-justify-center-symbolic",
    "xffm/","format-justify-fill-symbolic",
    "xffm/","format-justify-left-symbolic",
    "xffm/","format-justify-right-symbolic",
    "xffm/","format-text-bold-symbolic",
    "xffm/","format-text-direction-ltr-symbolic",
    "xffm/","format-text-direction-rtl-symbolic",
    "xffm/","format-text-italic-symbolic",
    "xffm/","format-text-strikethrough-symbolic",
    "xffm/","format-text-underline-symbolic",
    "xffm/","go-bottom-symbolic",
    "xffm/","go-down-symbolic",
    "xffm/","go-first-rtl-symbolic",
    "xffm/","go-first-symbolic",
    "xffm/","go-home-symbolic",
    "xffm/","go-jump-rtl-symbolic",
    "xffm/","go-jump-symbolic",
    "xffm/","go-last-rtl-symbolic",
    "xffm/","go-last-symbolic",
    "xffm/","go-next-rtl-symbolic",
    "xffm/","go-next-symbolic",
    "xffm/","go-previous-rtl-symbolic",
    "xffm/","go-previous-symbolic",
    "xffm/","go-top-symbolic",
    "xffm/","go-up-symbolic",
    "xffm/","insert-image-symbolic",
    "xffm/","insert-link-symbolic",
    "xffm/","insert-object-symbolic",
    "xffm/","insert-text-symbolic",
    "xffm/","list-remove-all-symbolic",
    "xffm/","mail-mark-important-symbolic",
    "xffm/","mail-send-receive-symbolic",
    "xffm/","mail-send-symbolic",
    "xffm/","mark-location-symbolic",
    "xffm/","media-eject-symbolic",
    "xffm/","media-playback-pause-symbolic",
    "xffm/","media-playback-start-rtl-symbolic",
    "xffm/","media-playback-start-symbolic",
    "xffm/","media-playback-stop-symbolic",
    "xffm/","media-record-symbolic",
    "xffm/","media-seek-backward-rtl-symbolic",
    "xffm/","media-seek-backward-symbolic",
    "xffm/","media-seek-forward-rtl-symbolic",
    "xffm/","media-seek-forward-symbolic",
    "xffm/","media-skip-backward-rtl-symbolic",
    "xffm/","media-skip-backward-symbolic",
    "xffm/","media-skip-forward-rtl-symbolic",
    "xffm/","media-skip-forward-symbolic",
    "xffm/","media-view-subtitles-symbolic",
    "xffm/","object-flip-horizontal-symbolic",
    "xffm/","object-flip-vertical-symbolic",
    "xffm/","object-rotate-left-symbolic",
    "xffm/","object-rotate-right-symbolic",
    "xffm/","object-select-symbolic",
    "xffm/","process-stop-symbolic",
    "xffm/","send-to-symbolic",
    "xffm/","system-run-symbolic",
    "xffm/","system-shutdown-symbolic",
    "xffm/","tab-new-symbolic",
    "xffm/","view-continuous-symbolic",
    "xffm/","view-dual-symbolic",
    "xffm/","view-fullscreen-symbolic",
    "xffm/","view-grid-symbolic",
    "xffm/","view-list-symbolic",
    "xffm/","view-more-symbolic",
    "xffm/","view-paged-symbolic",
    "xffm/","view-refresh-symbolic",
    "xffm/","view-restore-symbolic",
    "xffm/","window-close-symbolic",
    "xffm/","window-maximize-symbolic",
    "xffm/","window-minimize-symbolic",
    "xffm/","window-restore-symbolic",
    "xffm/","zoom-fit-best-symbolic",
    "xffm/","zoom-in-symbolic",
    "xffm/","zoom-original-symbolic",
    "xffm/","zoom-out-symbolic",
#endif
        NULL,NULL
    
};
#endif

static void
define_builtin_icons(void){
    // gtk 3.10 eliminates stock built in icons. So we must add those we 
    // shall need if no icontheme is in current use. Yeah, rodent apps
    // should be able to work when *no* icon theme is present.
    // "Icon themes are eyecandy toys for the weak of mind"
    //      <quote by Marcus Aurelius>

    gint sizes[]={16,22, 24, 32, 48, 0};
  /*  gchar *icon_ids[]={
        "xffm/stock_add/compositeX/emblem_greenball", "list-add-symbolic", 
        "xffm/stock_remove/compositeX/emblem_redball", "list-remove-symbolic", 
//        "xffm/stock_add", "list-add-symbolic", 
//        "xffm/stock_remove", "list-remove-symbolic",
        "xffm/stock_home", "user-home-symbolic",
//        "xffm/emblem_folder/compositeX/emblem_home", "user-home-symbolic",
        "xffm/emblem_desktop", "user-desktop-symbolic",
        "xffm/stock_directory", "folder-symbolic",
        "xffm/stock_file", "file",//?
        "xffm/emblem_symbolic-link", "file-symbolic",//?
        "xffm/emblem_symbolic-link", "missing-image",//?

"xffm/stock_harddisk", "drive-harddisk-symbolic",
"xffm/stock_jump", "media-eject-symbolic",//
"xffm/emblem_documents", "folder-documents-symbolic",
"xffm/emblem_downloads", "folder-download-symbolic",
"xffm/emblem_music", "folder-music-symbolic",
"xffm/emblem_photos", "folder-pictures-symbolic",
"xffm/emblem_shared", "folder-publicshare-symbolic",
"xffm/stock_file", "folder-templates-symbolic",//
"xffm/emblem_video", "folder-videos-symbolic",
"xffm/stock_find", "folder-saved-search-symbolic",
        NULL,NULL
    };*/
    gint i; gchar **g=icon_ids;
    for (i=0; sizes[i] > 0; i++) for (; g && *g; g=g+2)
    {

        GdkPixbuf *pixbuf = rfm_get_pixbuf(*g, sizes[i]);
        if (!pixbuf) 
            DBG("create_find_dialog(): cannot create pixbuf at size %d\n", sizes[i]);
        gtk_icon_theme_add_builtin_icon(*(g+1),sizes[i],pixbuf);
    }


}

static regex_t supported;
static gboolean regex_compiled = FALSE;

G_MODULE_EXPORT gboolean
svg_supported (void) {
    static int support = 2;
    if(support < 2)
        return (gboolean) support;
    else
        support = 0;
    GSList *l;
    GSList *pix_formats = NULL;
    if(!pix_formats)
        pix_formats = gdk_pixbuf_get_formats ();
    for(l = pix_formats; l; l = l->next) {
        gchar **pix_mimetypes;
        int i;
        GdkPixbufFormat *fmt = l->data;
        pix_mimetypes = gdk_pixbuf_format_get_mime_types (fmt);
        for(i = 0; pix_mimetypes[i]; i++) {
            if(g_ascii_strcasecmp (pix_mimetypes[i], "image/svg") == 0) {
                support = 1;
                break;
            }
        }
        g_strfreev (pix_mimetypes);
    }
    g_slist_free (pix_formats);
    return (gboolean) support;
}



static int
open_theme (void) {
    // If there is a version mismatch, then the cache will not
    // work with this version of Rodent and must be regenerated
    // before the main thread can continue.
    //
    if (gtk_icon_theme_get_default ()) {
	// Main thread should wait for cache to be generated.
	// If cache is up to date, then this function call should
	// return ipso facto.
	//
	// We pass NULL here so that function will not
	// enter endless loop to monitor gtk icon theme. 
	// Data parameter is also the nice wait period, in
	// seconds.
	if (!compare_cache_info ()){
	    DBG("** creating icontheme cache...\n");
	    create_new_gtk_cache(NULL);
	} else {
	    DBG("** loading icontheme cache...\n");
	    load_path_cache();
	} 
	// fire up gtk theme monitor.
	NOOP ("** background Starting GTK theme monitor\n");
	THREAD_CREATE( create_new_gtk_cache, GINT_TO_POINTER(5), "create_new_gtk_cache");
    }
    return 1;
}


static 
gint
create_icontheme_path_cache (void) {
    // This is to create a cache for full paths for icons.
    if(open_theme () < 0) {
        DBG ("create_icontheme_path_cache(): cannot load theme\n");
        return -1;
    }

    // This is to create a g_hash which will associate mimetype with an icon
    // the mimetype/icon association hash is created by parsing the xml file.
    gchar *mimefile = mime_icon_get_local_xml_file ();
    NOOP ("create_icontheme_path_cache(): looking for: %s\n", (mimefile ? mimefile : "null"));

    /* test for default mimefile  */
    if(!mimefile || !g_file_test (mimefile, G_FILE_TEST_EXISTS)) {
       NOOP ("%s: not found. \n", (mimefile ? mimefile : "null"));
       g_free (mimefile);
       mimefile = mime_icon_get_global_xml_file ();
       NOOP ("Now looking for: %s\n", (mimefile ? mimefile : "null"));
    }

    if(!mimefile || !g_file_test (mimefile, G_FILE_TEST_EXISTS)) {
        DBG ("No system wide mime file found: %s\n", (mimefile ? mimefile : "null"));
        g_free (mimefile);
        mimefile = NULL;
	return FALSE;
    }

    gboolean result = create_icon_hash (mimefile);
    g_free (mimefile);
    if(!result) {
	DBG ("cannot create basename_hash from mimefile:%s!\n", (mimefile ? mimefile : "null"));
    }
    return result;
}


