
#include "primary-options.h"


static gchar *shred_iterations[]={"1","3","5","10","20",NULL};
static gchar *shred_size[]={"10K","100K","1M","10M","100M","1G",NULL};
static gchar *ls_format[] = {"long","across","commas","horizontal","single-column","verbose","vertical",NULL};
static gchar *ls_istyle[] = {"none","slash","file-type","classify",NULL};
static gchar *ls_qstyle[] = {"literal","locale","shell","shell-always","c","escape",NULL};
static gchar *ls_sort[] = {"none","extension","size","time","version",NULL};
static gchar *ls_time[] = {"status","access",NULL};
static gchar *ls_tstyle[] = {"locale","full-iso","long-iso","iso",NULL};
static gchar *cp_v_control[] = {"existing","none","numbered","simple",NULL};
static gchar *cp_attributes[] = {"all","mode","ownership","timestamps","context","links","xattr",NULL};
static gchar *cp_when[] = {"always","auto","never",NULL};
static gchar *cp_suffix[] = {"~",".bak",NULL};
static gchar *rm_interactive[]={"always","never","once",NULL};

#if 0
gchar **get_shred_iterations(){return shred_iterations;}
gchar **get_shred_size(){return shred_size;}
gchar **get_ls_format(){return ls_format;}
gchar **get_ls_istyle(){return ls_istyle;}
gchar **get_ls_qstyle(){return ls_qstyle;}
gchar **get_ls_sort(){return ls_sort;}
gchar **get_ls_time(){return ls_time;}
gchar **get_ls_tstyle(){return ls_tstyle;}
gchar **get_cp_v_control(){return cp_v_control;}
gchar **get_cp_attributes(){return cp_attributes;}
gchar **get_cp_when(){return cp_when;}
gchar **get_cp_suffix(){return cp_suffix;}
gchar **get_rm_interactive(){return rm_interactive;}
#endif

static RfmProgramOptions ls_options[]={ 
    // 0x01
    {"",N_("Ask the user to get additional parameters"),TRUE,NULL},
    // 0x02
    {"-A",N_("-A, --almost-all           do not list implied . and .."),TRUE,NULL},
#ifdef GNU_LS
    // 0x04
    {"-C",N_("-C                         list entries by columns"),TRUE,NULL},
    // 0x08
    {"-D",N_("-D, --dired                generate output designed for Emacs' dired mode"),TRUE,NULL},
    // 0x010
    {"-F",N_("-F, --classify             append indicator (one of */=>@|) to entries"),TRUE,NULL},
    // 0x020
    {"-G",N_("-G, --no-group             in a long listing, don't print group names"),TRUE,NULL},
    // 0x040
    {"-H",N_("-H, --dereference-command-line\nfollow symbolic links listed on the command line"),TRUE,NULL},
    // 0x080
    {"-I",N_("-I, --ignore=PATTERN       do not list implied entries matching shell PATTERN"),TRUE,GINT_TO_POINTER(-1),RFM_LS_ignore},
    // 0x0100
    {"-L",N_("-L, --dereference          when showing file information for a symbolic\nlink, show information for the file the link\nreferences rather than for the link itself"),TRUE,NULL},
    // 0x0200
    {"-N",N_("-N, --literal              print raw entry names (don't treat e.g. control\ncharacters specially)"),TRUE,NULL},
    // 0x0400
    {"-Q",N_("-Q, --quote-name           enclose entry names in double quotes"),TRUE,NULL},
    // 0x0800
    {"-R",N_("-R, --recursive            list subdirectories recursively"),TRUE,NULL},
    // 0x01000
    {"-S",N_("-S                         sort by file size"),TRUE,NULL},
    // 0x02000
    {"-T",N_("-T, --tabsize=COLS         assume tab stops at each COLS instead of 8"),TRUE,GINT_TO_POINTER(-1),RFM_LS_tabsize},
    // 0x04000
    {"-U",N_("-U                         do not sort; list entries in directory order"),TRUE,NULL},
    // 0x08000
    {"-X",N_("-X                         sort alphabetically by entry extension"),TRUE,NULL},
    // 0x010000
    {"-Z",N_("-Z, --context              print any SELinux security context of each file"),TRUE,NULL},
    // 0x020000
    {"-a",N_("-a, --all                  do not ignore entries starting with ."),TRUE,NULL},
    // 0x040000
    {"--author",N_("--author               with -l, print the author of each file"),TRUE,NULL},
    // 0x080000
    {"-b",N_("-b, --escape               print C-style escapes for nongraphic characters"),TRUE,NULL},
    // 0x0
    {"--block-size","--block-size=SIZE      scale sizes by SIZE before printing them.  E.g.,\n'--block-size=M' prints sizes in units of\n1,048,576 bytes.  See SIZE format below.",TRUE,GINT_TO_POINTER(-1),RFM_LS_blocksize},
    // 0x0100000
    {"-c",N_("-c                         with -lt: sort by, and show, ctime (time of last\nmodification of file status information)\nwith -l: show ctime and sort by name\notherwise: sort by ctime, newest first"),TRUE,NULL},
    // 0x0200000
    {"--color",N_("--color[=WHEN]         colorize the output.  WHEN defaults to 'always'\nor can be 'never' or 'auto'.  More info below"),TRUE,NULL},
    // 0x0400000
    {"-d",N_("-d, --directory            list directory entries instead of contents,\nand do not dereference symbolic links"),TRUE,NULL},
    // 0x0800000
    {"-f",N_("-f                         do not sort, enable -aU, disable -ls --color"),TRUE,NULL},
    // 0x01000000
    {"--file-type",N_("--file-type            likewise, except do not append '*'"),TRUE,NULL},
    // 0x02000000
    {"--format",N_("--format=WORD          across -x, commas -m, horizontal -x, long -l,\nsingle-column -1, verbose -l, vertical -C"),TRUE,ls_format,RFM_LS_format},
    // 0x04000000
    {"--full-time",N_("--full-time            like -l --time-style=full-iso"),TRUE,NULL},
    // 0x08000000
    {"-g",N_("-g     like -l, but do not list owner"),TRUE,NULL},
    // 0x010000000
    {"--group-directories-first",N_("group directories before files."),TRUE,NULL},
    // 0x020000000
    {"-h",N_("-h, --human-readable       with -l, print sizes in human readable format\n(e.g., 1K 234M 2G)"),TRUE,NULL},
    // 0x040000000
    {"--si",N_("--si                   likewise, but use powers of 1000 not 1024"),TRUE,NULL},
    // 0x080000000
    {"--dereference-command-line-symlink-to-dir",N_("--dereference-command-line-symlink-to-dir\nfollow each command line symbolic link\nthat points to a directory"),TRUE,NULL},
    // 0x0100000000
    {"--hide",N_("--hide=PATTERN         do not list implied entries matching shell PATTERN\n(overridden by -a or -A)"),TRUE, GINT_TO_POINTER(-1),RFM_LS_hide},
    // 0x0200000000
    {"--indicator-style",N_("--indicator-style=WORD  append indicator with style WORD to entry names:\nnone (default), slash (-p),\nfile-type (--file-type), classify (-F)"),TRUE,ls_istyle,RFM_LS_istyle},
    // 0x0400000000
    {"-i",N_("-i, --inode                print the index number of each file"),TRUE,NULL},
    // 0x0800000000
    {"-k",N_("-k, --kibibytes            use 1024-byte blocks"),TRUE,NULL},
    // 0x01000000000
    {"-l",N_("-l                         use a long listing format"),TRUE,NULL},
    // 0x02000000000
    {"-m",N_("-m                         fill width with a comma separated list of entries"),TRUE,NULL},
    // 0x04000000000
    {"-n",N_("-n, --numeric-uid-gid      like -l, but list numeric user and group IDs"),TRUE,NULL},
    // 0x08000000000
    {"-o",N_("-o                         like -l, but do not list group information"),TRUE,NULL},
    // 0x010000000000
    {"-p",N_("-p, --indicator-style=slash\nappend / indicator to directories"),TRUE,NULL},
    // 0x020000000000
    {"-q",N_("-q, --hide-control-chars   print ? instead of non graphic characters"),TRUE,NULL},
    // 0x040000000000
    {"--show-control-chars",N_("--show-control-chars   show non graphic characters as-is (default\nunless program is 'ls' and output is a terminal)"),TRUE,NULL},
    // 0x080000000000
    {"--quoting-style",N_("--quoting-style=WORD   use quoting style WORD for entry names:\nliteral, locale, shell, shell-always, c, escape"),TRUE,ls_qstyle,RFM_LS_qstyle},
    // 0x0100000000000
    {"-r",N_("-r, --reverse              reverse order while sorting"),TRUE,NULL},
    // 0x0200000000000
    {"-s",N_("-s, --size                 print the allocated size of each file, in blocks"),TRUE,NULL},
    // 0x0400000000000
    {"--sort",N_("--sort=WORD            sort by WORD instead of name: none -U,\nextension -X, size -S, time -t, version -v"),TRUE,ls_sort,RFM_LS_sort},
    // 0x0800000000000
    {"--time",N_("--time=WORD            with -l, show time as WORD instead of modification\ntime: atime -u, access -u, use -u, ctime -c,\nor status -c; use specified time as sort key\nif --sort=time--time=WORD            with -l, show time as WORD instead of modification\ntime: atime -u, access -u, use -u, ctime -c,\nor status -c; use specified time as sort key\nif --sort=time--time=WORD            with -l, show time as WORD instead of modification\ntime: atime -u, access -u, use -u, ctime -c,\nor status -c; use specified time as sort key\nif --sort=time"),TRUE,ls_time,RFM_LS_time},
    // 0x01000000000000
    {"--time-style",N_("--time-style=STYLE  show times using style STYLE:\nfull-iso, long-iso, iso, +FORMAT\nFORMAT is interpreted like 'date'"),TRUE,ls_tstyle,RFM_LS_tstyle},
    // 0x02000000000000
    {"-t",N_("-t                         sort by modification time, newest first"),TRUE,NULL},
    // 0x04000000000000
    {"-u",N_("-u                         with -lt: sort by, and show, access time\nwith -l: show access time and sort by name\notherwise: sort by access time"),TRUE,NULL},
    // 0x08000000000000
    {"-v",N_("-v                         natural sort of (version) numbers within text"),TRUE,NULL},
    // 0x010000000000000
    {"-w",N_("-w, --width=COLS           assume screen width instead of current value"),TRUE,GINT_TO_POINTER(-1),RFM_LS_width},
    // 0x020000000000000
    {"-x",N_("-x                         list entries by lines instead of by columns"),TRUE,NULL},
    // 0x040000000000000
    {"-1",N_("-1                         list one file per line"),TRUE,NULL},
    // 0x080000000000000
    {"--help",NULL,FALSE,NULL},
    // 0x0100000000000000
    {"--version",NULL,FALSE,NULL},
#else
    // 0x02
    {"-B",N_("Force printing of non-printable characters"),TRUE,NULL},
    // 0x04
    {"-C",N_("Columns"),TRUE,NULL},
    // 0x08
    {"-D","-D format",FALSE,NULL},
    // 0x010
    {"-F",N_("append one of */=>@|"),TRUE,NULL},
    // 0x020
    {"-G",N_("Colorize"),TRUE,NULL},
    // 0x040
    {"-H",N_("Follow links"),TRUE,NULL},
    // 0x080
    {"-I",N_("prevent -A"),TRUE,NULL},
    // 0x0100
    {"-L",N_("Always follow links"),TRUE,NULL},
    // 0x0200
    {"-P",N_("Don't follow symbolic links"),TRUE,NULL},
    // 0x0400
    {"-R",N_("recursive"),TRUE,NULL},
    // 0x0800
    {"-S",N_("Sort by Size"),TRUE,NULL},
    // 0x01000
    {"-T",N_("With -l, display complete time"),TRUE,NULL},
    // 0x02000
    {"-U",N_("Sort by Date"),TRUE,NULL},
    // 0x04000
    {"-W",N_("Display whiteouts"),TRUE,NULL},
    // 0x08000
    {"-Z",N_("Display maclabel"),TRUE,NULL},
    // 0x010000
    {"-a","-a, --all",FALSE,NULL},
    // 0x020000
    {"-b","-b, --escape",TRUE,NULL},
    // 0x040000
    {"-c",N_("Sort by ctime"),TRUE,NULL},
    // 0x080000
    {"-d",N_("list directory entries"),TRUE,NULL},
    // 0x0100000
    {"-f",N_("Do Not Sort"),TRUE,NULL},
    // 0x0200000
    {"-g",N_("like -l, but do not list owner"),TRUE,NULL},
    // 0x0400000
    {"-h",N_("human-readable"),TRUE,NULL},
    // 0x0800000
    {"-i",N_("Inode"),TRUE,NULL},
    // 0x01000000
    {"-k",N_("block-size=1K"),TRUE,NULL},
    // 0x02000000
    {"-l",N_("Details"),TRUE,NULL},
    // 0x04000000
    {"-m",N_("Comma separated values (CSV)"),TRUE,NULL},
    // 0x08000000
    {"-n",N_("numeric-uid-gid"),TRUE,NULL},
    // 0x010000000
    {"-o",N_("include file flags"),TRUE,NULL},
    // 0x020000000
    {"-p",N_("indicator-style=slash"),TRUE,NULL},
    // 0x040000000
    {"-q",N_("hide control characters"),TRUE,NULL},
    // 0x080000000
    {"-r",N_("reverse"),TRUE,NULL},
    // 0x0100000000
    {"-s",N_("show size"),TRUE,NULL},
    // 0x0200000000
    {"-t",N_("Sort by Date"),TRUE,NULL},
    // 0x0400000000
    {"-u",N_("Sort by atime"),TRUE,NULL},
    // 0x0800000000
    {"-w",N_("Force raw printing"),TRUE,NULL},
    // 0x01000000000
    {"-x",N_("Sort across"),TRUE,NULL},
    // 0x02000000000
    {"-1",N_("1 file per line"),TRUE,NULL},
#endif
    {NULL,NULL,FALSE,NULL}
 };

static RfmProgramOptions cp_options[]={
    // 0x01
    {"",N_("Ask the user to get additional parameters"),TRUE,NULL},
#ifdef GNU_CP
    // 0x02
    {"-H",N_("-H, --dereference-command-line\nfollow symbolic links listed on the command line"),TRUE,NULL},
    // 0x04
    {"-L",N_("-L, --dereference            always follow symbolic links in SOURCE"),TRUE,NULL},
    // 0x08
    {"-P",N_("-P, --no-dereference         never follow symbolic links in SOURCE"),TRUE,NULL},
    // 0x010
    {"-R",N_("-R, -r, --recursive          copy directories recursively"),TRUE,NULL},
    // 0x020
    {"-a",N_("-a, --archive                same as -dR --preserve=all"),TRUE,NULL},
    // 0x040
    {"--attributes-only",N_("--attributes-only        don't copy the file data, just the attributes"),TRUE,NULL},
    // 0x080
    {"-b",N_("-b                  like --backup but does not accept an argument"),TRUE,NULL},
    // 0x0100
    {"--backup=",N_("--backup[=CONTROL]  make a backup of each existing destination file"),TRUE,cp_v_control,RFM_CP_backup},
    // 0x0200
    {"--copy-contents",N_("--copy-contents          copy contents of special files when recursive"),TRUE,NULL},
    // 0x0400
    {"-d",N_("-d                           same as --no-dereference --preserve=links"),TRUE,NULL},
    // 0x0800
    {"-f",N_("-f, --force                 remove existing destination files"),TRUE,NULL},
    // 0x01000
    {"-i",N_("Interactive"),TRUE,NULL},
    // 0x02000
    {"-l",N_("-l, --link                   hard link files instead of copying"),TRUE,NULL},
    // 0x04000
    {"-n",N_("n, --no-clobber             do not overwrite an existing file (overrides\n"
"a previous -i option)"),TRUE,NULL},
    // 0x08000
    {"-p",N_("-p                           same as --preserve=mode,ownership,timestamps"),TRUE,NULL},
    // 0x010000
    {"--preserve=",N_("--preserve[=ATTR_LIST]   preserve the specified attributes (default:\nmode,ownership,timestamps), if possible\nadditional attributes: context, links, xattr,\nall"),TRUE,cp_attributes,RFM_CP_preserve},
    // 0x020000
    {"--no-preserve=",N_("--no-preserve=ATTR_LIST  don't preserve the specified attributes"),TRUE,cp_attributes,RFM_CP_no_preserve},
    // 0x040000
    {"--parents",N_("--parents                use full source file name under DIRECTORY"),TRUE,NULL},
    // 0x080000
    {"--reflink=",N_("--reflink[=WHEN]         control clone/CoW copies. See below"),TRUE,cp_when,RFM_CP_reflink},
    // 0x0100000
    {"--remove-destination",N_("--remove-destination     remove each existing destination file before\nattempting to open it (contrast with --force)"),TRUE,NULL},
    // 0x0200000
    {"--sparse=",N_("--sparse=WHEN            control creation of sparse files. See below"),TRUE,cp_when,RFM_CP_sparse},
    // 0x0400000
    {"--strip-trailing-slashes",N_("--strip-trailing-slashes  remove any trailing slashes from each SOURCE\nargument"),TRUE,NULL},
    // 0x0800000
    {"-s",N_("-s, --symbolic-link          make symbolic links instead of copying"),TRUE,NULL},
    // 0x01000000
    {"--suffix=",N_("-S, --suffix=SUFFIX          override the usual backup suffix"),TRUE,cp_suffix, RFM_CP_suffix},
    // 0x02000000
    {"-T",N_("-t, --target-directory=DIRECTORY  copy all SOURCE arguments into DIRECTORY"),FALSE,NULL},
    // 0x04000000
    {"-u",N_("-u, --update                 copy only when the SOURCE file is newer\nthan the destination file or when the\ndestination file is missing"),TRUE,NULL},
    // 0x08000000
    {"-v",N_("-v, --verbose                explain what is being done"),TRUE,NULL},
    // 0x010000000
    {"-x",N_("-x, --one-file-system        stay on this file system"),TRUE,NULL},
    // 0x020000000
    {"--help",N_("Help"),FALSE,NULL},
    // 0x040000000
    {"--version",N_("Version"),FALSE,NULL},
#else
    // 0x02
    {"-H",N_("Follow links"),TRUE,NULL},
    // 0x04
    {"-L",N_("Always follow links"),TRUE,NULL},
    // 0x08
    {"-P",N_("Don't follow symbolic links"),TRUE,NULL},
    // 0x010
    {"-R",N_("recursive"),TRUE,NULL},
    // 0x020
    {"-a",N_("archive"),TRUE,NULL},
    // 0x040
    {"-f",N_("force"),TRUE,NULL},
    // 0x080
    {"-i",N_("-i                    prompt before every removal"),TRUE,NULL},
    // 0x0100
    {"-l",N_("hard link files instead of copying"),TRUE,NULL},
    // 0x0200
    {"-n",N_("Do not overwrite any file"),TRUE,NULL},
    // 0x0400
    {"-p",N_("Preserve all attributes"),TRUE,NULL},
    // 0x0800
    {"-v",N_("Verbose"),TRUE,NULL},
    // 0x01000
    {"-x",N_("Stay on single filesystem"),TRUE,NULL},
#endif

    {NULL,NULL,FALSE,NULL}
};

static RfmProgramOptions mv_options[]={
    // 0x01
    {"",N_("Ask the user to get additional parameters"),TRUE,NULL},
#ifdef GNU_MV
    // 0x02
    {"-b",N_("-b                  like --backup but does not accept an argument"),TRUE,NULL},
    // 0x04
    {"--backup=",N_("--backup[=CONTROL]  make a backup of each existing destination file"),TRUE,cp_v_control,RFM_MV_backup},
    // 0x08
    {"-f",N_("-f, --force                 remove existing destination files"),TRUE,NULL},
    // 0x010
    {"-i",N_("-i                    prompt before every removal"),TRUE,NULL},
    // 0x020
    {"--strip-trailing-slashes",N_("--strip-trailing-slashes  remove any trailing slashes from each SOURCE\nargument"),TRUE,NULL},
    // 0x040
    {"--suffix=",N_("-S, --suffix=SUFFIX          override the usual backup suffix"),TRUE,cp_suffix,RFM_MV_suffix},
    // 0x080
    {"-t",N_("-t, --target-directory=DIRECTORY  move all SOURCE arguments into DIRECTORY"),FALSE,NULL},
    // 0x0100
    {"-T",N_("-T, --no-target-directory    treat DEST as a normal file"),FALSE,NULL},
    // 0x0200
    {"-u",N_("-u, --update                 move only when the SOURCE file is newer\nthan the destination file or when the\ndestination file is missing"),TRUE,NULL},
    // 0x0400
    {"-v",N_("-v, --verbose                explain what is being done"),TRUE,NULL},
    // 0x0800
    {"--help",N_("Help"),FALSE,NULL},
    // 0x01000
    {"--version",N_("Version"),TRUE,NULL},
#else
    // 0x02
    {"-f",N_("force"),TRUE,NULL},
    // 0x04
    {"-i",N_("Interactive"),TRUE,NULL},
    // 0x08
    {"-n",N_("Do not overwrite any file"),TRUE,NULL},
    // 0x010
    {"-v",N_("Verbose"),TRUE,NULL},

#endif
    {NULL,NULL,FALSE,NULL}
};

static RfmProgramOptions ln_options[]={
    // 0x01
    {"",N_("Ask the user to get additional parameters"),TRUE,NULL},
#ifdef GNU_LN
    // 0x02
    {"-b",N_("-b                  like --backup but does not accept an argument"),TRUE,NULL},
    // 0x04
    {"--backup=",N_("--backup[=CONTROL]  make a backup of each existing destination file"),TRUE,cp_v_control,RFM_LN_backup},
    // 0x08
    {"-d","-d, -F, --directory",FALSE,NULL},
    // 0x010
    {"-f",N_("-f, --force                 remove existing destination files"),TRUE,NULL},
    // 0x020
    {"-L",N_("-L, --logical               dereference TARGETs that are symbolic links"),TRUE,NULL},
    // 0x040
    {"-n",N_("-n, --no-dereference        treat LINK_NAME as a normal file if\nit is a symbolic link to a directory"),TRUE,NULL},
    // 0x080
    {"-P",N_("-P, --physical              make hard links directly to symbolic links"),TRUE,NULL},
    // 0x0100
    {"-s",N_("-s, --symbolic              make symbolic links instead of hard links"),TRUE,NULL},
    // 0x0200
    {"--suffix=",N_("-S, --suffix=SUFFIX         override the usual backup suffix"),TRUE,cp_suffix,RFM_LN_suffix},
    // 0x0400
    {"-t",N_("-t, --target-directory=DIRECTORY  specify the DIRECTORY in which to create\nthe links"),FALSE,NULL},
    // 0x0800
    {"-T",N_("-T, --no-target-directory   treat LINK_NAME as a normal file always"),FALSE,NULL},
    // 0x01000
    {"-v",N_("-v, --verbose                explain what is being done"),TRUE,NULL},
    // 0x02000
    {"--help",N_("Help"),FALSE,NULL},
    // 0x04000
    {"--version",N_("Version"),FALSE,NULL},
#else
    // 0x02
    {"-F",N_("force"),TRUE,NULL},
    // 0x04
    {"-L",N_("make hard links to symbolic link references"),TRUE,NULL},
    // 0x08
    {"-P",N_("make hard links directly to symbolic links"),TRUE,NULL},
    // 0x010
    {"-f",N_("force"),TRUE,NULL},
    // 0x020
    {"-h",N_("Don't follow symbolic links"),TRUE,NULL},
    // 0x040
    {"-i",N_("Interactive"),TRUE,NULL},
    // 0x080
    {"-n",N_("Don't follow symbolic links"),TRUE,NULL},
    // 0x0100
    {"-s",N_("Create Symbolic Link"),TRUE,NULL},
    // 0x0200
    {"-v",N_("Verbose"),TRUE,NULL},
    // 0x0400
    {"-w",N_("Warn if error in documents"),TRUE,NULL},
#endif
    {NULL,NULL,FALSE,NULL}
};

static RfmProgramOptions rm_options[]={
    // 0x01
    {"",N_("Ask the user to get additional parameters"),TRUE,NULL},
#ifdef GNU_RM
    // 0x02
    {"-f",N_("-f, --force           ignore nonexistent files and arguments, never prompt"),TRUE,NULL},
    // 0x04
    {"-i",N_("-i                    prompt before every removal"),TRUE,NULL},
    // 0x08
    {"-I",N_("-I                    prompt once before removing more than three files, or\nwhen removing recursively.  Less intrusive than -i,\nwhile still giving protection against most mistakes"),TRUE,NULL},
    // 0x010
    {"--interactive=",N_("--interactive[=WHEN]  prompt according to WHEN: never, once (-I), or\nalways (-i).  Without WHEN, prompt always"),TRUE,rm_interactive,RFM_RM_interactive},
    // 0x020
    {"--one-file-system",N_("Stay on single filesystem"),TRUE,NULL},
    // 0x040
    {"--no-preserve-root",N_("--no-preserve-root  do not treat '/' specially"),TRUE,NULL},
    // 0x080
    {"--preserve-root",N_("--preserve-root   do not remove '/' (default)"),TRUE,NULL},
    // 0x0100
    {"-R",N_("-r, -R, --recursive   remove directories and their contents recursively"),TRUE,NULL},
    // 0x0200
    {"-v",N_("-v, --verbose         explain what is being done"),TRUE,NULL},
    // 0x0400
    {"--help",N_("Help"),FALSE,NULL},
    // 0x0800
    {"--version",N_("Version"),FALSE,NULL},
#else
    // 0x02
    {"-d",N_("Remove directory"),TRUE,NULL},
    // 0x04
    {"-f",N_("force"),TRUE,NULL},
    // 0x08
    {"-i",N_("Interactive"),TRUE,NULL},
    // 0x010
    {"-I",N_("Interactive"),TRUE,NULL},
    // 0x020
    {"-P",N_("Overwrite all files"),TRUE,NULL},
    // 0x040
    {"-R",N_("recursive"),TRUE,NULL},
    // 0x080
    {"-r",N_("recursive"),FALSE,NULL},
    // 0x0100
    {"-v",N_("Verbose"),TRUE,NULL},
    // 0x0200
    {"-W",N_("Undelete"),FALSE,NULL},
#endif
    {NULL,NULL,FALSE,NULL}
};

static RfmProgramOptions shred_options[]={
    // 0x01
    {"",N_("Ask the user to get additional parameters"),TRUE,NULL},
    // 0x02
    {"-f",N_("force"),TRUE,NULL},
    // this could use a spin button
    // 0x04
    {"--iterations=",N_("-n, --iterations=N  overwrite N times instead of the default (%d)"), TRUE,shred_iterations,RFM_SHRED_iterations},
    // 0x08
    {"--random-source=",N_("--random-source=FILE  get random bytes from FILE"),FALSE,NULL},// this needs a fileselector button.
    // 0x010
    {"--size=",N_("-s, --size=N   shred this many bytes (suffixes like K, M, G accepted)"),TRUE,shred_size,RFM_SHRED_size},// this could use a spinbutton

    // 0x020
    {"-u",N_("-u, --remove   truncate and remove file after overwriting"),TRUE,NULL},
    // 0x040
    {"-v",N_("-v, --verbose  show progress"),TRUE,NULL},
    // 0x080
    {"-x",N_("-x, --exact    do not round file sizes up to the next full block;\nthis is the default for non-regular files"),TRUE,NULL},
    // 0x0100
    {"-z",N_("-z, --zero     add a final overwrite with zeros to hide shredding"),TRUE,NULL},
    // 0x0200
    {"--help",N_("Help"),FALSE,NULL},
    // 0x0400
    {"--version",N_("Version"),FALSE,NULL},
    {NULL,NULL,FALSE,NULL}
};

void *get_ls_options(void){return (void *)ls_options;}
void *get_cp_options(void){return (void *)cp_options;}
void *get_mv_options(void){return (void *)mv_options;}
void *get_ln_options(void){return (void *)ln_options;}
void *get_rm_options(void){return (void *)rm_options;}
void *get_shred_options(void){return (void *)shred_options;}


