#ifdef COPYRIGHT_INFORMATION
#include "gplv3.h"
#endif
/* this file is included by rodent_popup.c */
/*
 * Copyright (C) 2002-2012 Edscott Wilson Garcia
 * EMail: edscott@users.sf.net
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; 
 */
typedef struct keybind_t {
    guint key;
    guint mask;
    gpointer callback;
} keybind_t;

static gchar *auto_C_name[] = {AUTO_C_NAME};

static int
set_auto_command (int j,
                  const gchar * name,
                  const gchar * alt_label,
                  const gchar * app,
                  const gchar * path
                  );


//static void gui_add_to_keylist (guint in_key, guint mask, gpointer callback);


////////////////////////////////////////////////////////////////////////////////////////
//           rodent_do_popup   guts (callback function)     
////////////////////////////////////////////////////////////////////////////////////////

static void
popup_autostuff (record_entry_t * en) {
    if (!en) return;
    gint j = 0;

    NOOP(stderr, "...popup_autostuff\n");


    // Special "open in new window" item for partition types
    // FIXME
    // XXX: This should probably be done by the fstab module, not here.
    if(FSTAB_is_partition_type (en)) {
        NOOP(stderr, "test FSTAB_is_partition_type (en)...\n");
        // only first item (open in new window...)
        gchar *mount_point = FSTAB_get_mnt_dir (en->path);
        if(mount_point) {
            j = set_auto_command ( j, auto_C_name[j], 
            _("Open in New Window"), "rodent-fm", mount_point);
            g_free (mount_point);
        }
    }
    // Special run command for dot desktop files.
    // XXX: as above, this should probably be done by the module...
    else if(IS_LOCAL_TYPE(en->type) && 
	    en->mimetype && strcmp(en->mimetype, "application/x-desktop")==0  ) {
	if (rfm_void(PLUGIN_DIR, "dotdesktop", "module_active")){
	    // get the Icon
	    const gchar *Icon=rfm_natural(PLUGIN_DIR, "dotdesktop", (void *)en, "item_icon_id");
	    // get the Name
	    gchar *Name=rfm_natural(PLUGIN_DIR, "dotdesktop", en->path, "item_name");
	    GtkWidget *a = 
		rfm_get_widget ("autotype_Prun");
	    if (Name) {

		GtkWidget *a;
		a =	rfm_get_widget ("autotype_Prun");
		gchar *q = rfm_utf_string (Name);
                rfm_replace_menu_label(a, q);
		/*label = gtk_bin_get_child (GTK_BIN (a));
		gtk_label_set_text ((GtkLabel *) label, q);*/
		g_free (q);
		g_object_set_data(G_OBJECT(a), "record_entry", (void *)en);
	    }
	    if (Icon) {
                rfm_replace_menu_image(a, Icon);
	    }
	    if (Icon && Name){
		SHOW_IT ( "autotype_Prun");
	    }
	    g_free (Name);
	}
    }
    // Executable files get the special "run in terminal" menu item:
    else if(IS_EXE_TYPE(en->type)) {
	if (IS_SDIR(en->type)) {
	    // ignore
	} else {
	    gchar *cmd;

	    GtkWidget  *a = rfm_get_widget ("autotype_Prun");
	    g_object_set_data(G_OBJECT(a), "record_entry", (void *)en);
	    cmd = g_strdup_printf ("%s (%s)", _("Run in terminal window"), _("Is executable"));
	    gchar *q = rfm_utf_string (cmd);
            rfm_replace_menu_label(a, q);
	    g_free (cmd);
	    g_free (q);
                
            rfm_replace_menu_image(a, "xffm/emblem_terminal");
	    SHOW_IT ( "autotype_Prun");
	}
    }
   

    // Mimetype associations. 
    // These mimetype associations are defined in the file
    // "applications-module.xml" and harvested from
    // installed dot desktop files by the dotdesktop module.
    //
    // Associations should be done to the basic mimetype 
    // (not any alias) for sanity sake.
    //
    // This is the nitty gritty. 
    // Suggest an application based on the file's mimetype.
    //
    NOOP(stderr, "AUTO: menu nitty-gritty now\n");
    gchar *magic_type = NULL;
    gchar *mime_type = NULL;
    if (IS_LOCAL_TYPE(en->type) && 1) {
	magic_type = rfm_rational(RFM_MODULE_DIR, "mime", (void *)en, "mime_magic", "mime_function");
	if (!en->mimemagic) magic_type = g_strdup(_("unknown"));
    }
    else magic_type = g_strdup(_("unknown"));
    // G_FILE_TEST_EXISTS is a downer on remote connections
    if (g_path_is_absolute(en->path)) {
	mime_type = MIME_type (en->path, en->st);
    }

    // These are the menu items set from dotdesktop files 
    // and "applications-module.xml"

    if(g_path_is_absolute(en->path)) {
        int k;
        NOOP(stderr, "AUTO: menu nitty-gritty mime-type=%s magic-type=%s\n", mime_type, magic_type);

        // here we use the freedesktop and magic
        // mimetype to get the run program.
        // We loop to get commands based on simple mimetype and magic mimetype,
        // in that order.
        for(k = 0; k < 2; k++) {
            gchar **apps = NULL;
            int i = 0;
            if(k == 0) {
                apps = MIME_apps (mime_type);
                NOOP(stderr, "AUTO: menu nitty-gritty (%s) apps=0x%lx\n", mime_type, (long)apps);
            } else {
                apps = MIME_apps (magic_type);
                NOOP(stderr, "AUTO: menu nitty-gritty (%s) apps=0x%lx\n", magic_type, (long)apps);
            }

            if(apps && apps[i])
                for(; apps && apps[i]; i++) {
                    NOOP ("AUTO: j=%d, i=%d %s -> %s\n", j, i, auto_C_name[j], apps[i]);fflush(NULL);

                    if(!auto_C_name[j]) {
                        // no menuitem spaces left.
                        continue;
                    }
		    if (!strlen(apps[i])) {
                        // bug trap, just in case an empty string slips past.
                        continue;
                    }
                    j = set_auto_command ( j, auto_C_name[j], NULL,
                                          // the command:
                                          apps[i], en->path);
                }
            g_strfreev (apps);
        }

    }
    
    NOOP(stderr, "AUTO: editor test...\n");
    gboolean has_editor=FALSE;
    gint k;
    gchar **apps = MIME_apps (mime_type);
    for (k=0; k<j && apps && apps[k]; k++){
        const gchar **editors = rfm_get_editors();
	for (; editors && *editors; editors++){
	    if (strstr(apps[k], *editors)) {
		has_editor=TRUE;
		break;
	    }
	    if (has_editor) break;
	}
    }
    g_strfreev (apps);
    if (!has_editor){
	// Default editor command.
	gchar *text_editor = rodent_get_text_editor(en);
	TRACE( "Got text editor: %s\n", text_editor);
	if (text_editor){
	    j = set_auto_command ( j,  
		    auto_C_name[j], NULL,
		    // the command:
		     text_editor, en->path);
		g_free(text_editor);
	}
    }


    if(g_path_is_absolute(en->path)) {
        SHOW_IT ( "open_with_menuitem");
        SHOW_IT ( "open_with_separator");
    }
    NOOP(stderr, "AUTO: done!\n");

    g_free (magic_type);
    g_free (mime_type);
    return;
}


////////////////////////////////////////////////////////////////////////////////////////

/**************************************************************************/
/**************************  pasteboard stuff  ****************************/
/**************************************************************************/

/*  */

/**************************************************************************/

///// popup callbacks....

/* this file is included by rodent_popup.c */


static void
setup_bookmark_menuitem(record_entry_t *en, 
    const gchar *menuitem,
    gboolean on){
    GtkWidget *w=rfm_get_widget( menuitem);
    if (!w) {
	DBG("no %s widget!\n", menuitem);
	return;
    } 
    
    gchar *basename=g_path_get_basename(en->path);
    gchar *baseutf=rfm_utf_string (basename);
    g_free(basename);
    gchar *text=g_strdup_printf("%s: <b><i>%s</i></b>",
	   (on)?_("Add bookmark"):_("Remove bookmark"), 
	   baseutf);
    g_free(baseutf);
    NOOP(stderr, "...setup_bookmark_menuitem\n");
    gchar *q = rfm_utf_string (text);
    g_free (text);
    rfm_replace_menu_label(w, q);
    
    /*GtkWidget *label = gtk_bin_get_child (GTK_BIN (w));
    gtk_label_set_markup ((GtkLabel *) label, q);*/
    g_free (q);

    SHOW_IT (menuitem);
    gchar *path = g_object_get_data(G_OBJECT(w), "path");
    g_free(path);
    g_object_set_data(G_OBJECT(w), "path",   g_strdup(en->path));
    NOOP("setting path to %s\n", en->path);
    //FIXME:
#if 0
    // I don't like this way of determine expose region.
    // Should do this in the callback, finding the appropriate 
    // population_p from path information.
    if (population_p) {
	GdkRectangle *rect=g_object_get_data(G_OBJECT(w), "rect");
	if (!rect) rect=(GdkRectangle *)malloc(sizeof(GdkRectangle));
	if (rfm_get_population_icon_rect(view_p, population_p, rect)) {
	    g_object_set_data(G_OBJECT(w), "rect",   rect);
	} else {
	    g_object_set_data(G_OBJECT(w), "rect",   NULL);
	}
    } else {
	g_object_set_data(G_OBJECT(w), "rect",   NULL);
    }
#endif
    
}



/////////////////////////////////////////////77
//////  rodent_menu

/*************************** specific commands to menu ***************/

/****************** gtk functions for callbacks *********************/
// show_mount: shows the menu mount item if fstab module available
static void
show_mount_item (view_t *view_p) {
    if(rfm_void (PLUGIN_DIR, "fstab", "is_root_module") == NULL) return;
    if(g_slist_length (view_p->selection_list) != 1) return;
    record_entry_t *en = view_p->selection_list->data;
    if (!en || !en->path) return;

    gint mounted = FALSE;
    gboolean in_fstab = FALSE;
    gboolean partition = FSTAB_is_partition_type (en);
    if(partition || IS_SDIR(en->type)) {
        mounted = FSTAB_entry_is_mounted (en);
        in_fstab = FSTAB_is_in_fstab (en->path);
    }
    gboolean isofs = 
	(en->mimetype && 
	 strstr(en->mimetype, "application/x-cd-image")) ||
	(en->mimemagic && 
	 strstr(en->mimemagic, "application/x-cd-image"));
    // This does not good. Mount volume will be /dev/loopX
    if (isofs) {
        mounted = FSTAB_entry_is_mounted (en);
    }
 

    NOOP ("POPUPx  %s is mounted=%d\n", en->path, mounted);
    gboolean do_mount_item = mounted || in_fstab || partition || isofs;
    if(do_mount_item) {
        if(mounted>0){ SHOW_IT ( "unmountP");}
	else if (mounted < 0){ SHOW_IT ( "mount_broken");}
	else { SHOW_IT ( "mountP");}
    }
}

static void
show_remove_item (view_t *view_p) {
    record_entry_t *en = view_p->selection_list->data;
    if(!en || !en->path) return;
    if(IS_UP_TYPE(en->type))return;
    /* for local remove: */
    if(g_path_is_absolute(en->path)) SHOW_IT ( "remove_menuitem");
}

static void
show_properties_item (view_t *view_p) {
    if (!rfm_void(RFM_MODULE_DIR, "properties", "module_active")) return;
    record_entry_t *en = view_p->selection_list->data;
    if(!en || !en->path) return;
    if (!g_path_is_absolute (en->path)) return;
    SHOW_IT ( "properties_menuitem");
    return;
}


static void
recursive_dirname (widgets_t * widgets_p, char *path, int level) {
    if(!path || strcmp (path, "/") == 0)
        return;
    if(level >= DEEPEST_DIR_MENU_LEVELS)
        return;
    gchar *b = g_path_get_dirname (path);
    gchar *name = g_strdup_printf ("level-%d", level);

    GtkWidget *a = rfm_get_widget (name);
    NOOP(stderr, "...recursive_dirname\n");
    gchar *q = rfm_utf_string (b);
    rfm_replace_menu_label(a, q);
    /*GtkWidget *label = gtk_bin_get_child (GTK_BIN (a));
    gtk_label_set_text ((GtkLabel *) label, q);*/
    g_free (q);
    gchar *old_b;
    if((old_b = g_object_get_data (G_OBJECT (a), "path")) != NULL) {
        g_object_set_data (G_OBJECT (a), "path", NULL);
        g_free (old_b);
    }
    g_object_set_data (G_OBJECT (a), "path", (gpointer) b);
    SHOW_IT ( name);

    recursive_dirname (widgets_p, b, level + 1);
    g_free (name);
    return;
}

#define MENU_IN_MODULE(x) (view_p->module && rfm_void(PLUGIN_DIR,view_p->module,(x)))

static void
show_open_items (view_t *view_p) {
    record_entry_t *en = view_p->selection_list->data;
    if(IS_UP_TYPE(en->type))return;

    // file_menu is already shown by here...
    SHOW_IT("select_menu");
    SHOW_IT("open_with_menuitem");
    SHOW_IT("copy_menuitem");
    SHOW_IT("cut_menuitem");
    HIDE_IT ("newfile_menuitem");
    HIDE_IT ("newdirectory_menuitem");

    if (en->mimetype &&
	    rfm_void(PLUGIN_DIR, "dotdesktop", "module_active") &&
	    strcmp(en->mimetype, "application/x-desktop")==0 )
    {
	NOOP ("showing autotype_Prun\n");
        SHOW_IT ( "autotype_Prun");
    }


    return;
}


////////////////////////////////////////////////
////   menu.i


static void
clean_object_data(GtkWidget *a, const gchar *data_id)
{
    gchar *old_text = g_object_get_data (G_OBJECT (a), data_id);
    if((old_text = g_object_get_data (G_OBJECT (a), data_id)) != NULL) {
        g_object_set_data (G_OBJECT (a), data_id, NULL);
        g_free (old_text);
    }
}

static int
set_auto_command (int j,
                  const gchar * name,
                  const gchar * alt_label,
                  const gchar * app,
                  const gchar * path
                  ) {
    widgets_t *widgets_p = rfm_get_widget ("widgets_p");
    int jj;

    gchar *dirname = g_path_get_dirname (path);
    gchar *basename = g_path_get_basename (path);

    GtkWidget *a = rfm_get_widget (name);

    const gchar * output_ext=MIME_command_output_ext(app);
    view_t *view_p=widgets_p->view_p;
    if(!MIME_is_valid_command (app)) {
        if (strcmp(app, "rodent-newtab")==0 && view_p->tab_constructor) {
            NOOP (">> set_auto_command: %s name=%s\n", app, name);
        }
        else if (strcmp(app, "rodent-newwin")==0) {
            NOOP (">> set_auto_command: %s name=%s\n", app, name);
        }
        else if (strcmp(app, "rodent-bcrypt")==0) {
            NOOP (">> set_auto_command: %s name=%s\n", app, name);
        }            
        else {
            return j;
        }
    }
    
    gchar *command;
    if(strncmp (app, "sudo -A ", strlen ("sudo -A ")) == 0) {
        if(getuid () == 0)
            return j;           /* don't sudoize root */
        if(!strlen (app + strlen ("sudo -A "))
           || !MIME_is_valid_command (app + strlen ("sudo -A ")))
            return j;
    }

    TRACE( "looking for command icon \"%s\"\n",app);
    gchar *app_no_args = g_strdup(app);
    if (strchr(app_no_args, ' ')) *strchr(app_no_args, ' ')=0;
    const gchar *icon_id=(const gchar *)
	rfm_natural(PLUGIN_DIR, "dotdesktop", (void *)app_no_args, "get_exec_icon");
	
    // try custom mime icon
    if (!icon_id){
	icon_id=MIME_command_icon (app_no_args);
	NOOP("icon id= %s, %s\n", icon_id, app_no_args);
    }

    // try named icon
    gchar *icon=NULL;
    if (!icon_id) {
	NOOP(stderr, "try named icon for %s\n", app_no_args);
	icon=ICON_get_filename_from_basename(app_no_args);
	// This should always be local and absolute.
	if (icon && g_file_test(icon, G_FILE_TEST_EXISTS)){
	    icon_id = icon;
	} 
    }
    g_free(app_no_args);

    if (!icon_id) {
        NOOP("2. command icon \"%s\" not found!\n",app);
        icon_id="xffm/stock_execute";
    }

    if (icon_id) {
        rfm_replace_menu_image(a, icon_id);
    }
    g_free(icon);

            
    gchar *effective_app = NULL;

    NOOP(stderr, "...set_auto_command\n");
    //label = gtk_bin_get_child (GTK_BIN (a));
    if(alt_label) { 
        gchar *new_label = rfm_utf_string (alt_label);
        rfm_replace_menu_label(a, new_label);
        g_free(new_label);
    } else {
        /* allow mixed utf8-eucjp  paths */
        gchar *new_label;
        {
            const gchar *text = MIME_command_text (app);
            if (!text && !strstr(app, " %s")){
                // If app does not end with a %s, try with %s
                effective_app = g_strdup_printf("%s %%s", app);
                text = MIME_command_text (effective_app);
                if (text) app = effective_app;
            } else if (!text && *(strstr(app, " %s")+strlen(" %s"))==0){
                // If app does end with a %s, try without it.
                effective_app = g_strdup(app);
                *strstr(effective_app, " %s") = 0;
                text = MIME_command_text (effective_app);
                if (text) app = effective_app;
            }
	    const gchar *text2 = MIME_command_text2 (app);
            TRACE( "set_auto_command(): looking for %s in hash: %s %s\n",app, text, text2);
            gchar *q;
            if (text) {
		gchar *texto;
		if (text2){
		    texto=g_strconcat(_(text), _(text2), NULL);
		} else {
		    texto=g_strdup(_(text));
		}
                NOOP("MIME: found\n");
                if (strstr(texto,"%s")!=NULL) {
                    q = MIME_mk_command_line (texto, basename);
                } else {
                    if (output_ext) 
                        q = g_strdup_printf("%s (%s)", texto, output_ext);
                    else
                        q = g_strdup(texto);
                }
		g_free(texto);
            }
            else {
                NOOP("MIME: not found\n");
                q = MIME_mk_command_line (app, basename);
            }
            new_label = rfm_utf_string (q);
            g_free (q);
        }
        rfm_replace_menu_label(a, new_label);
        //gtk_label_set_text ((GtkLabel *) label, new_label);
        g_free (new_label);
    }

    if(output_ext) {
        NOOP ("command is:  %s output_ext is; %s\n", app, output_ext);
        command = g_strdup (app);
    } else {
        /* this is to use relative paths for arguments for all
         * commands except those where the output directory (or
         * widgets_p->workdir) is requested from the user.
         * */
        NOOP ("making command from (%s, %s)\n", app, path);
        command = MIME_mk_command_line (app, path);
    }

    /* check for duplicates */
    {
        gint argcp1;
        gchar **argvp1;
        GError *error = NULL;
        if(!g_shell_parse_argv ((const gchar *)command, &argcp1, &argvp1, &error)) {
            g_free (command);
            g_error_free (error);
            g_strfreev (argvp1);
            NOOP ("!g_shell_parse_argv at popup_autostuff\n");
            return j;
        }
        for(jj = 0; jj < j; jj++) {
            gboolean is_duplicate = TRUE;
            gint ac,
              argcp2;
            gchar **argvp2;
            gchar *set_command = g_object_get_data (G_OBJECT (rfm_get_widget (auto_C_name[jj])),
                                                    "command");
            NOOP ("AUTO: j=%d: %s == %s\n", jj, set_command, command);
            if(!g_shell_parse_argv ((const gchar *)set_command, &argcp2, &argvp2, &error)) {
                g_free (basename);
                g_free (command);
                g_error_free (error);
                g_strfreev (argvp2);
                NOOP ("!g_shell_parse_argv at popup_autostuff\n");
                return j;
            }
            if(argcp2 != argcp1) {
                is_duplicate = FALSE;
            } else
                for(ac = 0; ac < argcp2; ac++) {
                    if(strcmp (argvp2[ac], argvp1[ac])) {
                        is_duplicate = FALSE;
                        break;
                    }
                }
            NOOP ("0x%lx, 0x%lx\n", (unsigned long)argvp1, (unsigned long)argvp2);

            g_strfreev (argvp2);
            argvp2 = NULL;
            /*if (strcmp(set_command,command)==0) */
            if(is_duplicate) {
                g_free (basename);
                g_free (command);
                NOOP ("AUTO: is_duplicate at popup_autostuff\n");
                return j;
            }
        }                       /* end for */
        g_strfreev (argvp1);
        argvp1 = NULL;
    }
    /* OK, by now we know the command is not duplicated... */
    // But is it a valid command??
    

    /* now let's free up any left over data from previous
     * generated menus... */
    clean_object_data(a, "command");
    clean_object_data(a, "workdir");
    g_object_set_data (G_OBJECT (a), "command", (gpointer) command);
    g_object_set_data (G_OBJECT (a), "workdir", (gpointer) dirname);
    if(MIME_command_output (app)) {
        g_object_set_data (G_OBJECT (a), "querypath", (gpointer)_("Specify Output Directory..."));
    } else {
        g_object_set_data (G_OBJECT (a), "querypath", NULL);
    }

    if(output_ext) {
        g_object_set_data (G_OBJECT (a), "output_arg", g_strdup (path));
    } else {
        clean_object_data(a, "output_arg");
        g_object_set_data (G_OBJECT (a), "output_arg", NULL);
    }
    NOOP(stderr, "AUTO:command=%s, output_arg=%s\n", command, path);
    g_object_set_data (G_OBJECT (a), "output_ext", (gpointer) output_ext);
    NOOP ("AUTO:now showing %s, active widget=0x%lx\n", name, (unsigned long)widgets_p->paper);
    SHOW_IT ( name);
    j++;
    g_free (basename);
    g_free (effective_app);
    return j;
}




