
/*
 * Copyright (C) 2002-2012 Edscott Wilson Garcia
 * EMail: edscott@users.sf.net
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; 
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include "rodent.h"
#include "rfm_modules.h"
#include "rodent_tip.i"

// Thread pool queued functions.

void
rodent_queue_f(void *data, void *pool_data){
    // This is a stop light for initial setup:
    rfm_global_t *rfm_global_p = rfm_global();
    rfm_rw_lock_reader_lock (&(rfm_global_p->setup_lock));
    rfm_rw_lock_reader_unlock (&(rfm_global_p->setup_lock));
    void **arg = data;
    enum signal_enum_e signal_enum = GPOINTER_TO_INT(arg[0]);
    view_t *view_p = arg[1];
    void *function_data = arg[2];
    g_free(arg);

    g_mutex_lock(rfm_global_p->status_mutex);
    gint status = rfm_global_p->status;
    g_mutex_unlock(rfm_global_p->status_mutex);
    if (status == STATUS_EXIT) return;

    const gchar *dbg_text = "signal_pool_f";
#ifdef DEBUG_TRACE
    switch (signal_enum) {
	case ADD_TO_VIEW_LIST:
	    dbg_text = "signal_pool_f: ADD_TO_VIEW_LIST";
	    break;
	case BOOKMARK_MONITOR:
	    dbg_text = "signal_pool_f: BOOKMARK_MONITOR";
	    break;
    }
#endif

    TRACE("rodent_queue_f(%s)...\n", dbg_text);
    // FIXME: queued functions may not unlock view list...
//    if (!rfm_view_list_lock(view_p, "rodent_queue_f")) return;
    if (view_p->flags.status == STATUS_EXIT) {
 //       rfm_view_list_unlock("rodent_queue_f");
        return;
    }
    
    rfm_thread_reference(view_p, g_thread_self(), dbg_text);

    switch (signal_enum) {
	case ADD_TO_VIEW_LIST:;
	    //rfm_add_view(view_p);
	    break; 
	case BOOKMARK_MONITOR:
	    rodent_bookmark_monitor(view_p, function_data);
	    break;
    }
#ifdef DEBUG_TRACE
    if (dbg_text==NULL) rfm_thread_unreference_quiet(view_p, g_thread_self());
    else
#endif
    rfm_thread_unreference(view_p, g_thread_self());
  //  rfm_view_list_unlock("rodent_queue_f");
}


gboolean
rodent_on_leave_paper (view_t *view_p) {
    NOOP (stderr,"on_leave_paper\n");
    // this does not always work since there are ways to get 
    // around this signal. like exiting the window by cruising
    // on top of a tooltip preview beyond the parent window's 
    // border...
    rodent_hide_tip();
    view_p->mouse_event.current_mouseX = -1;
    view_p->mouse_event.current_mouseY = -1;   
    rodent_unsaturate_icon (view_p);
    rodent_unsaturate_label(view_p);
    return TRUE;
}

void *
rodent_on_leave (void *data){
    rfm_global_t *rfm_global_p = rfm_global();
    view_t *view_p = data;
    TRACE("rodent_on_leave()...\n");
    if (!rfm_view_list_lock(view_p, "rodent_on_leave")) return NULL;
    widgets_t *widgets_p=&(view_p->widgets);
    rodent_on_leave_paper (view_p);
    if (widgets_p->rename) {
       // get pointer position
       GdkRectangle pointer;
#if GTK_MAJOR_VERSION<3 
       gdk_window_get_pointer(
          gtk_widget_get_window(rfm_global_p->window), 
	  &pointer.x, &pointer.y, NULL);
#else
	gdk_window_get_device_position( 
          gtk_widget_get_window(rfm_global_p->window), 
          rfm_global_p->pointer,
	  &pointer.x, &pointer.y, NULL);
#endif
        NOOP("rodent_mouse: pointer: x=%d, y=%d\n", pointer.x, pointer.y);
      // get window position
       gint windowX, windowY;
       gdk_window_get_position (
	       gtk_widget_get_window(rfm_global_p->window), 
    	        &windowX, &windowY);
        pointer.x += windowX;
        pointer.y += windowY;
        NOOP("rodent_mouse: window: x=%d, y=%d\n", windowX, windowY);
        GdkRectangle entry_extent;
        gdk_window_get_position (
		gtk_widget_get_window(widgets_p->rename), 
    	        &entry_extent.x, &entry_extent.y);
	Drawable drawable = 
	    GDK_WINDOW_XID(gtk_widget_get_window(widgets_p->rename));
        rfm_get_drawable_geometry(
		drawable, 
                NULL, NULL, &entry_extent.width, &entry_extent.height, NULL);
        entry_extent.width += entry_extent.x;
        entry_extent.height += entry_extent.y;
        NOOP("rodent_mouse: rename: x,y= (%d, %d), w,h=( %d, %d) \n", 
                entry_extent.x, entry_extent.y, 
		entry_extent.x+entry_extent.width, 
                entry_extent.y+entry_extent.height);
        gboolean x_condition=pointer.x >= entry_extent.x && pointer.x < entry_extent.width;
        gboolean y_condition=pointer.y >= entry_extent.y && pointer.y < entry_extent.height;
	NOOP ("rodent_mouse: pointerY=%d < ? entry_extent.height=%d\n",
		pointer.y, entry_extent.height);

        if (x_condition && y_condition) {
                NOOP("OK\n");
        } else if (view_p->widgets.rename) {
	    rfm_natural(RFM_MODULE_DIR, "callbacks", GINT_TO_POINTER(DONE_WITH_RENAME), "callback");
        }
    }
    rfm_view_list_unlock("rodent_on_leave");
    return NULL;
}





