#!/bin/sh

# $Id: check-and-defrag.sh,v 1.10 2005/04/20 13:54:18 knilch Exp $
#
# (c) 2004 Tobias 'knilch' Jordan <knilch@users.sourceforge.net>
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#             ###   ##   #  #  ####  ###    ###  #  #  ###   ####
#            #     #  #  ## #  #      #    #     #  #  #  #  #
#            #     #  #  # ##  ###    #    # ##  #  #  ###   ###
#            #     #  #  #  #  #      #    #  #  #  #  # #   #
#             ###   ##   #  #  #     ###    ###   ##   #  #  ####

RAMDEFRAG="/usr/local/bin/ramdefrag"

PERCENTAGE=50

#VERBOSE=NO
VERBOSE="YES, PLEASE!"

#                           ###   ####   ##   ###
#                           #  #  #     #  #  #  #
#                           ###   ###   #  #  #  #
#                           # #   #     ####  #  #
#                           #  #  ####  #  #  ###


#                       THE MYTH OF THE APPLE OF DISCORD
#         It seems that Zeus was preparing a wedding banquet for Peleus and
# Thetis and did not want to invite Eris because of Her reputation as a
# trouble maker.*
#         This made Eris angry, and so She fashioned an apple of pure gold**
# and inscribed upon it KALLISTI ("To The Prettiest One") and on the day of
# the fete She rolled it into the banquet hall and then left to be alone and
# joyously partake of a hot dog.
#         Now, three of the invited goddesses,*** Athena, Hera, and Aphrodite,
# each immediately claimed it to belong to herself because of the inscription.
# And they started fighting, and they started throwing punch all over the
# place and everything.
#         Finally Zeus calmed things down and declared that an arbitrator must
# be selected, which was a reasonable suggestion, and all agreed. He sent them
# to a shepherd of Troy, whose name was Paris because his mother had had a lot
# of gaul and had married a Frenchman; but each of the sneaky goddesses tried
# to outwit the others by going early and offering a bribe to Paris.
#         Athena offered him Heroic War Victories, Hera offered him Great
# Wealth, and Aphrodite offered him the Most Beautiful Woman on Earth. Being a
# healthy young Trojan lad, Paris promptly accepted Aphrodite's bribe and she
# got the apple and he got screwed.
#         As she had promised, she maneuvered earthly happenings so that Paris
# could have Helen (The Helen) then living with her husband Menelaus,King of
# Sparta. Anyway, everyone knows that the Trojan War followed when Sparta
# demanded their Queen back and that the Trojan War is said to be The First
# War among men.
#         And so we suffer because of the Original Snub. And so a Discordian
# is to partake of No Hot Dog Buns.
#         Do you believe that?
# -------------------------------------
# * This is called THE DOCTRINE OF THE ORIGINAL SNUB
# ** There is historic disagreement concerning whether this apple was of
#    metalic gold or acapulco.
# *** Actually there were five goddesses, but the Greeks did not know the Law
#     of Fives.

#                  ###   ###    ##    ###  ####  ####  ###
#                  #  #  #  #  #  #  #     #     #     #  #
#                  ###   ###   #  #  #     ###   ###   #  #
#                  #     # #   #  #  #     #     #     #  #
#                  #     #  #   ##    ###  ####  ####  ###


for i in "/bin/date" "/usr/bin/date" "/usr/local/bin/date" "`which date`" ; do
  if test -x "$i" ; then DATE="`date '+%a, %d. %b %Y'`" ; fi
done
for i in "/bin/date" "/usr/bin/date" "/usr/local/bin/date" "`which date`" ; do
  if test -x "$i" ; then TIME="`date '+%H:%M:%S'`" ; fi
done
for i in "/bin/ddate" "/usr/bin/ddate" "/usr/local/bin/ddate" "`which ddate`" ; do
  if test -x "$i" ; then DATE="`ddate '+%{%a, %d. %b%} %Y'`" ; fi
done

test "$VERBOSE" = "NO" || echo "$DATE" "$TIME" "starting $0"

for i in "`which ramdefrag`" "/usr/bin/ramdefrag" "/usr/local/bin/ramdefrag" "$RAMDEFRAG" ; do
  if test -x "$i" ; then RAMDEFRAG="$i" ; fi
done

if grep -q "PLANETARY  PI" "$RAMDEFRAG" ; then
  test "$VERBOSE" = "NO" || echo "found ramdefrag binary in $RAMDEFRAG"
else
  echo "can't find valid ramdefrag binary"
  exit 1
fi

#                        ####  #  #   ##   ###   ###
#                        #     ## #  #  #  #  #  #  #
#                        ###   # ##  #  #  ###   #  #
#                        #     #  #  #  #  # #   #  #
#                        #     #  #   ##   #  #  ###

TEMP="/tmp/ramdefrag-c-a-d.$$"
if "$RAMDEFRAG" -cba >"$TEMP" 2>/dev/null ; then
  FRAGMENTED="`tail -2 $TEMP | head -1 | cut -d. -f1`"
  test "$VERBOSE" = "NO" || echo "analyzing yields $FRAGMENTED percent fragmented"
  rm "$TEMP"
else
  echo "can't analyze memory!"
  rm "$TEMP"
  exit 2
fi


#                     ###    ##         #  #   ##  #####
#                     #  #  #  #        ## #  #  #   #
#                     #  #  #  #        # ##  #  #   #
#                     #  #  #  #        #  #  #  #   #
#                     ###    ##         #  #   ##    #
#
#                  ###   ####  #     ###   ####  #  #  ####
#                  #  #  #     #      #    #     #  #  #
#                  ###   ###   #      #    ###   #  #  ###
#                  #  #  #     #      #    #      ##   #
#                  ###   ####  ####  ###   ####   ##   ####

if test "$FRAGMENTED" -gt "$PERCENTAGE" ; then
  test "$VERBOSE" = "NO" && echo "fragmented: $FRAGMENTED (> $PERCENTAGE) - defragmenting..."
  test "$VERBOSE" = "NO" || echo "more than $PERCENTAGE percent fragmented - defragmenting..."
  if "$RAMDEFRAG" -csS >/dev/null 2>/dev/null ; then
    test "$VERBOSE" = "NO" || echo "defragmentation complete"
  else
    echo "can't defragment memory!"
    exit 3
  fi
else
  test "$VERBOSE" = "NO" || echo "less than $PERCENTAGE percent fragmented."
fi

#                ##   #  # #   # #####  #  #  ###   #  #   ###
#               #  #  ## #  # #    #    #  #   #    ## #  #
#               #  #  # ##   #     #    ####   #    # ##  # ##
#               ####  #  #   #     #    #  #   #    #  #  #  #
#               #  #  #  #   #     #    #  #  ###   #  #   ###

#              #   #   ##   #  #        ###   ####   ##   ###
#               # #   #  #  #  #        #  #  #     #  #  #  #
#                #    #  #  #  #        ###   ###   #  #  #  #
#                #    #  #  #  #        # #   #     ####  #  #
#                #     ##    ##         #  #  ####  #  #  ###

for i in "/bin/date" "/usr/bin/date" "/usr/local/bin/date" "`which date`" ; do
  if test -x "$i" ; then DATE="`date '+%a, %d. %b %Y'`" ; fi
done
for i in "/bin/date" "/usr/bin/date" "/usr/local/bin/date" "`which date`" ; do
  if test -x "$i" ; then TIME="`date '+%H:%M:%S'`" ; fi
done
for i in "/bin/ddate" "/usr/bin/ddate" "/usr/local/bin/ddate" "`which ddate`" ; do
  if test -x "$i" ; then DATE="`ddate '+%{%a, %d. %b%} %Y'`" ; fi
done

test "$VERBOSE" = "NO" || echo "$DATE" "$TIME" "$0 finished."

# fnord.
