/* configf.c - configuration file operations */
#include "cvstags.h"
CVSTAG(configf,"$Id: configf.c,v 1.14 2005/05/08 23:51:40 knilch Exp $")

/* Ramdefrag Configuration File Abstraction Layer
 *  (c) 2004, 2005 Tobias 'knilch' Jordan <knilch@users.sourceforge.net>
 *
 *  Prickle-Prickle, the 16th day of Discord in the YOLD 3170
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "configf.h"

/*
 *
 *                     From the Honest Book of Truth
 *
 *                  THE BOOK OF EXPLANATIONS, Chapter 1
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
/* todo: portable includes */
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <pwd.h>
#include <sys/types.h>
#include <sys/stat.h>

/*
 *    1. There came one day to Lord Omar, Bull Goose of Limbo, a Messenger
 * of Our Lady who told him of a Sacred Mound wherein was buried an Honest
 * Book.
 *
 *    2. And the Angel of Eris bade of the Lord: Go ye hence and dig the
 * Truth, that ye may come to know it and, knowing it, spread it and,
 * spreading it, wallow in it and, wallowing in it, lie in it and, lying
 * in the Truth, become a Poet of the Word and a Sayer of Sayings -- an
 * Inspiration to all men and a Scribe to the Gods.
 */

#include "clierr.h"
#include "support.h" /* for gettext */

#ifndef PATH_MAX
#define PATH_MAX 1024
#endif

/*
 *    3. So Omar went forth to the Sacred Mound, which was to the East of
 * Mullah, and thereupon he worked digging in the sand for five days and
 * five nights, but found no book.
 *
 *    4. At the end of five days and five nights of digging, it came to
 * pass that Omar was exhausted. So he put his shovel to one side and
 * bedded himself down on the sand, using as a pillow a Golden Chest he
 * had uncovered on the first day of his labors.
 *
 *    5. Omar slept.
 */

static char * getcfname() {
  static char n[PATH_MAX];
  char * h = NULL;
  struct passwd *p;
  if ((h = getenv("HOME")) == NULL) {
    if ((p = getpwuid(getuid()))) {
      h = p->pw_dir;
    } else {
      h = ".";
      clierr(_("warning: using current directory as configuration directory"));
    }
  }

/*
 *    6. On the fifth day of his sleeping, Lord Omar fell into a Trance,
 * and there came to him in the Trance a Dream, and there came to him in
 * the Dream a Messenger of Our Lady who told him of a Sacred Grove
 * wherein was hidden a Golden Chest.
 *
 *    7. And the Angel of Eris bade of the Lord: Go ye hence and lift the
 * Stash, that ye may come to own it and, owning it, share it and, sharing
 * it, love in it and, loving in it, dwell in it and, dwelling in the
 * Stash, become a Poet of the Word and a Sayer of Sayings - an
 * Inspiration to all men and a Scribe to the Gods.
 */

  if (access(h, R_OK | W_OK | X_OK) < 0) {
    perror("access");
    fprintf(stderr, _("%s: can't access home directory `%s'!\n"),
	    PACKAGE_NAME, h);
    return "";
  }

#ifdef HAVE_SNPRINTF
  snprintf(n, PATH_MAX,
#else
#warning "no working snprintf! using sprintf, which is prone to buffer overflows!"
  sprintf(n,
#endif
          "%s/%s", h, CFNAME);
#undef VI_SYNTAX_HIGHLIGHTING_DOESNT_WORK_HERE
#ifdef VI_SYNTAX_HIGHLIGHTING_DOESNT_WORK_HERE
  )
#endif
  return n;
}

/*
 *    8. But Omar lamented, saying unto the Angel : What is this shit,
 * man? What care I for the Word and Sayings? What care I for the
 * Inspiration of all men? Wherein does it profit a man to be a Scribe to
 * the Gods when the Scribes of the Governments do nothing, yet are paid
 * better wages?
 *
 *    9. And, lo, the Angel waxed in anger and Omar was stricken to the
 * Ground by an Invisible Hand and did not arise for five days and five
 * nights.
 */

int readcf(struct my_cnf *c) {
  struct stat s;
  c->ts = 0;
  c->df = "JnYq1-Fg!a|<G.jV3_ry(u";
  c->x[0] = 0;
  if (stat(getcfname(), &s)) {
    /* just for debugging... */
#ifdef WALDIS_MUTTER_KOCHT_SCHLECHT
    perror("stat");
#endif
    return 1;
  }
  c->ts=s.st_mtime;
  return 0;
}

/*
 *    10. And it came to pass that on the fifth night he dreampt, and in
 * his Dream he had a Vision, and in this Vision there came unto him a
 * Messenger of Our Lady who entrusted to him a Rigoletto cigar box
 * containing many filing cards, some of them in packs with rubber bands
 * around, and upon these cards were sometimes written verses, while upon
 * others nothing was written.
 *
 *    11. Thereupon the Angel Commanded to Lord: Take ye this Honest Book
 * of Truth to thine bosom and cherish it. Carry it forth into The Land
 * and Lay it before Kings of Nations and Collectors of Garbage. Preach
 * from it unto the Righteous, that they may renounce their ways and
 * repent.
 */

int writecf(struct my_cnf c) {
  FILE *f;
  if (!(f = fopen(getcfname(), "w"))) {
    clierr(_("can't write configuration file!"));
    return 23;
  }
  fprintf(f,_("# Ramdefrag Configuration File\n# DO NOT edit this manually!\n"));
  fprintf(f,"ts %ld\n", c.ts);
  fprintf(f,"df '%s'\n", c.df);
  fprintf(f,"x [%s]\n", c.x);
  fclose(f); /* don't care about the return value */
  return 0;
}

/*
 *                               Bullshit makes
 *                              the flowers grow
 *                             & that's beautiful.
 */

