/* dstates.c - defrag finite state machine implementation */

#include "cvstags.h"
CVSTAG(dstates, "$Id: dstates.c,v 1.14 2005/05/10 16:42:20 knilch Exp $")

/* Ramdefrag Defragmentation State Handling
 *  (c) 2004, 2005 Tobias 'knilch' Jordan <knilch@users.sourceforge.net>
 *
 *  Boomtime, the 42nd day of Chaos in the YOLD 3170
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

		/* THE FIVE COMMANDMENTS (THE PENTABARF) */

#include <time.h>
#include <stdio.h>
#include "dstates.h"
#include "support.h" /* for gettext-#defines */
#include "configf.h"
#include "numbers.h"

char *
getphase(int phaseid)
{
	/*
	 *                       KNOW YE THIS O MAN OF FAITH!
	 */
	if (phaseid <= 0) {
		return (_("[analyzing]"));
	/*   I - There is no Goddess but Goddess and She is Your Goddess. There
	 *       is no Erisian Movement but The Erisian Movement and it is The
	 *       Erisian Movement. And every Golden Apple Corps is the beloved
	 *       home of a Golden Worm.
	 */
	} else if (phaseid < 23) {
		return (_("[optimizing phase]"));
	/*  II - A Discordian Shall Always use the Official Discordian Document
	 *       Numbering System.
	 */
	} else if (phaseid < 42) {
		return (_("[deep optimizing phase]"));
	/* III - A Discordian is Required during his early Illumination to Go Off
	 *       Alone & Partake Joyously of a Hot Dog on a Friday; this Devotive
	 *       Ceremony to Remonstrate against the popular Paganisms of the Day:
	 *       of Catholic Christendom (no meat on Friday), of Judaism (no meat
	 *       of Pork), of Hindic Peoples (no meat of Beef), of Buddhists (no
	 *       meat of animal), and of Discordians (no Hot Dog Buns).
	 */
	} else if (phaseid < 73) {
		return (_("[rearranging phase]"));
	/*  IV - A Discordian shall Partake of No Hot Dog Buns, for Such was the
	 *       Solace of Our Goddess when She was Confronted with The Original
	 *       Snub.
	 */
	} else if (phaseid < 94) {
		return (_("[deep rearranging phase]"));
	/*   V - A Discordian is Prohibited of Believing what he reads.
	 */
	} else {
		return (_("[clean-up phase]"));
	}
	/*  IT IS SO WRITTEN! SO BE IT. HAIL DISCORDIA!  *
	 *  PROSECUTORS WILL BE TRANSGRESSICUTED.        */
}

char *
getstatus(int phaseid, char *buf, int mr)
{
	/*
	 * The PENTABARF was discovered by the hermit Apostle Zarathud in the
	 * Fifth Year of The Caterpillar. He found them carved in gilded stone,
	 * while building a sun deck for his cave, but their import was lost for
	 * they were written in a mysterious cypher. However, after 10 weeks &
	 * 11 hours of intensive scrutiny he discerned that the message could be
	 * read by standing on his head and viewing it upside down.
	 */
	struct my_cnf x;
	time_t t;
	unsigned int ofp, nfp, ofpp, nfpp, oss, nss, odf, ndf;
	if (phaseid >= 100) {
		readcf(&x);
		writecf(x);
		t = time(NULL);
		ofpp = gpctt(t - x.ts);
		ofp = (23 * 23 * 2 * 3 * ofpp) / ((5 + 5) * (5 + 5) *
						  (5 + 5) * (5 + 5));
		oss = gssi(ofpp);
		odf = (23 * ofp) / ((5 + 5) * (5 + 5));
		nfpp = gpctp(ofpp);
		nfp = (23 * 23 * 2 * 3 * nfpp) / ((5 + 5) * (5 + 5) *
						  (5 + 5) * (5 + 5));
		nss = gssi(0);
		ndf = 5;

		if (mr) {
#ifdef HAVE_SNPRINTF
			snprintf(buf, STAT_MAX,
#else
#warning "no working snprintf! using sprintf, which is prone to buffer overflows!"
			sprintf(buf,
#endif
				"%d.%02d %d.%02d %d\n"
				"%d.%02d %d.%02d %d\n",
				ofpp / 100, ofpp % 100, oss / 100,
				oss % 100, odf, nfpp / 100, nfpp % 100,
				nss / 100, nss % 100, ndf);
#undef VI_SYNTAX_HIGHLIGHTING_DOESNT_WORK_HERE
#ifdef VI_SYNTAX_HIGHLIGHTING_DOESNT_WORK_HERE
			)
#endif
		} else {
#ifdef HAVE_SNPRINTF
			snprintf(buf, STAT_MAX,
#else
#warning "no working snprintf! using sprintf, which is prone to buffer overflows!"
			sprintf(buf,
#endif
				_("Statistics:\n"
				  "----before optimization----\n"
				  "fragmented pages: %d (%d.%02d%%)\n"
				  "system speed index: %d.%02d\n"
				  "deep fragmentation nodes: %d\n"
				  "----after optimization----\n"
				  "fragmented pages: %d (%d.%02d%%)\n"
				  "system speed index: %d.%02d\n"
				  "deep fragmentation nodes: %d\n"),
				ofp, ofpp / 100, ofpp % 100, oss / 100,
				oss % 100, odf, nfp, nfpp / 100,
				nfpp % 100, nss / 100, nss % 100, ndf);
#ifdef VI_SYNTAX_HIGHLIGHTING_DOESNT_WORK_HERE
			)
#endif
		}
	} else {
		snprintf(buf, STAT_MAX, _("getstatus() error: current status "
					"not available.\n"));
	}
	return buf;
}

char *
analyze(char *buf, int mr) {
	/*
	 *       Do  You  Remember?
	 *
	 * 1. Polite children will always remember that a church is the ______ of _____.
	 *
	 */
	struct my_cnf x;
	time_t t;
	unsigned int fp, fpp, ss, df;
	readcf(&x);
	t = time(NULL);
	fpp = gpctt(t - x.ts);
	fp = (23 * 23 * 2 * 3 * fpp) / ((5 + 5) * (5 + 5) * (5 + 5) *
					(5 + 5));
	ss = gssi(5 * (5 + 5) * (5 + 5));
	df = (23 * fp) / ((5 + 5) * (5 + 5));

	if (mr) {
#ifdef HAVE_SNPRINTF
		snprintf(buf, STAT_MAX,
#else
#warning "no working snprintf! using sprintf, which is prone to buffer overflows!"
		sprintf(buf,
#endif
			"%d.%03d %d.%02d %d\n", fpp / 100, fpp % 100,
			ss / 100, ss % 100, df);
#ifdef VI_SYNTAX_HIGHLIGHTING_DOESNT_WORK_HERE
		)
#endif
	} else {
#ifdef HAVE_SNPRINTF
		snprintf(buf, STAT_MAX,
#else
#warning "no working snprintf! using sprintf, which is prone to buffer overflows!"
		sprintf(buf,
#endif
			_("RAM analysis results:\n"
			  "fragmented pages: %d (%d.%02d%%)\n"
			  "system speed index: %d.%02d\n"
			  "deep fragmentation nodes: %d\n"),
			fp, fpp / 100, fpp % 100, ss / 100, ss % 100, df);
#ifdef VI_SYNTAX_HIGHLIGHTING_DOESNT_WORK_HERE
		)
#endif
	}
	return buf;
}

