/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import net.sf.juife.event.TaskEvent;
import net.sf.juife.event.TaskListener;
import org.jsampler.CC;
import org.jsampler.task.InstrumentsDb;
import org.jsampler.view.DbDirectoryTreeNode;
import org.linuxsampler.lscp.DbDirectoryInfo;
import org.linuxsampler.lscp.DbInstrumentInfo;
import org.linuxsampler.lscp.Parser;
import org.linuxsampler.lscp.event.InstrumentsDbEvent;
import org.linuxsampler.lscp.event.InstrumentsDbListener;

public class InstrumentsDbTreeModel
implements TreeModel {
    private DbDirectoryTreeNode root = null;
    private Vector<TreeModelListener> listeners = new Vector();
    private final EventHandler eventHandler = new EventHandler();

    public InstrumentsDbTreeModel() {
        this(null);
    }

    public InstrumentsDbTreeModel(ActionListener actionListener) {
        CC.getClient().addInstrumentsDbListener(this.getHandler());
        this.initDb(actionListener);
    }

    public InstrumentsDbTreeModel(boolean bl) {
        if (bl) {
            return;
        }
        CC.getClient().addInstrumentsDbListener(this.getHandler());
        this.initDb(null);
    }

    private void initDb(final ActionListener actionListener) {
        final InstrumentsDb.GetDrectory getDrectory = new InstrumentsDb.GetDrectory("/");
        final InstrumentsDb.GetDrectories getDrectories = new InstrumentsDb.GetDrectories("/");
        final InstrumentsDb.GetInstruments getInstruments = new InstrumentsDb.GetInstruments("/");
        getDrectory.addTaskListener(new TaskListener(){

            @Override
            public void taskPerformed(TaskEvent taskEvent) {
                if (getDrectory.doneWithErrors()) {
                    return;
                }
                InstrumentsDbTreeModel.this.root = new DbDirectoryTreeNode((DbDirectoryInfo)getDrectory.getResult());
                InstrumentsDbTreeModel.this.fireNodeStructureChanged(InstrumentsDbTreeModel.this.root);
                CC.getTaskQueue().add(getDrectories);
                CC.getTaskQueue().add(getInstruments);
            }
        });
        getDrectories.addTaskListener(new TaskListener(){

            @Override
            public void taskPerformed(TaskEvent taskEvent) {
                InstrumentsDbTreeModel.this.root.setConnected(true);
                if (getDrectories.doneWithErrors()) {
                    return;
                }
                InstrumentsDbTreeModel.this.updateDirectoryContent(InstrumentsDbTreeModel.this.root, (DbDirectoryInfo[])getDrectories.getResult());
                for (int i = 0; i < InstrumentsDbTreeModel.this.root.getChildCount(); ++i) {
                    DbDirectoryTreeNode dbDirectoryTreeNode = InstrumentsDbTreeModel.this.root.getChildAt(i);
                    dbDirectoryTreeNode.setConnected(true);
                    InstrumentsDbTreeModel.this.updateDirectoryContent(dbDirectoryTreeNode, "/" + Parser.toEscapedFileName(dbDirectoryTreeNode));
                }
                if (actionListener != null) {
                    actionListener.actionPerformed(null);
                }
            }
        });
        getInstruments.addTaskListener(new TaskListener(){

            @Override
            public void taskPerformed(TaskEvent taskEvent) {
                if (getInstruments.doneWithErrors()) {
                    return;
                }
                InstrumentsDbTreeModel.this.updateDirectoryContent(InstrumentsDbTreeModel.this.root, (DbInstrumentInfo[])getInstruments.getResult());
            }
        });
        CC.getTaskQueue().add(getDrectory);
    }

    public void treeWillExpand(TreePath treePath) {
        DbDirectoryTreeNode dbDirectoryTreeNode = (DbDirectoryTreeNode)treePath.getLastPathComponent();
        if (!dbDirectoryTreeNode.isConnected()) {
            dbDirectoryTreeNode.setConnected(true);
            this.updateDirectoryContent(dbDirectoryTreeNode, dbDirectoryTreeNode.getInfo().getDirectoryPath());
        }
        for (int i = 0; i < dbDirectoryTreeNode.getChildCount(); ++i) {
            DbDirectoryTreeNode dbDirectoryTreeNode2 = dbDirectoryTreeNode.getChildAt(i);
            if (dbDirectoryTreeNode2.isConnected()) continue;
            dbDirectoryTreeNode2.setConnected(true);
            String string = this.getPathName(treePath.getPath());
            if (string.length() > 1) {
                string = string + "/";
            }
            this.updateDirectoryContent(dbDirectoryTreeNode2, string + Parser.toEscapedFileName(dbDirectoryTreeNode2));
        }
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.add(treeModelListener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.remove(treeModelListener);
    }

    @Override
    public Object getChild(Object object, int n) {
        return ((DbDirectoryTreeNode)object).getChildAt(n);
    }

    @Override
    public int getChildCount(Object object) {
        return ((DbDirectoryTreeNode)object).getChildCount();
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        if (object == null || object2 == null) {
            return -1;
        }
        return ((DbDirectoryTreeNode)object).getIndex((DbDirectoryTreeNode)object2);
    }

    @Override
    public boolean isLeaf(Object object) {
        return ((DbDirectoryTreeNode)object).isLeaf();
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    private void updateDirectoryContent(DbDirectoryTreeNode dbDirectoryTreeNode, String string) {
        this.updateDirectoryContent(dbDirectoryTreeNode, string, null);
    }

    private void updateDirectoryContent(final DbDirectoryTreeNode dbDirectoryTreeNode, String string, final ActionListener actionListener) {
        final InstrumentsDb.GetDrectories getDrectories = new InstrumentsDb.GetDrectories(string);
        getDrectories.addTaskListener(new TaskListener(){

            @Override
            public void taskPerformed(TaskEvent taskEvent) {
                if (getDrectories.doneWithErrors()) {
                    if (actionListener != null) {
                        actionListener.actionPerformed(null);
                    }
                    return;
                }
                InstrumentsDbTreeModel.this.updateDirectoryContent(dbDirectoryTreeNode, (DbDirectoryInfo[])getDrectories.getResult());
                if (actionListener != null) {
                    actionListener.actionPerformed(null);
                }
            }
        });
        CC.scheduleTask(getDrectories);
        final InstrumentsDb.GetInstruments getInstruments = new InstrumentsDb.GetInstruments(string);
        getInstruments.addTaskListener(new TaskListener(){

            @Override
            public void taskPerformed(TaskEvent taskEvent) {
                if (getInstruments.doneWithErrors()) {
                    return;
                }
                InstrumentsDbTreeModel.this.updateDirectoryContent(dbDirectoryTreeNode, (DbInstrumentInfo[])getInstruments.getResult());
            }
        });
        CC.scheduleTask(getInstruments);
    }

    private void updateDirectoryContent(DbDirectoryTreeNode dbDirectoryTreeNode, DbDirectoryInfo[] dbDirectoryInfoArray) {
        boolean bl = false;
        Vector<DbDirectoryTreeNode> vector = new Vector<DbDirectoryTreeNode>();
        for (int i = 0; i < dbDirectoryTreeNode.getChildCount(); ++i) {
            for (int j = 0; j < dbDirectoryInfoArray.length; ++j) {
                if (dbDirectoryInfoArray[j] == null || !dbDirectoryInfoArray[j].getName().equals(dbDirectoryTreeNode.getChildAt(i).toString())) continue;
                dbDirectoryInfoArray[j] = null;
                bl = true;
                break;
            }
            if (!bl) {
                vector.add(dbDirectoryTreeNode.getChildAt(i));
            }
            bl = false;
        }
        for (DbDirectoryTreeNode dbDirectoryTreeNode2 : vector) {
            int n = dbDirectoryTreeNode.getIndex(dbDirectoryTreeNode2);
            dbDirectoryTreeNode.removeDirectory(n);
            this.fireNodeRemoved(dbDirectoryTreeNode, dbDirectoryTreeNode2, n);
        }
        for (DbDirectoryInfo dbDirectoryInfo : dbDirectoryInfoArray) {
            if (dbDirectoryInfo == null) continue;
            DbDirectoryTreeNode dbDirectoryTreeNode3 = new DbDirectoryTreeNode(dbDirectoryInfo);
            dbDirectoryTreeNode.addDirectory(dbDirectoryTreeNode3);
            this.fireNodeInserted(dbDirectoryTreeNode3, dbDirectoryTreeNode.getIndex(dbDirectoryTreeNode3));
            if (dbDirectoryTreeNode.getParent() == null) {
                dbDirectoryTreeNode3.setConnected(true);
                this.updateDirectoryContent(dbDirectoryTreeNode3, dbDirectoryInfo.getDirectoryPath());
                continue;
            }
            if (!dbDirectoryTreeNode.isConnected()) continue;
            this.updateDirectoryContent(dbDirectoryTreeNode3, dbDirectoryInfo.getDirectoryPath());
        }
    }

    private void updateDirectoryContent(DbDirectoryTreeNode dbDirectoryTreeNode, DbInstrumentInfo[] dbInstrumentInfoArray) {
        int n;
        boolean bl = false;
        Vector<DbInstrumentInfo> vector = new Vector<DbInstrumentInfo>();
        for (int i = 0; i < dbDirectoryTreeNode.getInstrumentCount(); ++i) {
            String object = dbDirectoryTreeNode.getInstrumentAt(i).getName();
            for (n = 0; n < dbInstrumentInfoArray.length; ++n) {
                if (dbInstrumentInfoArray[n] == null || !dbInstrumentInfoArray[n].getName().equals(object)) continue;
                dbInstrumentInfoArray[n] = null;
                bl = true;
                break;
            }
            if (!bl) {
                vector.add(dbDirectoryTreeNode.getInstrumentAt(i));
            }
            bl = false;
        }
        for (DbInstrumentInfo dbInstrumentInfo : vector) {
            n = dbDirectoryTreeNode.getInstrumentIndex(dbInstrumentInfo);
            dbDirectoryTreeNode.removeInstrument(n);
        }
        for (DbInstrumentInfo dbInstrumentInfo : dbInstrumentInfoArray) {
            if (dbInstrumentInfo == null) continue;
            dbDirectoryTreeNode.addInstrument(dbInstrumentInfo);
        }
    }

    public void refreshDirectoryContent(String string) {
        final DbDirectoryTreeNode dbDirectoryTreeNode = this.getNodeByPath(string);
        if (dbDirectoryTreeNode == null) {
            return;
        }
        dbDirectoryTreeNode.removeAllDirectories();
        this.fireNodeStructureChanged(dbDirectoryTreeNode);
        dbDirectoryTreeNode.removeAllInstruments();
        final InstrumentsDb.GetDrectories getDrectories = new InstrumentsDb.GetDrectories(string);
        getDrectories.addTaskListener(new TaskListener(){

            @Override
            public void taskPerformed(TaskEvent taskEvent) {
                if (getDrectories.doneWithErrors()) {
                    return;
                }
                for (DbDirectoryInfo dbDirectoryInfo : (DbDirectoryInfo[])getDrectories.getResult()) {
                    DbDirectoryTreeNode dbDirectoryTreeNode2 = new DbDirectoryTreeNode(dbDirectoryInfo);
                    dbDirectoryTreeNode.addDirectory(dbDirectoryTreeNode2);
                    InstrumentsDbTreeModel.this.fireNodeInserted(dbDirectoryTreeNode2, dbDirectoryTreeNode.getIndex(dbDirectoryTreeNode2));
                    dbDirectoryTreeNode2.setConnected(true);
                    InstrumentsDbTreeModel.this.updateDirectoryContent(dbDirectoryTreeNode2, dbDirectoryTreeNode2.getInfo().getDirectoryPath());
                }
            }
        });
        CC.scheduleTask(getDrectories);
        final InstrumentsDb.GetInstruments getInstruments = new InstrumentsDb.GetInstruments(string);
        getInstruments.addTaskListener(new TaskListener(){

            @Override
            public void taskPerformed(TaskEvent taskEvent) {
                if (getInstruments.doneWithErrors()) {
                    return;
                }
                for (DbInstrumentInfo dbInstrumentInfo : (DbInstrumentInfo[])getInstruments.getResult()) {
                    dbDirectoryTreeNode.addInstrument(dbInstrumentInfo);
                }
            }
        });
        CC.scheduleTask(getInstruments);
    }

    protected Object[] getPathToRoot(DbDirectoryTreeNode dbDirectoryTreeNode) {
        Vector<DbDirectoryTreeNode> vector = new Vector<DbDirectoryTreeNode>();
        while (dbDirectoryTreeNode != null) {
            vector.insertElementAt(dbDirectoryTreeNode, 0);
            if (dbDirectoryTreeNode == this.getRoot()) break;
            dbDirectoryTreeNode = dbDirectoryTreeNode.getParent();
        }
        return vector.toArray(new Object[vector.size()]);
    }

    protected String getPathName(Object[] objectArray) {
        if (objectArray.length == 1) {
            return "/";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 1; i < objectArray.length; ++i) {
            stringBuffer.append('/').append(Parser.toEscapedFileName(objectArray[i]));
        }
        return stringBuffer.toString();
    }

    private void fireNodeInserted(DbDirectoryTreeNode dbDirectoryTreeNode, int n) {
        Object[] objectArray = this.getPathToRoot(dbDirectoryTreeNode.getParent());
        int[] nArray = new int[]{n};
        Object[] objectArray2 = new Object[]{dbDirectoryTreeNode};
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, objectArray, nArray, objectArray2);
        for (TreeModelListener treeModelListener : this.listeners) {
            treeModelListener.treeNodesInserted(treeModelEvent);
        }
    }

    private void fireNodeChanged(DbDirectoryTreeNode dbDirectoryTreeNode, int n) {
        Object[] objectArray = this.getPathToRoot(dbDirectoryTreeNode.getParent());
        int[] nArray = new int[]{n};
        Object[] objectArray2 = new Object[]{dbDirectoryTreeNode};
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, objectArray, nArray, objectArray2);
        for (TreeModelListener treeModelListener : this.listeners) {
            treeModelListener.treeNodesChanged(treeModelEvent);
        }
    }

    private void fireNodeRemoved(DbDirectoryTreeNode dbDirectoryTreeNode, DbDirectoryTreeNode dbDirectoryTreeNode2, int n) {
        Object[] objectArray = this.getPathToRoot(dbDirectoryTreeNode);
        int[] nArray = new int[]{n};
        Object[] objectArray2 = new Object[]{dbDirectoryTreeNode2};
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, objectArray, nArray, objectArray2);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            this.listeners.get(i).treeNodesRemoved(treeModelEvent);
        }
    }

    private void fireNodeStructureChanged(DbDirectoryTreeNode dbDirectoryTreeNode) {
        Object[] objectArray = this.getPathToRoot(dbDirectoryTreeNode);
        Object[] objectArray2 = new Object[]{dbDirectoryTreeNode};
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, objectArray);
        for (TreeModelListener treeModelListener : this.listeners) {
            treeModelListener.treeStructureChanged(treeModelEvent);
        }
    }

    public DbDirectoryTreeNode getNodeByPath(String string) {
        String[] stringArray = Parser.getDirectoryList(string);
        if (stringArray == null) {
            return null;
        }
        if (stringArray.length == 1) {
            return this.root;
        }
        if (this.root == null) {
            return null;
        }
        DbDirectoryTreeNode dbDirectoryTreeNode = this.root;
        boolean bl = false;
        for (int i = 1; i < stringArray.length; ++i) {
            for (int j = 0; j < dbDirectoryTreeNode.getChildCount(); ++j) {
                String string2 = Parser.toNonEscapedFileName(stringArray[i]);
                if (!string2.equals(dbDirectoryTreeNode.getChildAt(j).toString())) continue;
                dbDirectoryTreeNode = dbDirectoryTreeNode.getChildAt(j);
                bl = true;
                break;
            }
            if (!bl) {
                return null;
            }
            bl = false;
        }
        return dbDirectoryTreeNode;
    }

    public String getPathByNode(DbDirectoryTreeNode dbDirectoryTreeNode) {
        if (dbDirectoryTreeNode == null) {
            return null;
        }
        return this.getPathName(this.getPathToRoot(dbDirectoryTreeNode));
    }

    public void loadPath(String string, final ActionListener actionListener) {
        final String[] stringArray = Parser.getDirectoryList(string);
        if (stringArray == null) {
            actionListener.actionPerformed(null);
            return;
        }
        ActionListener actionListener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = "";
                DbDirectoryTreeNode dbDirectoryTreeNode = null;
                for (int i = 0; i < stringArray.length; ++i) {
                    string = i > 1 ? string + "/" + stringArray[i] : string + stringArray[i];
                    dbDirectoryTreeNode = InstrumentsDbTreeModel.this.getNodeByPath(string);
                    if (dbDirectoryTreeNode == null) {
                        if (actionListener != null) {
                            actionListener.actionPerformed(null);
                        }
                        return;
                    }
                    if (dbDirectoryTreeNode.isConnected()) continue;
                    dbDirectoryTreeNode.setConnected(true);
                    InstrumentsDbTreeModel.this.updateDirectoryContent(dbDirectoryTreeNode, string, this);
                    return;
                }
                if (actionListener != null) {
                    actionListener.actionPerformed(null);
                }
            }
        };
        actionListener2.actionPerformed(null);
    }

    public void reset() {
        DbDirectoryTreeNode dbDirectoryTreeNode = this.root;
        this.root = null;
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, (TreePath)null);
        for (TreeModelListener treeModelListener : this.listeners) {
            treeModelListener.treeStructureChanged(treeModelEvent);
        }
    }

    private EventHandler getHandler() {
        return this.eventHandler;
    }

    private class EventHandler
    implements InstrumentsDbListener {
        private EventHandler() {
        }

        @Override
        public void directoryCountChanged(final InstrumentsDbEvent instrumentsDbEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EventHandler.this.updateDirectoryCount(instrumentsDbEvent);
                }
            });
        }

        private void updateDirectoryCount(InstrumentsDbEvent instrumentsDbEvent) {
            DbDirectoryTreeNode dbDirectoryTreeNode;
            if (instrumentsDbEvent.getPathName().equals("/") && InstrumentsDbTreeModel.this.root == null) {
                InstrumentsDbTreeModel.this.initDb(null);
            }
            if ((dbDirectoryTreeNode = InstrumentsDbTreeModel.this.getNodeByPath(instrumentsDbEvent.getPathName())) == null) {
                return;
            }
            if (!dbDirectoryTreeNode.isConnected()) {
                return;
            }
            InstrumentsDbTreeModel.this.updateDirectoryContent(dbDirectoryTreeNode, instrumentsDbEvent.getPathName());
        }

        @Override
        public void directoryInfoChanged(final InstrumentsDbEvent instrumentsDbEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EventHandler.this.updateDirectoryInfo(instrumentsDbEvent);
                }
            });
        }

        private void updateDirectoryInfo(InstrumentsDbEvent instrumentsDbEvent) {
            final DbDirectoryTreeNode dbDirectoryTreeNode = InstrumentsDbTreeModel.this.getNodeByPath(instrumentsDbEvent.getPathName());
            if (dbDirectoryTreeNode == null) {
                return;
            }
            final InstrumentsDb.GetDrectory getDrectory = new InstrumentsDb.GetDrectory(instrumentsDbEvent.getPathName());
            getDrectory.addTaskListener(new TaskListener(){

                @Override
                public void taskPerformed(TaskEvent taskEvent) {
                    if (getDrectory.doneWithErrors()) {
                        return;
                    }
                    if (dbDirectoryTreeNode.getParent() != null) {
                        dbDirectoryTreeNode.getParent().updateDirectory((DbDirectoryInfo)getDrectory.getResult());
                        InstrumentsDbTreeModel.this.fireNodeChanged(dbDirectoryTreeNode, dbDirectoryTreeNode.getParent().getIndex(dbDirectoryTreeNode));
                    }
                }
            });
            CC.getTaskQueue().add(getDrectory);
        }

        @Override
        public void directoryNameChanged(final InstrumentsDbEvent instrumentsDbEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EventHandler.this.directoryRenamed(instrumentsDbEvent);
                }
            });
        }

        private void directoryRenamed(InstrumentsDbEvent instrumentsDbEvent) {
            Object object;
            DbDirectoryTreeNode dbDirectoryTreeNode = InstrumentsDbTreeModel.this.getNodeByPath(instrumentsDbEvent.getPathName());
            if (dbDirectoryTreeNode == null) {
                object = Parser.getParentDirectory(instrumentsDbEvent.getPathName());
                object = ((String)object).length() == 1 ? (String)object + Parser.toEscapedFileName(instrumentsDbEvent.getNewName()) : (String)object + "/" + Parser.toEscapedFileName(instrumentsDbEvent.getNewName());
                dbDirectoryTreeNode = InstrumentsDbTreeModel.this.getNodeByPath((String)object);
            }
            if (dbDirectoryTreeNode == null || dbDirectoryTreeNode.getParent() == null) {
                CC.getLogger().warning("Invalid path: " + instrumentsDbEvent.getPathName());
                return;
            }
            dbDirectoryTreeNode.setName(instrumentsDbEvent.getNewName());
            object = dbDirectoryTreeNode.getParent();
            int n = ((DbDirectoryTreeNode)object).getIndex(dbDirectoryTreeNode);
            ((DbDirectoryTreeNode)object).removeDirectory(n);
            InstrumentsDbTreeModel.this.fireNodeRemoved((DbDirectoryTreeNode)object, dbDirectoryTreeNode, n);
            ((DbDirectoryTreeNode)object).addDirectory(dbDirectoryTreeNode);
            InstrumentsDbTreeModel.this.fireNodeInserted(dbDirectoryTreeNode, ((DbDirectoryTreeNode)object).getIndex(dbDirectoryTreeNode));
        }

        @Override
        public void instrumentCountChanged(final InstrumentsDbEvent instrumentsDbEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DbDirectoryTreeNode dbDirectoryTreeNode = InstrumentsDbTreeModel.this.getNodeByPath(instrumentsDbEvent.getPathName());
                    if (dbDirectoryTreeNode == null) {
                        return;
                    }
                    if (!dbDirectoryTreeNode.isConnected()) {
                        return;
                    }
                    InstrumentsDbTreeModel.this.updateDirectoryContent(dbDirectoryTreeNode, instrumentsDbEvent.getPathName());
                }
            });
        }

        @Override
        public void instrumentInfoChanged(final InstrumentsDbEvent instrumentsDbEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EventHandler.this.updateInstrumentInfo(instrumentsDbEvent);
                }
            });
        }

        @Override
        public void instrumentNameChanged(final InstrumentsDbEvent instrumentsDbEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EventHandler.this.instrumentRenamed(instrumentsDbEvent);
                }
            });
        }

        private void updateInstrumentInfo(InstrumentsDbEvent instrumentsDbEvent) {
            String string = Parser.getParentDirectory(instrumentsDbEvent.getPathName());
            final DbDirectoryTreeNode dbDirectoryTreeNode = InstrumentsDbTreeModel.this.getNodeByPath(string);
            if (dbDirectoryTreeNode == null) {
                return;
            }
            if (!dbDirectoryTreeNode.isConnected()) {
                return;
            }
            final InstrumentsDb.GetInstrument getInstrument = new InstrumentsDb.GetInstrument(instrumentsDbEvent.getPathName());
            getInstrument.addTaskListener(new TaskListener(){

                @Override
                public void taskPerformed(TaskEvent taskEvent) {
                    if (getInstrument.doneWithErrors()) {
                        return;
                    }
                    dbDirectoryTreeNode.updateInstrument((DbInstrumentInfo)getInstrument.getResult());
                }
            });
            CC.getTaskQueue().add(getInstrument);
        }

        private void instrumentRenamed(InstrumentsDbEvent instrumentsDbEvent) {
            String string = Parser.getParentDirectory(instrumentsDbEvent.getPathName());
            DbDirectoryTreeNode dbDirectoryTreeNode = InstrumentsDbTreeModel.this.getNodeByPath(string);
            if (dbDirectoryTreeNode == null) {
                return;
            }
            String string2 = Parser.getFileName(instrumentsDbEvent.getPathName());
            if (string2 == null) {
                return;
            }
            DbInstrumentInfo dbInstrumentInfo = dbDirectoryTreeNode.getInstrument(Parser.toNonEscapedFileName(string2));
            if (dbInstrumentInfo == null) {
                dbInstrumentInfo = dbDirectoryTreeNode.getInstrument(instrumentsDbEvent.getNewName());
            }
            if (dbInstrumentInfo == null) {
                CC.getLogger().warning("Invalid path: " + instrumentsDbEvent.getPathName());
                return;
            }
            dbInstrumentInfo.setName(instrumentsDbEvent.getNewName());
            dbDirectoryTreeNode.removeInstrument(dbDirectoryTreeNode.getInstrumentIndex(dbInstrumentInfo));
            dbDirectoryTreeNode.addInstrument(dbInstrumentInfo);
        }

        @Override
        public void jobStatusChanged(InstrumentsDbEvent instrumentsDbEvent) {
        }
    }
}

