/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.fantasia;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.juife.NavigationPage;
import org.jsampler.view.fantasia.FantasiaI18n;
import org.jsampler.view.fantasia.FantasiaPrefs;
import org.jsampler.view.fantasia.InstrumentsDbFrame;
import org.jsampler.view.fantasia.basic.FantasiaTaskPane;
import org.jsampler.view.std.JSDbSearchPane;

public class DbSearchPage
extends NavigationPage {
    private final DbSearchPane dbSearchPane;

    public DbSearchPage(final InstrumentsDbFrame instrumentsDbFrame) {
        this.setTitle(FantasiaI18n.i18n.getLabel("DbSearchPage.title"));
        this.setLayout(new BorderLayout());
        this.dbSearchPane = new DbSearchPane(instrumentsDbFrame);
        this.dbSearchPane.setBackgroundColor(new Color(0x626262));
        this.add(this.dbSearchPane);
        this.dbSearchPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                instrumentsDbFrame.setSearchResults(DbSearchPage.this.dbSearchPane.getDirectoryResults(), DbSearchPage.this.dbSearchPane.getInstrumentResults());
            }
        });
    }

    public void setSearchPath(String string) {
        this.dbSearchPane.setSearchPath(string);
    }

    class DbSearchPane
    extends JSDbSearchPane {
        DbSearchPane(Frame frame) {
            super(frame);
        }

        @Override
        protected JComponent createCriteriaPane(String string, JComponent jComponent) {
            final FantasiaTaskPane fantasiaTaskPane = new FantasiaTaskPane();
            fantasiaTaskPane.setTitle(string);
            fantasiaTaskPane.add(jComponent);
            fantasiaTaskPane.setAlignmentX(0.0f);
            fantasiaTaskPane.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
            fantasiaTaskPane.setCollapsed(true);
            fantasiaTaskPane.setAnimated(FantasiaPrefs.preferences().getBoolProperty("animated"));
            FantasiaPrefs.preferences().addPropertyChangeListener("animated", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    fantasiaTaskPane.setAnimated(FantasiaPrefs.preferences().getBoolProperty("animated"));
                }
            });
            return fantasiaTaskPane;
        }
    }
}

