/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.std;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.juife.JuifeUtils;
import org.jsampler.CC;
import org.jsampler.DefaultOrchestraModel;
import org.jsampler.MidiInstrumentMap;
import org.jsampler.OrchestraInstrument;
import org.jsampler.OrchestraModel;
import org.jsampler.SamplerChannelModel;
import org.jsampler.event.ListEvent;
import org.jsampler.event.ListListener;
import org.jsampler.event.SamplerChannelListEvent;
import org.jsampler.event.SamplerChannelListListener;
import org.jsampler.view.InstrumentTable;
import org.jsampler.view.std.JSAddMidiInstrumentDlg;
import org.jsampler.view.std.JSAddOrEditInstrumentDlg;
import org.jsampler.view.std.StdA4n;
import org.jsampler.view.std.StdI18n;
import org.linuxsampler.lscp.Instrument;

public class JSOrchestraPane
extends JPanel {
    protected final InstrumentTable instrumentTable;
    protected final Action actionAddInstrument = new AddInstrumentAction();
    protected final Action actionEditInstrument = new EditInstrumentAction();
    protected final Action actionDeleteInstrument = new DeleteInstrumentAction();
    protected final Action actionInstrumentUp = new InstrumentUpAction();
    protected final Action actionInstrumentDown = new InstrumentDownAction();
    private OrchestraModel orchestra;
    private LoadInstrumentActionFactory loadInstrActionFactory = new LoadInstrumentActionFactory();

    public JSOrchestraPane() {
        this((OrchestraModel)null);
    }

    public JSOrchestraPane(OrchestraModel orchestraModel) {
        this.instrumentTable = new InstrumentTable();
        this.instrumentTable.setFillsViewportHeight(true);
        this.setOrchestra(orchestraModel);
        this.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.instrumentTable);
        this.add(jScrollPane);
        this.installListeneres();
    }

    private void installListeneres() {
        InstrumentSelectionHandler instrumentSelectionHandler = new InstrumentSelectionHandler();
        this.instrumentTable.getSelectionModel().addListSelectionListener(instrumentSelectionHandler);
        this.instrumentTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() != 3) {
                    return;
                }
                int n = JSOrchestraPane.this.instrumentTable.rowAtPoint(mouseEvent.getPoint());
                if (n == -1) {
                    return;
                }
                JSOrchestraPane.this.instrumentTable.getSelectionModel().setSelectionInterval(n, n);
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() < 2) {
                    return;
                }
                if (JSOrchestraPane.this.instrumentTable.getSelectedInstrument() == null) {
                    return;
                }
                JSOrchestraPane.this.editInstrument(JSOrchestraPane.this.instrumentTable.getSelectedInstrument());
            }
        });
        ContextMenu contextMenu = new ContextMenu();
        this.instrumentTable.addMouseListener(contextMenu);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(127, 0);
        this.instrumentTable.getInputMap(0).put(keyStroke, "deleteInstrument");
        this.instrumentTable.getActionMap().put("deleteInstrument", this.actionDeleteInstrument);
    }

    public void setOrchestra(OrchestraModel orchestraModel) {
        this.orchestra = orchestraModel;
        if (orchestraModel == null) {
            orchestraModel = new DefaultOrchestraModel();
            this.actionAddInstrument.setEnabled(false);
        } else {
            this.actionAddInstrument.setEnabled(true);
        }
        this.instrumentTable.getModel().setOrchestraModel(orchestraModel);
    }

    public OrchestraInstrument getSelectedInstrument() {
        return this.instrumentTable.getSelectedInstrument();
    }

    public OrchestraInstrument createInstrument() {
        JSAddOrEditInstrumentDlg jSAddOrEditInstrumentDlg = new JSAddOrEditInstrumentDlg();
        jSAddOrEditInstrumentDlg.setVisible(true);
        if (jSAddOrEditInstrumentDlg.isCancelled()) {
            return null;
        }
        return jSAddOrEditInstrumentDlg.getInstrument();
    }

    public void editInstrument(OrchestraInstrument orchestraInstrument) {
        JSAddOrEditInstrumentDlg jSAddOrEditInstrumentDlg = new JSAddOrEditInstrumentDlg(orchestraInstrument);
        jSAddOrEditInstrumentDlg.setVisible(true);
    }

    class ContextMenu
    extends MouseAdapter
    implements SamplerChannelListListener,
    ListSelectionListener {
        private final JPopupMenu cmenu = new JPopupMenu();
        JMenuItem miEdit = new JMenuItem(StdI18n.i18n.getMenuLabel("ContextMenu.edit"));
        JMenu mLoadInstrument = new JMenu(StdI18n.i18n.getMenuLabel("JSOrchestraPane.loadInstrument"));
        JMenu mMapInstrument = new JMenu(StdI18n.i18n.getMenuLabel("JSOrchestraPane.mapInstrument"));

        ContextMenu() {
            this.cmenu.add(this.miEdit);
            this.miEdit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JSOrchestraPane.this.actionEditInstrument.actionPerformed(null);
                }
            });
            JMenuItem jMenuItem = new JMenuItem(StdI18n.i18n.getMenuLabel("ContextMenu.delete"));
            this.cmenu.add(jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JSOrchestraPane.this.actionDeleteInstrument.actionPerformed(null);
                }
            });
            this.cmenu.addSeparator();
            this.cmenu.add(this.mLoadInstrument);
            this.cmenu.add(this.mMapInstrument);
            CC.getSamplerModel().addSamplerChannelListListener(this);
            JSOrchestraPane.this.instrumentTable.getSelectionModel().addListSelectionListener(this);
            ListListener<MidiInstrumentMap> listListener = new ListListener<MidiInstrumentMap>(){

                @Override
                public void entryAdded(ListEvent<MidiInstrumentMap> listEvent) {
                    ContextMenu.this.updateAddToMidiMapMenu(ContextMenu.this.mMapInstrument);
                }

                @Override
                public void entryRemoved(ListEvent<MidiInstrumentMap> listEvent) {
                    ContextMenu.this.updateAddToMidiMapMenu(ContextMenu.this.mMapInstrument);
                }
            };
            CC.getSamplerModel().addMidiInstrumentMapListListener(listListener);
            CC.getMainFrame().addChannelsPaneSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    ContextMenu.this.updateLoadInstrumentMenu(ContextMenu.this.mLoadInstrument);
                }
            });
        }

        private void updateLoadInstrumentMenu(JMenu jMenu) {
            jMenu.removeAll();
            StdA4n.updateLoadInstrumentMenu(jMenu, JSOrchestraPane.this.loadInstrActionFactory);
            this.updateLoadInstrumentMenuState(jMenu);
        }

        private void updateLoadInstrumentMenuState(JMenu jMenu) {
            OrchestraInstrument orchestraInstrument = JSOrchestraPane.this.instrumentTable.getSelectedInstrument();
            boolean bl = orchestraInstrument == null;
            bl = bl || CC.getSamplerModel().getChannelCount() == 0;
            jMenu.setEnabled(!bl);
        }

        private void updateAddToMidiMapMenu(JMenu jMenu) {
            jMenu.removeAll();
            for (int i = 0; i < CC.getSamplerModel().getMidiInstrumentMapCount(); ++i) {
                MidiInstrumentMap midiInstrumentMap = CC.getSamplerModel().getMidiInstrumentMap(i);
                jMenu.add(new JMenuItem(new AddToMidiMapAction(midiInstrumentMap)));
            }
            this.updateAddToMidiMapMenuState(jMenu);
        }

        private void updateAddToMidiMapMenuState(JMenu jMenu) {
            OrchestraInstrument orchestraInstrument = JSOrchestraPane.this.instrumentTable.getSelectedInstrument();
            boolean bl = orchestraInstrument == null;
            bl = bl || CC.getSamplerModel().getMidiInstrumentMapCount() == 0;
            jMenu.setEnabled(!bl);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateLoadInstrumentMenuState(this.mLoadInstrument);
            this.updateAddToMidiMapMenuState(this.mMapInstrument);
        }

        @Override
        public void channelAdded(SamplerChannelListEvent samplerChannelListEvent) {
            if (CC.getSamplerModel().getChannelListIsAdjusting()) {
                return;
            }
            this.updateLoadInstrumentMenu(this.mLoadInstrument);
        }

        @Override
        public void channelRemoved(SamplerChannelListEvent samplerChannelListEvent) {
            this.updateLoadInstrumentMenu(this.mLoadInstrument);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.show(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.show(mouseEvent);
            }
        }

        void show(MouseEvent mouseEvent) {
            this.cmenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    class AddToMidiMapAction
    extends AbstractAction {
        private final MidiInstrumentMap midiMap;

        AddToMidiMapAction(MidiInstrumentMap midiInstrumentMap) {
            super(midiInstrumentMap.getName());
            this.midiMap = midiInstrumentMap;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            OrchestraInstrument orchestraInstrument = JSOrchestraPane.this.instrumentTable.getSelectedInstrument();
            if (orchestraInstrument == null) {
                return;
            }
            Window window = JuifeUtils.getWindow(JSOrchestraPane.this);
            JSAddMidiInstrumentDlg jSAddMidiInstrumentDlg = window instanceof Dialog ? new JSAddMidiInstrumentDlg((Dialog)window, this.midiMap, (Instrument)orchestraInstrument) : (window instanceof Frame ? new JSAddMidiInstrumentDlg((Frame)window, this.midiMap, (Instrument)orchestraInstrument) : new JSAddMidiInstrumentDlg((Frame)null, this.midiMap, (Instrument)orchestraInstrument));
            jSAddMidiInstrumentDlg.setVisible(true);
        }
    }

    class LoadInstrumentActionFactory
    implements StdA4n.LoadInstrumentActionFactory {
        LoadInstrumentActionFactory() {
        }

        @Override
        public StdA4n.LoadInstrumentAction createLoadInstrumentAction(SamplerChannelModel samplerChannelModel, boolean bl) {
            return new LoadInstrumentAction(samplerChannelModel, bl);
        }
    }

    private class LoadInstrumentAction
    extends StdA4n.LoadInstrumentAction {
        LoadInstrumentAction(SamplerChannelModel samplerChannelModel, boolean bl) {
            super(samplerChannelModel, bl);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            OrchestraInstrument orchestraInstrument = JSOrchestraPane.this.instrumentTable.getSelectedInstrument();
            if (orchestraInstrument == null) {
                return;
            }
            int n = orchestraInstrument.getInstrumentIndex();
            this.channelModel.setBackendEngineType(orchestraInstrument.getEngine());
            this.channelModel.loadBackendInstrument(orchestraInstrument.getFilePath(), n);
        }
    }

    private class InstrumentDownAction
    extends AbstractAction {
        InstrumentDownAction() {
            super("");
            String string = StdI18n.i18n.getLabel("JSOrchestraPane.ttInstrumentDown");
            this.putValue("ShortDescription", string);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            OrchestraInstrument orchestraInstrument = JSOrchestraPane.this.instrumentTable.getSelectedInstrument();
            JSOrchestraPane.this.instrumentTable.getModel().getOrchestraModel().moveInstrumentDown(orchestraInstrument);
            JSOrchestraPane.this.instrumentTable.setSelectedInstrument(orchestraInstrument);
        }
    }

    private class InstrumentUpAction
    extends AbstractAction {
        InstrumentUpAction() {
            super("");
            String string = StdI18n.i18n.getLabel("JSOrchestraPane.ttInstrumentUp");
            this.putValue("ShortDescription", string);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            OrchestraInstrument orchestraInstrument = JSOrchestraPane.this.instrumentTable.getSelectedInstrument();
            JSOrchestraPane.this.instrumentTable.getModel().getOrchestraModel().moveInstrumentUp(orchestraInstrument);
            JSOrchestraPane.this.instrumentTable.setSelectedInstrument(orchestraInstrument);
        }
    }

    private class DeleteInstrumentAction
    extends AbstractAction {
        DeleteInstrumentAction() {
            super("");
            String string = StdI18n.i18n.getLabel("JSOrchestraPane.ttDeleteInstrument");
            this.putValue("ShortDescription", string);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            OrchestraInstrument orchestraInstrument = JSOrchestraPane.this.instrumentTable.getSelectedInstrument();
            if (orchestraInstrument == null) {
                return;
            }
            int n = JSOrchestraPane.this.instrumentTable.getSelectedRow();
            JSOrchestraPane.this.orchestra.removeInstrument(orchestraInstrument);
            if (JSOrchestraPane.this.instrumentTable.getRowCount() > n) {
                JSOrchestraPane.this.instrumentTable.getSelectionModel().setSelectionInterval(n, n);
            }
        }
    }

    private class EditInstrumentAction
    extends AbstractAction {
        EditInstrumentAction() {
            super("");
            String string = StdI18n.i18n.getLabel("JSOrchestraPane.ttEditInstrument");
            this.putValue("ShortDescription", string);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JSOrchestraPane.this.editInstrument(JSOrchestraPane.this.instrumentTable.getSelectedInstrument());
        }
    }

    private class AddInstrumentAction
    extends AbstractAction {
        AddInstrumentAction() {
            super("");
            String string = StdI18n.i18n.getLabel("JSOrchestraPane.ttAddInstrument");
            this.putValue("ShortDescription", string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            OrchestraInstrument orchestraInstrument = JSOrchestraPane.this.createInstrument();
            if (orchestraInstrument == null) {
                return;
            }
            JSOrchestraPane.this.orchestra.addInstrument(orchestraInstrument);
        }
    }

    private class InstrumentSelectionHandler
    implements ListSelectionListener {
        private InstrumentSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            if (JSOrchestraPane.this.instrumentTable.getSelectedInstrument() == null) {
                JSOrchestraPane.this.actionEditInstrument.setEnabled(false);
                JSOrchestraPane.this.actionDeleteInstrument.setEnabled(false);
                JSOrchestraPane.this.actionInstrumentUp.setEnabled(false);
                JSOrchestraPane.this.actionInstrumentDown.setEnabled(false);
                return;
            }
            JSOrchestraPane.this.actionEditInstrument.setEnabled(true);
            JSOrchestraPane.this.actionDeleteInstrument.setEnabled(true);
            int n = JSOrchestraPane.this.instrumentTable.getSelectedRow();
            JSOrchestraPane.this.actionInstrumentUp.setEnabled(n != 0);
            JSOrchestraPane.this.actionInstrumentDown.setEnabled(n != JSOrchestraPane.this.instrumentTable.getRowCount() - 1);
        }
    }
}

