/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.lafwidget.animation.effects;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jvnet.lafwidget.LafWidgetUtilities;
import org.jvnet.lafwidget.animation.FadeConfigurationManager;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeTracker;

public class IconGlowListener {
    protected ChangeListener modelListener;
    protected Component comp;
    protected long glowLoopAnimationId;
    protected ButtonModel buttonModel;
    protected Map<FadeKind, Boolean> prevStateMap;

    public IconGlowListener(Component comp, ButtonModel buttonModel) {
        this.comp = comp;
        this.buttonModel = buttonModel;
        this.prevStateMap = new HashMap<FadeKind, Boolean>();
        this.prevStateMap.put(FadeKind.ICON_GLOW, buttonModel.isRollover());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trackModelChange(FadeKind fadeKind, boolean newState) {
        if (LafWidgetUtilities.toIgnoreAnimations(this.comp)) {
            return;
        }
        try {
            if (this.prevStateMap.containsKey(fadeKind)) {
                boolean prevState = this.prevStateMap.get(fadeKind);
                if (!prevState && newState) {
                    this.glowLoopAnimationId = FadeTracker.getInstance().trackFadeLooping(fadeKind, LafWidgetUtilities.getAnimationKind(this.comp).derive(0.1f), this.comp, null, false, null, -1, true);
                } else if (prevState && !newState) {
                    FadeTracker.getInstance().requestStopOnCycleBreak(this.glowLoopAnimationId);
                }
            }
        }
        finally {
            this.prevStateMap.put(fadeKind, newState);
        }
    }

    public void registerListeners() {
        this.modelListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (FadeConfigurationManager.getInstance().fadeAllowed(FadeKind.ICON_GLOW, IconGlowListener.this.comp)) {
                    IconGlowListener.this.trackModelChange(FadeKind.ICON_GLOW, IconGlowListener.this.buttonModel.isRollover());
                }
            }
        };
        this.buttonModel.addChangeListener(this.modelListener);
    }

    public void unregisterListeners() {
        this.buttonModel.removeChangeListener(this.modelListener);
    }
}

