/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter;

import java.awt.Insets;
import java.awt.Rectangle;
import org.jdesktop.swingx.painter.AbstractPainter;

public abstract class AbstractLayoutPainter<T>
extends AbstractPainter<T> {
    private VerticalAlignment verticalAlignment = VerticalAlignment.CENTER;
    private HorizontalAlignment horizontalAlignment = HorizontalAlignment.CENTER;
    private Insets insets = new Insets(0, 0, 0, 0);
    private boolean fillVertical = false;
    private boolean fillHorizontal = false;

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public boolean isFillHorizontal() {
        return this.fillHorizontal;
    }

    public boolean isFillVertical() {
        return this.fillVertical;
    }

    public void setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        HorizontalAlignment horizontalAlignment2 = this.getHorizontalAlignment();
        this.horizontalAlignment = horizontalAlignment;
        this.setDirty(true);
        this.firePropertyChange("horizontal", (Object)horizontalAlignment2, (Object)this.horizontalAlignment);
    }

    public void setFillHorizontal(boolean bl) {
        boolean bl2 = this.isFillHorizontal();
        this.fillHorizontal = bl;
        this.setDirty(true);
        this.firePropertyChange("horizontalStretch", bl2, this.fillHorizontal);
    }

    public void setInsets(Insets insets) {
        Insets insets2 = this.getInsets();
        this.insets = insets;
        this.setDirty(true);
        this.firePropertyChange("insets", insets2, this.insets);
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        VerticalAlignment verticalAlignment2 = this.getVerticalAlignment();
        this.verticalAlignment = verticalAlignment;
        this.setDirty(true);
        this.firePropertyChange("vertical", (Object)verticalAlignment2, (Object)this.verticalAlignment);
    }

    public void setFillVertical(boolean bl) {
        boolean bl2 = this.isFillVertical();
        this.fillVertical = bl;
        this.setDirty(true);
        this.firePropertyChange("verticalStretch", bl2, this.fillVertical);
    }

    protected final Rectangle calculateLayout(int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle();
        rectangle.width = n;
        rectangle.height = n2;
        if (this.isFillHorizontal()) {
            rectangle.width = n3 - this.insets.left - this.insets.right;
        }
        if (this.isFillVertical()) {
            rectangle.height = n4 - this.insets.top - this.insets.bottom;
        }
        rectangle.x = this.calculateX(rectangle.width, n3);
        rectangle.y = this.calculateY(rectangle.height, n4);
        return rectangle;
    }

    private int calculateY(int n, int n2) {
        int n3 = 0;
        if (this.getVerticalAlignment() == VerticalAlignment.TOP) {
            n3 = 0;
            n3 += this.insets.top;
        }
        if (this.getVerticalAlignment() == VerticalAlignment.CENTER) {
            n3 = (n2 - n) / 2;
            n3 += this.insets.top;
        }
        if (this.getVerticalAlignment() == VerticalAlignment.BOTTOM) {
            n3 = n2 - n;
            n3 -= this.insets.bottom;
        }
        return n3;
    }

    private int calculateX(int n, int n2) {
        int n3 = 0;
        if (this.getHorizontalAlignment() == HorizontalAlignment.LEFT) {
            n3 = 0;
            n3 += this.insets.left;
        }
        if (this.getHorizontalAlignment() == HorizontalAlignment.CENTER) {
            n3 = (n2 - n) / 2;
            n3 += this.insets.left;
        }
        if (this.getHorizontalAlignment() == HorizontalAlignment.RIGHT) {
            n3 = n2 - n;
            n3 -= this.insets.right;
        }
        return n3;
    }

    public static enum VerticalAlignment {
        TOP,
        CENTER,
        BOTTOM;

    }

    public static enum HorizontalAlignment {
        LEFT,
        CENTER,
        RIGHT;

    }
}

