MACRO(checkVapourSynth)
	IF (NOT VAPOURSYNTH_CHECKED)
		OPTION(VAPOURSYNTH "" ON)

		MESSAGE(STATUS "Checking for VAPOURSYNTH")
		MESSAGE(STATUS "***********************")

		IF (VAPOURSYNTH)
                        PKG_CHECK_MODULES(VAPOURSYNTHSCRIPT vapoursynth-script)
                        IF (VAPOURSYNTHSCRIPT_FOUND)
                                MESSAGE(STATUS "VSSCRIPT<${VAPOURSYNTHSCRIPT_CFLAGS}>  < ${VAPOURSYNTHSCRIPT_LDFLAGS}>")
                                SET(USE_VAPOURSYNTH 1)
                        ENDIF (VAPOURSYNTHSCRIPT_FOUND)
		ELSE (VAPOURSYNTH)
			MESSAGE("${MSG_DISABLE_OPTION}")
		ENDIF (VAPOURSYNTH)

		SET(VAPOURSYNTH_CHECKED 1)

		MESSAGE("")
	ENDIF (NOT VAPOURSYNTH_CHECKED)

	APPEND_SUMMARY_LIST("Miscellaneous" "VapourSynth" "${VAPOURSYNTHSCRIPT_FOUND}")
ENDMACRO(checkVapourSynth)
