/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.io;

import com.db4o.io.IoAdapter;
import java.io.IOException;

public class IoAdapterWindow {
    private IoAdapter _io;
    private int _blockOff;
    private int _len;
    private boolean _disabled;

    public IoAdapterWindow(IoAdapter ioAdapter, int n, int n2) {
        this._io = ioAdapter;
        this._blockOff = n;
        this._len = n2;
        this._disabled = false;
    }

    public int length() {
        return this._len;
    }

    public void write(int n, byte[] byArray) throws IllegalArgumentException, IllegalStateException, IOException {
        this.checkBounds(n, byArray);
        this._io.blockSeek(this._blockOff + n);
        this._io.write(byArray);
    }

    public int read(int n, byte[] byArray) throws IllegalArgumentException, IllegalStateException, IOException {
        this.checkBounds(n, byArray);
        this._io.blockSeek(this._blockOff + n);
        return this._io.read(byArray);
    }

    public void disable() {
        this._disabled = true;
    }

    public void flush() throws IOException {
        if (!this._disabled) {
            this._io.sync();
        }
    }

    private void checkBounds(int n, byte[] byArray) {
        if (this._disabled) {
            throw new IllegalStateException();
        }
        if (byArray == null || n < 0 || n + byArray.length > this._len) {
            throw new IllegalArgumentException();
        }
    }
}

