/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.rssowl.core.internal.persist.LongArrayList;
import org.rssowl.core.internal.persist.SortedLongArrayList;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.INewsBin;
import org.rssowl.core.persist.reference.NewsReference;
import org.rssowl.core.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NewsContainer {
    private LongArrayList[] fNewsIds;

    protected NewsContainer() {
    }

    public NewsContainer(Map<INews.State, Boolean> statesToSortedMap) {
        int length = INews.State.values().length;
        this.fNewsIds = new LongArrayList[length];
        int i = 0;
        while (i < this.fNewsIds.length) {
            Boolean sort = statesToSortedMap.get((Object)INews.State.getState(i));
            this.fNewsIds[i] = sort != null && sort.equals(Boolean.TRUE) ? new SortedLongArrayList(0) : new LongArrayList(0);
            ++i;
        }
    }

    public LongArrayList[] internalGetNewsIds() {
        return this.fNewsIds;
    }

    public Pair<Boolean, Boolean> setNews(Map<INews.State, List<NewsReference>> newsMap) {
        Assert.isNotNull(newsMap, (String)"newsMap");
        boolean changed = false;
        boolean isNewNewsAdded = false;
        EnumSet<INews.State> statesToReset = EnumSet.allOf(INews.State.class);
        statesToReset.removeAll(newsMap.keySet());
        for (INews.State state : statesToReset) {
            int index = state.ordinal();
            LongArrayList currentArrayList = this.fNewsIds[index];
            if (currentArrayList.size() <= 0) continue;
            currentArrayList.clear();
            changed = true;
        }
        for (Map.Entry entry : newsMap.entrySet()) {
            List news = (List)entry.getValue();
            INews.State state = (INews.State)((Object)entry.getKey());
            Assert.isNotNull((Object)news, (String)"news");
            Assert.isNotNull((Object)((Object)state), (String)"state");
            long[] newArray = new long[news.size()];
            int i = 0;
            while (i < news.size()) {
                newArray[i] = ((NewsReference)news.get(i)).getId();
                ++i;
            }
            int index = state.ordinal();
            LongArrayList currentArrayList = this.fNewsIds[index];
            if (state.equals((Object)INews.State.NEW)) {
                if (newArray.length > currentArrayList.size()) {
                    isNewNewsAdded = true;
                } else {
                    long[] lArray = newArray;
                    int n = newArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        long value = lArray[n2];
                        if (currentArrayList.indexOf(value) < 0) {
                            isNewNewsAdded = true;
                            break;
                        }
                        ++n2;
                    }
                }
                if (!isNewNewsAdded && newArray.length == currentArrayList.size()) continue;
                changed = true;
                currentArrayList.setAll(newArray);
                continue;
            }
            if (currentArrayList.elementsEqual(newArray)) continue;
            currentArrayList.setAll(newArray);
            changed = true;
        }
        return Pair.create(changed, isNewNewsAdded);
    }

    public void addNews(INews news) {
        this.checkNewsIdNotNull(news);
        this.fNewsIds[this.getIndex(news)].add(news.getId());
    }

    private int getIndex(INews news) {
        return news.getState().ordinal();
    }

    public boolean removeNews(INews news) {
        this.checkNewsIdNotNull(news);
        return this.fNewsIds[this.getIndex(news)].removeByElement(news.getId());
    }

    public int getNewsCount(Set<INews.State> states) {
        Assert.isNotNull(states, (String)"states");
        int count = 0;
        for (INews.State state : states) {
            count += this.fNewsIds[state.ordinal()].size();
        }
        return count;
    }

    public boolean containsNews(INews news) {
        this.checkNewsIdNotNull(news);
        int i = 0;
        int c = this.fNewsIds.length;
        while (i < c) {
            if (this.fNewsIds[i].contains(news.getId())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void checkNewsIdNotNull(INews news) {
        Assert.isNotNull((Object)news.getId(), (String)"news.getId()");
    }

    public List<NewsReference> getNews() {
        return this.getNews(EnumSet.allOf(INews.State.class));
    }

    public List<NewsReference> getNews(Set<INews.State> states) {
        ArrayList<NewsReference> newsRefs = new ArrayList<NewsReference>(this.getNewsCount(states));
        for (INews.State state : states) {
            int index = state.ordinal();
            LongArrayList newsIds = this.fNewsIds[index];
            int i = 0;
            int c = newsIds.size();
            while (i < c) {
                long newsId = newsIds.get(i);
                Assert.isLegal((newsId != 0L ? 1 : 0) != 0);
                newsRefs.add(new NewsReference(newsId));
                ++i;
            }
        }
        return newsRefs;
    }

    public List<NewsReference> removeNews(Set<INews.State> states) {
        List<NewsReference> newsRefs = this.getNews(states);
        for (INews.State state : states) {
            int index = state.ordinal();
            this.fNewsIds[index].clear();
        }
        return newsRefs;
    }

    public void removeNewsRefs(List<NewsReference> newsRefs) {
        LongArrayList[] longArrayListArray = this.fNewsIds;
        int n = this.fNewsIds.length;
        int n2 = 0;
        while (n2 < n) {
            LongArrayList list = longArrayListArray[n2];
            for (NewsReference newsRef : newsRefs) {
                list.removeByElement(newsRef.getId());
            }
            ++n2;
        }
    }

    public boolean updateNewsStates(Collection<INewsBin.StatesUpdateInfo> statesUpdateInfos) {
        boolean changed = false;
        for (INewsBin.StatesUpdateInfo info : statesUpdateInfos) {
            long newsId = info.getNewsReference().getId();
            if (info.getOldState() == null) {
                boolean itemRemoved = this.fNewsIds[INews.State.NEW.ordinal()].removeByElement(newsId);
                if (!itemRemoved) {
                    EnumSet<INews.State> remainingStates = EnumSet.allOf(INews.State.class);
                    remainingStates.remove((Object)INews.State.NEW);
                    remainingStates.remove((Object)info.getNewState());
                    for (INews.State state : remainingStates) {
                        if (!this.fNewsIds[state.ordinal()].removeByElement(newsId)) continue;
                        itemRemoved = true;
                    }
                }
                if (!itemRemoved) continue;
                changed = true;
                this.fNewsIds[info.getNewState().ordinal()].add(newsId);
                continue;
            }
            if (!this.fNewsIds[info.getOldState().ordinal()].removeByElement(newsId)) continue;
            changed = true;
            this.fNewsIds[info.getNewState().ordinal()].add(newsId);
        }
        return changed;
    }
}

