/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.persist;

import java.util.HashMap;
import java.util.Map;
import org.rssowl.core.internal.persist.Persistable;
import org.rssowl.core.persist.NewsCounterItem;

public final class NewsCounter
extends Persistable {
    private Map<String, NewsCounterItem> fCountersMap;

    public synchronized void put(String link, NewsCounterItem item) {
        if (this.fCountersMap == null) {
            this.fCountersMap = new HashMap<String, NewsCounterItem>();
        }
        this.fCountersMap.put(link, item);
    }

    public synchronized NewsCounterItem get(String link) {
        if (this.fCountersMap == null) {
            return null;
        }
        return this.fCountersMap.get(link);
    }

    public synchronized NewsCounterItem remove(String link) {
        if (this.fCountersMap == null) {
            return null;
        }
        return this.fCountersMap.remove(link);
    }

    public synchronized int getNewCount(String feedLink) {
        NewsCounterItem counter = this.get(feedLink);
        if (counter == null) {
            return 0;
        }
        return counter.getNewCounter();
    }

    public synchronized int getUnreadCount(String feedLink) {
        NewsCounterItem counter = this.get(feedLink);
        if (counter == null) {
            return 0;
        }
        return counter.getUnreadCounter();
    }

    public synchronized int getStickyCount(String feedLink) {
        NewsCounterItem counter = this.get(feedLink);
        if (counter == null) {
            return 0;
        }
        return counter.getStickyCounter();
    }
}

