/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs;

import java.io.Serializable;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.rssowl.core.Owl;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IFolderChild;
import org.rssowl.core.persist.IModelFactory;
import org.rssowl.core.persist.IPersistable;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.dao.IFolderDAO;
import org.rssowl.core.persist.service.PersistenceException;
import org.rssowl.core.util.Pair;
import org.rssowl.core.util.StringUtils;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.Messages;
import org.rssowl.ui.internal.util.FolderChooser;
import org.rssowl.ui.internal.util.LayoutUtils;
import org.rssowl.ui.internal.util.ModelUtils;

public class FolderWizard
extends Wizard
implements INewWizard {
    private NewFolderWizardPage fPage;
    private IStructuredSelection fSelection;

    public void addPages() {
        this.fPage = new NewFolderWizardPage(Messages.FolderWizard_NEW_FOLDER);
        this.setWindowTitle(Messages.FolderWizard_FOLDER);
        this.setHelpAvailable(false);
        this.addPage((IWizardPage)this.fPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.fSelection = selection;
    }

    public boolean performFinish() {
        String name = this.fPage.getFolderName();
        IModelFactory factory = Owl.getModelFactory();
        if (!StringUtils.isSet((String)name)) {
            this.fPage.setErrorMessage(Messages.FolderWizard_ENTER_NAME);
            this.fPage.focusInput();
            return false;
        }
        IFolder parent = this.fPage.getFolder();
        IFolder folder = factory.createFolder(null, parent, name);
        if (parent != null) {
            Map properties = parent.getProperties();
            for (Map.Entry property : properties.entrySet()) {
                folder.setProperty((String)property.getKey(), (Serializable)property.getValue());
            }
        }
        ((IFolderDAO)DynamicDAO.getDAO(IFolderDAO.class)).save((IPersistable)parent);
        return true;
    }

    private IFolder getParent() throws PersistenceException {
        Pair<IFolder, IFolderChild> pair = ModelUtils.getLocationAndPosition(this.fSelection);
        return (IFolder)pair.getFirst();
    }

    private class NewFolderWizardPage
    extends WizardPage {
        private FolderChooser fFolderChooser;
        private Text fNameInput;

        NewFolderWizardPage(String pageName) {
            super(pageName, pageName, OwlUI.getImageDescriptor("icons/wizban/folder_wiz.gif"));
            this.setMessage(Messages.FolderWizard_FOLDER_WIZ_TITLE);
        }

        public void createControl(Composite parent) {
            Composite control = new Composite(parent, 0);
            control.setLayout((Layout)LayoutUtils.createGridLayout(2, 5, 5));
            control.setLayoutData((Object)new GridData(4, 1, true, false));
            Label l1 = new Label(control, 0);
            l1.setText(Messages.FolderWizard_NAME);
            this.fNameInput = new Text(control, 2052);
            this.fNameInput.setLayoutData((Object)new GridData(4, 1, true, false));
            this.fNameInput.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    NewFolderWizardPage.this.setErrorMessage(null);
                }
            });
            Label l2 = new Label(control, 0);
            l2.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            l2.setText(Messages.FolderWizard_LOCATION);
            this.fFolderChooser = new FolderChooser(control, FolderWizard.this.getParent(), 2048, true);
            this.fFolderChooser.setExpandStrategy(FolderChooser.ExpandStrategy.PACK);
            this.fFolderChooser.setLayoutData(new GridData(4, 1, true, false));
            this.fFolderChooser.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0, 2, 5, false));
            this.fFolderChooser.setBackground(control.getDisplay().getSystemColor(25));
            this.setControl((Control)control);
        }

        String getFolderName() {
            return this.fNameInput.getText();
        }

        void focusInput() {
            this.fNameInput.setFocus();
            this.fNameInput.selectAll();
        }

        IFolder getFolder() {
            return this.fFolderChooser.getFolder();
        }
    }
}

