/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs;

import java.net.URI;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.rssowl.core.Owl;
import org.rssowl.core.connection.CredentialsException;
import org.rssowl.core.connection.ICredentials;
import org.rssowl.core.connection.ICredentialsProvider;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.core.util.StringUtils;
import org.rssowl.core.util.URIUtils;
import org.rssowl.ui.internal.Activator;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.Messages;
import org.rssowl.ui.internal.util.BrowserUtils;
import org.rssowl.ui.internal.util.LayoutUtils;

public class LoginDialog
extends TitleAreaDialog {
    private static final String PROTOCOL_SEPARATOR = "://";
    private final LocalResourceManager fResources;
    private final URI fLink;
    private Text fUsername;
    private Text fPassword;
    private Button fRememberPassword;
    private final ICredentialsProvider fCredProvider;
    private final String fRealm;
    private String fHeader;
    private String fSubline;
    private ImageDescriptor fTitleImageDescriptor;
    private final IPreferenceScope fPreferences;
    private final boolean fIsSyncLogin;

    public LoginDialog(Shell parentShell, URI link, String realm) {
        this(parentShell, link, realm, false);
    }

    public LoginDialog(Shell parentShell, URI link, String realm, boolean isSyncLogin) {
        super(parentShell);
        this.fLink = link;
        this.fRealm = realm;
        this.fIsSyncLogin = isSyncLogin;
        this.fResources = new LocalResourceManager(JFaceResources.getResources());
        this.fCredProvider = Owl.getConnectionService().getCredentialsProvider(link);
        this.fPreferences = Owl.getPreferenceService().getGlobalScope();
    }

    public void setHeader(String header) {
        this.fHeader = header;
    }

    public void setSubline(String subline) {
        this.fSubline = subline;
    }

    public void setTitleImageDescriptor(ImageDescriptor titleImageDescriptor) {
        this.fTitleImageDescriptor = titleImageDescriptor;
    }

    public boolean close() {
        this.fResources.dispose();
        return super.close();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            boolean rememberPassword;
            boolean bl = rememberPassword = this.fIsSyncLogin || this.fRememberPassword.getSelection();
            if (rememberPassword != this.fPreferences.getBoolean(DefaultPreferences.REMEMBER_PASSWORD)) {
                this.fPreferences.putBoolean(DefaultPreferences.REMEMBER_PASSWORD, rememberPassword);
            }
            final String username = this.fUsername.getText();
            final String password = this.fPassword.getText();
            ICredentials credentials = new ICredentials(){

                public String getDomain() {
                    return null;
                }

                public String getPassword() {
                    return password;
                }

                public String getUsername() {
                    return username;
                }
            };
            try {
                if (this.fCredProvider != null) {
                    if (rememberPassword) {
                        this.fCredProvider.setAuthCredentials(credentials, this.fLink, null);
                    } else {
                        this.fCredProvider.setInMemoryAuthCredentials(credentials, this.fLink, null);
                    }
                    if (this.fRealm != null) {
                        if (rememberPassword) {
                            this.fCredProvider.setAuthCredentials(credentials, URIUtils.normalizeUri((URI)this.fLink, (boolean)true), this.fRealm);
                        } else {
                            this.fCredProvider.setInMemoryAuthCredentials(credentials, URIUtils.normalizeUri((URI)this.fLink, (boolean)true), this.fRealm);
                        }
                    }
                }
            }
            catch (CredentialsException e) {
                Activator.getDefault().getLog().log(e.getStatus());
            }
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.LoginDialog_FEED_REQUIRES_AUTH);
    }

    protected Control createDialogArea(Composite parent) {
        new Label(parent, 258).setLayoutData((Object)new GridData(4, 1, true, false));
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutUtils.createGridLayout(2, 5, 10));
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.setTitle(StringUtils.isSet((String)this.fHeader) ? this.fHeader : Messages.LoginDialog_LOGIN);
        if (this.fTitleImageDescriptor != null) {
            this.setTitleImage(OwlUI.getImage((ResourceManager)this.fResources, this.fTitleImageDescriptor));
        } else {
            this.setTitleImage(OwlUI.getImage((ResourceManager)this.fResources, "icons/wizban/auth.gif"));
        }
        if (StringUtils.isSet((String)this.fSubline)) {
            this.setMessage(this.fSubline);
        } else if (this.fRealm != null) {
            this.setMessage(NLS.bind((String)Messages.LoginDialog_ENTER_USER_PW_REALM, (Object)this.fRealm));
        } else {
            this.setMessage(Messages.LoginDialog_ENTER_USER_PW);
        }
        new Label(composite, 0);
        Label hostLabel = new Label(composite, 64);
        hostLabel.setLayoutData((Object)new GridData(1, 1, false, false));
        StringBuilder hostLabelValue = new StringBuilder();
        if (StringUtils.isSet((String)this.fLink.getScheme())) {
            hostLabelValue.append(this.fLink.getScheme()).append(PROTOCOL_SEPARATOR);
        }
        hostLabelValue.append(URIUtils.safeGetHost((URI)this.fLink));
        hostLabel.setText(hostLabelValue.toString());
        Label usernameLabel = new Label(composite, 0);
        usernameLabel.setText(Messages.LoginDialog_USERNAME);
        usernameLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.fUsername = new Text(composite, 2052);
        this.fUsername.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fUsername.setFocus();
        Label passwordLabel = new Label(composite, 0);
        passwordLabel.setText(Messages.LoginDialog_PASSWORD);
        passwordLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.fPassword = new Text(composite, 0x400804);
        this.fPassword.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (!this.fIsSyncLogin) {
            new Label(composite, 0);
            this.fRememberPassword = new Button(composite, 32);
            this.fRememberPassword.setText(Messages.LoginDialog_REMEMBER_PASSWORD);
            this.fRememberPassword.setSelection(this.fPreferences.getBoolean(DefaultPreferences.REMEMBER_PASSWORD));
            this.fRememberPassword.setLayoutData((Object)new GridData(4, 1, true, false));
            ((GridData)this.fRememberPassword.getLayoutData()).verticalIndent = 5;
        }
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(4, 0x1000008, true, true));
        this.preload();
        LoginDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        if (this.fIsSyncLogin) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout(2, false);
            layout.marginLeft = 5;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.horizontalSpacing = 0;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            composite.setFont(parent.getFont());
            if (this.isHelpAvailable()) {
                Control helpControl = this.createHelpControl(composite);
                ((GridData)helpControl.getLayoutData()).horizontalIndent = this.convertHorizontalDLUsToPixels(7);
            }
            Link createAccountLink = new Link(composite, 0);
            createAccountLink.setText(Messages.LoginDialog_CREATE_NEW_ACCOUNT);
            createAccountLink.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
            createAccountLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BrowserUtils.openLinkExternal("https://www.google.com/accounts/NewAccount?continue=http%3A%2F%2Fwww.google.com%2Freader%2F&followup=http%3A%2F%2Fwww.google.com%2Freader%2F&service=reader");
                }
            });
            Control buttonSection = super.createButtonBar(composite);
            ((GridData)buttonSection.getLayoutData()).grabExcessHorizontalSpace = true;
            return composite;
        }
        return super.createButtonBar(parent);
    }

    private void preload() {
        ICredentials authCredentials = null;
        try {
            if (this.fCredProvider != null) {
                authCredentials = this.fCredProvider.getAuthCredentials(this.fLink, this.fRealm);
            }
            if (this.fCredProvider != null && this.fRealm != null && authCredentials == null) {
                authCredentials = this.fCredProvider.getAuthCredentials(URIUtils.normalizeUri((URI)this.fLink, (boolean)true), this.fRealm);
            }
        }
        catch (CredentialsException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
        if (authCredentials != null) {
            String username = authCredentials.getUsername();
            String password = authCredentials.getPassword();
            if (StringUtils.isSet((String)username)) {
                this.fUsername.setText(username);
                this.fUsername.selectAll();
            }
            if (StringUtils.isSet((String)password)) {
                this.fPassword.setText(password);
            }
        }
    }

    protected int getShellStyle() {
        int style = 0x10860 | LoginDialog.getDefaultOrientation();
        return style;
    }

    protected void initializeBounds() {
        super.initializeBounds();
        Shell shell = this.getShell();
        int minWidth = this.convertHorizontalDLUsToPixels(320);
        int minHeight = shell.computeSize((int)minWidth, (int)-1).y;
        Point requiredSize = shell.computeSize(-1, -1);
        shell.setSize(Math.max(minWidth, requiredSize.x), Math.max(minHeight, requiredSize.y));
        LayoutUtils.positionShell(shell);
    }
}

