/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.editors.feed;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageDescriptor;
import org.rssowl.core.internal.InternalOwl;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.ICategory;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.ILabel;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.IPerson;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.dao.IBookMarkDAO;
import org.rssowl.core.persist.event.NewsEvent;
import org.rssowl.core.persist.reference.FeedLinkReference;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.DateUtils;
import org.rssowl.core.util.StringUtils;
import org.rssowl.core.util.SyncUtils;
import org.rssowl.ui.internal.EntityGroup;
import org.rssowl.ui.internal.EntityGroupItem;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.editors.feed.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewsGrouping {
    private static final long DAY = 86400000L;
    private static final long WEEK = 604800000L;
    private static final int TITLE_ID_BEGIN = 1000;
    private static final int LABEL_ID_BEGIN = 2000;
    private static final int CATEGORY_ID_BEGIN = 3000;
    private static final int AUTHOR_ID_BEGIN = 4000;
    public static final String GROUP_CATEGORY_ID = "org.rssowl.ui.internal.editors.feed.NewsGrouping";
    private Type fType = Type.NO_GROUPING;

    Type getType() {
        return this.fType;
    }

    public void setType(Type type) {
        this.fType = type;
    }

    boolean needsRefresh(Collection<NewsEvent> events, boolean isUpdate) {
        if (this.fType == Type.NO_GROUPING) {
            return false;
        }
        if (CoreUtils.gotDeleted(events) || CoreUtils.gotRestored(events)) {
            return true;
        }
        if (this.fType == Type.GROUP_BY_STATE) {
            return CoreUtils.isStateChange(events);
        }
        if (this.fType == Type.GROUP_BY_DATE) {
            return CoreUtils.isDateChange(events);
        }
        if (this.fType == Type.GROUP_BY_AUTHOR) {
            return CoreUtils.isAuthorChange(events);
        }
        if (this.fType == Type.GROUP_BY_CATEGORY) {
            return CoreUtils.isCategoryChange(events);
        }
        if (this.fType == Type.GROUP_BY_LABEL) {
            return CoreUtils.isLabelChange(events);
        }
        if (this.fType == Type.GROUP_BY_FEED && isUpdate) {
            return false;
        }
        if (this.fType == Type.GROUP_BY_TOPIC) {
            return CoreUtils.isTitleChange(events);
        }
        if (this.fType == Type.GROUP_BY_STICKY) {
            return CoreUtils.isStickyStateChange(events);
        }
        return this.fType != Type.GROUP_BY_RATING;
    }

    public Collection<EntityGroup> group(Collection<INews> input) {
        Assert.isTrue((this.fType != Type.NO_GROUPING ? 1 : 0) != 0, (String)"Grouping is not enabled!");
        if (input.size() == 0) {
            return new ArrayList<EntityGroup>(0);
        }
        if (Type.GROUP_BY_DATE == this.fType) {
            return this.createDateGroups(input);
        }
        if (Type.GROUP_BY_STATE == this.fType) {
            return this.createStateGroups(input);
        }
        if (Type.GROUP_BY_AUTHOR == this.fType) {
            return this.createAuthorGroups(input);
        }
        if (Type.GROUP_BY_CATEGORY == this.fType) {
            return this.createCategoryGroups(input);
        }
        if (Type.GROUP_BY_LABEL == this.fType) {
            return this.createLabelGroups(input);
        }
        if (Type.GROUP_BY_RATING == this.fType) {
            return this.createRatingGroups(input);
        }
        if (Type.GROUP_BY_FEED == this.fType) {
            return this.createFeedGroups(input);
        }
        if (Type.GROUP_BY_STICKY == this.fType) {
            return this.createStickyGroups(input);
        }
        if (Type.GROUP_BY_TOPIC == this.fType) {
            return this.createTopicGroups(input);
        }
        return new ArrayList<EntityGroup>(0);
    }

    private List<EntityGroup> createTopicGroups(Collection<INews> input) {
        EntityGroup gDefault = new EntityGroup(Group.NO_TOPIC.ordinal(), GROUP_CATEGORY_ID, Group.NO_TOPIC.getName());
        HashMap<String, EntityGroup> groupCache = new HashMap<String, EntityGroup>();
        groupCache.put(Group.NO_TOPIC.getName(), gDefault);
        int nextId = Group.NO_TOPIC.ordinal() + 1000;
        for (INews object : input) {
            if (!(object instanceof INews)) continue;
            INews news = object;
            EntityGroup group = gDefault;
            String normalizedTitle = CoreUtils.getHeadline((INews)news, (boolean)true);
            normalizedTitle = CoreUtils.normalizeTitle((String)normalizedTitle);
            String groupId = !SyncUtils.isSynchronized((INews)news) && StringUtils.isSet((String)news.getInReplyTo()) ? news.getInReplyTo() : normalizedTitle;
            if (StringUtils.isSet((String)groupId) && (group = (EntityGroup)groupCache.get(groupId)) == null) {
                group = new EntityGroup(nextId++, GROUP_CATEGORY_ID, normalizedTitle);
                groupCache.put(groupId, group);
            }
            new EntityGroupItem(group, (IEntity)news);
        }
        return this.maskEmpty(new ArrayList<EntityGroup>(Arrays.asList(groupCache.values().toArray(new EntityGroup[groupCache.values().size()]))));
    }

    private List<EntityGroup> createStickyGroups(Collection<INews> input) {
        EntityGroup gSticky = new EntityGroup(Group.STICKY.ordinal(), GROUP_CATEGORY_ID, Group.STICKY.getName());
        EntityGroup gNotSticky = new EntityGroup(Group.NOT_STICKY.ordinal(), GROUP_CATEGORY_ID, Group.NOT_STICKY.getName());
        for (INews object : input) {
            if (!(object instanceof INews)) continue;
            INews news = object;
            if (news.isFlagged()) {
                new EntityGroupItem(gSticky, (IEntity)news);
                continue;
            }
            new EntityGroupItem(gNotSticky, (IEntity)news);
        }
        return this.maskEmpty(new ArrayList<EntityGroup>(Arrays.asList(gSticky, gNotSticky)));
    }

    private Collection<EntityGroup> createFeedGroups(Collection<INews> input) {
        HashMap<Long, EntityGroup> groupCache = new HashMap<Long, EntityGroup>();
        IBookMarkDAO bookmarkDao = (IBookMarkDAO)DynamicDAO.getDAO(IBookMarkDAO.class);
        HashMap<FeedLinkReference, IBookMark> feedToBookMarkCache = new HashMap<FeedLinkReference, IBookMark>();
        int nextId = 0;
        for (INews object : input) {
            EntityGroup group;
            if (!(object instanceof INews)) continue;
            INews news = object;
            FeedLinkReference feedRef = news.getFeedReference();
            IBookMark bookmark = (IBookMark)feedToBookMarkCache.get(feedRef);
            if (bookmark == null) {
                Collection bookmarks = bookmarkDao.loadAll(feedRef);
                if (bookmarks.isEmpty()) continue;
                bookmark = (IBookMark)bookmarks.iterator().next();
                feedToBookMarkCache.put(feedRef, bookmark);
            }
            if ((group = (EntityGroup)groupCache.get(bookmark.getId())) == null) {
                String name = bookmark.getName();
                group = new EntityGroup(nextId++, GROUP_CATEGORY_ID, name);
                if (!InternalOwl.TESTING) {
                    ImageDescriptor feedIcon = OwlUI.getFavicon(bookmark);
                    group.setImage(feedIcon != null ? feedIcon : OwlUI.BOOKMARK);
                }
                groupCache.put(bookmark.getId(), group);
            }
            new EntityGroupItem(group, (IEntity)news);
        }
        return this.sort(this.maskEmpty(new ArrayList<EntityGroup>(Arrays.asList(groupCache.values().toArray(new EntityGroup[groupCache.values().size()])))));
    }

    private List<EntityGroup> createRatingGroups(Collection<INews> input) {
        EntityGroup gFantastic = new EntityGroup(Group.FANTASTIC.ordinal(), GROUP_CATEGORY_ID, Group.FANTASTIC.getName());
        EntityGroup gGood = new EntityGroup(Group.GOOD.ordinal(), GROUP_CATEGORY_ID, Group.GOOD.getName());
        EntityGroup gModerate = new EntityGroup(Group.MODERATE.ordinal(), GROUP_CATEGORY_ID, Group.MODERATE.getName());
        EntityGroup gBad = new EntityGroup(Group.BAD.ordinal(), GROUP_CATEGORY_ID, Group.BAD.getName());
        EntityGroup gVeryBad = new EntityGroup(Group.VERY_BAD.ordinal(), GROUP_CATEGORY_ID, Group.VERY_BAD.getName());
        for (INews object : input) {
            if (!(object instanceof INews)) continue;
            INews news = object;
            if (news.getRating() >= 80) {
                new EntityGroupItem(gFantastic, (IEntity)news);
                continue;
            }
            if (news.getRating() >= 60) {
                new EntityGroupItem(gGood, (IEntity)news);
                continue;
            }
            if (news.getRating() >= 40) {
                new EntityGroupItem(gModerate, (IEntity)news);
                continue;
            }
            if (news.getRating() >= 20) {
                new EntityGroupItem(gBad, (IEntity)news);
                continue;
            }
            new EntityGroupItem(gVeryBad, (IEntity)news);
        }
        return this.maskEmpty(new ArrayList<EntityGroup>(Arrays.asList(gFantastic, gGood, gModerate, gBad, gVeryBad)));
    }

    private Collection<EntityGroup> createLabelGroups(Collection<INews> input) {
        EntityGroup gDefault = new EntityGroup(Group.NONE.ordinal(), GROUP_CATEGORY_ID, Messages.NewsGrouping_UNLABELED, Integer.MAX_VALUE, null);
        HashMap<String, EntityGroup> groupCache = new HashMap<String, EntityGroup>();
        groupCache.put(Group.NONE.getName(), gDefault);
        int nextId = Group.NONE.ordinal() + 2000;
        for (INews object : input) {
            ILabel label;
            String name;
            if (!(object instanceof INews)) continue;
            INews news = object;
            Set labels = CoreUtils.getSortedLabels((INews)news);
            EntityGroup group = gDefault;
            if (!labels.isEmpty() && (group = (EntityGroup)groupCache.get(name = (label = (ILabel)labels.iterator().next()).getName())) == null) {
                group = new EntityGroup(nextId++, GROUP_CATEGORY_ID, name, label.getOrder(), OwlUI.getRGB(label));
                groupCache.put(name, group);
            }
            new EntityGroupItem(group, (IEntity)news);
        }
        return this.sort(this.maskEmpty(new ArrayList<EntityGroup>(Arrays.asList(groupCache.values().toArray(new EntityGroup[groupCache.values().size()])))));
    }

    private Collection<EntityGroup> createCategoryGroups(Collection<INews> input) {
        EntityGroup gDefault = new EntityGroup(Group.UNKNOWN_CATEGORY.ordinal(), GROUP_CATEGORY_ID, Group.UNKNOWN_CATEGORY.getName());
        HashMap<String, EntityGroup> groupCache = new HashMap<String, EntityGroup>();
        groupCache.put(Group.UNKNOWN_CATEGORY.getName(), gDefault);
        int nextId = Group.UNKNOWN_CATEGORY.ordinal() + 3000;
        for (INews object : input) {
            if (!(object instanceof INews)) continue;
            INews news = object;
            List categories = news.getCategories();
            EntityGroup group = gDefault;
            if (categories.size() > 0) {
                String name = ((ICategory)categories.get(0)).getName();
                if (!StringUtils.isSet((String)name)) {
                    name = Group.UNKNOWN_CATEGORY.getName();
                }
                if ((group = (EntityGroup)groupCache.get(name)) == null) {
                    group = new EntityGroup(nextId++, GROUP_CATEGORY_ID, name);
                    groupCache.put(name, group);
                }
            }
            new EntityGroupItem(group, (IEntity)news);
        }
        return this.sort(this.maskEmpty(new ArrayList<EntityGroup>(Arrays.asList(groupCache.values().toArray(new EntityGroup[groupCache.values().size()])))));
    }

    private Collection<EntityGroup> createAuthorGroups(Collection<INews> input) {
        EntityGroup gDefault = new EntityGroup(Group.UNKNOWN_AUTHOR.ordinal(), GROUP_CATEGORY_ID, Group.UNKNOWN_AUTHOR.getName());
        HashMap<String, EntityGroup> groupCache = new HashMap<String, EntityGroup>();
        groupCache.put(Group.UNKNOWN_AUTHOR.getName(), gDefault);
        int nextId = Group.UNKNOWN_AUTHOR.ordinal() + 4000;
        for (INews object : input) {
            if (!(object instanceof INews)) continue;
            INews news = object;
            IPerson author = news.getAuthor();
            EntityGroup group = gDefault;
            if (author != null) {
                String name = author.getName();
                if (!StringUtils.isSet((String)name)) {
                    name = Group.UNKNOWN_AUTHOR.getName();
                }
                if ((group = (EntityGroup)groupCache.get(name)) == null) {
                    group = new EntityGroup(nextId++, GROUP_CATEGORY_ID, name);
                    groupCache.put(name, group);
                }
            }
            new EntityGroupItem(group, (IEntity)news);
        }
        return this.sort(this.maskEmpty(new ArrayList<EntityGroup>(Arrays.asList(groupCache.values().toArray(new EntityGroup[groupCache.values().size()])))));
    }

    private List<EntityGroup> createStateGroups(Collection<INews> input) {
        EntityGroup gNew = new EntityGroup(Group.NEW.ordinal(), GROUP_CATEGORY_ID, Group.NEW.getName());
        EntityGroup gUpdated = new EntityGroup(Group.UPDATED.ordinal(), GROUP_CATEGORY_ID, Group.UPDATED.getName());
        EntityGroup gUnread = new EntityGroup(Group.UNREAD.ordinal(), GROUP_CATEGORY_ID, Group.UNREAD.getName());
        EntityGroup gRead = new EntityGroup(Group.READ.ordinal(), GROUP_CATEGORY_ID, Group.READ.getName());
        for (INews object : input) {
            if (!(object instanceof INews)) continue;
            INews news = object;
            if (INews.State.NEW.equals((Object)news.getState())) {
                new EntityGroupItem(gNew, (IEntity)news);
                continue;
            }
            if (INews.State.UPDATED.equals((Object)news.getState())) {
                new EntityGroupItem(gUpdated, (IEntity)news);
                continue;
            }
            if (INews.State.UNREAD.equals((Object)news.getState())) {
                new EntityGroupItem(gUnread, (IEntity)news);
                continue;
            }
            if (!INews.State.READ.equals((Object)news.getState())) continue;
            new EntityGroupItem(gRead, (IEntity)news);
        }
        return this.maskEmpty(new ArrayList<EntityGroup>(Arrays.asList(gNew, gUpdated, gUnread, gRead)));
    }

    private List<EntityGroup> createDateGroups(Collection<INews> input) {
        Calendar today = DateUtils.getToday();
        long todayMillis = today.getTimeInMillis();
        Date yesterday = new Date(todayMillis - 86400000L);
        today.set(7, today.getFirstDayOfWeek());
        Date earlierThisWeek = today.getTime();
        Date lastWeek = new Date(earlierThisWeek.getTime() - 604800000L);
        EntityGroup gToday = new EntityGroup(Group.TODAY.ordinal(), GROUP_CATEGORY_ID, Group.TODAY.getName());
        EntityGroup gYesterday = new EntityGroup(Group.YESTERDAY.ordinal(), GROUP_CATEGORY_ID, Group.YESTERDAY.getName());
        EntityGroup gEarlierThisWeek = new EntityGroup(Group.EARLIER_THIS_WEEK.ordinal(), GROUP_CATEGORY_ID, Group.EARLIER_THIS_WEEK.getName());
        EntityGroup gLastWeek = new EntityGroup(Group.LAST_WEEK.ordinal(), GROUP_CATEGORY_ID, Group.LAST_WEEK.getName());
        EntityGroup gOlder = new EntityGroup(Group.OLDER.ordinal(), GROUP_CATEGORY_ID, Group.OLDER.getName());
        for (INews object : input) {
            if (!(object instanceof INews)) continue;
            INews news = object;
            Date date = DateUtils.getRecentDate((INews)news);
            if (date.getTime() >= todayMillis) {
                new EntityGroupItem(gToday, (IEntity)news);
                continue;
            }
            if (date.compareTo(yesterday) >= 0) {
                new EntityGroupItem(gYesterday, (IEntity)news);
                continue;
            }
            if (date.compareTo(earlierThisWeek) >= 0) {
                new EntityGroupItem(gEarlierThisWeek, (IEntity)news);
                continue;
            }
            if (date.compareTo(lastWeek) >= 0) {
                new EntityGroupItem(gLastWeek, (IEntity)news);
                continue;
            }
            new EntityGroupItem(gOlder, (IEntity)news);
        }
        return this.maskEmpty(new ArrayList<EntityGroup>(Arrays.asList(gToday, gYesterday, gEarlierThisWeek, gLastWeek, gOlder)));
    }

    private List<EntityGroup> maskEmpty(List<EntityGroup> items) {
        ArrayList<EntityGroup> maskedItems = new ArrayList<EntityGroup>();
        for (EntityGroup item : items) {
            if (item.size() <= 0) continue;
            maskedItems.add(item);
        }
        return maskedItems;
    }

    private Collection<EntityGroup> sort(List<EntityGroup> items) {
        TreeSet<EntityGroup> sortedItems = new TreeSet<EntityGroup>(new Comparator<EntityGroup>(){

            @Override
            public int compare(EntityGroup o1, EntityGroup o2) {
                if (o1.equals(o2)) {
                    return 0;
                }
                if (o1.getSortKey() != null && o2.getSortKey() != null) {
                    if (o1.getSortKey().equals(o2.getSortKey())) {
                        return -1;
                    }
                    return o1.getSortKey().compareTo(o2.getSortKey());
                }
                if (o1.getName().equalsIgnoreCase(o2.getName())) {
                    return -1;
                }
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        sortedItems.addAll(items);
        return sortedItems;
    }

    boolean isActive() {
        return this.fType != Type.NO_GROUPING;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Group {
        NO_TOPIC(Messages.NewsGrouping_NO_TOPIC),
        UNKNOWN_CATEGORY(Messages.NewsGrouping_UNKNOWN_CATEGORY),
        UNKNOWN_AUTHOR(Messages.NewsGrouping_UNKNOWN_AUTHOR),
        NONE(Messages.NewsGrouping_NONE),
        TODAY(Messages.NewsGrouping_TODAY),
        YESTERDAY(Messages.NewsGrouping_YESTERDAY),
        EARLIER_THIS_WEEK(Messages.NewsGrouping_EARLIER_THIS_WEEK),
        LAST_WEEK(Messages.NewsGrouping_LAST_WEEK),
        OLDER(Messages.NewsGrouping_OLDER_NEWS),
        FANTASTIC(Messages.NewsGrouping_FANTASTIC),
        GOOD(Messages.NewsGrouping_GOOD),
        MODERATE(Messages.NewsGrouping_MODERATE),
        BAD(Messages.NewsGrouping_BAD),
        VERY_BAD(Messages.NewsGrouping_UNRATED),
        NEW(Messages.NewsGrouping_NEW),
        UPDATED(Messages.NewsGrouping_UPDATED),
        UNREAD(Messages.NewsGrouping_UNREAD),
        READ(Messages.NewsGrouping_READ),
        STICKY(Messages.NewsGrouping_STICKY),
        NOT_STICKY(Messages.NewsGrouping_NOT_STICKY);

        String fName;

        private Group(String name) {
            this.fName = name;
        }

        public String getName() {
            return this.fName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        NO_GROUPING(Messages.NewsGrouping_NO_GROUPING, Messages.NewsGrouping_UNGROUPED),
        GROUP_BY_DATE(Messages.NewsGrouping_GROUP_BY_DATE, Messages.NewsGrouping_GROUPED_BY_DATE),
        GROUP_BY_STATE(Messages.NewsGrouping_GROUP_BY_STATE, Messages.NewsGrouping_GROUPED_BY_STATE),
        GROUP_BY_AUTHOR(Messages.NewsGrouping_GROUP_BY_AUTHOR, Messages.NewsGrouping_GROUPED_BY_AUTHOR),
        GROUP_BY_CATEGORY(Messages.NewsGrouping_GROUP_BY_CATEGORY, Messages.NewsGrouping_GROUPED_BY_CATEGORY),
        GROUP_BY_TOPIC(Messages.NewsGrouping_GROUP_BY_TITLE, Messages.NewsGrouping_GROUPED_BY_TITLE),
        GROUP_BY_FEED(Messages.NewsGrouping_GROUP_BY_FEED, Messages.NewsGrouping_GROUPED_BY_FEED),
        GROUP_BY_LABEL(Messages.NewsGrouping_GROUP_BY_LABEL, Messages.NewsGrouping_GROUPED_BY_LABEL),
        GROUP_BY_RATING(Messages.NewsGrouping_GROUP_BY_RATING, Messages.NewsGrouping_GROUPED_BY_RATING),
        GROUP_BY_STICKY(Messages.NewsGrouping_GROUP_BY_STICKY, Messages.NewsGrouping_GROUPED_BY_STICKY);

        String fActionName;
        String fDisplayName;

        private Type(String actionName, String displayName) {
            this.fActionName = actionName;
            this.fDisplayName = displayName;
        }

        public String getName() {
            return this.fActionName;
        }

        public String getDisplayName() {
            return this.fDisplayName;
        }
    }
}

