#include <stdlib.h>
#include <string.h>
#define YYBYACC 1
#define YYMAJOR 1
#define YYMINOR 9
#define YYLEX yylex()
#define YYEMPTY -1
#define yyclearin (yychar=(YYEMPTY))
#define yyerrok (yyerrflag=0)
#define YYRECOVERING() (yyerrflag!=0)
#define YYPREFIX "yy"
#line 22 "parse.y"
#include <sys/types.h>
#include <sys/stat.h>

#include <ctype.h>
#include <grp.h>
#include <pwd.h>
#include <string.h>
#include <syslog.h>

#include "fdm.h"
#include "deliver.h"
#include "fetch.h"
#include "match.h"

struct strb	*parse_tags;
struct macros	 parse_macros;
struct macro	*parse_last;	/* last command-line argument macro */

u_int		 parse_ruleidx;
u_int		 parse_actionidx;

ARRAY_DECL(, struct rule *) parse_rulestack;
struct rule	*parse_rule;

struct files	 parse_filestack;
struct file	*parse_file;

int		 yyparse(void);

int
parse_conf(const char *path, struct strings *macros)
{
	struct macro	*macro;
	FILE		*f;
	u_int		 i;

        if ((f = fopen(path, "r")) == NULL)
                return (-1);

	ARRAY_INIT(&parse_rulestack);
	parse_rule = NULL;

	ARRAY_INIT(&parse_filestack);
	parse_file = xmalloc(sizeof *parse_file);

	parse_file->f = f;
	parse_file->line = 0;
	parse_file->path = path;

	strb_create(&parse_tags);
	default_tags(&parse_tags, NULL);
	add_tag(&parse_tags, "home", "%s", conf.user_home);

	TAILQ_INIT(&parse_macros);
	parse_last = NULL;
	for (i = 0; i < ARRAY_LENGTH(macros); i++) {
		parse_last = extract_macro(ARRAY_ITEM(macros, i));
		TAILQ_INSERT_TAIL(&parse_macros, parse_last, entry);
	}

	parse_file->line++;
        yyparse();

	if (!ARRAY_EMPTY(&parse_rulestack))
		yyerror("missing }");
	ARRAY_FREE(&parse_rulestack);

	ARRAY_FREE(&parse_filestack);
	xfree(parse_file);

	while (!TAILQ_EMPTY(&parse_macros)) {
		macro = TAILQ_FIRST(&parse_macros);
		TAILQ_REMOVE(&parse_macros, macro, entry);

		if (macro->type == MACRO_STRING)
			xfree(macro->value.str);
		xfree(macro);
	}

	strb_destroy(&parse_tags);

        fclose(f);
        return (0);
}

__dead printflike1 void
yyerror(const char *fmt, ...)
{
	va_list	ap;
	char   *s;

	xasprintf(&s,
	    "%s: %s at line %d", parse_file->path, fmt, parse_file->line);

	va_start(ap, fmt);
	log_vwrite(LOG_CRIT, s, ap);
	va_end(ap);

	exit(1);
}
#line 251 "parse.y"
#ifndef YYSTYPE_DEFINED
#define YYSTYPE_DEFINED
typedef union
{
	long long 	 	 number;
        char 			*string;
	int 		 	 flag;
	u_int			 locks;
	struct {
		struct fetch	*fetch;
		void		*data;
	} fetch;
	struct {
		char		*host;
		char		*port;
	} server;
	enum area	 	 area;
	enum exprop		 exprop;
	struct actitem 		*actitem;
	struct actlist 		*actlist;
	struct expr		*expr;
	struct expritem		*expritem;
	struct strings		*strings;
	struct replstrs		*replstrs;
	enum fetch_only		 only;
	struct {
		char		*path;
		enum fetch_only	 only;
	} poponly;
	struct {
		int		 flags;
		char		*str;
	} re;
	gid_t			 localgid;
	enum cmp		 cmp;
	struct rule		*rule;
	struct {
		char		*user;
		int		 user_netrc;
		char		*pass;
		int		 pass_netrc;
	} userpass;
	userfunction		 ufn;
	struct userfunctions    *ufns;
} YYSTYPE;
#endif /* YYSTYPE_DEFINED */
#line 161 "parse.c"
#define TOKACCOUNT 257
#define TOKACCOUNTS 258
#define TOKACTION 259
#define TOKACTIONS 260
#define TOKADDHEADER 261
#define TOKADDTOCACHE 262
#define TOKAGE 263
#define TOKALL 264
#define TOKALLOWMANY 265
#define TOKAND 266
#define TOKANYNAME 267
#define TOKANYSIZE 268
#define TOKANYTYPE 269
#define TOKAPPEND 270
#define TOKATTACHMENT 271
#define TOKBODY 272
#define TOKBYTES 273
#define TOKCACHE 274
#define TOKCASE 275
#define TOKCMDUSER 276
#define TOKCOMPRESS 277
#define TOKCONTINUE 278
#define TOKCOUNT 279
#define TOKDAYS 280
#define TOKDEFUSER 281
#define TOKDELTOOBIG 282
#define TOKDISABLED 283
#define TOKDOMAIN 284
#define TOKDOTLOCK 285
#define TOKDROP 286
#define TOKEQ 287
#define TOKEXEC 288
#define TOKEXPIRE 289
#define TOKFCNTL 290
#define TOKFILEGROUP 291
#define TOKFILEUMASK 292
#define TOKFLOCK 293
#define TOKFOLDER 294
#define TOKFOLDERS 295
#define TOKFROM 296
#define TOKGIGABYTES 297
#define TOKGROUP 298
#define TOKGROUPS 299
#define TOKHEADER 300
#define TOKHEADERS 301
#define TOKHOURS 302
#define TOKIGNOREERRORS 303
#define TOKIMAP 304
#define TOKIMAPS 305
#define TOKIMPLACT 306
#define TOKIN 307
#define TOKINCACHE 308
#define TOKINVALID 309
#define TOKKEEP 310
#define TOKKEY 311
#define TOKKILOBYTES 312
#define TOKLOCKFILE 313
#define TOKLOCKTIMEOUT 314
#define TOKLOCKTYPES 315
#define TOKLOCKWAIT 316
#define TOKLOOKUPORDER 317
#define TOKMAILDIR 318
#define TOKMAILDIRS 319
#define TOKMATCH 320
#define TOKMATCHED 321
#define TOKMAXSIZE 322
#define TOKMBOX 323
#define TOKMBOXES 324
#define TOKMEGABYTES 325
#define TOKMINUTES 326
#define TOKMONTHS 327
#define TOKNE 328
#define TOKNEWONLY 329
#define TOKNNTP 330
#define TOKNNTPS 331
#define TOKNOAPOP 332
#define TOKNOCRAMMD5 333
#define TOKNOCREATE 334
#define TOKNOLOGIN 335
#define TOKNONE 336
#define TOKNORECEIVED 337
#define TOKNOT 338
#define TOKNOTLS1 339
#define TOKNOUIDL 340
#define TOKNOVERIFY 341
#define TOKOLDONLY 342
#define TOKOR 343
#define TOKPARALLELACCOUNTS 344
#define TOKPASS 345
#define TOKPASSWD 346
#define TOKPIPE 347
#define TOKPOP3 348
#define TOKPOP3S 349
#define TOKPORT 350
#define TOKPROXY 351
#define TOKPURGEAFTER 352
#define TOKQUEUEHIGH 353
#define TOKQUEUELOW 354
#define TOKREMOVEFROMCACHE 355
#define TOKREMOVEHEADER 356
#define TOKREMOVEHEADERS 357
#define TOKRETURNS 358
#define TOKREWRITE 359
#define TOKSECONDS 360
#define TOKSERVER 361
#define TOKSET 362
#define TOKSIZE 363
#define TOKSMTP 364
#define TOKSTARTTLS 365
#define TOKSTDIN 366
#define TOKSTDOUT 367
#define TOKSTRING 368
#define TOKSTRIPCHARACTERS 369
#define TOKTAG 370
#define TOKTAGGED 371
#define TOKTIMEOUT 372
#define TOKTO 373
#define TOKTOTALSIZE 374
#define TOKUNMATCHED 375
#define TOKUSER 376
#define TOKUSERS 377
#define TOKVALUE 378
#define TOKVERIFYCERTS 379
#define TOKWEEKS 380
#define TOKWRITE 381
#define TOKYEARS 382
#define NONE 383
#define NUMBER 384
#define STRING 385
#define STRMACRO 386
#define NUMMACRO 387
#define STRCOMMAND 388
#define NUMCOMMAND 389
#define YYERRCODE 256
const short yylhs[] =
	{                                        -1,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   79,
   79,   80,   80,   81,   81,   82,   82,   83,   83,   84,
   84,   85,   85,   86,   86,   56,   56,   57,   57,   52,
   52,   52,   53,   53,   34,   34,   34,   54,   55,   32,
   32,   32,   32,   32,   33,   33,   33,   33,   33,   33,
   33,   33,   36,   36,   78,   76,   76,   76,   76,   76,
   76,   76,   76,   76,   76,   76,   76,   76,   76,   76,
   76,   76,   76,   76,   76,   76,   76,   76,   76,   76,
   76,   76,   76,   74,   74,   40,   40,   60,   60,   61,
   61,   70,   71,   71,   42,   42,   62,   62,   63,   63,
   65,   65,   30,   30,   30,   31,   31,   31,   29,   29,
   59,   59,   44,   44,   44,   45,   45,   13,   13,   15,
   15,   14,   14,   49,   49,   48,   48,   50,   50,   51,
   51,   18,   18,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    2,
    2,   73,   73,   43,   43,   41,   41,   12,   12,    3,
    3,    3,    3,   35,   35,   46,   46,    5,    5,    6,
    6,    4,    4,   16,   16,   17,   17,   10,   10,    9,
    9,    9,    9,    9,    9,    9,    9,    9,    9,    9,
    9,    9,    9,    9,    9,    9,    8,    8,    7,    7,
   47,   47,   47,   47,   77,   75,   66,   66,   58,   58,
   64,   64,   25,   25,   26,   26,   20,   20,   28,   28,
   27,   27,   19,   19,   21,   21,   37,   37,   22,   22,
   23,   23,   24,   24,   69,   69,   69,   69,   68,   67,
   67,   39,   39,   38,   38,   11,   11,   11,   11,   11,
   11,   11,   11,   72,
};
const short yylen[] =
	{                                         2,
    0,    2,    2,    2,    2,    2,    2,    2,    2,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    2,    1,    2,    0,    1,
    1,    1,    1,    3,    1,    1,    1,    1,    1,    1,
    2,    2,    2,    2,    1,    2,    2,    2,    2,    2,
    2,    2,    2,    0,    3,    3,    3,    3,    2,    3,
    2,    2,    2,    3,    3,    3,    3,    3,    3,    3,
    3,    2,    3,    3,    3,    3,    2,    2,    3,    3,
    3,    3,    3,    3,    3,    2,    1,    2,    1,    2,
    1,    1,    2,    1,    2,    4,    2,    4,    2,    4,
    2,    4,    1,    1,    1,    2,    1,    1,    1,    1,
    0,    2,    0,    2,    4,    2,    1,    1,    0,    1,
    0,    1,    0,    2,    2,    3,    2,    0,    2,    0,
    2,    1,    0,    2,    2,    2,    2,    1,    3,    3,
    9,    4,    1,    3,    4,    4,    1,    1,    1,    2,
    1,    4,    6,    2,    4,    2,    4,    0,    1,    0,
    2,    2,    2,    1,    0,    1,    0,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    2,
    3,    2,   10,    3,    4,    5,    5,    2,    2,    4,
    3,    5,    5,    5,    4,    4,    3,    2,    1,    2,
    4,    6,    3,    1,    1,    3,    0,    1,    0,    2,
    2,    4,    1,    0,    1,    0,    1,    0,    1,    0,
    1,    0,    1,    0,    1,    0,    1,    1,    1,    1,
    1,    1,    1,    1,    4,    0,    2,    2,    4,    1,
    0,    3,    0,    1,    0,    9,    6,   10,    6,    1,
    1,    1,    8,    6,
};
const short yydefred[] =
	{                                      1,
    0,    0,    0,    0,    0,    0,    9,    0,    0,  205,
    2,    3,    4,    5,    6,    7,    8,   31,   32,   30,
   33,    0,    0,    0,    0,    0,  118,    0,    0,    0,
   63,    0,    0,   61,    0,    0,   62,    0,    0,    0,
    0,   59,    0,    0,   78,   77,    0,    0,    0,    0,
    0,    0,    0,   72,    0,    0,    0,  122,    0,   12,
   13,    0,    0,    0,   55,  204,    0,  206,  178,  179,
    0,    0,   14,   15,    0,  180,    0,    0,  174,    0,
  188,  175,    0,    0,    0,  189,    0,  182,    0,  117,
    0,    0,    0,   79,   36,   37,   35,   80,  110,  109,
   81,   83,   74,   73,   58,   60,    0,  105,  103,  104,
  108,  107,    0,   92,   94,    0,   56,    0,   70,   71,
   76,   75,   68,   69,    0,   67,    0,   85,   34,    0,
   10,   11,    0,    0,  177,  148,  231,  232,  149,    0,
    0,    0,   24,   25,    0,    0,  143,    0,  176,    0,
  152,    0,    0,    0,  147,  138,    0,    0,    0,    0,
   53,    0,    0,    0,  198,  191,  168,  169,    0,    0,
    0,    0,    0,    0,  116,    0,    0,    0,    0,    0,
    0,  181,    0,    0,   49,   46,   47,   51,   48,   50,
   52,  106,   93,   41,   44,   42,   43,    0,   20,   21,
   22,   23,  233,  234,    0,  230,  250,    0,    0,    0,
    0,  251,  252,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  151,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  159,  203,    0,    0,  197,
  190,    0,    0,    0,  170,  171,    0,  172,  173,    0,
    0,  185,    0,    0,    0,  161,  163,  162,    0,    0,
    0,  120,  254,    0,    0,    0,    0,   97,    0,   99,
    0,    0,  139,    0,  132,  140,    0,    0,    0,    0,
    0,  144,  153,  150,    0,    0,    0,    0,    0,  115,
    0,    0,  201,  194,  192,  193,    0,  186,    0,    0,
  155,    0,    0,    0,    0,    0,   91,    0,    0,    0,
    0,    0,    0,  126,    0,    0,  142,    0,  238,    0,
   18,   19,    0,    0,  157,   96,    0,    0,    0,    0,
  240,    0,  227,  228,    0,    0,  208,    0,    0,   16,
   17,    0,    0,   98,   90,  100,  125,  124,    0,    0,
  223,    0,    0,  202,  164,    0,    0,    0,    0,    0,
  225,    0,  244,    0,    0,  101,    0,    0,  211,  235,
  213,    0,    0,    0,  249,  247,  242,    0,    0,   89,
    0,    0,    0,  215,    0,  166,    0,  239,  221,    0,
    0,  102,   88,    0,  212,  217,    0,  183,    0,    0,
  253,  219,  141,  246,    0,  248,
};
const short yydgoto[] =
	{                                       1,
  225,  226,  182,  247,  169,  249,   28,   71,   29,   72,
  208,  237,   30,   59,  263,  152,  153,  276,  352,  397,
  362,  209,  154,  211,  372,  385,  390,  403,   98,  112,
  113,  117,  106,  107,  356,   65,  335,  364,  336,  288,
  155,  156,   88,   62,   89,  387,   68,  223,  314,  317,
  280,   21,   22,   90,  307,  273,  282,  323,  255,  381,
  308,  212,  213,  342,  337,  338,  330,  331,  287,  115,
  116,   11,   12,   13,   14,   15,   16,   17,  157,   63,
   91,  343,  339,  214,  215,  158,
};
const short yysindex[] =
	{                                      0,
  499, -250, -250, -250, -312, 3804,    0,   -9,   -2,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   -3, -196, -214,   -3, -197,    0,  -54, -248, -175,
    0, -250, -250,    0, -206, -185,    0, -233, -250, -272,
 -242,    0, -290, -272,    0,    0, -272, -250, -282, -272,
 -272, -250, -272,    0, -250, -272, -250,    0, -214,    0,
    0, 3414, -116, -272,    0,    0, -117,    0,    0,    0,
 -248, -312,    0,    0,  -56,    0, -234, -250,    0, -250,
    0,    0,   31, -250, -250,    0, -250,    0, -208,    0,
 -112,   -3,   -3,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, -223,    0,    0,    0,
    0,    0, -129,    0,    0, -290,    0, -227,    0,    0,
    0,    0,    0,    0,   -3,    0,   -3,    0,    0, 3302,
    0,    0, -250, -250,    0,    0,    0,    0,    0, -250,
 -250, -250,    0,    0, -250, -260,    0, -250,    0, 3744,
    0, -250, -250, -260,    0,    0, -108, -100, -250,   -3,
    0, -162, 3129, -312,    0,    0,    0,    0, -272, -250,
   31, -250,  -60,   31,    0, -203, -272,  -14,   -3,  -29,
 -225,    0, -250,   -3,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, -224,    0,    0,
    0,    0,    0,    0, -220,    0,    0, -181, -260, -260,
 -260,    0,    0,  -73,  -59,  -33, -167,   -3,  -38, -160,
   -3, -250, -136,  -40,    0, 3528,   -3,   -3, -318, -250,
   -3, -250,   -3,   16,   -3,    0,    0, 3672, -162,    0,
    0,   -3, -272,   -3,    0,    0, -272,    0,    0, -272,
 -250,    0, -254, -250, -189,    0,    0,    0,   20, -250,
 -250,    0,    0, -318, -318, -318, -250,    0, -250,    0,
 -250,   -3,    0, -250,    0,    0, -250, -179, -250, -186,
 -250,    0,    0,    0, -250, -250, -121,   29,   43,    0,
   -3, 3600,    0,    0,    0,    0,   -3,    0,   -3,  135,
    0, -192, -192, -256, -121, -133,    0,   70,   97,   -3,
   -3,   -3, -170,    0,   -3, -250,    0,   -3,    0, -151,
    0,    0, -149, -250,    0,    0, -162, -272, -250, -121,
    0, -256,    0,    0,  -71, -126,    0, -256,   -5,    0,
    0,  -67,    7,    0,    0,    0,    0,    0,   -3, -250,
    0, -125,   -3,    0,    0,  168, -124, -256, -126, -250,
    0, -149,    0, -149, -250,    0, -250, -250,    0,    0,
    0, -115, -254, -250,    0,    0,    0, -114, -125,    0,
  104, -149,  112,    0, -109,    0,  182,    0,    0, -109,
 -115,    0,    0, -109,    0,    0, -140,    0, -140, -109,
    0,    0,    0,    0, -140,    0,};
const short yyrindex[] =
	{                                      0,
    0,    0,    0,    0, 3459,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    1, 3200, 3445,   80,  236,    0,  -70,  -74,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 3390,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   -4, 3459,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, -111,    0,
    0,  579, 2884,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 2452,    0,    0,    0,
    0,    0, 2921,    0,    0, 2929,    0, 2524,    0,    0,
    0,    0,    0,    0, 2934,    0, 2939,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 3300,
    0, 2961,    0, 3459,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  712, -120,
    0,    0,    0,  716,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, -128,    0,    0,
    0,    0,    0,    0, -127,    0,    0, 2974,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1288, 1360,    0,
 1435,    0, 1064, 1507,    0,    0, 1579, 1651,  422,    0,
 1726,    0, 1798,    0,  203,    0,    0,    0, 2961,    0,
    0,  817,    0, 1018,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 2414,  657, -101,    0,    0,    0,    0,
    0, 1870,    0,    0,    0,    0,    0,  176,    0, 1942,
    0,    0,    0,    0,    0,    0,  536,    0,    0,    0,
  326,    0,    0,    0,    0,    0, 1020,    0, -118,    0,
    0, 2604,    0, 2532,  245,    0,    0,    0,    0, 2017,
 2089, 2161,    0,    0, 1144,    0,    0, 2233,    0,  307,
    0,    0,  764,    0,    0,    0, 2961,  191,    0, 2701,
    0,  335,    0,    0,    0, 2632,    0,  771,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 2308,    0,
    0,  878,  650,    0,    0,    0,    0,  167, 2788,    0,
    0, 2696,    0, 2669,    0,    0,    0,    0,    0,    0,
    0,  950,  200,    0,    0,    0,    0, 2765,  993,    0,
    0,  139,    0,    0, 1216,    0,    0,    0,    0,  570,
 2770,    0,    0, 2819,    0,    0, 2380,    0, 2857,  570,
    0,    0,    0,    0, 2857,    0,};
const short yygindex[] =
	{                                      0,
  -49,    4,    0,    0,  -21,    0,    0,    0,  -53,  173,
    0, -217,    0,    0,    0,  216,    0,    0, -301, -316,
 -110,    0,  117,    0, -131, -141,    0, -361,    0,  138,
    0, -153,  -44,  -19,    0,    0, -283, -106,  -78, -123,
  190,    0,    0,   13, -245,    0,    0,  -89,    0,    0,
    0,  202, 3320, 2990,   67,    0,    0,    0,    0,  -85,
   21,    0,    0,    0,    0,  -39,    0,  -10, -198,  188,
    0,    0,    0,    0,    0,    0,    0,    0,  231,    0,
    0,    0,   23,    0,    0,    0,
};
#define YYTABLESIZE 4183
const short yytable[] =
	{                                     167,
   38,  168,   57,  167,   57,  168,  159,  298,  126,   57,
  183,  160,  151,   57,  230,   99,  102,   69,  165,  161,
   78,  293,  232,  252,  118,   27,  285,  119,   57,  122,
  123,  124,  170,  171,  172,  234,  128,  404,  256,   57,
   67,   38,  108,  406,  173,  194,  257,  109,  199,  267,
  110,   55,  103,  121,  363,  114,  185,  286,   56,  259,
  378,  177,  379,  269,  229,  304,  305,  306,   66,  195,
   26,  130,  333,  399,  363,  258,  104,  401,  186,   39,
  394,   73,   74,  405,  196,  334,   58,   75,   76,  294,
  167,   64,  168,  111,   70,   77,  296,  197,  181,   78,
  222,   95,  187,  188,   96,  105,   97,  251,  289,  354,
  240,   95,   79,  239,   96,  236,   97,  365,  200,  264,
  265,  266,  260,   38,  241,   38,  261,  386,  262,  368,
   18,   19,   80,   20,   18,   19,  189,   20,  224,  174,
  290,  131,  132,  274,  301,   81,  176,  160,  160,  243,
  277,  248,  250,  325,  160,  108,  190,  118,  191,  279,
  109,   60,   61,  110,  340,  341,  245,  326,  300,   94,
  313,   82,  321,  322,  328,  127,  284,   95,   18,   19,
   96,   20,   97,  329,  199,  199,  316,   83,  113,  113,
  101,  351,   84,  350,  344,   85,  236,  236,   95,   86,
  217,   96,  360,   97,   39,  361,  367,  371,  220,   18,
   19,  373,   20,   95,   18,   19,   96,   20,   97,  384,
  374,  346,  398,  118,  402,  389,  245,  295,  392,  396,
  118,  160,  231,  229,  165,   54,  395,  111,  275,  112,
  167,  292,  284,  164,  207,   87,  210,  391,  376,  400,
  192,  375,  166,  359,  200,  200,  162,   38,  129,   38,
   38,   38,   38,  224,  160,  160,   38,  246,   18,   19,
   38,   20,   18,   19,   38,   20,   18,   19,   38,   20,
  268,  270,  383,   38,   18,   19,   38,   20,   38,  309,
  358,  245,  332,  347,   38,   38,   38,  163,   38,   38,
  127,  199,  199,  193,   38,   38,  237,   38,  355,  324,
   38,   18,   19,    0,   20,    0,    0,    0,   38,   38,
   38,   60,   61,   38,   38,   18,   19,   87,   20,   38,
   38,   38,   38,   38,  243,   38,   39,  281,   39,   38,
   38,   38,   38,   38,  271,   38,  254,   38,   38,   38,
   38,   18,   19,   39,   20,   38,   38,   38,  253,   38,
   54,    0,   38,    0,   38,   38,   38,   38,   39,  207,
   38,  200,  200,   38,  345,  345,   38,   38,    0,   18,
   19,   38,   20,   38,    0,   38,   38,   38,   38,   39,
   39,   18,   19,    0,   20,  224,    0,  224,    0,   39,
   18,   19,    0,   20,   18,   19,    0,   20,    0,    0,
    0,   39,  224,   18,   19,    0,   20,    0,   39,   39,
   39,  236,    0,  245,    0,  245,  377,   18,   19,    0,
   20,  237,  127,  382,  127,  127,  127,  127,    0,    0,
  245,   39,    0,    0,   39,  127,    0,    0,  224,  127,
   86,    0,    0,  127,   18,   19,    0,   20,  224,  243,
    0,  127,   39,  127,   39,   39,   39,   39,    0,  127,
  127,  127,    0,  127,  127,    0,  245,  224,    0,  127,
  127,   18,   19,    0,   20,  127,  245,    0,   18,   19,
    0,   20,   54,  127,   54,  127,   18,   19,  127,   20,
  224,  207,    0,  207,  127,    0,    0,  127,  127,   54,
  127,    0,    0,    0,  127,  127,  127,  127,  207,    0,
  127,  224,  127,    0,  224,  224,    0,    0,  245,    0,
  127,  127,  127,    0,  127,  209,    0,  127,    0,  127,
  127,    0,  127,    0,    0,  127,  236,    0,  127,  245,
    0,  127,  245,  245,  207,   54,  127,    0,  127,    0,
    0,  127,  127,  237,  207,  237,  237,  237,  237,  218,
    0,    0,    0,  207,    0,    0,  237,  207,   65,  207,
  237,    0,    0,  207,  237,  207,  207,   87,   87,    0,
   87,  243,  237,  243,  237,    0,    0,   54,    0,    0,
  237,  237,    0,    0,  237,  237,  207,    0,  243,  207,
  237,  237,    0,    0,    0,    0,  237,    0,   54,    0,
    0,   54,   54,   10,  237,    0,  237,  207,    0,  237,
  207,  207,    0,    0,    0,  237,    0,    0,  237,  237,
    0,  237,    0,    0,  243,  237,  237,  237,  237,  210,
    0,    0,    0,  237,  243,    0,  236,    0,    0,    0,
  209,  237,  237,  237,    0,  237,  243,    0,  237,    0,
  237,  237,    0,  237,    0,    0,  237,    0,  236,    0,
  236,  236,  236,  236,    0,    0,    0,  237,    0,  237,
    0,  236,  237,  237,  218,  236,  243,    0,    0,  236,
    0,    0,    0,   65,    0,    0,    0,  236,    0,  236,
   86,   86,    0,   86,    0,  236,  236,  243,    0,    0,
  243,  243,    0,    0,    0,  236,  236,    0,    0,    0,
    0,  236,    0,    0,    0,    0,    0,    0,    0,  236,
    0,  236,    0,    0,  236,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  236,    2,  236,    3,    0,    0,
  236,    0,  236,  224,    0,    0,    0,    0,  236,    0,
  245,    0,    4,    0,  210,    0,  236,  236,  236,    0,
  236,  236,    0,  236,    0,  236,  236,    0,  236,    0,
    0,  236,  209,    0,  209,  209,  209,  209,    0,    0,
    0,    0,  236,    0,  236,  209,    0,  236,  236,  209,
    0,    0,    0,  209,    0,    0,    0,    0,    5,    0,
    0,  209,    0,  209,    0,    0,  218,    0,  218,    0,
    0,    0,    0,    0,  184,   65,    0,   65,  154,  209,
  209,    0,    0,  218,    0,  209,    0,    0,    0,    0,
    0,    0,   65,  209,    0,  209,    0,    0,  209,    0,
    6,    0,    0,    0,    0,    0,    0,    0,  209,    0,
  209,    0,    0,    0,  209,    0,  209,  214,    0,  218,
    0,    7,  209,    0,    8,    9,    0,    0,  224,  218,
  209,  209,  209,    0,  209,  245,    0,  209,   65,  209,
  209,    0,  209,    0,    0,  209,  210,    0,  210,  210,
  210,  210,    0,  236,    0,  236,  209,    0,  209,  210,
    0,  209,  209,  210,    0,    0,    0,  210,    0,    0,
  236,  218,    0,    0,  218,  210,    0,  210,    0,  196,
   65,    0,    0,    0,    0,    0,    0,    0,    0,  216,
  236,  236,  218,  210,  210,  218,  218,    0,    0,  210,
    0,   65,    0,    0,   65,   65,  236,  210,    0,  210,
  184,  184,  210,    0,  154,  154,  236,  184,    0,    0,
    0,  154,  210,    0,  210,  236,    0,    0,  210,  236,
  210,  236,  214,    0,    0,  236,  210,  236,  236,    0,
    0,    0,  214,    0,  210,  210,  210,    0,  210,    0,
    0,  210,    0,  210,  210,    0,  210,    0,  236,  210,
  224,  236,  224,  224,  224,  224,    0,  245,    0,  245,
  210,    0,  210,  224,    0,  210,  210,  224,    0,  236,
    0,  224,  236,  236,  245,    0,    0,    0,    0,  224,
    0,  224,    0,    0,  184,    0,    0,    0,  154,    0,
    0,    0,    0,  130,    0,    0,    0,  224,  224,    0,
    0,    0,    0,  224,  216,  196,  196,    0,    0,    0,
  245,  224,  196,  224,    0,    0,  224,  184,  184,    0,
  245,  154,  154,    0,    0,    0,  224,    0,  224,    0,
    0,    0,  224,  245,    0,  245,    0,    0,    0,  245,
  224,  245,    0,    0,    0,    0,    0,  214,  224,  224,
  224,    0,  224,    0,    0,  224,    0,  224,  224,    0,
  224,    0,  245,  224,  214,  245,  214,  214,  214,  214,
  195,    0,  187,  131,  224,    0,  224,  214,    0,  224,
  224,  214,    0,  245,    0,  214,  245,  245,    0,  196,
    0,    0,    0,  214,    0,  214,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  214,  214,    0,    0,    0,    0,  214,  130,    0,
    0,    0,  196,  196,    0,  214,    0,  214,    0,    0,
  214,    0,    0,    0,    0,    0,  216,    0,  216,  216,
  216,  216,  214,    0,    0,  218,  214,    0,    0,  216,
    0,    0,    0,  216,  214,    0,    0,  216,    0,    0,
    0,    0,  214,  214,  214,  216,  214,  216,    0,  214,
    0,  214,  214,    0,  214,    0,    0,  214,    0,  214,
    0,  214,    0,  216,  216,    0,    0,    0,  214,  216,
  214,    0,    0,  214,  214,    0,  214,  216,  131,  216,
    0,    0,  216,    0,    0,    0,  195,  195,  187,  187,
    0,    0,    0,  195,    0,  187,    0,  137,  216,    0,
    0,    0,    0,    0,    0,    0,  216,    0,    0,    0,
    0,    0,  214,    0,  216,  216,  216,    0,  216,    0,
    0,  216,  214,  216,  216,    0,  216,    0,    0,  216,
  130,    0,  130,  130,  130,  130,    0,  214,    0,    0,
  216,  214,  216,  130,    0,  216,  216,  130,    0,    0,
  218,  130,    0,    0,    0,    0,    0,    0,    0,  130,
    0,  130,    0,    0,  214,    0,    0,  214,    0,  133,
  195,    0,  187,    0,    0,    0,    0,  130,  130,    0,
    0,    0,    0,  130,    0,  214,    0,    0,  214,  214,
    0,  130,    0,  130,    0,    0,  130,    0,    0,    0,
    0,    0,    0,  195,  195,  187,  187,    0,    0,    0,
  131,    0,  131,  131,  131,  131,    0,    0,    0,    0,
  130,    0,  137,  131,    0,    0,    0,  131,  130,  130,
  130,  131,  130,    0,    0,  130,    0,  130,    0,  131,
  130,  131,    0,  130,  135,    0,  130,    0,    0,    0,
    0,    0,    0,    0,  130,    0,  130,  131,  131,  130,
  130,    0,    0,  131,    0,    0,    0,    0,    0,    0,
    0,  131,    0,  131,    0,    0,  131,    0,    0,    0,
    0,    0,  218,    0,  218,  218,  218,  218,    0,    0,
    0,    0,    0,    0,  133,  218,    0,    0,    0,  218,
  131,    0,    0,  218,    0,    0,    0,    0,  131,  131,
  131,  218,  131,  218,    0,  131,   29,  131,    0,    0,
  131,    0,    0,  131,    0,    0,  131,    0,    0,  218,
  218,    0,    0,    0,  131,  218,  131,    0,    0,  131,
  131,    0,    0,  218,    0,  218,    0,    0,  218,    0,
    0,    0,    0,    0,  137,    0,  137,  137,  137,  137,
    0,    0,    0,    0,    0,    0,    0,  137,    0,  135,
    0,  137,  218,    0,    0,  137,    0,    0,    0,    0,
  218,  218,  218,  137,  218,  137,    0,  218,  134,  218,
  218,    0,  218,    0,    0,  218,    0,    0,    0,    0,
    0,  137,  137,    0,    0,    0,  218,  137,  218,    0,
    0,  218,  218,    0,    0,  137,    0,  137,    0,    0,
  137,    0,    0,    0,    0,    0,  133,    0,  133,  133,
  133,  133,    0,    0,    0,    0,    0,    0,    0,  133,
    0,   29,    0,  133,  137,    0,    0,  133,    0,    0,
    0,    0,  137,  137,  137,  133,  137,  133,    0,  137,
  136,  137,    0,    0,  137,    0,    0,  137,    0,    0,
    0,    0,    0,  133,  133,    0,    0,    0,  137,  133,
  137,    0,    0,  137,  137,    0,    0,  133,    0,  133,
    0,    0,  133,    0,    0,    0,    0,    0,    0,    0,
    0,  135,    0,  135,  135,  135,  135,    0,    0,    0,
    0,    0,    0,  134,  135,    0,  133,    0,  135,    0,
    0,    0,  135,    0,  133,  133,  133,    0,  133,    0,
  135,  133,  135,  133,    0,  156,  133,    0,    0,  133,
    0,    0,    0,    0,    0,    0,    0,    0,  135,  135,
  133,    0,  133,    0,  135,  133,  133,    0,    0,    0,
    0,    0,  135,    0,  135,    0,    0,  135,    0,    0,
    0,    0,    0,   29,    0,   29,   29,   29,   29,    0,
    0,    0,    0,    0,    0,  136,   29,    0,    0,    0,
   29,  135,    0,    0,   29,    0,    0,    0,    0,  135,
  135,  135,   29,  135,   29,    0,  135,   95,  135,    0,
    0,  135,    0,    0,  135,    0,    0,    0,    0,    0,
   29,   29,    0,    0,    0,  135,   29,  135,    0,    0,
  135,  135,    0,    0,   29,    0,   29,    0,    0,   29,
    0,    0,    0,    0,    0,  134,    0,  134,  134,  134,
  134,    0,    0,    0,    0,    0,    0,    0,  134,    0,
  156,    0,  134,   29,    0,    0,  134,    0,    0,    0,
    0,   29,   29,   29,  134,   29,  134,    0,   29,   27,
   29,    0,    0,   29,    0,    0,   29,    0,    0,    0,
    0,    0,  134,  134,    0,    0,    0,   29,  134,   29,
    0,    0,   29,   29,    0,    0,  134,    0,  134,    0,
    0,  134,    0,    0,    0,    0,    0,  136,    0,  136,
  136,  136,  136,    0,    0,    0,    0,    0,    0,    0,
  136,    0,   95,    0,  136,  134,    0,    0,  136,    0,
    0,    0,    0,  134,  134,  134,  136,  134,  136,    0,
  134,  128,  134,    0,    0,  134,    0,    0,  134,    0,
    0,    0,    0,    0,  136,  136,    0,    0,    0,  134,
  136,  134,    0,    0,  134,  134,    0,    0,  136,    0,
  136,    0,    0,  136,    0,    0,    0,    0,    0,    0,
    0,    0,  156,    0,  156,  156,  156,  156,    0,    0,
    0,    0,    0,    0,   27,  156,    0,  136,    0,  156,
    0,    0,    0,  156,    0,  136,  136,  136,    0,  136,
    0,  156,  136,  156,  136,    0,   26,  136,    0,    0,
  136,    0,    0,    0,    0,    0,    0,    0,    0,  156,
  156,  136,    0,  136,    0,  156,  136,  136,    0,    0,
    0,    0,    0,  156,    0,  156,    0,    0,  156,    0,
    0,    0,    0,    0,   95,    0,   95,   95,   95,   95,
    0,    0,    0,    0,    0,    0,  128,   95,    0,    0,
    0,   95,  156,    0,    0,   95,    0,    0,    0,    0,
  156,  156,  156,   95,  156,   95,    0,  156,  145,  156,
    0,    0,  156,    0,    0,  156,    0,    0,    0,    0,
    0,   95,   95,    0,    0,    0,  156,   95,  156,    0,
    0,  156,  156,    0,    0,   95,    0,   95,    0,    0,
   95,    0,    0,    0,    0,    0,   27,    0,   27,   27,
   27,   27,    0,    0,    0,    0,    0,    0,    0,   27,
    0,   26,    0,   27,   95,    0,    0,   27,    0,    0,
    0,    0,   95,   95,   95,   27,   95,   27,    0,   95,
  146,   95,    0,    0,   95,    0,    0,   95,    0,    0,
    0,    0,    0,   27,   27,    0,    0,    0,   95,   27,
   95,    0,    0,   95,   95,    0,    0,   27,    0,   27,
    0,    0,   27,    0,    0,    0,    0,    0,  128,    0,
  128,  128,  128,  128,    0,    0,    0,    0,    0,    0,
    0,  128,    0,  145,    0,  128,   27,    0,    0,  128,
    0,    0,    0,    0,   27,   27,   27,  128,   27,  128,
    0,   27,   28,   27,    0,    0,   27,    0,    0,   27,
    0,    0,    0,    0,    0,  128,  128,    0,    0,    0,
   27,  128,   27,    0,    0,   27,   27,    0,    0,  128,
    0,  128,    0,    0,  128,    0,    0,    0,    0,    0,
    0,    0,    0,   26,    0,   26,   26,   26,   26,    0,
    0,    0,    0,    0,    0,  146,   26,    0,  128,    0,
   26,    0,    0,    0,   26,    0,  128,  128,  128,    0,
  128,    0,   26,  128,   26,  128,    0,  129,  128,    0,
    0,  128,    0,    0,    0,    0,    0,    0,    0,    0,
   26,   26,  128,    0,  128,    0,   26,  128,  128,    0,
    0,    0,    0,    0,   26,    0,   26,    0,    0,   26,
    0,    0,    0,    0,    0,  145,    0,  145,  145,  145,
  145,    0,    0,    0,    0,    0,    0,   28,  145,    0,
    0,    0,  145,   26,    0,    0,  145,    0,    0,    0,
    0,   26,   26,   26,  145,   26,  145,    0,   26,  220,
   26,    0,    0,   26,    0,    0,   26,    0,    0,    0,
    0,    0,  145,  145,    0,    0,    0,   26,  145,   26,
    0,    0,   26,   26,    0,    0,  145,    0,  145,    0,
    0,  145,    0,  236,    0,    0,    0,  146,    0,  146,
  146,  146,  146,    0,    0,    0,    0,    0,    0,    0,
  146,    0,  129,    0,  146,  145,    0,    0,  146,    0,
    0,    0,    0,  145,  145,  145,  146,  145,  146,    0,
  145,   45,  145,    0,    0,  145,    0,    0,  145,    0,
    0,    0,    0,    0,  146,  146,    0,    0,    0,  145,
  146,  145,    0,    0,  145,  145,    0,    0,  146,    0,
  146,    0,    0,  146,    0,    0,    0,    0,    0,   28,
    0,   28,   28,   28,   28,    0,    0,    0,    0,    0,
    0,    0,   28,    0,  220,    0,   28,  146,    0,    0,
   28,    0,    0,    0,    0,  146,  146,  146,   28,  146,
   28,    0,  146,   40,  146,    0,    0,  146,    0,    0,
  146,  243,    0,    0,    0,    0,   28,   28,  236,    0,
    0,  146,   28,  146,    0,    0,  146,  146,    0,    0,
   28,    0,   28,    0,    0,   28,    0,    0,    0,    0,
    0,    0,    0,    0,  129,    0,  129,  129,  129,  129,
    0,    0,    0,    0,   45,    0,   45,  129,    0,   28,
    0,  129,    0,    0,    0,  129,    0,   28,   28,   28,
    0,   28,    0,  129,   28,  129,   28,    0,    0,   28,
    0,    0,   28,  241,    0,    0,    0,    0,    0,    0,
    0,  129,  129,   28,    0,   28,    0,  129,   28,   28,
    0,    0,    0,    0,    0,  129,    0,  129,    0,    0,
  129,  226,    0,    0,    0,    0,  220,    0,  220,  220,
  220,  220,    0,    0,    0,    0,   40,    0,   40,  220,
    0,    0,    0,  220,  129,    0,  243,  220,    0,    0,
    0,    0,  129,  129,  129,  220,  129,  220,  224,  129,
  236,  129,  236,    0,  129,    0,    0,  129,    0,    0,
    0,    0,    0,  220,  220,    0,    0,  236,  129,  220,
  129,    0,    0,  129,  129,  224,    0,  220,    0,  220,
  207,    0,  220,    0,    0,    0,    0,    0,   45,    0,
   45,   45,    0,    0,    0,    0,    0,   45,    0,    0,
    0,    0,    0,  236,    0,   45,  220,    0,  241,    0,
    0,    0,    0,  236,  220,  220,  220,    0,  220,    0,
    0,  220,  236,  220,    0,  236,  220,    0,    0,  220,
    0,    0,  236,  236,  236,  236,  226,    0,    0,    0,
  220,    0,  220,    0,  222,  220,  220,    0,    0,  216,
    0,   45,    0,    0,    0,  236,    0,    0,  236,    0,
   40,    0,   40,   40,    0,    0,    0,  226,  243,   40,
  243,    0,    0,  224,   45,    0,  236,   40,    0,  236,
  236,    0,    0,    0,    0,  243,    0,    0,    0,    0,
    0,    0,    0,   45,    0,    0,    0,    0,  218,    0,
  224,    0,    0,    0,    0,  207,    0,   45,   45,    0,
    0,    0,    0,    0,   45,    0,    0,   45,   45,    0,
    0,  243,    0,   40,    0,    0,    0,    0,    0,    0,
    0,  243,    0,    0,    0,    0,  220,    0,    0,    0,
  241,    0,  241,  243,    0,    0,   40,    0,    0,    0,
  243,  243,  243,    0,    0,    0,    0,  241,    0,    0,
    0,    0,    0,   64,    0,   40,    0,    0,  226,  222,
  226,    0,    0,  243,  216,    0,  243,  241,  241,   40,
   40,    0,    0,    0,    0,  226,   40,    0,    0,   40,
   40,    0,  226,  241,  243,    0,    0,  243,  243,    0,
   57,    0,    0,  241,    0,  224,    0,  224,   82,    0,
    0,    0,  241,   66,    0,    0,    0,    0,   84,    0,
    0,  226,  224,  218,    0,  241,    0,    0,    0,    0,
    0,  226,  224,    0,  224,    0,    0,  207,    0,  207,
  158,    0,    0,    0,    0,  241,    0,    0,    0,  224,
  226,  226,  226,  121,  207,    0,    0,    0,  224,    0,
    0,  220,    0,    0,    0,    0,  241,    0,  224,  241,
  241,   23,   24,  226,    0,    0,  226,    0,    0,    0,
    0,  224,    0,  224,    0,  224,    0,  224,   64,    0,
  207,    0,    0,    0,  226,  224,    0,  226,  226,    0,
  207,  222,    0,  222,  100,    0,  216,    0,  216,  207,
  224,    0,    0,  224,  224,  224,    0,  120,  222,    0,
    0,    0,  207,  216,  226,   57,  226,    0,    0,    0,
    0,  224,    0,   82,  224,  224,    0,  224,   66,    0,
  224,  226,  207,   84,    0,    0,    0,  175,    0,    0,
    0,    0,    0,    0,  222,  218,    0,  218,  224,  216,
    0,  224,  224,  207,  222,  158,  207,  207,    0,  216,
    0,    0,  218,    0,    0,    0,    0,  226,  121,    0,
    0,    0,    0,  222,    0,    0,    0,  226,  216,    0,
    0,    0,    0,  220,    0,  220,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  222,    0,  218,  222,
  220,  216,    0,    0,  216,    0,    0,    0,  218,    0,
   64,    0,   64,    0,    0,    0,    0,  222,    0,  226,
  222,  222,  216,    0,    0,  216,  216,   64,    0,    0,
    0,    0,    0,    0,    0,    0,  220,    0,    0,    0,
  226,    0,    0,  226,  226,    0,  220,   57,    0,   57,
  218,    0,    0,    0,    0,   82,    0,   82,    0,    0,
   66,    0,   66,    0,   57,   84,    0,   84,    0,    0,
    0,  218,   82,   64,  218,  218,    0,   66,    0,    0,
    0,  278,   84,    0,    0,    0,    0,  158,  220,  158,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  121,    0,  121,    0,  158,    0,    0,    0,    0,  220,
   57,    0,  220,  220,    0,   64,    0,  121,   82,  302,
  303,  238,    0,   66,    0,    0,    0,    0,   84,    0,
    0,    0,    0,    0,    0,    0,   64,    0,    0,   64,
   64,    0,    0,    0,  319,  320,    0,    0,    0,    0,
  158,    0,   57,    0,    0,    0,    0,    0,    0,    0,
   82,    0,    0,  121,    0,   66,    0,    0,    0,    0,
   84,    0,  348,   57,    0,    0,   57,   57,    0,    0,
    0,   82,    0,    0,   82,   82,   66,    0,  357,   66,
   66,   84,  158,   25,   84,   84,    0,    0,  366,    0,
    0,    0,  369,    0,    0,  121,    0,    0,    0,  370,
    0,    0,    0,  158,    0,    0,  158,  158,    0,    0,
    0,   92,   93,    0,  380,    0,  121,  380,   25,  121,
  121,    0,    0,  388,    0,    0,    0,    0,    0,    0,
  393,  125,  393,    0,  127,    0,    0,    0,    0,    0,
    0,    0,  160,    0,    0,    0,    0,  131,  132,  133,
  134,    0,    0,    0,    0,    0,    0,    0,  135,   25,
    0,    0,    0,  178,  179,    0,  180,    0,    0,    0,
  184,    0,    0,    0,  136,    0,   79,    0,    0,    0,
    0,    0,  114,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  137,  138,    0,    0,    0,    0,  139,    0,
    0,    0,    0,    0,    0,    0,  140,    0,    0,    0,
    0,  141,  216,   25,    0,    0,    0,    0,    0,  218,
  219,   25,    0,    0,  221,    0,    0,  224,    0,    0,
    0,  227,  228,    0,    0,   82,  231,  233,  235,    0,
    0,    0,  231,  142,  143,  144,    0,  145,    0,  242,
    0,  244,  146,    0,    0,  147,    0,    0,  148,    0,
    0,    0,  235,  123,  123,    0,    0,    0,    0,  149,
    0,    0,    0,   18,   19,    0,   20,  123,  123,    0,
    0,    0,  123,  123,    0,    0,    0,    0,    0,  123,
  123,    0,    0,   25,   25,  272,  150,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  123,  123,  235,
    0,  235,    0,  291,    0,    0,    0,  235,  114,  114,
  114,  114,    0,    0,    0,  123,    0,  113,    0,  114,
  297,    0,    0,  299,    0,  123,  123,    0,  291,    0,
    0,    0,    0,    0,    0,  114,   25,  114,   25,    0,
  310,    0,    0,  311,    0,    0,  312,    0,  315,    0,
  318,    0,    0,  114,  114,  198,  138,  291,  291,  114,
    0,    0,    0,    0,    0,    0,    0,  114,  114,  199,
  200,    0,  114,  114,  201,  202,    0,   25,   25,  114,
  114,  203,  204,    0,    0,  349,    0,    0,    0,    0,
    0,    0,    0,  353,    0,    0,  114,  114,  114,  205,
  206,    0,  283,    0,  114,  114,  114,    0,  114,    0,
    0,    0,    0,  114,    0,  114,  114,  207,    0,  114,
    0,    0,  131,  132,  133,  134,    0,    0,    0,   25,
  114,    0,    0,  135,    0,    0,   25,    0,    0,    0,
    0,    0,    0,  113,  113,    0,    0,    0,    0,  136,
    0,   79,    0,  113,  113,  113,  113,  113,  113,    0,
    0,    0,  113,  113,  113,  119,  119,  137,  138,  113,
  113,  119,  119,  139,  327,    0,    0,    0,    0,  119,
  113,  140,  113,  119,    0,    0,  141,  113,  113,    0,
    0,    0,    0,    0,    0,    0,  119,    0,  113,  113,
    0,    0,    0,    0,  113,  113,    0,    0,    0,    0,
   82,    0,  113,    0,    0,    0,  119,  113,  142,  143,
  144,    0,  145,    0,    0,    0,    0,  146,    0,  119,
  147,    0,    0,  148,    0,    0,  131,  132,  133,  134,
    0,  113,    0,    0,  149,    0,    0,  135,    0,  113,
  113,  113,    0,  113,    0,  119,    0,    0,  113,    0,
    0,  113,    0,  136,  113,   79,    0,    0,    0,    0,
    0,  119,    0,    0,    0,  113,  119,    0,    0,  119,
    0,  137,  138,  119,    0,    0,    0,  139,    0,    0,
    0,    0,    0,  119,  119,  140,  119,    0,    0,    0,
  141,    0,    0,    0,    0,    0,    0,    0,  131,  132,
  133,  134,    0,    0,    0,    0,    0,    0,    0,  135,
    0,    0,    0,    0,   82,    0,    0,    0,    0,    0,
    0,    0,  142,  143,  144,  136,  145,   79,    0,    0,
    0,  146,    0,    0,  147,    0,    0,  148,    0,    0,
    0,    0,    0,  137,  138,    0,    0,    0,  149,  139,
    0,    0,    0,    0,    0,    0,    0,  140,    0,    0,
    0,    0,  141,    0,    0,    0,    0,    0,    0,    0,
  131,  132,  133,  134,    0,    0,    0,    0,    0,    0,
    0,  135,    0,    0,    0,    0,   82,    0,    0,    0,
    0,    0,    0,    0,  142,  143,  144,  136,  145,   79,
    0,    0,    0,  146,    0,    0,  147,    0,    0,  148,
    0,    0,    0,    0,    0,  137,  138,    0,    0,    0,
  149,  139,    0,    0,    0,    0,    0,    0,    0,  140,
    0,    0,    0,    0,  141,    0,    0,    0,    0,    0,
    0,    0,  131,  132,  133,  134,    0,    0,    0,    0,
    0,    0,    0,  135,    0,    0,    0,    0,   82,    0,
    0,    0,    0,    0,    0,    0,  142,  143,  144,  136,
  145,   79,    0,    0,    0,  146,    0,    0,  147,    0,
    0,  148,    0,    0,    0,    0,    0,  137,  138,    0,
    0,    0,  149,  139,    0,    0,   18,   19,    0,   20,
    0,  140,    0,    0,    0,    0,  141,    0,   31,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   32,
    0,    0,    0,    0,   33,   34,    0,    0,    0,    0,
   82,    0,    0,    0,   35,   36,    0,    0,  142,  143,
  144,    0,  145,    0,    0,    0,   37,  146,    0,   38,
  147,    0,    0,  148,    0,    0,   39,   40,   41,   42,
   43,    0,    0,    0,  149,   44,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   45,    0,    0,
   46,    0,    0,    0,    0,    0,    0,   47,    0,    0,
    0,    0,    0,    0,   48,   49,   50,   51,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   52,    0,    0,   53,    0,    0,    0,    0,
    0,    0,   54,
};
const short yycheck[] =
	{                                      60,
    0,   62,   43,   60,   43,   62,  123,  253,   53,   43,
  123,  123,   62,   43,  123,   35,   36,  266,   72,   64,
  275,  239,  123,  177,   44,  338,  345,   47,   43,   49,
   50,   51,  267,  268,  269,  159,   56,  399,  264,   43,
   28,   41,  285,  405,  279,  273,  272,  290,  123,  123,
  293,   61,  286,  336,  338,  346,  280,  376,   61,  183,
  362,   83,  364,  123,  154,  264,  265,  266,  123,  297,
    4,   59,  329,  390,  358,  301,  310,  394,  302,    0,
  382,  257,  258,  400,  312,  342,  283,  263,  264,  243,
   60,  289,   62,  336,  343,  271,  250,  325,  307,  275,
  361,  384,  326,  327,  387,   39,  389,  311,  232,  327,
  164,  384,  288,  163,  387,  278,  389,  123,  123,  209,
  210,  211,  347,  123,  169,  125,  347,  373,  310,  123,
  385,  386,  308,  388,  385,  386,  360,  388,    0,  374,
  125,  259,  260,  311,  125,  321,   80,  259,  260,  171,
  311,  173,  174,  125,  266,  285,  380,  177,  382,  296,
  290,  376,  377,  293,  298,  299,    0,  125,  358,  376,
  350,  347,  294,  295,   40,    0,  226,  384,  385,  386,
  387,  388,  389,  376,  259,  260,  373,  363,  259,  260,
  376,  341,  368,  345,  125,  371,  298,  299,  384,  375,
  134,  387,  274,  389,  125,  332,  274,  333,  142,  385,
  386,   44,  388,  384,  385,  386,  387,  388,  389,  335,
  345,  125,   41,  243,  365,  340,  287,  247,  125,  339,
  250,  343,  361,  361,   44,    0,  125,  358,  277,  358,
   41,  238,  292,   71,    0,   30,  130,  379,  359,  391,
  113,  358,  309,  332,  259,  260,   67,  257,   57,  259,
  260,  261,  262,  125,  376,  377,  266,  328,  385,  386,
  270,  388,  385,  386,  274,  388,  385,  386,  278,  388,
  214,  215,  368,  283,  385,  386,  286,  388,  288,  269,
  330,  125,  303,  313,  294,  295,  296,   67,  298,  299,
  125,  376,  377,  116,  304,  305,    0,  307,  328,  287,
  310,  385,  386,   -1,  388,   -1,   -1,   -1,  318,  319,
  320,  376,  377,  323,  324,  385,  386,  125,  388,  329,
  330,  331,  332,  333,    0,  335,  257,  378,  259,  339,
  340,  341,  342,  343,  378,  345,  376,  347,  348,  349,
  350,  385,  386,  274,  388,  355,  356,  357,  373,  359,
  125,   -1,  362,   -1,  364,  365,  366,  367,  289,  125,
  370,  376,  377,  373,  308,  309,  376,  377,   -1,  385,
  386,  381,  388,  383,   -1,  385,  386,  387,  388,  310,
  311,  385,  386,   -1,  388,  257,   -1,  259,   -1,  320,
  385,  386,   -1,  388,  385,  386,   -1,  388,   -1,   -1,
   -1,  332,  274,  385,  386,   -1,  388,   -1,  339,  340,
  341,    0,   -1,  257,   -1,  259,  360,  385,  386,   -1,
  388,  125,  257,  367,  259,  260,  261,  262,   -1,   -1,
  274,  362,   -1,   -1,  365,  270,   -1,   -1,  310,  274,
  125,   -1,   -1,  278,  385,  386,   -1,  388,  320,  125,
   -1,  286,  383,  288,  385,  386,  387,  388,   -1,  294,
  295,  296,   -1,  298,  299,   -1,  310,  339,   -1,  304,
  305,  385,  386,   -1,  388,  310,  320,   -1,  385,  386,
   -1,  388,  257,  318,  259,  320,  385,  386,  323,  388,
  362,  257,   -1,  259,  329,   -1,   -1,  332,  333,  274,
  335,   -1,   -1,   -1,  339,  340,  341,  342,  274,   -1,
  345,  383,  347,   -1,  386,  387,   -1,   -1,  362,   -1,
  355,  356,  357,   -1,  359,    0,   -1,  362,   -1,  364,
  365,   -1,  367,   -1,   -1,  370,  125,   -1,  373,  383,
   -1,  376,  386,  387,  310,  320,  381,   -1,  383,   -1,
   -1,  386,  387,  257,  320,  259,  260,  261,  262,    0,
   -1,   -1,   -1,  329,   -1,   -1,  270,  333,    0,  335,
  274,   -1,   -1,  339,  278,  341,  342,  385,  386,   -1,
  388,  257,  286,  259,  288,   -1,   -1,  362,   -1,   -1,
  294,  295,   -1,   -1,  298,  299,  362,   -1,  274,  365,
  304,  305,   -1,   -1,   -1,   -1,  310,   -1,  383,   -1,
   -1,  386,  387,  125,  318,   -1,  320,  383,   -1,  323,
  386,  387,   -1,   -1,   -1,  329,   -1,   -1,  332,  333,
   -1,  335,   -1,   -1,  310,  339,  340,  341,  342,    0,
   -1,   -1,   -1,  347,  320,   -1,    0,   -1,   -1,   -1,
  125,  355,  356,  357,   -1,  359,  332,   -1,  362,   -1,
  364,  365,   -1,  367,   -1,   -1,  370,   -1,  257,   -1,
  259,  260,  261,  262,   -1,   -1,   -1,  381,   -1,  383,
   -1,  270,  386,  387,  125,  274,  362,   -1,   -1,  278,
   -1,   -1,   -1,  125,   -1,   -1,   -1,  286,   -1,  288,
  385,  386,   -1,  388,   -1,  294,  295,  383,   -1,   -1,
  386,  387,   -1,   -1,   -1,  304,  305,   -1,   -1,   -1,
   -1,  310,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,
   -1,  320,   -1,   -1,  323,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  333,  257,  335,  259,   -1,   -1,
  339,   -1,  341,    0,   -1,   -1,   -1,   -1,  347,   -1,
    0,   -1,  274,   -1,  125,   -1,  355,  356,  357,   -1,
  359,  125,   -1,  362,   -1,  364,  365,   -1,  367,   -1,
   -1,  370,  257,   -1,  259,  260,  261,  262,   -1,   -1,
   -1,   -1,  381,   -1,  383,  270,   -1,  386,  387,  274,
   -1,   -1,   -1,  278,   -1,   -1,   -1,   -1,  320,   -1,
   -1,  286,   -1,  288,   -1,   -1,  257,   -1,  259,   -1,
   -1,   -1,   -1,   -1,  123,  257,   -1,  259,  123,  304,
  305,   -1,   -1,  274,   -1,  310,   -1,   -1,   -1,   -1,
   -1,   -1,  274,  318,   -1,  320,   -1,   -1,  323,   -1,
  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,
  335,   -1,   -1,   -1,  339,   -1,  341,    0,   -1,  310,
   -1,  383,  347,   -1,  386,  387,   -1,   -1,  125,  320,
  355,  356,  357,   -1,  359,  125,   -1,  362,  320,  364,
  365,   -1,  367,   -1,   -1,  370,  257,   -1,  259,  260,
  261,  262,   -1,  257,   -1,  259,  381,   -1,  383,  270,
   -1,  386,  387,  274,   -1,   -1,   -1,  278,   -1,   -1,
  274,  362,   -1,   -1,  365,  286,   -1,  288,   -1,  123,
  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,
  294,  295,  383,  304,  305,  386,  387,   -1,   -1,  310,
   -1,  383,   -1,   -1,  386,  387,  310,  318,   -1,  320,
  259,  260,  323,   -1,  259,  260,  320,  266,   -1,   -1,
   -1,  266,  333,   -1,  335,  329,   -1,   -1,  339,  333,
  341,  335,    0,   -1,   -1,  339,  347,  341,  342,   -1,
   -1,   -1,  125,   -1,  355,  356,  357,   -1,  359,   -1,
   -1,  362,   -1,  364,  365,   -1,  367,   -1,  362,  370,
  257,  365,  259,  260,  261,  262,   -1,  257,   -1,  259,
  381,   -1,  383,  270,   -1,  386,  387,  274,   -1,  383,
   -1,  278,  386,  387,  274,   -1,   -1,   -1,   -1,  286,
   -1,  288,   -1,   -1,  343,   -1,   -1,   -1,  343,   -1,
   -1,   -1,   -1,    0,   -1,   -1,   -1,  304,  305,   -1,
   -1,   -1,   -1,  310,  125,  259,  260,   -1,   -1,   -1,
  310,  318,  266,  320,   -1,   -1,  323,  376,  377,   -1,
  320,  376,  377,   -1,   -1,   -1,  333,   -1,  335,   -1,
   -1,   -1,  339,  333,   -1,  335,   -1,   -1,   -1,  339,
  347,  341,   -1,   -1,   -1,   -1,   -1,  125,  355,  356,
  357,   -1,  359,   -1,   -1,  362,   -1,  364,  365,   -1,
  367,   -1,  362,  370,  257,  365,  259,  260,  261,  262,
  123,   -1,  123,    0,  381,   -1,  383,  270,   -1,  386,
  387,  274,   -1,  383,   -1,  278,  386,  387,   -1,  343,
   -1,   -1,   -1,  286,   -1,  288,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  304,  305,   -1,   -1,   -1,   -1,  310,  125,   -1,
   -1,   -1,  376,  377,   -1,  318,   -1,  320,   -1,   -1,
  323,   -1,   -1,   -1,   -1,   -1,  257,   -1,  259,  260,
  261,  262,  335,   -1,   -1,    0,  339,   -1,   -1,  270,
   -1,   -1,   -1,  274,  347,   -1,   -1,  278,   -1,   -1,
   -1,   -1,  355,  356,  357,  286,  359,  288,   -1,  362,
   -1,  364,  365,   -1,  367,   -1,   -1,  370,   -1,  257,
   -1,  259,   -1,  304,  305,   -1,   -1,   -1,  381,  310,
  383,   -1,   -1,  386,  387,   -1,  274,  318,  125,  320,
   -1,   -1,  323,   -1,   -1,   -1,  259,  260,  259,  260,
   -1,   -1,   -1,  266,   -1,  266,   -1,    0,  339,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  347,   -1,   -1,   -1,
   -1,   -1,  310,   -1,  355,  356,  357,   -1,  359,   -1,
   -1,  362,  320,  364,  365,   -1,  367,   -1,   -1,  370,
  257,   -1,  259,  260,  261,  262,   -1,  335,   -1,   -1,
  381,  339,  383,  270,   -1,  386,  387,  274,   -1,   -1,
  125,  278,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  286,
   -1,  288,   -1,   -1,  362,   -1,   -1,  365,   -1,    0,
  343,   -1,  343,   -1,   -1,   -1,   -1,  304,  305,   -1,
   -1,   -1,   -1,  310,   -1,  383,   -1,   -1,  386,  387,
   -1,  318,   -1,  320,   -1,   -1,  323,   -1,   -1,   -1,
   -1,   -1,   -1,  376,  377,  376,  377,   -1,   -1,   -1,
  257,   -1,  259,  260,  261,  262,   -1,   -1,   -1,   -1,
  347,   -1,  125,  270,   -1,   -1,   -1,  274,  355,  356,
  357,  278,  359,   -1,   -1,  362,   -1,  364,   -1,  286,
  367,  288,   -1,  370,    0,   -1,  373,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  381,   -1,  383,  304,  305,  386,
  387,   -1,   -1,  310,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  318,   -1,  320,   -1,   -1,  323,   -1,   -1,   -1,
   -1,   -1,  257,   -1,  259,  260,  261,  262,   -1,   -1,
   -1,   -1,   -1,   -1,  125,  270,   -1,   -1,   -1,  274,
  347,   -1,   -1,  278,   -1,   -1,   -1,   -1,  355,  356,
  357,  286,  359,  288,   -1,  362,    0,  364,   -1,   -1,
  367,   -1,   -1,  370,   -1,   -1,  373,   -1,   -1,  304,
  305,   -1,   -1,   -1,  381,  310,  383,   -1,   -1,  386,
  387,   -1,   -1,  318,   -1,  320,   -1,   -1,  323,   -1,
   -1,   -1,   -1,   -1,  257,   -1,  259,  260,  261,  262,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  270,   -1,  125,
   -1,  274,  347,   -1,   -1,  278,   -1,   -1,   -1,   -1,
  355,  356,  357,  286,  359,  288,   -1,  362,    0,  364,
  365,   -1,  367,   -1,   -1,  370,   -1,   -1,   -1,   -1,
   -1,  304,  305,   -1,   -1,   -1,  381,  310,  383,   -1,
   -1,  386,  387,   -1,   -1,  318,   -1,  320,   -1,   -1,
  323,   -1,   -1,   -1,   -1,   -1,  257,   -1,  259,  260,
  261,  262,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  270,
   -1,  125,   -1,  274,  347,   -1,   -1,  278,   -1,   -1,
   -1,   -1,  355,  356,  357,  286,  359,  288,   -1,  362,
    0,  364,   -1,   -1,  367,   -1,   -1,  370,   -1,   -1,
   -1,   -1,   -1,  304,  305,   -1,   -1,   -1,  381,  310,
  383,   -1,   -1,  386,  387,   -1,   -1,  318,   -1,  320,
   -1,   -1,  323,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  257,   -1,  259,  260,  261,  262,   -1,   -1,   -1,
   -1,   -1,   -1,  125,  270,   -1,  347,   -1,  274,   -1,
   -1,   -1,  278,   -1,  355,  356,  357,   -1,  359,   -1,
  286,  362,  288,  364,   -1,    0,  367,   -1,   -1,  370,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  304,  305,
  381,   -1,  383,   -1,  310,  386,  387,   -1,   -1,   -1,
   -1,   -1,  318,   -1,  320,   -1,   -1,  323,   -1,   -1,
   -1,   -1,   -1,  257,   -1,  259,  260,  261,  262,   -1,
   -1,   -1,   -1,   -1,   -1,  125,  270,   -1,   -1,   -1,
  274,  347,   -1,   -1,  278,   -1,   -1,   -1,   -1,  355,
  356,  357,  286,  359,  288,   -1,  362,    0,  364,   -1,
   -1,  367,   -1,   -1,  370,   -1,   -1,   -1,   -1,   -1,
  304,  305,   -1,   -1,   -1,  381,  310,  383,   -1,   -1,
  386,  387,   -1,   -1,  318,   -1,  320,   -1,   -1,  323,
   -1,   -1,   -1,   -1,   -1,  257,   -1,  259,  260,  261,
  262,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  270,   -1,
  125,   -1,  274,  347,   -1,   -1,  278,   -1,   -1,   -1,
   -1,  355,  356,  357,  286,  359,  288,   -1,  362,    0,
  364,   -1,   -1,  367,   -1,   -1,  370,   -1,   -1,   -1,
   -1,   -1,  304,  305,   -1,   -1,   -1,  381,  310,  383,
   -1,   -1,  386,  387,   -1,   -1,  318,   -1,  320,   -1,
   -1,  323,   -1,   -1,   -1,   -1,   -1,  257,   -1,  259,
  260,  261,  262,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  270,   -1,  125,   -1,  274,  347,   -1,   -1,  278,   -1,
   -1,   -1,   -1,  355,  356,  357,  286,  359,  288,   -1,
  362,    0,  364,   -1,   -1,  367,   -1,   -1,  370,   -1,
   -1,   -1,   -1,   -1,  304,  305,   -1,   -1,   -1,  381,
  310,  383,   -1,   -1,  386,  387,   -1,   -1,  318,   -1,
  320,   -1,   -1,  323,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  257,   -1,  259,  260,  261,  262,   -1,   -1,
   -1,   -1,   -1,   -1,  125,  270,   -1,  347,   -1,  274,
   -1,   -1,   -1,  278,   -1,  355,  356,  357,   -1,  359,
   -1,  286,  362,  288,  364,   -1,    0,  367,   -1,   -1,
  370,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  304,
  305,  381,   -1,  383,   -1,  310,  386,  387,   -1,   -1,
   -1,   -1,   -1,  318,   -1,  320,   -1,   -1,  323,   -1,
   -1,   -1,   -1,   -1,  257,   -1,  259,  260,  261,  262,
   -1,   -1,   -1,   -1,   -1,   -1,  125,  270,   -1,   -1,
   -1,  274,  347,   -1,   -1,  278,   -1,   -1,   -1,   -1,
  355,  356,  357,  286,  359,  288,   -1,  362,    0,  364,
   -1,   -1,  367,   -1,   -1,  370,   -1,   -1,   -1,   -1,
   -1,  304,  305,   -1,   -1,   -1,  381,  310,  383,   -1,
   -1,  386,  387,   -1,   -1,  318,   -1,  320,   -1,   -1,
  323,   -1,   -1,   -1,   -1,   -1,  257,   -1,  259,  260,
  261,  262,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  270,
   -1,  125,   -1,  274,  347,   -1,   -1,  278,   -1,   -1,
   -1,   -1,  355,  356,  357,  286,  359,  288,   -1,  362,
    0,  364,   -1,   -1,  367,   -1,   -1,  370,   -1,   -1,
   -1,   -1,   -1,  304,  305,   -1,   -1,   -1,  381,  310,
  383,   -1,   -1,  386,  387,   -1,   -1,  318,   -1,  320,
   -1,   -1,  323,   -1,   -1,   -1,   -1,   -1,  257,   -1,
  259,  260,  261,  262,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  270,   -1,  125,   -1,  274,  347,   -1,   -1,  278,
   -1,   -1,   -1,   -1,  355,  356,  357,  286,  359,  288,
   -1,  362,    0,  364,   -1,   -1,  367,   -1,   -1,  370,
   -1,   -1,   -1,   -1,   -1,  304,  305,   -1,   -1,   -1,
  381,  310,  383,   -1,   -1,  386,  387,   -1,   -1,  318,
   -1,  320,   -1,   -1,  323,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  257,   -1,  259,  260,  261,  262,   -1,
   -1,   -1,   -1,   -1,   -1,  125,  270,   -1,  347,   -1,
  274,   -1,   -1,   -1,  278,   -1,  355,  356,  357,   -1,
  359,   -1,  286,  362,  288,  364,   -1,    0,  367,   -1,
   -1,  370,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  304,  305,  381,   -1,  383,   -1,  310,  386,  387,   -1,
   -1,   -1,   -1,   -1,  318,   -1,  320,   -1,   -1,  323,
   -1,   -1,   -1,   -1,   -1,  257,   -1,  259,  260,  261,
  262,   -1,   -1,   -1,   -1,   -1,   -1,  125,  270,   -1,
   -1,   -1,  274,  347,   -1,   -1,  278,   -1,   -1,   -1,
   -1,  355,  356,  357,  286,  359,  288,   -1,  362,    0,
  364,   -1,   -1,  367,   -1,   -1,  370,   -1,   -1,   -1,
   -1,   -1,  304,  305,   -1,   -1,   -1,  381,  310,  383,
   -1,   -1,  386,  387,   -1,   -1,  318,   -1,  320,   -1,
   -1,  323,   -1,    0,   -1,   -1,   -1,  257,   -1,  259,
  260,  261,  262,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  270,   -1,  125,   -1,  274,  347,   -1,   -1,  278,   -1,
   -1,   -1,   -1,  355,  356,  357,  286,  359,  288,   -1,
  362,    0,  364,   -1,   -1,  367,   -1,   -1,  370,   -1,
   -1,   -1,   -1,   -1,  304,  305,   -1,   -1,   -1,  381,
  310,  383,   -1,   -1,  386,  387,   -1,   -1,  318,   -1,
  320,   -1,   -1,  323,   -1,   -1,   -1,   -1,   -1,  257,
   -1,  259,  260,  261,  262,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  270,   -1,  125,   -1,  274,  347,   -1,   -1,
  278,   -1,   -1,   -1,   -1,  355,  356,  357,  286,  359,
  288,   -1,  362,    0,  364,   -1,   -1,  367,   -1,   -1,
  370,    0,   -1,   -1,   -1,   -1,  304,  305,  125,   -1,
   -1,  381,  310,  383,   -1,   -1,  386,  387,   -1,   -1,
  318,   -1,  320,   -1,   -1,  323,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  257,   -1,  259,  260,  261,  262,
   -1,   -1,   -1,   -1,  123,   -1,  125,  270,   -1,  347,
   -1,  274,   -1,   -1,   -1,  278,   -1,  355,  356,  357,
   -1,  359,   -1,  286,  362,  288,  364,   -1,   -1,  367,
   -1,   -1,  370,    0,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  304,  305,  381,   -1,  383,   -1,  310,  386,  387,
   -1,   -1,   -1,   -1,   -1,  318,   -1,  320,   -1,   -1,
  323,    0,   -1,   -1,   -1,   -1,  257,   -1,  259,  260,
  261,  262,   -1,   -1,   -1,   -1,  123,   -1,  125,  270,
   -1,   -1,   -1,  274,  347,   -1,  125,  278,   -1,   -1,
   -1,   -1,  355,  356,  357,  286,  359,  288,    0,  362,
  257,  364,  259,   -1,  367,   -1,   -1,  370,   -1,   -1,
   -1,   -1,   -1,  304,  305,   -1,   -1,  274,  381,  310,
  383,   -1,   -1,  386,  387,    0,   -1,  318,   -1,  320,
    0,   -1,  323,   -1,   -1,   -1,   -1,   -1,  257,   -1,
  259,  260,   -1,   -1,   -1,   -1,   -1,  266,   -1,   -1,
   -1,   -1,   -1,  310,   -1,  274,  347,   -1,  125,   -1,
   -1,   -1,   -1,  320,  355,  356,  357,   -1,  359,   -1,
   -1,  362,  329,  364,   -1,  332,  367,   -1,   -1,  370,
   -1,   -1,  339,  340,  341,  342,  125,   -1,   -1,   -1,
  381,   -1,  383,   -1,    0,  386,  387,   -1,   -1,    0,
   -1,  320,   -1,   -1,   -1,  362,   -1,   -1,  365,   -1,
  257,   -1,  259,  260,   -1,   -1,   -1,    0,  257,  266,
  259,   -1,   -1,  125,  343,   -1,  383,  274,   -1,  386,
  387,   -1,   -1,   -1,   -1,  274,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  362,   -1,   -1,   -1,   -1,    0,   -1,
  125,   -1,   -1,   -1,   -1,  125,   -1,  376,  377,   -1,
   -1,   -1,   -1,   -1,  383,   -1,   -1,  386,  387,   -1,
   -1,  310,   -1,  320,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  320,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,
  257,   -1,  259,  332,   -1,   -1,  343,   -1,   -1,   -1,
  339,  340,  341,   -1,   -1,   -1,   -1,  274,   -1,   -1,
   -1,   -1,   -1,    0,   -1,  362,   -1,   -1,  257,  125,
  259,   -1,   -1,  362,  125,   -1,  365,  294,  295,  376,
  377,   -1,   -1,   -1,   -1,  274,  383,   -1,   -1,  386,
  387,   -1,  125,  310,  383,   -1,   -1,  386,  387,   -1,
    0,   -1,   -1,  320,   -1,  257,   -1,  259,    0,   -1,
   -1,   -1,  329,    0,   -1,   -1,   -1,   -1,    0,   -1,
   -1,  310,  274,  125,   -1,  342,   -1,   -1,   -1,   -1,
   -1,  320,  257,   -1,  259,   -1,   -1,  257,   -1,  259,
    0,   -1,   -1,   -1,   -1,  362,   -1,   -1,   -1,  274,
  339,  340,  341,    0,  274,   -1,   -1,   -1,  310,   -1,
   -1,  125,   -1,   -1,   -1,   -1,  383,   -1,  320,  386,
  387,    2,    3,  362,   -1,   -1,  365,   -1,   -1,   -1,
   -1,  333,   -1,  335,   -1,  310,   -1,  339,  125,   -1,
  310,   -1,   -1,   -1,  383,  320,   -1,  386,  387,   -1,
  320,  257,   -1,  259,   35,   -1,  257,   -1,  259,  329,
  362,   -1,   -1,  365,  339,  340,   -1,   48,  274,   -1,
   -1,   -1,  342,  274,  257,  125,  259,   -1,   -1,   -1,
   -1,  383,   -1,  125,  386,  387,   -1,  362,  125,   -1,
  365,  274,  362,  125,   -1,   -1,   -1,   78,   -1,   -1,
   -1,   -1,   -1,   -1,  310,  257,   -1,  259,  383,  310,
   -1,  386,  387,  383,  320,  125,  386,  387,   -1,  320,
   -1,   -1,  274,   -1,   -1,   -1,   -1,  310,  125,   -1,
   -1,   -1,   -1,  339,   -1,   -1,   -1,  320,  339,   -1,
   -1,   -1,   -1,  257,   -1,  259,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  362,   -1,  310,  365,
  274,  362,   -1,   -1,  365,   -1,   -1,   -1,  320,   -1,
  257,   -1,  259,   -1,   -1,   -1,   -1,  383,   -1,  362,
  386,  387,  383,   -1,   -1,  386,  387,  274,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  310,   -1,   -1,   -1,
  383,   -1,   -1,  386,  387,   -1,  320,  257,   -1,  259,
  362,   -1,   -1,   -1,   -1,  257,   -1,  259,   -1,   -1,
  257,   -1,  259,   -1,  274,  257,   -1,  259,   -1,   -1,
   -1,  383,  274,  320,  386,  387,   -1,  274,   -1,   -1,
   -1,  222,  274,   -1,   -1,   -1,   -1,  257,  362,  259,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  257,   -1,  259,   -1,  274,   -1,   -1,   -1,   -1,  383,
  320,   -1,  386,  387,   -1,  362,   -1,  274,  320,  260,
  261,  123,   -1,  320,   -1,   -1,   -1,   -1,  320,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  383,   -1,   -1,  386,
  387,   -1,   -1,   -1,  285,  286,   -1,   -1,   -1,   -1,
  320,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  362,   -1,   -1,  320,   -1,  362,   -1,   -1,   -1,   -1,
  362,   -1,  313,  383,   -1,   -1,  386,  387,   -1,   -1,
   -1,  383,   -1,   -1,  386,  387,  383,   -1,  329,  386,
  387,  383,  362,    4,  386,  387,   -1,   -1,  339,   -1,
   -1,   -1,  343,   -1,   -1,  362,   -1,   -1,   -1,  350,
   -1,   -1,   -1,  383,   -1,   -1,  386,  387,   -1,   -1,
   -1,   32,   33,   -1,  365,   -1,  383,  368,   39,  386,
  387,   -1,   -1,  374,   -1,   -1,   -1,   -1,   -1,   -1,
  381,   52,  383,   -1,   55,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   63,   -1,   -1,   -1,   -1,  259,  260,  261,
  262,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  270,   80,
   -1,   -1,   -1,   84,   85,   -1,   87,   -1,   -1,   -1,
   91,   -1,   -1,   -1,  286,   -1,  288,   -1,   -1,   -1,
   -1,   -1,  123,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  304,  305,   -1,   -1,   -1,   -1,  310,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  318,   -1,   -1,   -1,
   -1,  323,  133,  134,   -1,   -1,   -1,   -1,   -1,  140,
  141,  142,   -1,   -1,  145,   -1,   -1,  148,   -1,   -1,
   -1,  152,  153,   -1,   -1,  347,  157,  158,  159,   -1,
   -1,   -1,  163,  355,  356,  357,   -1,  359,   -1,  170,
   -1,  172,  364,   -1,   -1,  367,   -1,   -1,  370,   -1,
   -1,   -1,  183,  304,  305,   -1,   -1,   -1,   -1,  381,
   -1,   -1,   -1,  385,  386,   -1,  388,  318,  319,   -1,
   -1,   -1,  323,  324,   -1,   -1,   -1,   -1,   -1,  330,
  331,   -1,   -1,  214,  215,  216,  123,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,  230,
   -1,  232,   -1,  234,   -1,   -1,   -1,  238,  259,  260,
  261,  262,   -1,   -1,   -1,  366,   -1,  123,   -1,  270,
  251,   -1,   -1,  254,   -1,  376,  377,   -1,  259,   -1,
   -1,   -1,   -1,   -1,   -1,  286,  267,  288,  269,   -1,
  271,   -1,   -1,  274,   -1,   -1,  277,   -1,  279,   -1,
  281,   -1,   -1,  304,  305,  304,  305,  288,  289,  310,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  318,
  319,   -1,  323,  324,  323,  324,   -1,  308,  309,  330,
  331,  330,  331,   -1,   -1,  316,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  324,   -1,   -1,  347,  348,  349,  348,
  349,   -1,  125,   -1,  355,  356,  357,   -1,  359,   -1,
   -1,   -1,   -1,  364,   -1,  366,  367,  366,   -1,  370,
   -1,   -1,  259,  260,  261,  262,   -1,   -1,   -1,  360,
  381,   -1,   -1,  270,   -1,   -1,  367,   -1,   -1,   -1,
   -1,   -1,   -1,  304,  305,   -1,   -1,   -1,   -1,  286,
   -1,  288,   -1,  259,  260,  261,  262,  318,  319,   -1,
   -1,   -1,  323,  324,  270,  257,  258,  304,  305,  330,
  331,  263,  264,  310,  125,   -1,   -1,   -1,   -1,  271,
  286,  318,  288,  275,   -1,   -1,  323,  348,  349,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  288,   -1,  304,  305,
   -1,   -1,   -1,   -1,  310,  366,   -1,   -1,   -1,   -1,
  347,   -1,  318,   -1,   -1,   -1,  308,  323,  355,  356,
  357,   -1,  359,   -1,   -1,   -1,   -1,  364,   -1,  321,
  367,   -1,   -1,  370,   -1,   -1,  259,  260,  261,  262,
   -1,  347,   -1,   -1,  381,   -1,   -1,  270,   -1,  355,
  356,  357,   -1,  359,   -1,  347,   -1,   -1,  364,   -1,
   -1,  367,   -1,  286,  370,  288,   -1,   -1,   -1,   -1,
   -1,  363,   -1,   -1,   -1,  381,  368,   -1,   -1,  371,
   -1,  304,  305,  375,   -1,   -1,   -1,  310,   -1,   -1,
   -1,   -1,   -1,  385,  386,  318,  388,   -1,   -1,   -1,
  323,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  259,  260,
  261,  262,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  270,
   -1,   -1,   -1,   -1,  347,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  355,  356,  357,  286,  359,  288,   -1,   -1,
   -1,  364,   -1,   -1,  367,   -1,   -1,  370,   -1,   -1,
   -1,   -1,   -1,  304,  305,   -1,   -1,   -1,  381,  310,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,   -1,   -1,
   -1,   -1,  323,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  259,  260,  261,  262,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  270,   -1,   -1,   -1,   -1,  347,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  355,  356,  357,  286,  359,  288,
   -1,   -1,   -1,  364,   -1,   -1,  367,   -1,   -1,  370,
   -1,   -1,   -1,   -1,   -1,  304,  305,   -1,   -1,   -1,
  381,  310,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,
   -1,   -1,   -1,   -1,  323,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  259,  260,  261,  262,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  270,   -1,   -1,   -1,   -1,  347,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  355,  356,  357,  286,
  359,  288,   -1,   -1,   -1,  364,   -1,   -1,  367,   -1,
   -1,  370,   -1,   -1,   -1,   -1,   -1,  304,  305,   -1,
   -1,   -1,  381,  310,   -1,   -1,  385,  386,   -1,  388,
   -1,  318,   -1,   -1,   -1,   -1,  323,   -1,  265,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  276,
   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,
  347,   -1,   -1,   -1,  291,  292,   -1,   -1,  355,  356,
  357,   -1,  359,   -1,   -1,   -1,  303,  364,   -1,  306,
  367,   -1,   -1,  370,   -1,   -1,  313,  314,  315,  316,
  317,   -1,   -1,   -1,  381,  322,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  334,   -1,   -1,
  337,   -1,   -1,   -1,   -1,   -1,   -1,  344,   -1,   -1,
   -1,   -1,   -1,   -1,  351,  352,  353,  354,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  369,   -1,   -1,  372,   -1,   -1,   -1,   -1,
   -1,   -1,  379,
};
#define YYFINAL 1
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 389
#if YYDEBUG
const char * const yyname[] =
	{
"end-of-file",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,"'('","')'",0,"'+'","','",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"'<'","'='",
"'>'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"'{'",0,"'}'",0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,"TOKACCOUNT","TOKACCOUNTS","TOKACTION","TOKACTIONS","TOKADDHEADER",
"TOKADDTOCACHE","TOKAGE","TOKALL","TOKALLOWMANY","TOKAND","TOKANYNAME",
"TOKANYSIZE","TOKANYTYPE","TOKAPPEND","TOKATTACHMENT","TOKBODY","TOKBYTES",
"TOKCACHE","TOKCASE","TOKCMDUSER","TOKCOMPRESS","TOKCONTINUE","TOKCOUNT",
"TOKDAYS","TOKDEFUSER","TOKDELTOOBIG","TOKDISABLED","TOKDOMAIN","TOKDOTLOCK",
"TOKDROP","TOKEQ","TOKEXEC","TOKEXPIRE","TOKFCNTL","TOKFILEGROUP",
"TOKFILEUMASK","TOKFLOCK","TOKFOLDER","TOKFOLDERS","TOKFROM","TOKGIGABYTES",
"TOKGROUP","TOKGROUPS","TOKHEADER","TOKHEADERS","TOKHOURS","TOKIGNOREERRORS",
"TOKIMAP","TOKIMAPS","TOKIMPLACT","TOKIN","TOKINCACHE","TOKINVALID","TOKKEEP",
"TOKKEY","TOKKILOBYTES","TOKLOCKFILE","TOKLOCKTIMEOUT","TOKLOCKTYPES",
"TOKLOCKWAIT","TOKLOOKUPORDER","TOKMAILDIR","TOKMAILDIRS","TOKMATCH",
"TOKMATCHED","TOKMAXSIZE","TOKMBOX","TOKMBOXES","TOKMEGABYTES","TOKMINUTES",
"TOKMONTHS","TOKNE","TOKNEWONLY","TOKNNTP","TOKNNTPS","TOKNOAPOP",
"TOKNOCRAMMD5","TOKNOCREATE","TOKNOLOGIN","TOKNONE","TOKNORECEIVED","TOKNOT",
"TOKNOTLS1","TOKNOUIDL","TOKNOVERIFY","TOKOLDONLY","TOKOR",
"TOKPARALLELACCOUNTS","TOKPASS","TOKPASSWD","TOKPIPE","TOKPOP3","TOKPOP3S",
"TOKPORT","TOKPROXY","TOKPURGEAFTER","TOKQUEUEHIGH","TOKQUEUELOW",
"TOKREMOVEFROMCACHE","TOKREMOVEHEADER","TOKREMOVEHEADERS","TOKRETURNS",
"TOKREWRITE","TOKSECONDS","TOKSERVER","TOKSET","TOKSIZE","TOKSMTP",
"TOKSTARTTLS","TOKSTDIN","TOKSTDOUT","TOKSTRING","TOKSTRIPCHARACTERS","TOKTAG",
"TOKTAGGED","TOKTIMEOUT","TOKTO","TOKTOTALSIZE","TOKUNMATCHED","TOKUSER",
"TOKUSERS","TOKVALUE","TOKVERIFYCERTS","TOKWEEKS","TOKWRITE","TOKYEARS","NONE",
"NUMBER","STRING","STRMACRO","NUMMACRO","STRCOMMAND","NUMCOMMAND",
};
const char * const yyrule[] =
	{"$accept : cmds",
"cmds :",
"cmds : cmds account",
"cmds : cmds defaction",
"cmds : cmds defmacro",
"cmds : cmds rule",
"cmds : cmds set",
"cmds : cmds close",
"cmds : cmds cache",
"cmds : cmds NONE",
"actionp : TOKACTION",
"actionp : TOKACTIONS",
"userp : TOKUSER",
"userp : TOKUSERS",
"accountp : TOKACCOUNT",
"accountp : TOKACCOUNTS",
"groupp : TOKGROUP",
"groupp : TOKGROUPS",
"folderp : TOKFOLDER",
"folderp : TOKFOLDERS",
"maildirp : TOKMAILDIR",
"maildirp : TOKMAILDIRS",
"mboxp : TOKMBOX",
"mboxp : TOKMBOXES",
"rmheaderp : TOKREMOVEHEADER",
"rmheaderp : TOKREMOVEHEADERS",
"val : TOKVALUE strv",
"val : strv",
"optval : TOKVALUE strv",
"optval :",
"xstrv : STRCOMMAND",
"xstrv : STRING",
"xstrv : STRMACRO",
"strv : xstrv",
"strv : strv '+' xstrv",
"numv : NUMCOMMAND",
"numv : NUMBER",
"numv : NUMMACRO",
"replstrv : strv",
"replpathv : strv",
"size : numv",
"size : numv TOKBYTES",
"size : numv TOKKILOBYTES",
"size : numv TOKMEGABYTES",
"size : numv TOKGIGABYTES",
"time : numv",
"time : numv TOKHOURS",
"time : numv TOKMINUTES",
"time : numv TOKSECONDS",
"time : numv TOKDAYS",
"time : numv TOKWEEKS",
"time : numv TOKMONTHS",
"time : numv TOKYEARS",
"expire : TOKEXPIRE time",
"expire :",
"cache : TOKCACHE replpathv expire",
"set : TOKSET TOKMAXSIZE size",
"set : TOKSET TOKLOCKTYPES locklist",
"set : TOKSET TOKLOCKFILE replpathv",
"set : TOKSET TOKLOCKWAIT",
"set : TOKSET TOKLOCKTIMEOUT time",
"set : TOKSET TOKDELTOOBIG",
"set : TOKSET TOKIGNOREERRORS",
"set : TOKSET TOKALLOWMANY",
"set : TOKSET TOKDEFUSER strv",
"set : TOKSET TOKCMDUSER strv",
"set : TOKSET TOKSTRIPCHARACTERS strv",
"set : TOKSET TOKTIMEOUT time",
"set : TOKSET TOKQUEUEHIGH numv",
"set : TOKSET TOKQUEUELOW numv",
"set : TOKSET TOKPARALLELACCOUNTS numv",
"set : TOKSET TOKPROXY replstrv",
"set : TOKSET TOKVERIFYCERTS",
"set : TOKSET TOKIMPLACT TOKKEEP",
"set : TOKSET TOKIMPLACT TOKDROP",
"set : TOKSET TOKPURGEAFTER numv",
"set : TOKSET TOKPURGEAFTER TOKNONE",
"set : TOKSET TOKNORECEIVED",
"set : TOKSET TOKNOCREATE",
"set : TOKSET TOKFILEGROUP TOKUSER",
"set : TOKSET TOKFILEGROUP localgid",
"set : TOKSET TOKFILEUMASK TOKUSER",
"set : TOKSET TOKLOOKUPORDER ufnlist",
"set : TOKSET TOKFILEUMASK numv",
"defmacro : STRMACRO '=' strv",
"defmacro : NUMMACRO '=' numv",
"replstrslist : replstrslist strv",
"replstrslist : strv",
"stringslist : stringslist replstrv",
"stringslist : replstrv",
"pathslist : pathslist replpathv",
"pathslist : replpathv",
"ufn : TOKPASSWD",
"ufnlist : ufnlist ufn",
"ufnlist : ufn",
"rmheaders : rmheaderp strv",
"rmheaders : rmheaderp '{' replstrslist '}'",
"maildirs : maildirp replpathv",
"maildirs : maildirp '{' pathslist '}'",
"mboxes : mboxp replpathv",
"mboxes : mboxp '{' pathslist '}'",
"folders : folderp replstrv",
"folders : folderp '{' stringslist '}'",
"lock : TOKFCNTL",
"lock : TOKFLOCK",
"lock : TOKDOTLOCK",
"locklist : locklist lock",
"locklist : lock",
"locklist : TOKNONE",
"localgid : replstrv",
"localgid : numv",
"user :",
"user : TOKUSER strv",
"users :",
"users : userp strv",
"users : userp '{' replstrslist '}'",
"casere : TOKCASE replstrv",
"casere : replstrv",
"not : TOKNOT",
"not :",
"keep : TOKKEEP",
"keep :",
"disabled : TOKDISABLED",
"disabled :",
"port : TOKPORT replstrv",
"port : TOKPORT numv",
"server : TOKSERVER replstrv port",
"server : TOKSERVER replstrv",
"to :",
"to : TOKTO strv",
"from :",
"from : TOKFROM strv",
"compress : TOKCOMPRESS",
"compress :",
"actitem : execpipe strv",
"actitem : TOKREWRITE strv",
"actitem : writeappend strv",
"actitem : TOKMAILDIR strv",
"actitem : rmheaders",
"actitem : TOKADDHEADER strv val",
"actitem : TOKMBOX strv compress",
"actitem : imaptype server userpassnetrc folder1 verify nocrammd5 nologin tls1 starttls",
"actitem : TOKSMTP server from to",
"actitem : TOKSTDOUT",
"actitem : TOKTAG strv optval",
"actitem : TOKADDTOCACHE replpathv TOKKEY strv",
"actitem : TOKREMOVEFROMCACHE replpathv TOKKEY strv",
"actitem : actions",
"actitem : TOKDROP",
"actitem : TOKKEEP",
"actlist : actlist actitem",
"actlist : actitem",
"defaction : TOKACTION replstrv users actitem",
"defaction : TOKACTION replstrv users '{' actlist '}'",
"accounts : accountp strv",
"accounts : accountp '{' replstrslist '}'",
"actions : actionp strv",
"actions : actionp '{' replstrslist '}'",
"cont :",
"cont : TOKCONTINUE",
"area :",
"area : TOKIN TOKALL",
"area : TOKIN TOKHEADERS",
"area : TOKIN TOKBODY",
"retrc : numv",
"retrc :",
"retre : casere",
"retre :",
"ltgt : '<'",
"ltgt : '>'",
"eqne : TOKEQ",
"eqne : TOKNE",
"cmp : ltgt",
"cmp : eqne",
"execpipe : TOKEXEC",
"execpipe : TOKPIPE",
"writeappend : TOKWRITE",
"writeappend : TOKAPPEND",
"exprop : TOKAND",
"exprop : TOKOR",
"expritem : not TOKALL",
"expritem : not casere area",
"expritem : not accounts",
"expritem : not execpipe strv user TOKRETURNS '(' retrc ',' retre ')'",
"expritem : not TOKTAGGED strv",
"expritem : not TOKSIZE ltgt size",
"expritem : not TOKSTRING strv TOKTO casere",
"expritem : not TOKINCACHE replpathv TOKKEY strv",
"expritem : not TOKMATCHED",
"expritem : not TOKUNMATCHED",
"expritem : not TOKAGE ltgt time",
"expritem : not TOKAGE TOKINVALID",
"expritem : not TOKATTACHMENT TOKCOUNT cmp numv",
"expritem : not TOKATTACHMENT TOKTOTALSIZE ltgt size",
"expritem : not TOKATTACHMENT TOKANYSIZE ltgt size",
"expritem : not TOKATTACHMENT TOKANYTYPE strv",
"expritem : not TOKATTACHMENT TOKANYNAME strv",
"exprlist : exprlist exprop expritem",
"exprlist : exprop expritem",
"expr : expritem",
"expr : expritem exprlist",
"perform : users actionp actitem cont",
"perform : users actionp '{' actlist '}' cont",
"perform : users actions cont",
"perform : '{'",
"close : '}'",
"rule : TOKMATCH expr perform",
"folderlist :",
"folderlist : folders",
"folder1 :",
"folder1 : folderp strv",
"groups : groupp replstrv",
"groups : groupp '{' stringslist '}'",
"nocrammd5 : TOKNOCRAMMD5",
"nocrammd5 :",
"nologin : TOKNOLOGIN",
"nologin :",
"tls1 : TOKNOTLS1",
"tls1 :",
"starttls : TOKSTARTTLS",
"starttls :",
"uidl : TOKNOUIDL",
"uidl :",
"verify : TOKNOVERIFY",
"verify :",
"apop : TOKNOAPOP",
"apop :",
"only : TOKNEWONLY",
"only : TOKOLDONLY",
"poptype : TOKPOP3",
"poptype : TOKPOP3S",
"imaptype : TOKIMAP",
"imaptype : TOKIMAPS",
"nntptype : TOKNNTP",
"nntptype : TOKNNTPS",
"userpassnetrc : TOKUSER replstrv TOKPASS replstrv",
"userpassnetrc :",
"userpassnetrc : TOKUSER replstrv",
"userpassnetrc : TOKPASS replstrv",
"userpassreqd : TOKUSER replstrv TOKPASS replstrv",
"userpass : userpassreqd",
"userpass :",
"poponly : only TOKCACHE replpathv",
"poponly :",
"imaponly : only",
"imaponly :",
"fetchtype : poptype server userpassnetrc poponly apop verify uidl tls1 starttls",
"fetchtype : TOKPOP3 TOKPIPE replstrv userpassreqd poponly apop",
"fetchtype : imaptype server userpassnetrc folderlist imaponly verify nocrammd5 nologin tls1 starttls",
"fetchtype : TOKIMAP TOKPIPE replstrv userpass folderlist imaponly",
"fetchtype : TOKSTDIN",
"fetchtype : maildirs",
"fetchtype : mboxes",
"fetchtype : nntptype server userpassnetrc groups TOKCACHE replpathv verify tls1",
"account : TOKACCOUNT replstrv disabled users fetchtype keep",
};
#endif
#ifdef YYSTACKSIZE
#undef YYMAXDEPTH
#define YYMAXDEPTH YYSTACKSIZE
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 10000
#define YYMAXDEPTH 10000
#endif
#endif
#define YYINITSTACKSIZE 200
/* LINTUSED */
int yydebug;
int yynerrs;
int yyerrflag;
int yychar;
short *yyssp;
YYSTYPE *yyvsp;
YYSTYPE yyval;
YYSTYPE yylval;
short *yyss;
short *yysslim;
YYSTYPE *yyvs;
unsigned int yystacksize;
#line 2416 "parse.y"

/* Programs */
#line 1670 "parse.c"
/* allocate initial stack or double stack size, up to YYMAXDEPTH */
static int yygrowstack(void)
{
    unsigned int newsize;
    long sslen;
    short *newss;
    YYSTYPE *newvs;

    if ((newsize = yystacksize) == 0)
        newsize = YYINITSTACKSIZE;
    else if (newsize >= YYMAXDEPTH)
        return -1;
    else if ((newsize *= 2) > YYMAXDEPTH)
        newsize = YYMAXDEPTH;
    sslen = yyssp - yyss;
#ifdef SIZE_MAX
#define YY_SIZE_MAX SIZE_MAX
#else
#define YY_SIZE_MAX 0xffffffffU
#endif
    if (newsize && YY_SIZE_MAX / newsize < sizeof *newss)
        goto bail;
    newss = yyss ? (short *)realloc(yyss, newsize * sizeof *newss) :
      (short *)malloc(newsize * sizeof *newss); /* overflow check above */
    if (newss == NULL)
        goto bail;
    yyss = newss;
    yyssp = newss + sslen;
    if (newsize && YY_SIZE_MAX / newsize < sizeof *newvs)
        goto bail;
    newvs = yyvs ? (YYSTYPE *)realloc(yyvs, newsize * sizeof *newvs) :
      (YYSTYPE *)malloc(newsize * sizeof *newvs); /* overflow check above */
    if (newvs == NULL)
        goto bail;
    yyvs = newvs;
    yyvsp = newvs + sslen;
    yystacksize = newsize;
    yysslim = yyss + newsize - 1;
    return 0;
bail:
    if (yyss)
            free(yyss);
    if (yyvs)
            free(yyvs);
    yyss = yyssp = NULL;
    yyvs = yyvsp = NULL;
    yystacksize = 0;
    return -1;
}

#define YYABORT goto yyabort
#define YYREJECT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR goto yyerrlab
int
yyparse(void)
{
    int yym, yyn, yystate;
#if YYDEBUG
    const char *yys;

    if ((yys = getenv("YYDEBUG")))
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif /* YYDEBUG */

    yynerrs = 0;
    yyerrflag = 0;
    yychar = (-1);

    if (yyss == NULL && yygrowstack()) goto yyoverflow;
    yyssp = yyss;
    yyvsp = yyvs;
    *yyssp = yystate = 0;

yyloop:
    if ((yyn = yydefred[yystate]) != 0) goto yyreduce;
    if (yychar < 0)
    {
        if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, reading %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
    }
    if ((yyn = yysindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: state %d, shifting to state %d\n",
                    YYPREFIX, yystate, yytable[yyn]);
#endif
        if (yyssp >= yysslim && yygrowstack())
        {
            goto yyoverflow;
        }
        *++yyssp = yystate = yytable[yyn];
        *++yyvsp = yylval;
        yychar = (-1);
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if ((yyn = yyrindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag) goto yyinrecovery;
#if defined(__GNUC__)
    goto yynewerror;
#endif
yynewerror:
    yyerror("syntax error");
#if defined(__GNUC__)
    goto yyerrlab;
#endif
yyerrlab:
    ++yynerrs;
yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if ((yyn = yysindex[*yyssp]) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: state %d, error recovery shifting\
 to state %d\n", YYPREFIX, *yyssp, yytable[yyn]);
#endif
                if (yyssp >= yysslim && yygrowstack())
                {
                    goto yyoverflow;
                }
                *++yyssp = yystate = yytable[yyn];
                *++yyvsp = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: error recovery discarding state %d\n",
                            YYPREFIX, *yyssp);
#endif
                if (yyssp <= yyss) goto yyabort;
                --yyssp;
                --yyvsp;
            }
        }
    }
    else
    {
        if (yychar == 0) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, error recovery discards token %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
        yychar = (-1);
        goto yyloop;
    }
yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: state %d, reducing by rule %d (%s)\n",
                YYPREFIX, yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    if (yym)
        yyval = yyvsp[1-yym];
    else
        memset(&yyval, 0, sizeof yyval);
    switch (yyn)
    {
case 26:
#line 359 "parse.y"
{
	     yyval.string = yyvsp[0].string;
     }
break;
case 27:
#line 363 "parse.y"
{
	     yyval.string = yyvsp[0].string;
     }
break;
case 28:
#line 368 "parse.y"
{
		yyval.string = yyvsp[0].string;
        }
break;
case 29:
#line 372 "parse.y"
{
		yyval.string = NULL;
	}
break;
case 30:
#line 377 "parse.y"
{
	       yyval.string = run_command(yyvsp[0].string, parse_file->path);
	       xfree(yyvsp[0].string);
       }
break;
case 31:
#line 382 "parse.y"
{
	       yyval.string = yyvsp[0].string;
       }
break;
case 32:
#line 386 "parse.y"
{
	       struct macro	*macro;

	       if (strlen(yyvsp[0].string) > MAXNAMESIZE)
		       yyerror("macro name too long: %s", yyvsp[0].string);

	       if ((macro = find_macro(yyvsp[0].string)) == NULL)
		       yyerror("undefined macro: %s", yyvsp[0].string);
	       if (macro->type != MACRO_STRING)
		       yyerror("string macro expected: %s", yyvsp[0].string);

	       yyval.string = xstrdup(macro->value.str);

	       xfree(yyvsp[0].string);
       }
break;
case 33:
#line 403 "parse.y"
{
	      yyval.string = yyvsp[0].string;
      }
break;
case 34:
#line 407 "parse.y"
{
	      size_t	size;

	      size = strlen(yyvsp[-2].string) + strlen(yyvsp[0].string) + 1;
	      yyval.string = xrealloc(yyvsp[-2].string, 1, size);
	      strlcat(yyval.string, yyvsp[0].string, size);
	      xfree(yyvsp[0].string);
      }
break;
case 35:
#line 417 "parse.y"
{
	      const char	*errstr;
	      char		*s;

	      s = run_command(yyvsp[0].string, parse_file->path);

	      yyval.number = strtonum(s, 0, LLONG_MAX, &errstr);
	      if (errstr != NULL)
		      yyerror("number is %s", errstr);

	      xfree(s);

	      xfree(yyvsp[0].string);
      }
break;
case 36:
#line 432 "parse.y"
{
	      yyval.number = yyvsp[0].number;
      }
break;
case 37:
#line 436 "parse.y"
{
	      struct macro	*macro;

	      if (strlen(yyvsp[0].string) > MAXNAMESIZE)
		      yyerror("macro name too long: %s", yyvsp[0].string);

	      if ((macro = find_macro(yyvsp[0].string)) == NULL)
		      yyerror("undefined macro: %s", yyvsp[0].string);
	      if (macro->type != MACRO_NUMBER)
		      yyerror("number macro expected: %s", yyvsp[0].string);

	      yyval.number = macro->value.num;

	      xfree(yyvsp[0].string);
      }
break;
case 38:
#line 453 "parse.y"
{
		  struct replstr	rs;

		  rs.str = yyvsp[0].string;
		  yyval.string = replacestr(&rs, parse_tags, NULL, NULL);
		  xfree(yyvsp[0].string);
	  }
break;
case 39:
#line 462 "parse.y"
{
		  struct replpath	rp;

		  rp.str = yyvsp[0].string;
		  yyval.string = replacepath(&rp, parse_tags, NULL, NULL, conf.user_home);
		  xfree(yyvsp[0].string);
	   }
break;
case 40:
#line 471 "parse.y"
{
	      yyval.number = yyvsp[0].number;
      }
break;
case 41:
#line 475 "parse.y"
{
	      yyval.number = yyvsp[-1].number;
      }
break;
case 42:
#line 479 "parse.y"
{
	      if (yyvsp[-1].number > LLONG_MAX / 1024)
		      yyerror("size is too big");
	      yyval.number = yyvsp[-1].number * 1024;
      }
break;
case 43:
#line 485 "parse.y"
{
	      if (yyvsp[-1].number > LLONG_MAX / (1024 * 1024))
		      yyerror("size is too big");
	      yyval.number = yyvsp[-1].number * (1024 * 1024);
      }
break;
case 44:
#line 491 "parse.y"
{
	      if (yyvsp[-1].number > LLONG_MAX / (1024 * 1024 * 1024))
		      yyerror("size is too big");
	      yyval.number = yyvsp[-1].number * (1024 * 1024 * 1024);
      }
break;
case 45:
#line 498 "parse.y"
{
	      yyval.number = yyvsp[0].number;
      }
break;
case 46:
#line 502 "parse.y"
{
	      if (yyvsp[-1].number > LLONG_MAX / TIME_HOUR)
		      yyerror("time is too long");
	      yyval.number = yyvsp[-1].number * TIME_HOUR;
      }
break;
case 47:
#line 508 "parse.y"
{
	      if (yyvsp[-1].number > LLONG_MAX / TIME_MINUTE)
		      yyerror("time is too long");
	      yyval.number = yyvsp[-1].number * TIME_MINUTE;
      }
break;
case 48:
#line 514 "parse.y"
{
	      yyval.number = yyvsp[-1].number;
      }
break;
case 49:
#line 518 "parse.y"
{
	      if (yyvsp[-1].number > LLONG_MAX / TIME_DAY)
		      yyerror("time is too long");
	      yyval.number = yyvsp[-1].number * TIME_DAY;
      }
break;
case 50:
#line 524 "parse.y"
{
	      if (yyvsp[-1].number > LLONG_MAX / TIME_WEEK)
		      yyerror("time is too long");
	      yyval.number = yyvsp[-1].number * TIME_WEEK;
      }
break;
case 51:
#line 530 "parse.y"
{
	      if (yyvsp[-1].number > LLONG_MAX / TIME_MONTH)
		      yyerror("time is too long");
	      yyval.number = yyvsp[-1].number * TIME_MONTH;
      }
break;
case 52:
#line 536 "parse.y"
{
	      if (yyvsp[-1].number > LLONG_MAX / TIME_YEAR)
		      yyerror("time is too long");
	      yyval.number = yyvsp[-1].number * TIME_YEAR;
      }
break;
case 53:
#line 543 "parse.y"
{
#if UINT64_MAX < LLONG_MAX
		if (yyvsp[0].number > UINT64_MAX)
			yyerror("time too long");
#endif

		yyval.number = yyvsp[0].number;
	}
break;
case 54:
#line 552 "parse.y"
{
		yyval.number = -1;
	}
break;
case 55:
#line 557 "parse.y"
{
	       struct cache	*cache;

	       TAILQ_FOREACH(cache, &conf.caches, entry) {
		       if (strcmp(cache->path, yyvsp[-1].string) == 0)
			       yyerror("duplicate cache path");
	       }

	       cache = xcalloc(1, sizeof *cache);
	       cache->path = yyvsp[-1].string;
	       cache->expire = yyvsp[0].number;

	       TAILQ_INSERT_TAIL(&conf.caches, cache, entry);

	       log_debug2("added cache \"%s\": expire %lld", cache->path, yyvsp[0].number);
       }
break;
case 56:
#line 575 "parse.y"
{
	     if (yyvsp[0].number == 0)
		     yyerror("zero maximum size");
	     if (yyvsp[0].number > MAXMAILSIZE)
		     yyerror("maximum size too large: %lld", yyvsp[0].number);
	     conf.max_size = yyvsp[0].number;
     }
break;
case 57:
#line 583 "parse.y"
{
	     if (yyvsp[0].locks & LOCK_FCNTL && yyvsp[0].locks & LOCK_FLOCK)
		     yyerror("fcntl and flock locking cannot be used together");
	     conf.lock_types = yyvsp[0].locks;
     }
break;
case 58:
#line 589 "parse.y"
{
	     if (conf.lock_file != NULL)
		     xfree(conf.lock_file);
	     conf.lock_file = yyvsp[0].string;
     }
break;
case 59:
#line 595 "parse.y"
{
	     conf.lock_wait = 1;
     }
break;
case 60:
#line 599 "parse.y"
{
	     conf.lock_timeout = yyvsp[0].number;
     }
break;
case 61:
#line 603 "parse.y"
{
	     conf.del_big = 1;
     }
break;
case 62:
#line 607 "parse.y"
{
	     conf.ignore_errors = 1;
     }
break;
case 63:
#line 611 "parse.y"
{
	     conf.allow_many = 1;
     }
break;
case 64:
#line 615 "parse.y"
{
	     if (conf.def_user == NULL)
		     conf.def_user = yyvsp[0].string;
     }
break;
case 65:
#line 620 "parse.y"
{
	     if (conf.cmd_user == NULL)
		     conf.cmd_user = yyvsp[0].string;
     }
break;
case 66:
#line 625 "parse.y"
{
	     xfree(conf.strip_chars);
	     conf.strip_chars = yyvsp[0].string;
     }
break;
case 67:
#line 630 "parse.y"
{
	     if (yyvsp[0].number == 0)
		     yyerror("zero timeout");
	     if (yyvsp[0].number > INT_MAX / 1000)
		     yyerror("timeout too long: %lld", yyvsp[0].number);
	     conf.timeout = yyvsp[0].number * 1000;
     }
break;
case 68:
#line 638 "parse.y"
{
	     if (yyvsp[0].number == 0)
		     yyerror("zero queue-high");
	     if (yyvsp[0].number > MAXQUEUEVALUE)
		     yyerror("queue-high too big: %lld", yyvsp[0].number);
	     if (conf.queue_low != -1 && yyvsp[0].number <= conf.queue_low)
		     yyerror("queue-high must be larger than queue-low");
	     conf.queue_high = yyvsp[0].number;
     }
break;
case 69:
#line 648 "parse.y"
{
	     if (yyvsp[0].number > MAXQUEUEVALUE)
		     yyerror("queue-low too big: %lld", yyvsp[0].number);
	     if (conf.queue_high == -1)
		     yyerror("queue-high not specified");
	     if (yyvsp[0].number >= conf.queue_high)
		     yyerror("queue-low must be smaller than queue-high");
	     conf.queue_low = yyvsp[0].number;
     }
break;
case 70:
#line 658 "parse.y"
{
	     if (yyvsp[0].number > INT_MAX)
		     yyerror("parallel-accounts too big: %lld", yyvsp[0].number);
	     if (yyvsp[0].number == 0)
		     yyerror("parallel-accounts cannot be zero");
	     conf.max_accts = yyvsp[0].number;
     }
break;
case 71:
#line 666 "parse.y"
{
	     if (conf.proxy != NULL) {
		     xfree(conf.proxy->server.host);
		     xfree(conf.proxy->server.port);
		     if (conf.proxy->user != NULL)
			     xfree(conf.proxy->user);
		     if (conf.proxy->pass != NULL)
			     xfree(conf.proxy->pass);
	     }
	     if ((conf.proxy = getproxy(yyvsp[0].string)) == NULL)
		     yyerror("invalid proxy");
	     xfree(yyvsp[0].string);
     }
break;
case 72:
#line 680 "parse.y"
{
	     conf.verify_certs = 1;
     }
break;
case 73:
#line 684 "parse.y"
{
	     conf.impl_act = DECISION_KEEP;
     }
break;
case 74:
#line 688 "parse.y"
{
	     conf.impl_act = DECISION_DROP;
     }
break;
case 75:
#line 692 "parse.y"
{
	     if (yyvsp[0].number == 0)
		     yyerror("invalid purge-after value: 0");
	     if (yyvsp[0].number > UINT_MAX)
		     yyerror("purge-after value too large: %lld", yyvsp[0].number);

	     conf.purge_after = yyvsp[0].number;
     }
break;
case 76:
#line 701 "parse.y"
{
	     conf.purge_after = 0;
     }
break;
case 77:
#line 705 "parse.y"
{
	     conf.no_received = 1;
     }
break;
case 78:
#line 709 "parse.y"
{
	     conf.no_create = 1;
     }
break;
case 79:
#line 713 "parse.y"
{
	     conf.file_group = -1;
     }
break;
case 80:
#line 717 "parse.y"
{
	     conf.file_group = yyvsp[0].localgid;
     }
break;
case 81:
#line 721 "parse.y"
{
	     conf.file_umask = umask(0);
	     umask(conf.file_umask);
     }
break;
case 82:
#line 726 "parse.y"
{
	     ARRAY_FREEALL(conf.user_order);
	     conf.user_order = yyvsp[0].ufns;
     }
break;
case 83:
#line 731 "parse.y"
{
	     char	s[8];
	     u_int	n;

	     /*
	      * We can't differentiate umasks in octal from normal numbers
	      * (requiring a leading zero a la C would be nice, but it would
	      * potentially break existing configs), so we need to fiddle to
	      * convert.
	      */
	     memset(s, 0, sizeof s);
	     xsnprintf(s, sizeof s, "%03lld", yyvsp[0].number);
	     if (s[3] != '\0' || s[0] < '0' || s[0] > '7' ||
		 s[1] < 0 || s[1] > '7' || s[2] < '0' || s[2] > '7')
		     yyerror("invalid umask: %s", s);
	     if (sscanf(s, "%o", &n) != 1)
		     yyerror("invalid umask: %s", s);
	     conf.file_umask = n;
     }
break;
case 84:
#line 752 "parse.y"
{
		  struct macro	*macro;

		  if (strlen(yyvsp[-2].string) > MAXNAMESIZE)
			  yyerror("macro name too long: %s", yyvsp[-2].string);

		  macro = xmalloc(sizeof *macro);
		  strlcpy(macro->name, yyvsp[-2].string, sizeof macro->name);
		  macro->type = MACRO_STRING;
		  macro->value.str = yyvsp[0].string;

		  if (parse_last == NULL)
			  TAILQ_INSERT_HEAD(&parse_macros, macro, entry);
		  else {
			  TAILQ_INSERT_AFTER(
			      &parse_macros, parse_last, macro, entry);
		  }

		  log_debug3("added macro \"%s\": \"%s\"", macro->name,
		      macro->value.str);
		  xfree(yyvsp[-2].string);
	  }
break;
case 85:
#line 775 "parse.y"
{
		  struct macro	*macro;

		  if (strlen(yyvsp[-2].string) > MAXNAMESIZE)
			  yyerror("macro name too long: %s", yyvsp[-2].string);

		  macro = xmalloc(sizeof *macro);
		  strlcpy(macro->name, yyvsp[-2].string, sizeof macro->name);
		  macro->type = MACRO_NUMBER;
		  macro->value.num = yyvsp[0].number;

		  if (parse_last == NULL)
			  TAILQ_INSERT_HEAD(&parse_macros, macro, entry);
		  else {
			  TAILQ_INSERT_AFTER(
			      &parse_macros, parse_last, macro, entry);
		  }

		  log_debug3("added macro \"%s\": %lld", macro->name,
		      macro->value.num);
		  xfree(yyvsp[-2].string);
	  }
break;
case 86:
#line 799 "parse.y"
{
		      if (*yyvsp[0].string == '\0')
			      yyerror("empty string in list");

		      yyval.replstrs = yyvsp[-1].replstrs;
		      ARRAY_EXPAND(yyval.replstrs, 1);
		      ARRAY_LAST(yyval.replstrs).str = yyvsp[0].string;
	      }
break;
case 87:
#line 808 "parse.y"
{
		      if (*yyvsp[0].string == '\0')
			     yyerror("empty string in list");

		      yyval.replstrs = xmalloc(sizeof *yyval.replstrs);
		      ARRAY_INIT(yyval.replstrs);
		      ARRAY_EXPAND(yyval.replstrs, 1);
		      ARRAY_LAST(yyval.replstrs).str = yyvsp[0].string;
	      }
break;
case 88:
#line 819 "parse.y"
{
		     if (*yyvsp[0].string == '\0')
			     yyerror("empty string in list");

		     yyval.strings = yyvsp[-1].strings;
		     ARRAY_ADD(yyval.strings, yyvsp[0].string);
	     }
break;
case 89:
#line 827 "parse.y"
{
		     if (*yyvsp[0].string == '\0')
			     yyerror("empty string in list");

		     yyval.strings = xmalloc(sizeof *yyval.strings);
		     ARRAY_INIT(yyval.strings);
		     ARRAY_ADD(yyval.strings, yyvsp[0].string);
	     }
break;
case 90:
#line 837 "parse.y"
{
		   if (*yyvsp[0].string == '\0')
			   yyerror("invalid path");

		   yyval.strings = yyvsp[-1].strings;
		   ARRAY_ADD(yyval.strings, yyvsp[0].string);
	   }
break;
case 91:
#line 845 "parse.y"
{
		   if (*yyvsp[0].string == '\0')
			   yyerror("invalid path");

		   yyval.strings = xmalloc(sizeof *yyval.strings);
		   ARRAY_INIT(yyval.strings);
		   ARRAY_ADD(yyval.strings, yyvsp[0].string);
	   }
break;
case 92:
#line 855 "parse.y"
{
	     yyval.ufn = &passwd_lookup;
     }
break;
case 93:
#line 860 "parse.y"
{
		 yyval.ufns = yyvsp[-1].ufns;
		 ARRAY_ADD(yyval.ufns, yyvsp[0].ufn);
	 }
break;
case 94:
#line 865 "parse.y"
{
		 yyval.ufns = xmalloc(sizeof *yyval.ufns);
		 ARRAY_INIT(yyval.ufns);
		 ARRAY_ADD(yyval.ufns, yyvsp[0].ufn);
	 }
break;
case 95:
#line 872 "parse.y"
{
		   if (*yyvsp[0].string == '\0')
			   yyerror("invalid header");

		   yyval.replstrs = xmalloc(sizeof *yyval.replstrs);
		   ARRAY_INIT(yyval.replstrs);
		   ARRAY_EXPAND(yyval.replstrs, 1);
		   ARRAY_LAST(yyval.replstrs).str = yyvsp[0].string;
	   }
break;
case 96:
#line 882 "parse.y"
{
		   yyval.replstrs = yyvsp[-1].replstrs;
	   }
break;
case 97:
#line 887 "parse.y"
{
		  if (*yyvsp[0].string == '\0')
			  yyerror("invalid path");

		  yyval.strings = xmalloc(sizeof *yyval.strings);
		  ARRAY_INIT(yyval.strings);
		  ARRAY_ADD(yyval.strings, yyvsp[0].string);
	  }
break;
case 98:
#line 896 "parse.y"
{
		  yyval.strings = yyvsp[-1].strings;
	  }
break;
case 99:
#line 901 "parse.y"
{
		if (*yyvsp[0].string == '\0')
			yyerror("invalid path");

		yyval.strings = xmalloc(sizeof *yyval.strings);
		ARRAY_INIT(yyval.strings);
		ARRAY_ADD(yyval.strings, yyvsp[0].string);
	}
break;
case 100:
#line 910 "parse.y"
{
		yyval.strings = yyvsp[-1].strings;
	}
break;
case 101:
#line 915 "parse.y"
{
		 if (*yyvsp[0].string == '\0')
			 yyerror("invalid folder");

		 yyval.strings = xmalloc(sizeof *yyval.strings);
		 ARRAY_INIT(yyval.strings);
		 ARRAY_ADD(yyval.strings, yyvsp[0].string);
	 }
break;
case 102:
#line 924 "parse.y"
{
		 yyval.strings = yyvsp[-1].strings;
	 }
break;
case 103:
#line 929 "parse.y"
{
	      yyval.locks = LOCK_FCNTL;
      }
break;
case 104:
#line 933 "parse.y"
{
	      yyval.locks = LOCK_FLOCK;
      }
break;
case 105:
#line 937 "parse.y"
{
	      yyval.locks = LOCK_DOTLOCK;
      }
break;
case 106:
#line 942 "parse.y"
{
		  yyval.locks = yyvsp[-1].locks | yyvsp[0].locks;
	  }
break;
case 107:
#line 946 "parse.y"
{
		  yyval.locks = yyvsp[0].locks;
	  }
break;
case 108:
#line 950 "parse.y"
{
		  yyval.locks = 0;
	  }
break;
case 109:
#line 955 "parse.y"
{
		  struct group	*gr;

		  if (*yyvsp[0].string == '\0')
			  yyerror("invalid group");

		  gr = getgrnam(yyvsp[0].string);
		  if (gr == NULL)
			  yyerror("unknown group: %s", yyvsp[0].string);
		  yyval.localgid = gr->gr_gid;
		  endgrent();

		  xfree(yyvsp[0].string);
	  }
break;
case 110:
#line 970 "parse.y"
{
		  struct group	*gr;

		  if (yyvsp[0].number > GID_MAX)
			  yyerror("invalid gid: %llu", yyvsp[0].number);
		  gr = getgrgid(yyvsp[0].number);
		  if (gr == NULL)
			  yyerror("unknown gid: %llu", yyvsp[0].number);
		  yyval.localgid = gr->gr_gid;
		  endgrent();
	  }
break;
case 111:
#line 983 "parse.y"
{
	      yyval.string = NULL;
      }
break;
case 112:
#line 987 "parse.y"
{
	      yyval.string = yyvsp[0].string;
      }
break;
case 113:
#line 992 "parse.y"
{
	       yyval.replstrs = NULL;
       }
break;
case 114:
#line 996 "parse.y"
{
	       yyval.replstrs = xmalloc(sizeof *yyval.replstrs);
	       ARRAY_INIT(yyval.replstrs);
	       ARRAY_EXPAND(yyval.replstrs, 1);
	       ARRAY_LAST(yyval.replstrs).str = yyvsp[0].string;
       }
break;
case 115:
#line 1003 "parse.y"
{
	       yyval.replstrs = yyvsp[-1].replstrs;
       }
break;
case 116:
#line 1008 "parse.y"
{
		/* match case */
		yyval.re.flags = 0;
		yyval.re.str = yyvsp[0].string;
        }
break;
case 117:
#line 1014 "parse.y"
{
		/* ignore case */
		yyval.re.flags = RE_IGNCASE;
		yyval.re.str = yyvsp[0].string;
	}
break;
case 118:
#line 1021 "parse.y"
{
	      yyval.flag = 1;
      }
break;
case 119:
#line 1025 "parse.y"
{
	      yyval.flag = 0;
      }
break;
case 120:
#line 1030 "parse.y"
{
	      yyval.flag = 1;
      }
break;
case 121:
#line 1034 "parse.y"
{
	      yyval.flag = 0;
      }
break;
case 122:
#line 1039 "parse.y"
{
		  yyval.flag = 1;
          }
break;
case 123:
#line 1043 "parse.y"
{
		  yyval.flag = 0;
	  }
break;
case 124:
#line 1048 "parse.y"
{
	      if (*yyvsp[0].string == '\0')
		      yyerror("invalid port");

	      yyval.string = yyvsp[0].string;
      }
break;
case 125:
#line 1055 "parse.y"
{
	      if (yyvsp[0].number == 0 || yyvsp[0].number > 65535)
		      yyerror("invalid port");

	      xasprintf(&yyval.string, "%lld", yyvsp[0].number);
      }
break;
case 126:
#line 1063 "parse.y"
{
		if (*yyvsp[-1].string == '\0')
			yyerror("invalid host");

		yyval.server.host = yyvsp[-1].string;
		yyval.server.port = yyvsp[0].string;
	}
break;
case 127:
#line 1071 "parse.y"
{
		if (*yyvsp[0].string == '\0')
			yyerror("invalid host");

		yyval.server.host = yyvsp[0].string;
		yyval.server.port = NULL;
	}
break;
case 128:
#line 1080 "parse.y"
{
	    yyval.string = NULL;
    }
break;
case 129:
#line 1084 "parse.y"
{
	    yyval.string = yyvsp[0].string;
    }
break;
case 130:
#line 1089 "parse.y"
{
	      yyval.string = NULL;
      }
break;
case 131:
#line 1093 "parse.y"
{
	      yyval.string = yyvsp[0].string;
      }
break;
case 132:
#line 1098 "parse.y"
{
		  yyval.flag = 1;
	  }
break;
case 133:
#line 1102 "parse.y"
{
		  yyval.flag = 0;
	  }
break;
case 134:
#line 1107 "parse.y"
{
		 struct deliver_pipe_data	*data;

		 if (*yyvsp[0].string == '\0')
			 yyerror("invalid command");

		 yyval.actitem = xcalloc(1, sizeof *yyval.actitem);
		 yyval.actitem->deliver = &deliver_pipe;

		 data = xcalloc(1, sizeof *data);
		 yyval.actitem->data = data;

		 data->pipe = yyvsp[-1].flag;
		 data->cmd.str = yyvsp[0].string;
	 }
break;
case 135:
#line 1123 "parse.y"
{
		 struct deliver_rewrite_data	*data;

		 if (*yyvsp[0].string == '\0')
			 yyerror("invalid command");

		 yyval.actitem = xcalloc(1, sizeof *yyval.actitem);
		 yyval.actitem->deliver = &deliver_rewrite;

		 data = xcalloc(1, sizeof *data);
		 yyval.actitem->data = data;

		 data->cmd.str = yyvsp[0].string;
	 }
break;
case 136:
#line 1138 "parse.y"
{
		 struct deliver_write_data	*data;

		 if (*yyvsp[0].string == '\0')
			 yyerror("invalid path");

		 yyval.actitem = xcalloc(1, sizeof *yyval.actitem);
		 yyval.actitem->deliver = &deliver_write;

		 data = xcalloc(1, sizeof *data);
		 yyval.actitem->data = data;

		 data->append = yyvsp[-1].flag;
		 data->path.str = yyvsp[0].string;
	 }
break;
case 137:
#line 1154 "parse.y"
{
		 struct deliver_maildir_data	*data;

		 if (*yyvsp[0].string == '\0')
			 yyerror("invalid path");

		 yyval.actitem = xcalloc(1, sizeof *yyval.actitem);
		 yyval.actitem->deliver = &deliver_maildir;

		 data = xcalloc(1, sizeof *data);
		 yyval.actitem->data = data;

		 data->path.str = yyvsp[0].string;
	 }
break;
case 138:
#line 1169 "parse.y"
{
		 struct deliver_remove_header_data *data;

		 yyval.actitem = xcalloc(1, sizeof *yyval.actitem);
		 yyval.actitem->deliver = &deliver_remove_header;

		 data = xcalloc(1, sizeof *data);
		 yyval.actitem->data = data;

		 data->hdrs = yyvsp[0].replstrs;
	 }
break;
case 139:
#line 1181 "parse.y"
{
		 struct deliver_add_header_data	*data;

		 if (*yyvsp[-1].string == '\0')
			 yyerror("invalid header");

		 yyval.actitem = xcalloc(1, sizeof *yyval.actitem);
		 yyval.actitem->deliver = &deliver_add_header;

		 data = xcalloc(1, sizeof *data);
		 yyval.actitem->data = data;

		 data->hdr.str = yyvsp[-1].string;
		 data->value.str = yyvsp[0].string;
	 }
break;
case 140:
#line 1197 "parse.y"
{
		 struct deliver_mbox_data	*data;

		 if (*yyvsp[-1].string == '\0')
			 yyerror("invalid path");

		 yyval.actitem = xcalloc(1, sizeof *yyval.actitem);
		 yyval.actitem->deliver = &deliver_mbox;

		 data = xcalloc(1, sizeof *data);
		 yyval.actitem->data = data;

		 data->path.str = yyvsp[-1].string;
		 data->compress = yyvsp[0].flag;
	 }
break;
case 141:
#line 1214 "parse.y"
{
		 struct deliver_imap_data	*data;

		 if (yyvsp[-8].flag && yyvsp[0].flag)
			 yyerror("use either imaps or set starttls");

		 yyval.actitem = xcalloc(1, sizeof *yyval.actitem);
		 yyval.actitem->deliver = &deliver_imap;

		 data = xcalloc(1, sizeof *data);
		 yyval.actitem->data = data;

		 if (yyvsp[-6].userpass.user_netrc && yyvsp[-6].userpass.pass_netrc)
			 find_netrc(yyvsp[-7].server.host, &data->user, &data->pass);
		 else {
			 if (yyvsp[-6].userpass.user_netrc)
				 find_netrc(yyvsp[-7].server.host, &data->user, NULL);
			 else
				 data->user = yyvsp[-6].userpass.user;
			 if (yyvsp[-6].userpass.pass_netrc)
				 find_netrc(yyvsp[-7].server.host, NULL, &data->pass);
			 else
				 data->pass = yyvsp[-6].userpass.pass;
		 }

		 data->folder.str = yyvsp[-5].string;
		 data->server.ssl = yyvsp[-8].flag;
		 data->server.verify = yyvsp[-4].flag;
		 data->server.tls1 = yyvsp[-1].flag;
		 data->server.host = yyvsp[-7].server.host;
		 if (yyvsp[-7].server.port != NULL)
			 data->server.port = yyvsp[-7].server.port;
		 else if (yyvsp[-8].flag)
			 data->server.port = xstrdup("imaps");
		 else
			 data->server.port = xstrdup("imap");
		 data->server.ai = NULL;
		 data->nocrammd5 = yyvsp[-3].flag;
		 data->nologin = yyvsp[-2].flag;
		 data->starttls = yyvsp[0].flag;
	 }
break;
case 142:
#line 1256 "parse.y"
{
		 struct deliver_smtp_data	*data;

		 yyval.actitem = xcalloc(1, sizeof *yyval.actitem);
		 yyval.actitem->deliver = &deliver_smtp;

		 data = xcalloc(1, sizeof *data);
		 yyval.actitem->data = data;

		 data->server.host = yyvsp[-2].server.host;
		 if (yyvsp[-2].server.port != NULL)
			 data->server.port = yyvsp[-2].server.port;
		 else
			 data->server.port = xstrdup("smtp");
		 data->server.ai = NULL;
		 data->from.str = yyvsp[-1].string;
		 data->to.str = yyvsp[0].string;
	 }
break;
case 143:
#line 1275 "parse.y"
{
		 yyval.actitem = xcalloc(1, sizeof *yyval.actitem);
		 yyval.actitem->deliver = &deliver_stdout;
	 }
break;
case 144:
#line 1280 "parse.y"
{
		 struct deliver_tag_data	*data;

		 if (*yyvsp[-1].string == '\0')
			 yyerror("invalid tag");

		 yyval.actitem = xcalloc(1, sizeof *yyval.actitem);
		 yyval.actitem->deliver = &deliver_tag;

		 data = xcalloc(1, sizeof *data);
		 yyval.actitem->data = data;

		 data->key.str = yyvsp[-1].string;
		 data->value.str = yyvsp[0].string;
	 }
break;
case 145:
#line 1296 "parse.y"
{
		 struct deliver_add_to_cache_data	*data;

		 if (*yyvsp[-2].string == '\0')
			 yyerror("invalid path");
		 if (*yyvsp[0].string == '\0')
			 yyerror("invalid key");

		 yyval.actitem = xcalloc(1, sizeof *yyval.actitem);
		 yyval.actitem->deliver = &deliver_add_to_cache;

		 data = xcalloc(1, sizeof *data);
		 yyval.actitem->data = data;

		 data->key.str = yyvsp[0].string;
		 data->path = yyvsp[-2].string;
	 }
break;
case 146:
#line 1314 "parse.y"
{
		 struct deliver_remove_from_cache_data	*data;

		 if (*yyvsp[-2].string == '\0')
			 yyerror("invalid path");
		 if (*yyvsp[0].string == '\0')
			 yyerror("invalid key");

		 yyval.actitem = xcalloc(1, sizeof *yyval.actitem);
		 yyval.actitem->deliver = &deliver_remove_from_cache;

		 data = xcalloc(1, sizeof *data);
		 yyval.actitem->data = data;

		 data->key.str = yyvsp[0].string;
		 data->path = yyvsp[-2].string;
	 }
break;
case 147:
#line 1332 "parse.y"
{
		 struct deliver_action_data	*data;

		 /*
		  * This is a special-case, handled when the list of delivery
		  * targets is resolved rather than by calling a deliver
		  * function, so the deliver pointer is NULL.
		  */
		 yyval.actitem = xcalloc(1, sizeof *yyval.actitem);
		 yyval.actitem->deliver = NULL;

		 data = xcalloc(1, sizeof *data);
		 yyval.actitem->data = data;

		 data->actions = yyvsp[0].replstrs;
 	 }
break;
case 148:
#line 1349 "parse.y"
{
		 yyval.actitem = xcalloc(1, sizeof *yyval.actitem);
		 yyval.actitem->deliver = &deliver_drop;
	 }
break;
case 149:
#line 1354 "parse.y"
{
		 yyval.actitem = xcalloc(1, sizeof *yyval.actitem);
		 yyval.actitem->deliver = &deliver_keep;
	 }
break;
case 150:
#line 1360 "parse.y"
{
		 yyval.actlist = yyvsp[-1].actlist;

		 TAILQ_INSERT_TAIL(yyval.actlist, yyvsp[0].actitem, entry);
		 yyvsp[0].actitem->idx = parse_actionidx++;
	 }
break;
case 151:
#line 1367 "parse.y"
{
		 yyval.actlist = xmalloc(sizeof *yyval.actlist);
		 TAILQ_INIT(yyval.actlist);

		 TAILQ_INSERT_HEAD(yyval.actlist, yyvsp[0].actitem, entry);
		 yyvsp[0].actitem->idx = 0;

		 parse_actionidx = 1;
	 }
break;
case 152:
#line 1378 "parse.y"
{
		   struct action	*t;

		   if (strlen(yyvsp[-2].string) >= MAXNAMESIZE)
			   yyerror("action name too long: %s", yyvsp[-2].string);
		   if (*yyvsp[-2].string == '\0')
			   yyerror("invalid action name");
		   if (find_action(yyvsp[-2].string) != NULL)
			   yyerror("duplicate action: %s", yyvsp[-2].string);

		   t = xmalloc(sizeof *t);
		   strlcpy(t->name, yyvsp[-2].string, sizeof t->name);

		   t->list = xmalloc(sizeof *t->list);
		   TAILQ_INIT(t->list);
		   TAILQ_INSERT_HEAD(t->list, yyvsp[0].actitem, entry);
		   yyvsp[0].actitem->idx = 0;

		   t->users = yyvsp[-1].replstrs;
		   TAILQ_INSERT_TAIL(&conf.actions, t, entry);

		   print_action(t);

		   xfree(yyvsp[-2].string);
	   }
break;
case 153:
#line 1404 "parse.y"
{
		   struct action	*t;

		   if (strlen(yyvsp[-4].string) >= MAXNAMESIZE)
			   yyerror("action name too long: %s", yyvsp[-4].string);
		   if (*yyvsp[-4].string == '\0')
			   yyerror("invalid action name");
		   if (find_action(yyvsp[-4].string) != NULL)
			   yyerror("duplicate action: %s", yyvsp[-4].string);

		   t = xmalloc(sizeof *t);
		   strlcpy(t->name, yyvsp[-4].string, sizeof t->name);

		   t->list = yyvsp[-1].actlist;

		   t->users = yyvsp[-3].replstrs;
		   TAILQ_INSERT_TAIL(&conf.actions, t, entry);

		   print_action(t);

		   xfree(yyvsp[-4].string);
	   }
break;
case 154:
#line 1428 "parse.y"
{
		  if (*yyvsp[0].string == '\0')
			  yyerror("invalid account name");
		  if (!have_accounts(yyvsp[0].string))
			  yyerror("no matching accounts: %s", yyvsp[0].string);

		  yyval.replstrs = xmalloc(sizeof *yyval.replstrs);
		  ARRAY_INIT(yyval.replstrs);
		  ARRAY_EXPAND(yyval.replstrs, 1);
		  ARRAY_LAST(yyval.replstrs).str = yyvsp[0].string;
	  }
break;
case 155:
#line 1440 "parse.y"
{
		  yyval.replstrs = yyvsp[-1].replstrs;
	  }
break;
case 156:
#line 1445 "parse.y"
{
		 if (*yyvsp[0].string == '\0')
			 yyerror("invalid action name");

		 yyval.replstrs = xmalloc(sizeof *yyval.replstrs);
		 ARRAY_INIT(yyval.replstrs);
		 ARRAY_EXPAND(yyval.replstrs, 1);
		 ARRAY_LAST(yyval.replstrs).str = yyvsp[0].string;
	 }
break;
case 157:
#line 1455 "parse.y"
{
		 yyval.replstrs = yyvsp[-1].replstrs;
	 }
break;
case 158:
#line 1460 "parse.y"
{
	      yyval.flag = 0;
      }
break;
case 159:
#line 1464 "parse.y"
{
	      yyval.flag = 1;
      }
break;
case 160:
#line 1469 "parse.y"
{
	      yyval.area = AREA_ANY;
      }
break;
case 161:
#line 1473 "parse.y"
{
	      yyval.area = AREA_ANY;
      }
break;
case 162:
#line 1477 "parse.y"
{
	      yyval.area = AREA_HEADERS;
      }
break;
case 163:
#line 1481 "parse.y"
{
	      yyval.area = AREA_BODY;
      }
break;
case 164:
#line 1486 "parse.y"
{
	       if (yyvsp[0].number < 0 || yyvsp[0].number > 255)
		       yyerror("invalid return code");

	       yyval.number = yyvsp[0].number;
       }
break;
case 165:
#line 1493 "parse.y"
{
	       yyval.number = -1;
       }
break;
case 166:
#line 1498 "parse.y"
{
	       yyval.re = yyvsp[0].re;
       }
break;
case 167:
#line 1502 "parse.y"
{
	       yyval.re.str = NULL;
       }
break;
case 168:
#line 1507 "parse.y"
{
	     yyval.cmp = CMP_LT;
     }
break;
case 169:
#line 1511 "parse.y"
{
	     yyval.cmp = CMP_GT;
     }
break;
case 170:
#line 1516 "parse.y"
{
	      yyval.cmp = CMP_EQ;
      }
break;
case 171:
#line 1520 "parse.y"
{
	      yyval.cmp = CMP_NE;
      }
break;
case 172:
#line 1525 "parse.y"
{
	     yyval.cmp = yyvsp[0].cmp;
     }
break;
case 173:
#line 1529 "parse.y"
{
	     yyval.cmp = yyvsp[0].cmp;
     }
break;
case 174:
#line 1534 "parse.y"
{
		  yyval.flag = 0;
	  }
break;
case 175:
#line 1538 "parse.y"
{
		  yyval.flag = 1;
	  }
break;
case 176:
#line 1543 "parse.y"
{
		     yyval.flag = 0;
	     }
break;
case 177:
#line 1547 "parse.y"
{
		     yyval.flag = 1;
	     }
break;
case 178:
#line 1552 "parse.y"
{
		yyval.exprop = OP_AND;
        }
break;
case 179:
#line 1556 "parse.y"
{
		yyval.exprop = OP_OR;
	}
break;
case 180:
#line 1561 "parse.y"
{
		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);
		  yyval.expritem->match = &match_all;
		  yyval.expritem->inverted = yyvsp[-1].flag;
	  }
break;
case 181:
#line 1567 "parse.y"
{
		  struct match_regexp_data	*data;
		  char				*cause;

		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);
		  yyval.expritem->match = &match_regexp;
		  yyval.expritem->inverted = yyvsp[-2].flag;

		  data = xcalloc(1, sizeof *data);
		  yyval.expritem->data = data;

		  data->area = yyvsp[0].area;

		  if (re_compile(&data->re, yyvsp[-1].re.str, yyvsp[-1].re.flags, &cause) != 0)
			  yyerror("%s", cause);
		  xfree(yyvsp[-1].re.str);
	  }
break;
case 182:
#line 1585 "parse.y"
{
		  struct match_account_data	*data;

		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);
		  yyval.expritem->match = &match_account;
		  yyval.expritem->inverted = yyvsp[-1].flag;

		  data = xcalloc(1, sizeof *data);
		  yyval.expritem->data = data;

		  data->accounts = yyvsp[0].replstrs;
	  }
break;
case 183:
#line 1598 "parse.y"
{
		  struct match_command_data	*data;
		  char				*cause;

		  if (*yyvsp[-7].string == '\0' || (yyvsp[-7].string[0] == '|' && yyvsp[-7].string[1] == '\0'))
			  yyerror("invalid command");
		  if (yyvsp[-3].number == -1 && yyvsp[-1].re.str == NULL)
			  yyerror("return code or regexp must be specified");

		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);
		  yyval.expritem->match = &match_command;
		  yyval.expritem->inverted = yyvsp[-9].flag;

		  data = xcalloc(1, sizeof *data);
		  yyval.expritem->data = data;

		  data->user.str = yyvsp[-6].string;
		  data->pipe = yyvsp[-8].flag;
		  data->cmd.str = yyvsp[-7].string;

		  data->ret = yyvsp[-3].number;

		  if (yyvsp[-1].re.str != NULL) {
			  if (re_compile(
			      &data->re, yyvsp[-1].re.str, yyvsp[-1].re.flags, &cause) != 0)
				  yyerror("%s", cause);
			  xfree(yyvsp[-1].re.str);
		  }

	  }
break;
case 184:
#line 1629 "parse.y"
{
		  struct match_tagged_data	*data;

		  if (*yyvsp[0].string == '\0')
			  yyerror("invalid tag");

		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);

		  yyval.expritem->match = &match_tagged;
		  yyval.expritem->inverted = yyvsp[-2].flag;

		  data = xcalloc(1, sizeof *data);
		  yyval.expritem->data = data;

		  data->tag.str = yyvsp[0].string;
	  }
break;
case 185:
#line 1646 "parse.y"
{
		  struct match_size_data	*data;

#if SIZE_MAX < LLONG_MAX
		  if (yyvsp[0].number > SIZE_MAX)
			  yyerror("size too large");
#endif

		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);

		  yyval.expritem->match = &match_size;
		  yyval.expritem->inverted = yyvsp[-3].flag;

		  data = xcalloc(1, sizeof *data);
		  yyval.expritem->data = data;

		  data->size = yyvsp[0].number;
		  data->cmp = yyvsp[-1].cmp;
	  }
break;
case 186:
#line 1666 "parse.y"
{
		  struct match_string_data	*data;
		  char				*cause;

		  if (*yyvsp[-2].string == '\0')
			  yyerror("invalid string");

		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);

		  yyval.expritem->match = &match_string;
		  yyval.expritem->inverted = yyvsp[-4].flag;

		  data = xcalloc(1, sizeof *data);
		  yyval.expritem->data = data;

		  data->str.str = yyvsp[-2].string;
		  if (re_compile(
		      &data->re, yyvsp[0].re.str, yyvsp[0].re.flags|RE_NOSUBST, &cause) != 0)
			  yyerror("%s", cause);
		  xfree(yyvsp[0].re.str);
	  }
break;
case 187:
#line 1688 "parse.y"
{
		  struct match_in_cache_data	*data;

		  if (*yyvsp[-2].string == '\0')
			  yyerror("invalid path");
		  if (*yyvsp[0].string == '\0')
			  yyerror("invalid key");

		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);

		  yyval.expritem->match = &match_in_cache;
		  yyval.expritem->inverted = yyvsp[-4].flag;

		  data = xcalloc(1, sizeof *data);
		  yyval.expritem->data = data;

		  data->key.str = yyvsp[0].string;
		  data->path = yyvsp[-2].string;
	  }
break;
case 188:
#line 1708 "parse.y"
{
		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);

		  yyval.expritem->match = &match_matched;
		  yyval.expritem->inverted = yyvsp[-1].flag;
          }
break;
case 189:
#line 1715 "parse.y"
{
		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);

		  yyval.expritem->match = &match_unmatched;
		  yyval.expritem->inverted = yyvsp[-1].flag;
          }
break;
case 190:
#line 1722 "parse.y"
{
		  struct match_age_data	*data;

		  if (yyvsp[0].number == 0)
			  yyerror("invalid time");

		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);

		  yyval.expritem->match = &match_age;
		  yyval.expritem->inverted = yyvsp[-3].flag;

		  data = xcalloc(1, sizeof *data);
		  yyval.expritem->data = data;

		  data->time = yyvsp[0].number;
		  data->cmp = yyvsp[-1].cmp;
	  }
break;
case 191:
#line 1740 "parse.y"
{
		  struct match_age_data	*data;

		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);

		  yyval.expritem->match = &match_age;
		  yyval.expritem->inverted = yyvsp[-2].flag;

		  data = xcalloc(1, sizeof *data);
		  yyval.expritem->data = data;

		  data->time = -1;
	  }
break;
case 192:
#line 1754 "parse.y"
{
		  struct match_attachment_data	*data;

		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);

		  yyval.expritem->match = &match_attachment;
		  yyval.expritem->inverted = yyvsp[-4].flag;

		  data = xcalloc(1, sizeof *data);
		  yyval.expritem->data = data;

		  data->op = ATTACHOP_COUNT;
		  data->cmp = yyvsp[-1].cmp;
		  data->value.num = yyvsp[0].number;
	  }
break;
case 193:
#line 1770 "parse.y"
{
		  struct match_attachment_data	*data;

#if SIZE_MAX < LLONG_MAX
		  if (yyvsp[0].number > SIZE_MAX)
			  yyerror("size too large");
#endif

		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);

		  yyval.expritem->match = &match_attachment;
		  yyval.expritem->inverted = yyvsp[-4].flag;

		  data = xcalloc(1, sizeof *data);
		  yyval.expritem->data = data;

		  data->op = ATTACHOP_TOTALSIZE;
		  data->cmp = yyvsp[-1].cmp;
		  data->value.size = yyvsp[0].number;
	  }
break;
case 194:
#line 1791 "parse.y"
{
		  struct match_attachment_data	*data;

#if SIZE_MAX < LLONG_MAX
		  if (yyvsp[0].number > SIZE_MAX)
			  yyerror("size too large");
#endif

		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);

		  yyval.expritem->match = &match_attachment;
		  yyval.expritem->inverted = yyvsp[-4].flag;

		  data = xcalloc(1, sizeof *data);
		  yyval.expritem->data = data;

		  data->op = ATTACHOP_ANYSIZE;
		  data->cmp = yyvsp[-1].cmp;
		  data->value.size = yyvsp[0].number;
	  }
break;
case 195:
#line 1812 "parse.y"
{
		  struct match_attachment_data	*data;

		  if (*yyvsp[0].string == '\0')
			  yyerror("invalid string");

		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);

		  yyval.expritem->match = &match_attachment;
		  yyval.expritem->inverted = yyvsp[-3].flag;

		  data = xcalloc(1, sizeof *data);
		  yyval.expritem->data = data;

		  data->op = ATTACHOP_ANYTYPE;
		  data->value.str.str = yyvsp[0].string;
	  }
break;
case 196:
#line 1830 "parse.y"
{
		  struct match_attachment_data	*data;

		  if (*yyvsp[0].string == '\0')
			  yyerror("invalid string");

		  yyval.expritem = xcalloc(1, sizeof *yyval.expritem);

		  yyval.expritem->match = &match_attachment;
		  yyval.expritem->inverted = yyvsp[-3].flag;

		  data = xcalloc(1, sizeof *data);
		  yyval.expritem->data = data;

		  data->op = ATTACHOP_ANYNAME;
		  data->value.str.str = yyvsp[0].string;
	  }
break;
case 197:
#line 1849 "parse.y"
{
		  yyval.expr = yyvsp[-2].expr;

		  yyvsp[0].expritem->op = yyvsp[-1].exprop;
		  TAILQ_INSERT_TAIL(yyval.expr, yyvsp[0].expritem, entry);
	  }
break;
case 198:
#line 1856 "parse.y"
{
		  yyval.expr = xmalloc(sizeof *yyval.expr);
		  TAILQ_INIT(yyval.expr);

		  yyvsp[0].expritem->op = yyvsp[-1].exprop;
		  TAILQ_INSERT_HEAD(yyval.expr, yyvsp[0].expritem, entry);
	  }
break;
case 199:
#line 1865 "parse.y"
{
	      yyval.expr = xmalloc(sizeof *yyval.expr);
	      TAILQ_INIT(yyval.expr);

	      TAILQ_INSERT_HEAD(yyval.expr, yyvsp[0].expritem, entry);
      }
break;
case 200:
#line 1872 "parse.y"
{
	      yyval.expr = yyvsp[0].expr;

	      TAILQ_INSERT_HEAD(yyval.expr, yyvsp[-1].expritem, entry);
      }
break;
case 201:
#line 1879 "parse.y"
{
		 struct action	*t;

		 yyval.rule = xcalloc(1, sizeof *yyval.rule);
		 yyval.rule->idx = parse_ruleidx++;
		 yyval.rule->actions = NULL;
		 TAILQ_INIT(&yyval.rule->rules);
		 yyval.rule->stop = !yyvsp[0].flag;
		 yyval.rule->users = yyvsp[-3].replstrs;

		 t = yyval.rule->lambda = xcalloc(1, sizeof *yyval.rule->lambda);
		 xsnprintf(t->name, sizeof t->name, "<rule %u>", yyval.rule->idx);
		 t->users = NULL;
		 t->list = xmalloc(sizeof *t->list);
		 TAILQ_INIT(t->list);
		 TAILQ_INSERT_HEAD(t->list, yyvsp[-1].actitem, entry);
		 yyvsp[-1].actitem->idx = 0;

		 if (parse_rule == NULL)
			 TAILQ_INSERT_TAIL(&conf.rules, yyval.rule, entry);
		 else
			 TAILQ_INSERT_TAIL(&parse_rule->rules, yyval.rule, entry);
	 }
break;
case 202:
#line 1903 "parse.y"
{
		 struct action	*t;

		 yyval.rule = xcalloc(1, sizeof *yyval.rule);
		 yyval.rule->idx = parse_ruleidx++;
		 yyval.rule->actions = NULL;
		 TAILQ_INIT(&yyval.rule->rules);
		 yyval.rule->stop = !yyvsp[0].flag;
		 yyval.rule->users = yyvsp[-5].replstrs;

		 t = yyval.rule->lambda = xcalloc(1, sizeof *yyval.rule->lambda);
		 xsnprintf(t->name, sizeof t->name, "<rule %u>", yyval.rule->idx);
		 t->users = NULL;
		 t->list = yyvsp[-2].actlist;

		 if (parse_rule == NULL)
			 TAILQ_INSERT_TAIL(&conf.rules, yyval.rule, entry);
		 else
			 TAILQ_INSERT_TAIL(&parse_rule->rules, yyval.rule, entry);
	 }
break;
case 203:
#line 1924 "parse.y"
{
		 yyval.rule = xcalloc(1, sizeof *yyval.rule);
		 yyval.rule->idx = parse_ruleidx++;
		 yyval.rule->lambda = NULL;
		 yyval.rule->actions = yyvsp[-1].replstrs;
		 TAILQ_INIT(&yyval.rule->rules);
		 yyval.rule->stop = !yyvsp[0].flag;
		 yyval.rule->users = yyvsp[-2].replstrs;

		 if (parse_rule == NULL)
			 TAILQ_INSERT_TAIL(&conf.rules, yyval.rule, entry);
		 else
			 TAILQ_INSERT_TAIL(&parse_rule->rules, yyval.rule, entry);
	 }
break;
case 204:
#line 1939 "parse.y"
{
		 yyval.rule = xcalloc(1, sizeof *yyval.rule);
		 yyval.rule->idx = parse_ruleidx++;
		 yyval.rule->lambda = NULL;
		 yyval.rule->actions = NULL;
		 TAILQ_INIT(&yyval.rule->rules);
		 yyval.rule->stop = 0;
		 yyval.rule->users = NULL;

		 if (parse_rule == NULL)
			 TAILQ_INSERT_TAIL(&conf.rules, yyval.rule, entry);
		 else
			 TAILQ_INSERT_TAIL(&parse_rule->rules, yyval.rule, entry);

		 ARRAY_ADD(&parse_rulestack, parse_rule);
		 parse_rule = yyval.rule;
	 }
break;
case 205:
#line 1958 "parse.y"
{
	       if (parse_rule == NULL)
		       yyerror("missing {");

	       parse_rule = ARRAY_LAST(&parse_rulestack);
	       ARRAY_TRUNC(&parse_rulestack, 1);
       }
break;
case 206:
#line 1967 "parse.y"
{
	      yyvsp[0].rule->expr = yyvsp[-1].expr;
	      print_rule(yyvsp[0].rule);
      }
break;
case 207:
#line 1973 "parse.y"
{
		    yyval.strings = xmalloc(sizeof *yyval.strings);
		    ARRAY_INIT(yyval.strings);
		    ARRAY_ADD(yyval.strings, xstrdup("INBOX"));
	    }
break;
case 208:
#line 1979 "parse.y"
{
		    yyval.strings = yyvsp[0].strings;
	    }
break;
case 209:
#line 1984 "parse.y"
{
		 yyval.string = xstrdup("INBOX");
	 }
break;
case 210:
#line 1988 "parse.y"
{
		 yyval.string = yyvsp[0].string;
	 }
break;
case 211:
#line 1994 "parse.y"
{
		if (*yyvsp[0].string == '\0')
			yyerror("invalid group");

		yyval.strings = xmalloc(sizeof *yyval.strings);
		ARRAY_INIT(yyval.strings);
		ARRAY_ADD(yyval.strings, yyvsp[0].string);
	}
break;
case 212:
#line 2003 "parse.y"
{
		yyval.strings = yyvsp[-1].strings;
	}
break;
case 213:
#line 2008 "parse.y"
{
		   yyval.flag = 1;
	   }
break;
case 214:
#line 2012 "parse.y"
{
		   yyval.flag = 0;
	   }
break;
case 215:
#line 2017 "parse.y"
{
		 yyval.flag = 1;
	 }
break;
case 216:
#line 2021 "parse.y"
{
		 yyval.flag = 0;
	 }
break;
case 217:
#line 2026 "parse.y"
{
		yyval.flag = 0;
	}
break;
case 218:
#line 2030 "parse.y"
{
		yyval.flag = 1;
	}
break;
case 219:
#line 2035 "parse.y"
{
		yyval.flag = 1;
	}
break;
case 220:
#line 2039 "parse.y"
{
		yyval.flag = 0;
	}
break;
case 221:
#line 2045 "parse.y"
{
		yyval.flag = 0;
	}
break;
case 222:
#line 2049 "parse.y"
{
		yyval.flag = 1;
	}
break;
case 223:
#line 2054 "parse.y"
{
		yyval.flag = 0;
	}
break;
case 224:
#line 2058 "parse.y"
{
		yyval.flag = 1;
	}
break;
case 225:
#line 2063 "parse.y"
{
	      yyval.flag = 0;
      }
break;
case 226:
#line 2067 "parse.y"
{
	      yyval.flag = 1;
      }
break;
case 227:
#line 2072 "parse.y"
{
	      yyval.only = FETCH_ONLY_NEW;
      }
break;
case 228:
#line 2076 "parse.y"
{
	      yyval.only = FETCH_ONLY_OLD;
      }
break;
case 229:
#line 2081 "parse.y"
{
		 yyval.flag = 0;
         }
break;
case 230:
#line 2085 "parse.y"
{
		 yyval.flag = 1;
	 }
break;
case 231:
#line 2090 "parse.y"
{
		  yyval.flag = 0;
          }
break;
case 232:
#line 2094 "parse.y"
{
		  yyval.flag = 1;
	  }
break;
case 233:
#line 2099 "parse.y"
{
		  yyval.flag = 0;
          }
break;
case 234:
#line 2103 "parse.y"
{
		  yyval.flag = 1;
	  }
break;
case 235:
#line 2108 "parse.y"
{
		       if (*yyvsp[-2].string == '\0')
			       yyerror("invalid user");
		       if (*yyvsp[0].string == '\0')
			       yyerror("invalid pass");

		       yyval.userpass.user = yyvsp[-2].string;
		       yyval.userpass.user_netrc = 0;
		       yyval.userpass.pass = yyvsp[0].string;
		       yyval.userpass.pass_netrc = 0;
	       }
break;
case 236:
#line 2120 "parse.y"
{
		       yyval.userpass.user = NULL;
		       yyval.userpass.user_netrc = 1;
		       yyval.userpass.pass = NULL;
		       yyval.userpass.pass_netrc = 1;
	       }
break;
case 237:
#line 2127 "parse.y"
{
		       if (*yyvsp[0].string == '\0')
			       yyerror("invalid user");

		       yyval.userpass.user = yyvsp[0].string;
		       yyval.userpass.user_netrc = 0;
		       yyval.userpass.pass = NULL;
		       yyval.userpass.pass_netrc = 1;
	       }
break;
case 238:
#line 2137 "parse.y"
{
		       if (*yyvsp[0].string == '\0')
			       yyerror("invalid pass");

		       yyval.userpass.user = NULL;
		       yyval.userpass.user_netrc = 1;
		       yyval.userpass.pass = yyvsp[0].string;
		       yyval.userpass.pass_netrc = 0;
	       }
break;
case 239:
#line 2148 "parse.y"
{
		      if (*yyvsp[-2].string == '\0')
			      yyerror("invalid user");
		      if (*yyvsp[0].string == '\0')
			      yyerror("invalid pass");

		      yyval.userpass.user = yyvsp[-2].string;
		      yyval.userpass.user_netrc = 0;
		      yyval.userpass.pass = yyvsp[0].string;
		      yyval.userpass.pass_netrc = 0;
	      }
break;
case 240:
#line 2161 "parse.y"
{
		  yyval.userpass.user = yyvsp[0].userpass.user;
		  yyval.userpass.user_netrc = yyvsp[0].userpass.user_netrc;
		  yyval.userpass.pass = yyvsp[0].userpass.pass;
		  yyval.userpass.pass_netrc = yyvsp[0].userpass.pass_netrc;
	  }
break;
case 241:
#line 2168 "parse.y"
{
		  yyval.userpass.user = NULL;
		  yyval.userpass.user_netrc = 0;
		  yyval.userpass.pass = NULL;
		  yyval.userpass.pass_netrc = 0;
	  }
break;
case 242:
#line 2176 "parse.y"
{
		 yyval.poponly.path = yyvsp[0].string;
		 yyval.poponly.only = yyvsp[-2].only;
	 }
break;
case 243:
#line 2181 "parse.y"
{
		 yyval.poponly.path = NULL;
		 yyval.poponly.only = FETCH_ONLY_ALL;
	 }
break;
case 244:
#line 2187 "parse.y"
{
		  yyval.only = yyvsp[0].only;
	  }
break;
case 245:
#line 2191 "parse.y"
{
		  yyval.only = FETCH_ONLY_ALL;
	  }
break;
case 246:
#line 2196 "parse.y"
{
		   struct fetch_pop3_data	*data;

		   if (yyvsp[-8].flag && yyvsp[0].flag)
			   yyerror("use either pop3s or set starttls");

		   yyval.fetch.fetch = &fetch_pop3;
		   data = xcalloc(1, sizeof *data);
		   yyval.fetch.data = data;

		   if (yyvsp[-6].userpass.user_netrc && yyvsp[-6].userpass.pass_netrc)
			  find_netrc(yyvsp[-7].server.host, &data->user, &data->pass);
		   else {
			   if (yyvsp[-6].userpass.user_netrc)
				   find_netrc(yyvsp[-7].server.host, &data->user, NULL);
			   else
				   data->user = yyvsp[-6].userpass.user;
			   if (yyvsp[-6].userpass.pass_netrc)
				   find_netrc(yyvsp[-7].server.host, NULL, &data->pass);
			   else
				   data->pass = yyvsp[-6].userpass.pass;
		   }

		   data->server.ssl = yyvsp[-8].flag;
		   data->server.verify = yyvsp[-3].flag;
		   data->server.tls1 = yyvsp[-1].flag;
		   data->server.host = yyvsp[-7].server.host;
		   if (yyvsp[-7].server.port != NULL)
			   data->server.port = yyvsp[-7].server.port;
		   else if (yyvsp[-8].flag)
			   data->server.port = xstrdup("pop3s");
		   else
			   data->server.port = xstrdup("pop3");
		   data->server.ai = NULL;
		   data->apop = yyvsp[-4].flag;
		   data->uidl = yyvsp[-2].flag;
		   data->starttls = yyvsp[0].flag;

		   data->path = yyvsp[-5].poponly.path;
		   data->only = yyvsp[-5].poponly.only;
	   }
break;
case 247:
#line 2238 "parse.y"
{
		   struct fetch_pop3_data	*data;

		   yyval.fetch.fetch = &fetch_pop3pipe;
		   data = xcalloc(1, sizeof *data);
		   yyval.fetch.data = data;
		   data->user = yyvsp[-2].userpass.user;
		   data->pass = yyvsp[-2].userpass.pass;
		   data->pipecmd = yyvsp[-3].string;
		   if (data->pipecmd == NULL || *data->pipecmd == '\0')
			   yyerror("invalid pipe command");
		   data->apop = yyvsp[0].flag;
		   data->path = yyvsp[-1].poponly.path;
		   data->only = yyvsp[-1].poponly.only;
	   }
break;
case 248:
#line 2255 "parse.y"
{
		   struct fetch_imap_data	*data;

		   if (yyvsp[-9].flag && yyvsp[0].flag)
			   yyerror("use either imaps or set starttls");

		   yyval.fetch.fetch = &fetch_imap;
		   data = xcalloc(1, sizeof *data);
		   yyval.fetch.data = data;

		   if (yyvsp[-7].userpass.user_netrc && yyvsp[-7].userpass.pass_netrc)
			   find_netrc(yyvsp[-8].server.host, &data->user, &data->pass);
		   else {
			   if (yyvsp[-7].userpass.user_netrc)
				   find_netrc(yyvsp[-8].server.host, &data->user, NULL);
			   else
				   data->user = yyvsp[-7].userpass.user;
			   if (yyvsp[-7].userpass.pass_netrc)
				   find_netrc(yyvsp[-8].server.host, NULL, &data->pass);
			   else
				   data->pass = yyvsp[-7].userpass.pass;
		   }

		   data->folders = yyvsp[-6].strings;
		   data->server.ssl = yyvsp[-9].flag;
		   data->server.verify = yyvsp[-4].flag;
		   data->server.tls1 = yyvsp[-1].flag;
		   data->server.host = yyvsp[-8].server.host;
		   if (yyvsp[-8].server.port != NULL)
			   data->server.port = yyvsp[-8].server.port;
		   else if (yyvsp[-9].flag)
			   data->server.port = xstrdup("imaps");
		   else
			   data->server.port = xstrdup("imap");
		   data->server.ai = NULL;
		   data->only = yyvsp[-5].only;
		   data->nocrammd5 = yyvsp[-3].flag;
		   data->nologin = yyvsp[-2].flag;
		   data->starttls = yyvsp[0].flag;
	   }
break;
case 249:
#line 2296 "parse.y"
{
		   struct fetch_imap_data	*data;

		   yyval.fetch.fetch = &fetch_imappipe;
		   data = xcalloc(1, sizeof *data);
		   yyval.fetch.data = data;
		   data->user = yyvsp[-2].userpass.user;
		   data->pass = yyvsp[-2].userpass.pass;
		   data->folders = yyvsp[-1].strings;
		   data->pipecmd = yyvsp[-3].string;
		   if (data->pipecmd == NULL || *data->pipecmd == '\0')
			   yyerror("invalid pipe command");
		   data->only = yyvsp[0].only;
	   }
break;
case 250:
#line 2311 "parse.y"
{
		   yyval.fetch.fetch = &fetch_stdin;
	   }
break;
case 251:
#line 2315 "parse.y"
{
		   struct fetch_maildir_data	*data;

		   yyval.fetch.fetch = &fetch_maildir;
		   data = xcalloc(1, sizeof *data);
		   yyval.fetch.data = data;
		   data->maildirs = yyvsp[0].strings;
	   }
break;
case 252:
#line 2324 "parse.y"
{
		   struct fetch_mbox_data	*data;

		   yyval.fetch.fetch = &fetch_mbox;
		   data = xcalloc(1, sizeof *data);
		   yyval.fetch.data = data;
		   data->mboxes = yyvsp[0].strings;
	   }
break;
case 253:
#line 2333 "parse.y"
{
		   struct fetch_nntp_data	*data;
		   char				*cause;

		   if (*yyvsp[-2].string == '\0')
			   yyerror("invalid cache");

		   yyval.fetch.fetch = &fetch_nntp;
		   data = xcalloc(1, sizeof *data);
		   yyval.fetch.data = data;

		   if (yyvsp[-5].userpass.user_netrc && yyvsp[-5].userpass.pass_netrc) {
			   if (find_netrc1(yyvsp[-6].server.host,
			       &data->user, &data->pass, &cause) != 0) {
				   log_debug2("%s", cause);
				   xfree(cause);
				   data->user = NULL;
				   data->pass = NULL;
			   }

		   } else {
			   if (yyvsp[-5].userpass.user_netrc)
				   find_netrc(yyvsp[-6].server.host, &data->user, NULL);
			   else
				   data->user = yyvsp[-5].userpass.user;
			   if (yyvsp[-5].userpass.pass_netrc)
				   find_netrc(yyvsp[-6].server.host, NULL, &data->pass);
			   else
				   data->pass = yyvsp[-5].userpass.pass;
		   }

		   data->names = yyvsp[-4].strings;
		   data->path = yyvsp[-2].string;
		   if (data->path == NULL || *data->path == '\0')
			   yyerror("invalid cache");

		   data->server.ssl = yyvsp[-7].flag;
		   data->server.verify = yyvsp[-1].flag;
		   data->server.tls1 = yyvsp[0].flag;
		   data->server.host = yyvsp[-6].server.host;
		   if (yyvsp[-6].server.port != NULL)
			   data->server.port = yyvsp[-6].server.port;
		   else if (yyvsp[-7].flag)
                           data->server.port = xstrdup("nntps");
                   else
			   data->server.port = xstrdup("nntp");
		   data->server.ai = NULL;
	   }
break;
case 254:
#line 2383 "parse.y"
{
		 struct account		*a;
		 char			*su, desc[DESCBUFSIZE];

		 if (strlen(yyvsp[-4].string) >= MAXNAMESIZE)
			 yyerror("account name too long: %s", yyvsp[-4].string);
		 if (*yyvsp[-4].string == '\0')
			 yyerror("invalid account name");
		 if (find_account(yyvsp[-4].string) != NULL)
			 yyerror("duplicate account: %s", yyvsp[-4].string);

		 a = xcalloc(1, sizeof *a);
		 strlcpy(a->name, yyvsp[-4].string, sizeof a->name);
		 a->keep = yyvsp[0].flag;
		 a->disabled = yyvsp[-3].flag;
		 a->users = yyvsp[-2].replstrs;
		 a->fetch = yyvsp[-1].fetch.fetch;
		 a->data = yyvsp[-1].fetch.data;
		 TAILQ_INSERT_TAIL(&conf.accounts, a, entry);

		 if (a->users != NULL)
			 su = fmt_replstrs(" users=", a->users);
		 else
			 su = xstrdup("");
		 a->fetch->desc(a, desc, sizeof desc);
		 log_debug2("added account \"%s\":%s fetch=%s", a->name, su,
		     desc);
		 xfree(su);

		 xfree(yyvsp[-4].string);
	 }
break;
#line 4297 "parse.c"
    }
    yyssp -= yym;
    yystate = *yyssp;
    yyvsp -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: after reduction, shifting from state 0 to\
 state %d\n", YYPREFIX, YYFINAL);
#endif
        yystate = YYFINAL;
        *++yyssp = YYFINAL;
        *++yyvsp = yyval;
        if (yychar < 0)
        {
            if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
            if (yydebug)
            {
                yys = 0;
                if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
                if (!yys) yys = "illegal-symbol";
                printf("%sdebug: state %d, reading %d (%s)\n",
                        YYPREFIX, YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == 0) goto yyaccept;
        goto yyloop;
    }
    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: after reduction, shifting from state %d \
to state %d\n", YYPREFIX, *yyssp, yystate);
#endif
    if (yyssp >= yysslim && yygrowstack())
    {
        goto yyoverflow;
    }
    *++yyssp = yystate;
    *++yyvsp = yyval;
    goto yyloop;
yyoverflow:
    yyerror("yacc stack overflow");
yyabort:
    if (yyss)
            free(yyss);
    if (yyvs)
            free(yyvs);
    yyss = yyssp = NULL;
    yyvs = yyvsp = NULL;
    yystacksize = 0;
    return (1);
yyaccept:
    if (yyss)
            free(yyss);
    if (yyvs)
            free(yyvs);
    yyss = yyssp = NULL;
    yyvs = yyvsp = NULL;
    yystacksize = 0;
    return (0);
}
