/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.alpn.client;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.alpn.ALPN;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.NegotiatingClientConnection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ALPNClientConnection
extends NegotiatingClientConnection
implements ALPN.ClientProvider {
    private static final Logger LOG = Log.getLogger(ALPNClientConnection.class);
    private final String protocol;

    public ALPNClientConnection(EndPoint endPoint, Executor executor, ClientConnectionFactory connectionFactory, SSLEngine sslEngine, Map<String, Object> context, String protocol) {
        super(endPoint, executor, sslEngine, connectionFactory, context);
        this.protocol = protocol;
        ALPN.put((SSLEngine)sslEngine, (ALPN.Provider)this);
    }

    public boolean supports() {
        return true;
    }

    public void unsupported() {
        ALPN.remove((SSLEngine)this.getSSLEngine());
        this.completed();
    }

    public List<String> protocols() {
        return Arrays.asList(this.protocol);
    }

    public void selected(String protocol) {
        if (this.protocol.equals(protocol)) {
            ALPN.remove((SSLEngine)this.getSSLEngine());
            this.completed();
        } else {
            LOG.info("Could not negotiate protocol: server {} - client {}", new Object[]{protocol, this.protocol});
            this.close();
        }
    }

    public void close() {
        ALPN.remove((SSLEngine)this.getSSLEngine());
        super.close();
    }
}

