/*
 * Copyright (c) 2004-2009, Luiz Otavio O Souza <loos.br@gmail.com>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * $Id: config.h 96 2009-01-20 15:34:19Z loos-br $
 */

#ifndef CONFIG_H
#define CONFIG_H

#include <sys/types.h>
#include <sys/time.h>

#include "tree.h"
#include "string.h"
#include "mysql.h"
#include "syslog.h"

#ifndef READONLY
#define READONLY		"r"
#endif

#ifndef DEFAULT_CONFIG_FILE
#define DEFAULT_CONFIG_FILE  	"msn-proxy.conf"
#endif

#ifndef DEFAULT_CONFIG_PATH
#define DEFAULT_CONFIG_PATH	"/usr/local/etc/msn-proxy/"
#endif

#ifndef DEFAULT_NS_HOST
#define DEFAULT_NS_HOST		"messenger.hotmail.com"
#endif

#ifndef DEFAULT_NS_PORT
#define DEFAULT_NS_PORT		"1863"
#endif

#ifndef LISTEN_HOST
#define LISTEN_HOST		"0.0.0.0"
#endif

#ifndef LISTEN_PORT
#define LISTEN_PORT		"1863"
#endif

typedef struct defaults__ {
    unsigned long	commands;
    string		internal_host;
    int			save_contacts;
    int			save_msg;
    int			connect;
} defaults_;

typedef struct config__ {
    log_		log;			/* log options */
    string		file;			/* path of config file */
    string		default_ns_host;	/* default ns server host */
    string		default_ns_port;	/* default ns server port */
    string		listen_host;		/* internal bind address */
    string		listen_port;		/* default to 1863 */
    mysql_		mysql;			/* mysql private data */
    defaults_		defaults;		/* global configuration */
    unsigned int	backlog;		/* default backlog for listen */
    unsigned int	port_min;		/* begin of port range used on
						   internal connections */
    unsigned int	port_max;		/* end of port range */
    unsigned int	max_clients;		/* number of clients */
    unsigned int	max_ctl_clients;	/* number of ctl clients */
    struct timeval	timeout_client_read;	/* timeouts */
    struct timeval	timeout_client_write;
    struct timeval	timeout_server_read;
    struct timeval	timeout_server_write;
    struct timeval	timeout_ctl_read;
    struct timeval	timeout_listen;
} config_;

int config_default(config_ *config);
int parse_config(config_ *config);
int config_no_op(config_ *config, string *key, string *val);
int set_int(config_ *config, string *key, string *val);
int set_string(config_ *config, string *key, string *val);
int set_timeout(config_ *config, string *key, string *val);
int config_set_path(string *file, char *path);
void print_config(config_ *config);

#endif
