/*
 * Copyright (c) 2004-2009, Luiz Otavio O Souza <loos.br@gmail.com>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * $Id: contacts.h 98 2009-01-24 17:23:36Z loos-br $
 */

#ifndef CONTACTS_H
#define CONTACTS_H

#include "contacts-data.h"
#include "user.h"
#include "xml.h"

void		contacts_RB_INSERT_COLOR(struct contacts *head, struct contact_ *elm);
void		contacts_RB_REMOVE_COLOR(struct contacts *head, struct contact_ *parent, struct contact_ *elm);
struct contact_	*contacts_RB_REMOVE(struct contacts *head, struct contact_ *elm);
struct contact_	*contacts_RB_INSERT(struct contacts *head, struct contact_ *elm);
struct contact_	*contacts_RB_FIND(struct contacts *head, struct contact_ *elm);
struct contact_	*contacts_RB_NEXT(struct contact_ *elm);
struct contact_	*contacts_RB_MINMAX(struct contacts *head, int val);
void		contact_zero(struct contact_ *contact);
void		contact_free(struct contact_ *contact);
void		contact_print(struct contact_ *contact);
void		contacts_free(struct user_ *user);
struct contact_ *contact_add(struct user_ *user, string *c);
struct contact_	*contact_find(struct user_ *user, string *c);
struct contact_ *contact_update(struct user_ *user, string *c);
int		msnp13_save_contact(struct user_ *user, command *cmd, int args);
int		msnp12_save_contact(struct user_ *user, command *cmd, int args);
int		msnp8_save_contact(struct user_ *user, command *cmd, int args);
int		msn_save_contactgroup(string *email, string *group, string *gid);
int		msnp12_save_contactgroup(struct user_ *user, command *cmd, int args);
int		msnp8_save_contactgroup(struct user_ *user, command *cmd, int args);
int		msnp13_contact_initial_state(struct user_ *user, command *cmd, int args);
int		msn_contact_initial_state(struct user_ *user, command *cmd, int args);
int		msn_contact_logoff(struct user_ *user, command *cmd, int args);
int		msn_contact_change(struct user_ *user, command *cmd, int args);
int		msnp12_client_syn_rewrite(struct user_ *user, command *cmd, int args);
int		msnp8_client_syn_rewrite(struct user_ *user, command *cmd, int args);
int		msnp8_server_syn_rewrite(struct user_ *user, command *cmd, int args);
int		loaduser(struct ctl_ *ctl, struct xml_tags *xml_tag_head);

#endif
