/*
 * Copyright (c) 2004-2009, Luiz Otavio O Souza <loos.br@gmail.com>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * $Id: ctl.h 96 2009-01-20 15:34:19Z loos-br $
 */

#ifndef CTL_H
#define CTL_H

#include <event.h>

#include "tree.h"
#include "string.h"
#include "xml-data.h"

struct ctl_ {
    struct xml_tags	xml_head;
    RB_ENTRY(ctl_)	ctl__;
    struct event	read;
    string		buf;
    int			end;
    int			fd;
};

struct ctls {
    struct ctl_		*rbh_root;	/* root of the tree */
};

void	ctl_client(int ctlfd, short event, void *config_);

#endif
