/*
 * Copyright (c) 2004-2009, Luiz Otavio O Souza <loos.br@gmail.com>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * $Id: msnp12.h 97 2009-01-23 13:47:17Z loos-br $
 */

CMD	SERVER_MSNP12_PRE_CMDS[] = {
		{ "CVR", 6, check_args },
		{ "USR", 0, server_msnp12_pre_usr },
		{ "VER", 0, msn_get_ver },
		{ "XFR", 0, xfr_proxy },
		{ NULL, 0, NULL }
	};

CMD	SERVER_MSNP12_POST_CMDS[] = {
		{ "XFR", 0, xfr_ns_post_proxy },
		{ NULL, 0, NULL }
	};

CMD	SERVER_MSNP12_CMDS[] = {
		{ "ADC", 0, check_ok }, /* XXX */
		{ "ADG", 0, check_ok }, /* XXX */
		{ "BLP", 1, check_args },
		{ "BPR", 0, check_ok },
		{ "CHG", 0, check_ok },
		{ "CHL", 2, check_args },
		{ "FLN", 0, msn_contact_logoff },
		{ "GCF", 0, check_ok },
		{ "GTC", 1, check_args },
		{ "ILN", 0, msn_contact_initial_state },
		{ "LSG", 0, msnp12_save_contactgroup },
		{ "LST", 0, msnp12_save_contact },
		{ "MSG", 3, check_args },
		{ "NLN", 0, msn_contact_change },
		{ "NOT", 1, check_args },
		{ "OUT", 1, check_args },
		{ "PRP", 0, msnp12_update_dn },
		{ "QNG", 1, check_args },
		{ "QRY", 1, check_args },
		{ "REM", 0, check_ok }, /* XXX */
		{ "RNG", 0, rng_sb_proxy },
		{ "SBP", 4, check_args },
		{ "SBS", 2, check_args },
		{ "SYN", 0, check_ok },
		{ "UBX", 0, msn_ubx },
		{ "URL", 0, msn_url },
		{ "UUX", 2, check_args },
		{ "XFR", 0, xfr_proxy },
		{ NULL, 0, NULL }
	};

CMD	CLIENT_MSNP12_PRE_CMDS[] = {
		{ "CVR", 9, check_args },
		{ "OUT", 0, check_ok },
		{ "USR", 0, client_msn_pre_usr },
		{ "VER", 0, msn_get_ver },
		{ NULL, 0, NULL }
	};

CMD	CLIENT_MSNP12_POST_CMDS[] = {
		{ NULL, 0, NULL }
	};

CMD	CLIENT_MSNP12_CMDS[] = {
		{ "ADC", 0, check_ok }, /* XXX */
		{ "ADG", 0, check_ok }, /* XXX */
		{ "CHG", 0, msn_update_status },
		{ "CHL", 1, check_args },
		{ "GCF", 2, check_args },
		{ "OUT", 0, check_ok },
		{ "PNG", 0, check_ok },
		{ "PRP", 3, check_args },
		{ "QRY", 3, check_args },
		{ "REA", 0, check_ok }, /* XXX - add lists */
		{ "REM", 0, check_ok }, /* XXX - add lists */
		{ "SBP", 4, check_args },
		{ "SYN", 0, msnp12_client_syn_rewrite },
		{ "URL", 0, msn_url },
		{ "UUX", 2, check_args },
		{ "XFR", 2, check_args },
		{ NULL, 0, NULL }
	};

SBCMD	SERVER_MSNP12_SB_CMDS[] = {
		{ "ACK", 1, check_sb_args },
		{ "ANS", 2, check_sb_args },
		{ "BYE", 1, check_sb_args },
		{ "CAL", 3, check_sb_args },
		{ "IRO", 0, sb_iro },
		{ "JOI", 0, msn_sb_joi },
		{ "MSG", 0, msn_sb_server_msg },
		{ "USR", 4, check_sb_args },
		{ NULL, 0, NULL }
	};

SBCMD	SERVER_MSNP12_SB_POST_CMDS[] = {
		{ "BYE", 0, msn_sb_post_bye },
		{ NULL, 0, NULL }
	};

SBCMD	CLIENT_MSNP12_SB_CMDS[] = {
		{ "ANS", 4, check_sb_args },
		{ "CAL", 0, msn_sb_cal },
		{ "MSG", 0, msn_sb_client_msg },
		{ "OUT", 0, check_sb_args },
		{ "USR", 3, check_sb_args },
		{ NULL, 0, NULL }
	};

SBCMD	CLIENT_MSNP12_SB_POST_CMDS[] = {
		{ "OUT", 0, msn_sb_post_out },
		{ NULL, 0, NULL }
	};

CMDS_	MSNP12_CMDS[] = {
	{ SERVER_CMD,		"server_cmd",		SERVER_MSNP12_CMDS },
	{ SERVER_PRE_CMD,	"server_pre_cmd",	SERVER_MSNP12_PRE_CMDS },
	{ SERVER_POST_CMD,	"server_post_cmd",	SERVER_MSNP12_POST_CMDS },
	{ CLIENT_CMD,		"client_cmd",		CLIENT_MSNP12_CMDS },
	{ CLIENT_PRE_CMD,	"client_pre_cmd",	CLIENT_MSNP12_PRE_CMDS },
	{ CLIENT_POST_CMD,	"client_post_cmd",	CLIENT_MSNP12_POST_CMDS },
	{ 0, NULL, NULL }
	};

SBCMDS_	MSNP12_SBCMDS[] = {
	{ SERVER_SB_CMD,	"server_cb_cmd",	SERVER_MSNP12_SB_CMDS },
	{ SERVER_SB_POST_CMD,	"server_sb_post_cmd",	SERVER_MSNP12_SB_POST_CMDS },
	{ CLIENT_SB_CMD,	"client_sb_cmd",	CLIENT_MSNP12_SB_CMDS },
	{ CLIENT_SB_POST_CMD,	"client_sb_post_cmd",	CLIENT_MSNP12_SB_POST_CMDS },
	{ 0, NULL, NULL }
	};

