/*
 * Copyright (c) 2004-2009, Luiz Otavio O Souza <loos.br@gmail.com>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * $Id: protocol.h 98 2009-01-24 17:23:36Z loos-br $
 */

#ifndef PROTOCOL_H
#define PROTOCOL_H

#include "user.h"
#include "command.h"

int	msn_encode(string *in, string *out, int options);
int	msn_decode(string *in, string *out);
string	*get_arg(command *cmd, int narg);
int	check_arg(string *arg, char *cmp);
int	msn_get_ver(struct user_ *user, command *cmd, int args);
int	client_msn_pre_usr(struct user_ *user, command *cmd, int args);
int	server_msnp12_pre_usr(struct user_ *user, command *cmd, int args);
int	server_msnp8_pre_usr(struct user_ *user, command *cmd, int args);
int	user_auth_request(struct user_ *user, string *email);
int	xfr_proxy(struct user_ *user, command *cmd, int args);
int	xfr_post_proxy(struct user_ *user, command *cmd, int args);
int	msn_warning_msg_client(struct sb_ *sb);
int	send_fln(struct user_ *user, struct contact_ *contact);
int	send_nln(struct user_ *user, struct contact_ *contact);
int	msnp18_adl_sync(struct user_ *user, command *cmd, int args);

#endif
