/*
 * Copyright (c) 2004-2009, Luiz Otavio O Souza <loos.br@gmail.com>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * $Id: sb.h 112 2009-03-15 17:30:28Z loos-br $
 */

#ifndef SB_H
#define SB_H

#include "user.h"

void		sb_free_xfr(struct sb_ *sb);
struct sb_	*sb_alloc(struct user_ *user);
void		sb_connect(const int listenfd, short event, void *p);
struct sb_	*sb_disconnect(struct sb_ *sb);
void		sb_disconnect_all(struct user_ *user);
void		sb_client_write(const int evfd, short event, void *p);
void		sb_client_read(const int evfd, short event, void *p);
void		sb_server_read(int evfd, short event, void *p);
void		sb_server_write(int evfd, short event, void *p);
struct sb_	*sb_proxy(struct user_ *user, string **arg);
int		xfr_sb_proxy(struct user_ *user, command *cmd, int args);
int		rng_sb_proxy(struct user_ *user, command *cmd, int args);
int		msn_sb_joi(struct sb_ *sb, command *cmd, int args);
int		msn_sb_post_out(struct sb_ *sb, command *cmd, int args);
int		sb_iro(struct sb_ *sb, command *cmd, int args);
int		msn_sb_post_bye(struct sb_ *sb, command *cmd, int args);
int		msn_sb_cal(struct sb_ *sb, command *cmd, int args);
struct sb_user_ *sb_user_free(struct sb_ *sb, struct sb_user_ *sb_user);

#endif
